

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetReservationJobInfoByRCId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetReservationJobInfoByRCId.sp,v $ $Id: MMGetReservationJobInfoByRCId.sp,v 1.1.2.3 2018/07/20 09:53:26 cliu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetReservationJobInfoByRCId <<<'

IF EXISTS (select * from sysobjects where name='MMGetReservationJobInfoByRCId')
	drop procedure MMGetReservationJobInfoByRCId
IF EXISTS (select * from GxQscripts where name='MMGetReservationJobInfoByRCId')
	delete from GxQscripts where name = 'MMGetReservationJobInfoByRCId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetReservationJobInfoByRCId')
	delete from GXDBVersions where aliasname = 'MMGetReservationJobInfoByRCId'
GO
print '... Creating Procedure: MMGetReservationJobInfoByRCId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetReservationJobInfoByRCId
  @i_jobId integer,
  @i_rcId integer
AS
-- Table MMResourceToJob Info
  DECLARE @o_ReservationId integer = 0;
  DECLARE @o_JobId Integer = 0;
  DECLARE @o_Priority integer = 0;
  DECLARE @o_PreEmptable integer = 0;
  DECLARE @o_InUse integer = 0;
  DECLARE @o_ReserveBitMask integer = 0;
  DECLARE @o_ReleaseTime integer = 0;
  DECLARE @o_ReservationType integer = 0;
  DECLARE @o_RCID integer = 0;
  DECLARE @o_PrimaryRCID integer = 0;
  DECLARE @o_ClientTokenId integer = 0;
  DECLARE @o_DestMediaGroupId integer = 0;
  DECLARE @o_LogicalReleased integer = 0;
  DECLARE @o_Flag integer = 0;
  DECLARE @o_CIEngineCoreId integer = 0;
  DECLARE @o_AppClientId integer = 0;
-- Table MMResource Info
  DECLARE @o_CopyId integer = 0;
  DECLARE @o_StreamId integer = 0;
  DECLARE @o_VolumeId integer = 0;
  DECLARE @o_MediaId integer = 0;
  DECLARE @o_DriveId integer = 0;
  DECLARE @o_ClientId integer = 0;
  DECLARE @o_DrivePoolId integer = 0;
  DECLARE @o_MasterPoolId integer = 0;
  DECLARE @o_MediaGroupId integer = 0;
  DECLARE @o_IntrJobId integer = 0;
  DECLARE @o_HasJobInterrupted integer = 0;
  DECLARE @o_ResReservationType integer = 0;
  DECLARE @o_ReservationTime integer = 0;
  DECLARE @o_ResPriority integer = 0;
  DECLARE @o_ResPreEmptable integer = 0;
  DECLARE @o_IsResDummy integer = 0;
  DECLARE @o_Released integer = 0;
  DECLARE @o_ResourceFlag integer = 0;
  DECLARE @o_PrimaryResId integer = 0;
  DECLARE @o_IntrResId integer = 0;
  DECLARE @o_LogicalRelease integer = 0;
  DECLARE @o_DoNotInterrupt integer = 0;
  DECLARE @o_LibraryId integer = 0;
  DECLARE @o_LibraryTypeId integer = 0;
  DECLARE @o_SpareGroupId integer = 0;
  DECLARE @o_MountPathId integer = 0;
  DECLARE @o_DriveInUseByDM integer = 0;
  DECLARE @o_ScheduleRunId bigint = 0;
  DECLARE @o_NoOtherSchedule integer = 0;
  DECLARE @o_ResReleaseTime integer = 0;
  DECLARE @o_ResFlag integer = 0;
  DECLARE @o_clientName varchar(255) = '';
  DECLARE @o_netHostName varchar(255) = '';
  DECLARE @o_MediaBarCode varchar(255) = ''
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF @i_rcId > 0
AND EXISTS (SELECT 1 FROM MMResourceToJob WITH (READUNCOMMITTED) WHERE RCId = @i_rcId)
BEGIN
	select
		@o_ReservationId = b.ReservationId,
		@o_JobId = b.JobId_l,
		@o_Priority = b.Priority,
		@o_PreEmptable = b.PreEmptable,
		@o_InUse = b.InUse,
		@o_ReserveBitMask = b.ReserveBitMask,
		@o_ReleaseTime = b.ReleaseTime,
		@o_ReservationType = b.ReservationType,
		@o_RCID = b.RCID,
		@o_PrimaryRCID = b.PrimaryRCID,
		@o_ClientTokenId = b.ClientTokenId,
		@o_DestMediaGroupId = b.DestMediaGroupId,
		@o_LogicalReleased = b.LogicalReleased,
		@o_Flag = b.Flag,
		@o_CIEngineCoreId = b.CIEngineCoreId,
		@o_AppClientId = b.AppClientId,
		@o_CopyId = a.CopyId,
		@o_StreamId = a.StreamId,
		@o_VolumeId = a.VolumeId,
		@o_MediaId = a.MediaId,
		@o_DriveId = a.DriveId,
		@o_ClientID = a.ClientId,
		@o_DrivePoolId = a.DrivePoolId,
		@o_MasterPoolId = a.MasterPoolId,
		@o_MediaGroupId = a.MediaGroupId,
		@o_IntrJobId			= a.IntrJobId_l,
		@o_HasJobInterrupted	= a.HasJobInterrupted,
		@o_ResReservationType	= a.ReservationType,
		@o_ReservationTime	= a.ReservationTime,
		@o_ResPriority		= a.Priority,
		@o_ResPreEmptable	= a.PreEmptable,
		@o_IsResDummy		= a.IsResDummy,
		@o_Released			= a.Released,
		@o_ResourceFlag		= a.ResourceFlag,
		@o_PrimaryResId = a.PrimaryResId,
		@o_IntrResId			= a.IntrResId,
		@o_LogicalRelease	= a.LogicalRelease,
		@o_DoNotInterrupt	= a.DoNotInterrupt,
		@o_LibraryId = a.LibraryId,
		@o_LibraryTypeId = a.LibraryTypeId,
		@o_SpareGroupId = a.SpareGroupId,
		@o_MountPathId = a.MountPathId,
		@o_DriveInUseByDM	= a.DriveInUseByDM,
		@o_ScheduleRunId		= a.ScheduleRunId,
		@o_NoOtherSchedule	= a.NoOtherSchedule,
		@o_ResReleaseTime	= a.ReleaseTime,
		@o_ResFlag			= a.Flag,
		@o_MediaBarCode =	case when a.MountPathId > 0
								then	(select ISNULL(MountPathName, '') from MMS2getMountPathNameGUIView WITH (NOLOCK) where MountPathID = a.MountPathId)
								else	(select ISNULL(Barcode, '') from MMMedia WITH (NOLOCK) where MediaId = a.MediaId)
								end
	from MMResource a WITH (READUNCOMMITTED), MMResourceToJob b WITH (READUNCOMMITTED)
	where	(@i_jobId = 0 OR b.JobId_h = 0 and b.JobId_l = @i_jobId)
	and		(@i_rcId = 0 OR b.RCId = @i_rcId)
	and		a.ReservationId = b.ReservationId
	if @o_ClientTokenId > 0 and @o_JobId > 0
	begin
		select	@o_clientName = ISNULL(client.Name, ''), @o_netHostName = ISNULL(client.net_hostname, '')
		from 	JMOracleRACStreamInfo stream WITH (READUNCOMMITTED),
				App_Client client WITH (READUNCOMMITTED)
		where	stream.JobId = @i_jobId
and		stream.racInstanceId = @o_ClientTokenId and stream.commCellId = 2
		and		stream.racHostId = client.Id
	end
END
ELSE IF EXISTS (SELECT 1 FROM ArchJobStreamStatus WITH (READUNCOMMITTED) WHERE (@i_jobId = 0 OR JobId = @i_jobId) AND SrcRCId = @i_rcId)
BEGIN
	select
		@o_ReservationId = b.SrcReservationId, --b.ReservationId,
		@o_JobId = b.jobId, --b.JobId_l,
		@o_Priority = 0, --b.Priority,
		@o_PreEmptable = 0, --b.PreEmptable,
		@o_InUse = 1, --b.InUse,
		@o_ReserveBitMask = 0, --b.ReserveBitMask,
		@o_ReleaseTime = 0, --b.ReleaseTime,
@o_ReservationType = 1, --b.ReservationType,
@o_ResReservationType = 1, -- default to read only
		@o_RCID = b.SrcRCId, --b.RCID,
		@o_PrimaryRCID = 0, --b.PrimaryRCID,
		@o_ClientTokenId = 0, --b.ClientTokenId,
		@o_DestMediaGroupId = 0, --b.DestMediaGroupId,
		@o_LogicalReleased = 0, --b.LogicalReleased,
		@o_Flag = 0, --b.Flag,
		@o_CIEngineCoreId = 0, --b.CIEngineCoreId,
		@o_AppClientId = 0, --b.AppClientId,
		@o_CopyId = b.SrcCopyId, --a.CopyId,
		@o_StreamId = b.SrcStreamNum, --a.StreamId,
		@o_VolumeId = b.FirstVolumeId, --a.VolumeId,
		--a.MediaId,
		@o_DriveId = 0, --a.DriveId,
		@o_ClientID = b.SrcMAId, --a.ClientId,
		@o_DrivePoolId = b.SrcDrivePoolId, --a.DrivePoolId,
		@o_MasterPoolId = 0, --a.MasterPoolId,
		@o_MediaGroupId = 0, --a.MediaGroupId,
		@o_PrimaryResId = 0, --a.PrimaryResId,
		@o_LibraryId = 0, --a.LibraryId,
		@o_LibraryTypeId = 0, --a.LibraryTypeId,
		@o_SpareGroupId = 0 --a.SpareGroupId,
		--a.MountPathId
	from ArchJobStreamStatus b WITH (READUNCOMMITTED)
	where	(@i_jobId = 0 OR b.JobId = @i_jobId)
	and		b.SrcRCId = @i_rcId
	if @o_VolumeId > 0
	begin
		select	@o_VolumeId = ISNULL(vol.VolumeId, 0),
				@o_MediaId = ISNULL(vol.MediaId, 0),
				@o_MountPathId = ISNULL(mp.MountPathId, 0),
				@o_MediaBarCode = case when mp.MountPathId is not null and mp.MountPathId > 0
											then	(select ISNULL(MountPathName, '') from MMS2getMountPathNameGUIView WITH (NOLOCK) where MountPathID = mp.MountPathId)
										when vol.MediaId is not null and vol.MediaId > 0
											then 	(select ISNULL(Barcode, '') from MMMedia WITH (NOLOCK) where MediaId = vol.MediaId)
										else ''	end
		from	MMVolume vol WITH (READUNCOMMITTED), MMMedia media WITH (READUNCOMMITTED), MMMountPath mp WITH (READUNCOMMITTED)
		where	vol.VolumeId = @o_VolumeId
		and		vol.MediaId = media.MediaId
		and		vol.MediaSideId = mp.MediaSideId
	end
END
select @o_ReservationId, @o_JobId, @o_Priority, @o_PreEmptable, @o_InUse, @o_ReserveBitMask, @o_ReleaseTime, @o_ReservationType,
		@i_rcId, @o_PrimaryRCID, @o_ClientTokenId, @o_DestMediaGroupId, @o_LogicalReleased, @o_Flag, @o_CIEngineCoreId, @o_AppClientId,
		@o_CopyId, @o_StreamId, @o_VolumeId, @o_MediaId, @o_DriveId, @o_ClientId, @o_DrivePoolId, @o_MasterPoolId, @o_MediaGroupId,
		@o_IntrJobId, @o_HasJobInterrupted, @o_ResReservationType, @o_ReservationTime, @o_ResPriority, @o_ResPreEmptable, @o_IsResDummy, @o_Released, @o_ResourceFlag,
		@o_PrimaryResId, @o_IntrResId, @o_LogicalRelease, @o_DoNotInterrupt,
		@o_LibraryId, @o_LibraryTypeId, @o_SpareGroupId, @o_MountPathId,
		@o_DriveInUseByDM, @o_ScheduleRunId, @o_NoOtherSchedule, @o_ResReleaseTime, @o_ResFlag,
		@o_clientName, @o_netHostName, @o_MediaBarCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetReservationJobInfoByRCId')
	delete from GxQscripts where name = 'MMGetReservationJobInfoByRCId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetReservationJobInfoByRCId')
	delete from GXDBVersions where aliasname = 'MMGetReservationJobInfoByRCId'
GO

insert into GXDBVersions values(2, 'MMGetReservationJobInfoByRCId',  '00010001000200030000', 'MMGetReservationJobInfoByRCId', '00010001000200030000')
GO

