

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetRPStoresForHost.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetRPStoresForHost.sp,v $ $Id: MMGetRPStoresForHost.sp,v 1.1.4.5 2018/07/21 22:40:03 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetRPStoresForHost <<<'

IF EXISTS (select * from sysobjects where name='MMGetRPStoresForHost')
	drop procedure MMGetRPStoresForHost
IF EXISTS (select * from GxQscripts where name='MMGetRPStoresForHost')
	delete from GxQscripts where name = 'MMGetRPStoresForHost'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetRPStoresForHost')
	delete from GXDBVersions where aliasname = 'MMGetRPStoresForHost'
GO
print '... Creating Procedure: MMGetRPStoresForHost'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetRPStoresForHost
  @i_hostId integer,
  @i_appId integer,
  @i_rpStoreId integer,
  @i_reserve integer
AS
  DECLARE @o_rpStoreId integer
  DECLARE @o_rpStoreName nvarchar(256)
  DECLARE @o_libraryId integer
  DECLARE @o_currMountPathId integer
  DECLARE @o_commCellId integer
  DECLARE @o_minSpacePerRPStoreGB integer
  DECLARE @o_maxSpacePerRPStoreGB integer
  DECLARE @o_flags integer
  DECLARE @o_offPeakScheduleXML XML
DECLARE @tblDrivePools TABLE (drivePoolId INT)
DECLARE @rpStoreId INT
DECLARE @blrXMLStr varchar(max)
DECLARE @blrXML XML
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- Get all RP Stores for hostId
IF (@i_appId = 0) AND (@i_rpStoreId = 0) AND (@i_hostId > 0)
BEGIN
	SELECT MMRP.RPStoreId, MMRP.RPStoreName, MP.LibraryId, MP.MountPathId, MMRP.commCellId, MMRP.MinSpacePerRPStoreGB, MMRP.MaxSpacePerRPStoreGB, MMRP.Flags, ISNULL(PRP.propVal, '')
	FROM MMMountPath MP WITH (READUNCOMMITTED), MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED),
	 MMDeviceController MMDC WITH (READUNCOMMITTED), MMRPStoreConfig MMRP WITH (READUNCOMMITTED)
LEFT OUTER JOIN MMRPStoreProp PRP WITH (READUNCOMMITTED) ON PRP.RPStoreId = MMRP.RPStoreId AND PRP.propName = 'OffPeak Schedule'
	WHERE MMDC.ClientId = @i_hostId
	AND MMDC.DeviceId = MPSD.DeviceId
	AND MPSD.MountPathId = MMRP.currMountPathId
	AND MPSD.MountPathId = MP.MountPathId
END
-- Get RP Stores configured for subclient
ELSE IF (@i_appId > 0) AND (@i_rpStoreId = 0)
BEGIN
	-- There is no copy involved. Subclient is directly associated to the RPStore library.
	--INSERT INTO @tblDrivePools
	--SELECT DP.DrivePoolId
	--FROM APP_Application APP WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED),
	--	MMDataPath DP WITH (READUNCOMMITTED)
	--WHERE APP.id = @i_appId
	--AND APP.dataArchGrpID = AGC.archGroupId
	--AND AGC.type = CVA_AGCOPYTYPE_BLOCK_LEVEL_REPLICATION
	--AND AGC.id = DP.copyId
	--SELECT MMRP.RPStoreId, MMRP.RPStoreName, MP.LibraryId, MP.MountPathId, MMRP.commCellId, MMRP.MinSpacePerRPStoreGB, MMRP.MaxSpacePerRPStoreGB, MMRP.Flags
	--FROM @tblDrivePools T, MMDrivePool D, MMMountPath MP WITH (READUNCOMMITTED), MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED),
	-- MMDeviceController MMDC WITH (READUNCOMMITTED), MMRPStoreConfig MMRP WITH (READUNCOMMITTED)
	--WHERE T.drivePoolId = D.DrivePoolId
	--AND D.masterPoolId = MP.MasterPoolId
	--AND MMDC.ClientId = @i_hostId
	--AND MMDC.DeviceId = MPSD.DeviceId
	--AND MPSD.MountPathId = MMRP.currMountPathId
	--AND MPSD.MountPathId = MP.MountPathId
	-- Get the RP Store Id from the subclientProp
	SET @blrXMLStr = (SELECT attrVal FROM APP_SubClientProp WITH (READUNCOMMITTED) WHERE attrName = 'Block Level Replication Recovery Options XML' AND componentNameId = @i_appId AND modified = 0)
	SET @blrXML = @blrXMLStr
	SELECT @rpStoreId = ISNULL((T.c.value('@rpStoreId', 'INTEGER')), 0)
		FROM @blrXML.nodes('/BlockReplication_BLRRecoveryOptions/granular') AS  T(c)
END
-- Get info for the passed in RPStoreId
ELSE IF (@i_rpStoreId > 0)
BEGIN
	SET @rpStoreId = @i_rpStoreId
END
IF (@rpStoreId > 0)
BEGIN
		SELECT MMRP.RPStoreId, MMRP.RPStoreName, MP.LibraryId, MP.MountPathId, MMRP.commCellId, MMRP.MinSpacePerRPStoreGB, MMRP.MaxSpacePerRPStoreGB, MMRP.Flags, ISNULL(PRP.propVal, '')
		FROM MMMountPath MP WITH (READUNCOMMITTED), MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED),
		 	MMRPStoreConfig MMRP WITH (READUNCOMMITTED)
LEFT OUTER JOIN MMRPStoreProp PRP WITH (READUNCOMMITTED) ON PRP.RPStoreId = MMRP.RPStoreId AND PRP.propName = 'OffPeak Schedule'
		WHERE MP.MountPathId = MPSD.MountPathId
		AND MPSD.MountPathId = MMRP.currMountPathId
		AND MMRP.RPStoreId = @rpStoreId
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetRPStoresForHost')
	delete from GxQscripts where name = 'MMGetRPStoresForHost'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetRPStoresForHost')
	delete from GXDBVersions where aliasname = 'MMGetRPStoresForHost'
GO

insert into GXDBVersions values(2, 'MMGetRPStoresForHost',  '00010001000400050000', 'MMGetRPStoresForHost', '00010001000400050000')
GO

