

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetPrunableVolsAndAFs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetPrunableVolsAndAFs.sp,v $ $Id: MMGetPrunableVolsAndAFs.sp,v 1.4.198.3 2018/08/23 14:36:55 aselvanayagam Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetPrunableVolsAndAFs <<<'

IF EXISTS (select * from sysobjects where name='MMGetPrunableVolsAndAFs')
	drop procedure MMGetPrunableVolsAndAFs
IF EXISTS (select * from GxQscripts where name='MMGetPrunableVolsAndAFs')
	delete from GxQscripts where name = 'MMGetPrunableVolsAndAFs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetPrunableVolsAndAFs')
	delete from GXDBVersions where aliasname = 'MMGetPrunableVolsAndAFs'
GO
print '... Creating Procedure: MMGetPrunableVolsAndAFs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetPrunableVolsAndAFs
  @i_MountPathTypeId INTEGER,
  @i_Mode INTEGER,
  @i_ReserveField1 INTEGER,
  @i_ReserveField2 INTEGER,
  @i_ReserveFieldStr VARCHAR(256)
AS
  DECLARE @o_VolumeId INTEGER;
  DECLARE @o_VolumeName VARCHAR(255)
  DECLARE @o_OMLVersion INTEGER;
  DECLARE @o_HostId INTEGER;
  DECLARE @o_MountPathId INTEGER;
  DECLARE @o_MountPathName VARCHAR(1024);
  DECLARE @o_MountPathTypeId INTEGER;
  DECLARE @o_UserName VARCHAR(255);
  DECLARE @o_Password VARCHAR(2048);
  DECLARE @o_SIDBStoreId INTEGER;
  DECLARE @o_CommCellId INTEGER;
  DECLARE @o_VolOrigCCId INTEGER;
  DECLARE @o_OrigVolumeId INTEGER;
  DECLARE @o_Folder VARCHAR(255);
  DECLARE @o_CClip VARCHAR(255);
  DECLARE @o_AFileId INTEGER;
  DECLARE @o_ArchChunkId BIGINT;
  DECLARE @o_PruneType INTEGER;
  DECLARE @o_PruneEntity INTEGER;
  DECLARE @o_BatchCount INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	/* - For Testing Purpose
	DECLARE	@i_MountPathTypeId						INTEGER = 7
	DECLARE	@i_Mode									INTEGER = 8
	*/
	-- Constants Declarations - Start ---------------------
	-- Mode
	DECLARE	@MODE_INITIALIZE						INTEGER = 1
	DECLARE	@MODE_FINALIZE							INTEGER = 2
	DECLARE	@MODE_QUERY								INTEGER = 3
	--DECLARE	@MODE_GET_NON_SI_RECYCLE_VOLUMES		INTEGER = 4
	--DECLARE	@MODE_GET_SI_RECYCLE_VOLUMES			INTEGER = 5
	--DECLARE	@MODE_GET_NON_SI_VOLUMES_DELETEDAF		INTEGER = 6
	--DECLARE	@MODE_GET_SI_VOLUMES_DELETEDAF			INTEGER = 7
	DECLARE	@MODE_GET_REG_PRUNE_RECORDS				INTEGER = 8
	DECLARE	@MODE_GET_SI_PRUNE_RECORDS				INTEGER = 9
	-- Constants Declarations - End ---------------------
	-- Constants Declarations - Start ---------------------
	-- Default Batch Counts
	DECLARE	@PRUNE_BATCH_COUNT_REG					INTEGER = 1000
	DECLARE	@PRUNE_BATCH_COUNT_SI					INTEGER = 1000
	-- Default Batch Counts - MMConfigs
	DECLARE	@PRUNE_BATCH_COUNT_REG_CONFIG_NAME		NVARCHAR(64) = N'MMCONFIG_PRUNE_BATCH_COUNT_REG'
	DECLARE	@PRUNE_BATCH_COUNT_SI_CONFIG_NAME		NVARCHAR(64) = N'MMCONFIG_PRUNE_BATCH_COUNT_SI'
	-- PruneType
	DECLARE	@PRUNE_TYPE_REG							INTEGER = 1
	DECLARE	@PRUNE_TYPE_SI							INTEGER = 2
	-- PruneEntity
	DECLARE	@PRUNE_ENTITY_REG_RECYCLE_VOL			INTEGER = 1
	DECLARE	@PRUNE_ENTITY_REG_VOL_AND_AF			INTEGER = 2
	DECLARE	@PRUNE_ENTITY_SHARED_RECYCLE_VOL		INTEGER = 11
	DECLARE	@PRUNE_ENTITY_SHARED_VOL_AND_AF			INTEGER = 12
	-- Constants Declarations - End ---------------------
	-- Local Variables
	DECLARE	@RegPruningBatchCount					INTEGER = 0
	DECLARE	@SIPruningBatchCount					INTEGER = 0
	-- Get the Batch Count from MMConfigs
	IF EXISTS (SELECT value FROM MMConfigs WHERE name = @PRUNE_BATCH_COUNT_REG_CONFIG_NAME)
		SELECT @RegPruningBatchCount = value FROM MMConfigs WHERE name = @PRUNE_BATCH_COUNT_REG_CONFIG_NAME
	ELSE
		SET @RegPruningBatchCount = @PRUNE_BATCH_COUNT_REG
	IF EXISTS (SELECT value FROM MMConfigs WHERE name = @PRUNE_BATCH_COUNT_SI_CONFIG_NAME)
		SELECT @SIPruningBatchCount = value FROM MMConfigs WHERE name = @PRUNE_BATCH_COUNT_SI_CONFIG_NAME
	ELSE
		SET @SIPruningBatchCount = @PRUNE_BATCH_COUNT_SI
	-- For the Output Mode to return the results
	IF @i_Mode >= @MODE_GET_REG_PRUNE_RECORDS
	BEGIN
		-- Check for Orphan Stores
		UPDATE	T1
		SET		PruneType = @PRUNE_TYPE_REG
		FROM	#tempMMPruneList T1 LEFT OUTER JOIN archCopySIDBStore ACS WITH (NOLOCK)
					ON T1.SIDBStoreid = ACS.SIDBStoreId
		WHERE	ACS.SIDBStoreId IS NULL
		/* Troubleshooting Purposes
		SELECT HostId, COUNT(HostId) FROM #tempMMPruneList WHERE PruneType = @PRUNE_TYPE_REG GROUP BY HostId order by hostid
		SELECT HostId, COUNT(HostId) FROM #tempMMPruneList WHERE PruneType = @PRUNE_TYPE_SI GROUP BY HostId order by hostid
		*/
		IF @i_Mode = @MODE_GET_SI_PRUNE_RECORDS
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#tempMMSIPruneList') is not null DROP TABLE #tempMMSIPruneList;
			WITH CTE1 AS
			(
				SELECT	VolumeId, VolumeName, OMLVersion, HostId, MountPathId, MountPathName, MountPathTypeId, UserName, Password, SIDBStoreId, CommCellId, VolOrigCCId, OrigVolumeId,
							Folder, CClip, AFileId, ArchChunkId, PruneType, PruneEntity, BatchCount,
							ROW_NUMBER() OVER(PARTITION BY SIDBStoreId ORDER BY HostId, MountPathId, VolumeId) AS RowNum
				FROM	#tempMMPruneList
				WHERE	PruneType = @PRUNE_TYPE_SI
			)
			SELECT	VolumeId, VolumeName, OMLVersion, HostId, MountPathId, MountPathName, MountPathTypeId, UserName, Password, SIDBStoreId, CommCellId, VolOrigCCId, OrigVolumeId,
						Folder, CClip, AFileId, ArchChunkId, PruneType, PruneEntity, BatchCount INTO #tempMMSIPruneList
			FROM	CTE1
			WHERE	RowNum <= @SIPruningBatchCount order by SIDBStoreId, HostId, MountPathId, VolumeId, RowNum;
			UPDATE	DAF
			SET		Retry = 1 /* Sending */
			FROM	MMDeletedAF DAF WITH (NOLOCK) INNER JOIN #tempMMSIPruneList TSI
						ON DAF.SIDBStoreId = TSI.SIDBStoreId
						AND DAF.VolumeId = TSI.VolumeId
						AND DAF.archFileId = TSI.AFileId
						AND DAF.archChunkId = TSI.ArchChunkId
			SELECT	* FROM #tempMMSIPruneList
			DROP TABLE #tempMMSIPruneList
		END
		ELSE
		BEGIN
			WITH CTE2 AS
			(
				SELECT	VolumeId, VolumeName, OMLVersion, HostId, MountPathId, MountPathName, MountPathTypeId, UserName, Password, SIDBStoreId, CommCellId, VolOrigCCId, OrigVolumeId,
							Folder, CClip, AFileId, ArchChunkId, PruneType, PruneEntity, BatchCount,
							ROW_NUMBER() OVER(PARTITION BY HostId ORDER BY MountPathId, VolumeId) AS RowNum
				FROM	#tempMMPruneList
				WHERE	PruneType = @PRUNE_TYPE_REG
			)
			SELECT	VolumeId, VolumeName, OMLVersion, HostId, MountPathId, MountPathName, MountPathTypeId, UserName, Password, SIDBStoreId, CommCellId, VolOrigCCId, OrigVolumeId,
						Folder, CClip, AFileId, ArchChunkId, PruneType, PruneEntity, BatchCount
			FROM	CTE2
			WHERE	RowNum <= @RegPruningBatchCount order by HostId, MountPathId, VolumeId, RowNum;
		END
		RETURN
	END
	-- Cleanup Mode
	IF @i_Mode = @MODE_FINALIZE
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tempMMPruneList') is not null DROP TABLE #tempMMPruneList
		RETURN
	END
	-- Initialize Mode
	IF @i_Mode = @MODE_INITIALIZE
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tempMMPruneList') is not null DROP TABLE #tempMMPruneList
		CREATE TABLE #tempMMPruneList(
						VolumeId				INTEGER,
						VolumeName				NVARCHAR(255),
						OMLVersion				INTEGER,
						HostId					INTEGER,
						MountPathId				INTEGER,
						MountPathName			NVARCHAR(1024),
						MountPathTypeId			INTEGER,
						UserName				NVARCHAR(255),
						Password				NVARCHAR(2048),
						SIDBStoreId				INTEGER,
						CommCellId				INTEGER,
						VolOrigCCId				INTEGER,
						OrigVolumeId			INTEGER,
						Folder					NVARCHAR(255),
						CClip					NVARCHAR(255),
						AFileId					INTEGER,
						ArchChunkId				BIGINT,
						PruneType				INTEGER,
						PruneEntity				INTEGER,
						BatchCount				INTEGER,
						CredentialAssocId		INTEGER)
		RETURN
	END
	IF @i_MountPathTypeId = 0 /* MOUNT_PATH_MAGNETIC */
	BEGIN
		-- Get Recyclable non-SI Volumes from Regular Mount Paths (MountPathTypeId = MOUNT_PATH_MAGNETIC)
		INSERT INTO	#tempMMPruneList
		SELECT		DISTINCT V.VolumeId, V.VolumeName, V.OMLVersion, H.ClientId, MP.MountPathId,
					MP.MountPathName, MP.MountPathTypeId, MP.UserName, MP.UserPassword, V.SIDBStoreId,
					V.origCCcommCellID, V.origCCcommCellID, V.origCCvolumeID, N'', N'',
					0, 0, @PRUNE_TYPE_REG, @PRUNE_ENTITY_REG_RECYCLE_VOL, 0, 0
		FROM		MMMountPath MP WITH (NOLOCK) INNER JOIN MMLibraryController LC WITH (NOLOCK)
						ON MP.LibraryId = LC.LibraryId
						AND MP.IsEnabled = 1
						AND MP.IsOffline = 0
						AND MP.MountPathTypeId = @i_MountPathTypeId
					INNER JOIN MMHost H WITH (NOLOCK)
						ON H.ClientId = LC.ClientId
						AND H.MmHostEnabled = 1
						AND H.MmHostSoftState = 1
					INNER JOIN MMVolume V WITH (NOLOCK)
						ON MP.MediaSideId = V.MediaSideId
						AND V.SIDBStoreId = 0
						AND V.VolumeFlags = 6 /* VOL_RECYCLE */
					LEFT OUTER JOIN archChunk AC WITH (NOLOCK)
						ON V.VolumeId = AC.VolumeId
		WHERE		AC.VolumeId IS NULL
		-- Get Recyclable SI Volumes from Regular Mount Paths (MountPathTypeId = MOUNT_PATH_MAGNETIC)
		INSERT INTO	#tempMMPruneList
		SELECT		DISTINCT V.VolumeId, V.VolumeName, V.OMLVersion, H.ClientId, MP.MountPathId,
					MP.MountPathName, MP.MountPathTypeId, MP.UserName, MP.UserPassword, V.SIDBStoreId,
					V.origCCcommCellID, V.origCCcommCellID, V.origCCvolumeID, N'', N'', 0, 0,
(CASE WHEN (SIDB.flags & 256 /* 256 */) > 0 THEN @PRUNE_TYPE_REG ELSE @PRUNE_TYPE_SI END), @PRUNE_ENTITY_REG_RECYCLE_VOL, 0, 0
		FROM		MMMountPath MP WITH (NOLOCK) INNER JOIN MMLibraryController LC WITH (NOLOCK)
						ON MP.LibraryId = LC.LibraryId
						AND MP.IsEnabled = 1
						AND MP.IsOffline = 0
						AND MP.MountPathTypeId = @i_MountPathTypeId
					INNER JOIN MMHost H WITH (NOLOCK)
						ON H.ClientId = LC.ClientId
						AND H.MmHostEnabled = 1
						AND H.MmHostSoftState = 1
					INNER JOIN MMVolume V WITH (NOLOCK)
						ON MP.MediaSideId = V.MediaSideId
						AND V.VolumeFlags = 6 /* VOL_RECYCLE */
					INNER JOIN IdxSIDBStore SIDB WITH (NOLOCK)
						ON SIDB.SIDBStoreId = V.SIDBStoreId
						AND
						(
							SIDB.CommCellId = 2
OR (SIDB.flags & 256 /* 256 */) > 0
						)
						AND
						(
(SIDB.flags & 256 /* 256 */) > 0
							OR
							(
(SIDB.flags & 2097152 /* 2097152 */) = 0
								AND
SIDB.Status <> 1 /* 1 */
								AND
(V.Attributes & 4 /* 4 */) = 0
							)
						)
					LEFT OUTER JOIN archChunk AC WITH (NOLOCK)
						ON V.VolumeId = AC.VolumeId
		WHERE		AC.VolumeId IS NULL
		-- Get from MMDeletedAF (Non-SI Volumes)
		INSERT INTO	#tempMMPruneList
		SELECT		DISTINCT V.VolumeId, V.VolumeName, V.OMLVersion, H.ClientId, MP.MountPathId,
					MP.MountPathName, MP.MountPathTypeId, MP.UserName, MP.UserPassword, V.SIDBStoreId,
					V.origCCcommCellID, V.origCCcommCellID, V.origCCvolumeID, N'', DAF.cclip,
					DAF.archFileId, DAF.archChunkId, @PRUNE_TYPE_REG, @PRUNE_ENTITY_REG_VOL_AND_AF, 0, 0
		FROM		MMMountPath MP WITH (NOLOCK) INNER JOIN MMLibraryController LC WITH (NOLOCK)
						ON MP.LibraryId = LC.LibraryId
						AND MP.IsEnabled = 1
						AND MP.IsOffline = 0
						AND MP.MountPathTypeId = @i_MountPathTypeId
					INNER JOIN MMHost H WITH (NOLOCK)
						ON H.ClientId = LC.ClientId
						AND H.MmHostEnabled = 1
						AND H.MmHostSoftState = 1
					INNER JOIN MMDeletedAF DAF WITH (NOLOCK)
						ON MP.MountPathId = DAF.MountPathId
						AND (DAF.archFileId > 0 AND DAF.archChunkId > 0)
						AND DAF.SIDBStoreId = 0
					INNER JOIN MMVolume V WITH (NOLOCK)
						ON DAF.Volumeid = V.VolumeId
		-- Get from MMDeletedAF (SI Volumes)
		INSERT INTO	#tempMMPruneList
		SELECT		DISTINCT V.VolumeId, V.VolumeName, V.OMLVersion, H.ClientId, MP.MountPathId,
					MP.MountPathName, MP.MountPathTypeId, MP.UserName, MP.UserPassword, V.SIDBStoreId,
					V.origCCcommCellID, V.origCCcommCellID, V.origCCvolumeID, N'', N'',
					DAF.archFileId, DAF.archChunkId, @PRUNE_TYPE_SI, @PRUNE_ENTITY_REG_VOL_AND_AF, 0, 0
		FROM		MMMountPath MP WITH (NOLOCK) INNER JOIN MMLibraryController LC WITH (NOLOCK)
						ON MP.LibraryId = LC.LibraryId
						AND MP.IsEnabled = 1
						AND MP.IsOffline = 0
						AND MP.MountPathTypeId = @i_MountPathTypeId
					INNER JOIN MMHost H WITH (NOLOCK)
						ON H.ClientId = LC.ClientId
						AND H.MmHostEnabled = 1
						AND H.MmHostSoftState = 1
					INNER JOIN MMDeletedAF DAF WITH (NOLOCK)
						ON MP.MountPathId = DAF.MountPathId
						AND (DAF.archFileId > 0 AND DAF.archChunkId > 0)
					INNER JOIN archCopySIDBStore ACS WITH (NOLOCK)
						ON DAF.SIDBStoreId = ACS.SIDBStoreId
					INNER JOIN archGroupCopy AGC WITH (NOLOCK)
						ON AGC.id = ACS.CopyId
AND (AGC.dedupeFlags & 2097152 /* 2097152 */) = 0
					INNER JOIN IdxSIDBStore SIDB WITH (NOLOCK)
						ON SIDB.SIDBStoreId = DAF.SIDBStoreId
						AND SIDB.CommCellId = 2
AND (SIDB.flags & 256 /* 256 */) = 0
AND SIDB.Status <> 1 /* 1 */
					INNER JOIN MMVolume V WITH (NOLOCK)
						ON DAF.Volumeid = V.VolumeId
	END
	ELSE	-- MOUNT_PATH_SHARED_STATIC, MOUNT_PATH_SHARED_REPLICA, MOUNT_PATH_EXTERNAL_REMOTE_HOST
	BEGIN
		-- Get Recyclable non-SI Volumes from Regular Mount Paths (MountPathTypeId = MOUNT_PATH_MAGNETIC)
		INSERT INTO	#tempMMPruneList
		SELECT		DISTINCT V.VolumeId, V.VolumeName, V.OMLVersion, H.ClientId, MP.MountPathId,
					MP.MountPathName, MP.MountPathTypeId, DC.UserName, DC.UserPassword, V.SIDBStoreId,
					V.origCCcommCellID, V.origCCcommCellID, V.origCCvolumeID, DC.Folder, N'',
					0, 0, @PRUNE_TYPE_REG, @PRUNE_ENTITY_SHARED_RECYCLE_VOL, 0, DC.CredentialAssocId
		FROM		MMMountPath MP WITH (NOLOCK) INNER JOIN MMMountPathToStorageDevice MPSD WITH (NOLOCK)
						ON MP.MountPathId = MPSD.MountPathId
						AND MP.IsEnabled = 1
						AND MP.IsOffline = 0
						AND MP.MountPathTypeId = @i_MountPathTypeId
					INNER JOIN MMDevice DEV WITH (NOLOCK)
						ON MPSD.DeviceId = DEV.DeviceId
						AND DEV.DeviceEnabled = 1
						AND DEV.DeviceBroken = 0
					INNER JOIN MMDeviceController DC WITH (NOLOCK)
						ON DEV.DeviceId = DC.DeviceId
						AND DC.DeviceControllerEnabled = 1
						AND DC.DeviceAccessible = 1
AND (DC.DeviceAccessType & 2) = 2 /* 2 */
					INNER JOIN MMHost H WITH (NOLOCK)
						ON H.ClientId = DC.ClientId
						AND H.MmHostEnabled = 1
						AND H.MmHostSoftState = 1
					INNER JOIN MMVolume V WITH (NOLOCK)
						ON MP.MediaSideId = V.MediaSideId
						AND V.SIDBStoreId = 0
						AND V.VolumeFlags = 6 /* VOL_RECYCLE */
					LEFT OUTER JOIN archChunk AC WITH (NOLOCK)
						ON V.VolumeId = AC.VolumeId
		WHERE		AC.VolumeId IS NULL
		-- Get Recyclable SI Volumes from Regular Mount Paths (MountPathTypeId = MOUNT_PATH_MAGNETIC)
		INSERT INTO	#tempMMPruneList
		SELECT		DISTINCT V.VolumeId, V.VolumeName, V.OMLVersion, H.ClientId, MP.MountPathId,
					MP.MountPathName, MP.MountPathTypeId, DC.UserName, DC.UserPassword, V.SIDBStoreId,
					V.origCCcommCellID, V.origCCcommCellID, V.origCCvolumeID, DC.Folder, N'', 0, 0,
(CASE WHEN (SIDB.flags & 256 /* 256 */) > 0 THEN @PRUNE_TYPE_REG ELSE @PRUNE_TYPE_SI END), @PRUNE_ENTITY_SHARED_RECYCLE_VOL, 0, DC.CredentialAssocId
		FROM		MMMountPath MP WITH (NOLOCK) INNER JOIN MMMountPathToStorageDevice MPSD WITH (NOLOCK)
						ON MP.MountPathId = MPSD.MountPathId
						AND MP.IsEnabled = 1
						AND MP.IsOffline = 0
						AND MP.MountPathTypeId = @i_MountPathTypeId
					INNER JOIN MMDevice DEV WITH (NOLOCK)
						ON MPSD.DeviceId = DEV.DeviceId
						AND DEV.DeviceEnabled = 1
						AND DEV.DeviceBroken = 0
					INNER JOIN MMDeviceController DC WITH (NOLOCK)
						ON DEV.DeviceId = DC.DeviceId
						AND DC.DeviceControllerEnabled = 1
						AND DC.DeviceAccessible = 1
AND (DC.DeviceAccessType & 2) = 2 /* 2 */
					INNER JOIN MMHost H WITH (NOLOCK)
						ON H.ClientId = DC.ClientId
						AND H.MmHostEnabled = 1
						AND H.MmHostSoftState = 1
					INNER JOIN MMVolume V WITH (NOLOCK)
						ON MP.MediaSideId = V.MediaSideId
						AND V.VolumeFlags = 6 /* VOL_RECYCLE */
					INNER JOIN IdxSIDBStore SIDB WITH (NOLOCK)
						ON SIDB.SIDBStoreId = V.SIDBStoreId
						AND
						(
							SIDB.CommCellId = 2
OR (SIDB.flags & 256 /* 256 */) > 0
						)
						AND
						(
(SIDB.flags & 256 /* 256 */) > 0
							OR
							(
(SIDB.flags & 2097152 /* 2097152 */) = 0
								AND
SIDB.Status <> 1 /* 1 */
								AND
(V.Attributes & 4 /* 4 */) = 0
							)
						)
					LEFT OUTER JOIN archChunk AC WITH (NOLOCK)
						ON V.VolumeId = AC.VolumeId
		WHERE		AC.VolumeId IS NULL
		-- Get from MMDeletedAF (Non-SI Volumes)
		INSERT INTO	#tempMMPruneList
		SELECT		DISTINCT V.VolumeId, V.VolumeName, V.OMLVersion, H.ClientId, MP.MountPathId,
					MP.MountPathName, MP.MountPathTypeId, DC.UserName, DC.UserPassword,	V.SIDBStoreId,
					V.origCCcommCellID, V.origCCcommCellID, V.origCCvolumeID, DC.Folder, DAF.cclip,
					DAF.archFileId, DAF.archChunkId, @PRUNE_TYPE_REG, @PRUNE_ENTITY_SHARED_VOL_AND_AF, 0, DC.CredentialAssocId
		FROM		MMMountPath MP WITH (NOLOCK) INNER JOIN MMMountPathToStorageDevice MPSD WITH (NOLOCK)
						ON MP.MountPathId = MPSD.MountPathId
						AND MP.IsEnabled = 1
						AND MP.IsOffline = 0
						AND MP.MountPathTypeId = @i_MountPathTypeId
					INNER JOIN MMDevice DEV WITH (NOLOCK)
						ON MPSD.DeviceId = DEV.DeviceId
						AND DEV.DeviceEnabled = 1
						AND DEV.DeviceBroken = 0
					INNER JOIN MMDeviceController DC WITH (NOLOCK)
						ON DEV.DeviceId = DC.DeviceId
						AND DC.DeviceControllerEnabled = 1
						AND DC.DeviceAccessible = 1
AND (DC.DeviceAccessType & 2) = 2 /* 2 */
					INNER JOIN MMHost H WITH (NOLOCK)
						ON H.ClientId = DC.ClientId
						AND H.MmHostEnabled = 1
						AND H.MmHostSoftState = 1
					INNER JOIN MMDeletedAF DAF WITH (NOLOCK)
						ON MP.MountPathId = DAF.MountPathId
						AND (DAF.archFileId > 0 AND DAF.archChunkId > 0)
						AND DAF.SIDBStoreId = 0
					INNER JOIN MMVolume V WITH (NOLOCK)
						ON DAF.Volumeid = V.Volumeid
		-- Get from MMDeletedAF (SI Volumes)
		INSERT INTO	#tempMMPruneList
		SELECT		DISTINCT V.VolumeId, V.VolumeName, V.OMLVersion, H.ClientId, MP.MountPathId,
					MP.MountPathName, MP.MountPathTypeId, DC.UserName, DC.UserPassword, V.SIDBStoreId,
					V.origCCcommCellID, V.origCCcommCellID, V.origCCvolumeID, DC.Folder, DAF.cclip, DAF.archFileId, DAF.archChunkId,
(CASE WHEN (SIDB.flags & 256 /* 256 */) > 0 THEN @PRUNE_TYPE_REG ELSE @PRUNE_TYPE_SI END), @PRUNE_ENTITY_SHARED_VOL_AND_AF, 0, DC.CredentialAssocId
		FROM		MMMountPath MP WITH (NOLOCK) INNER JOIN MMMountPathToStorageDevice MPSD WITH (NOLOCK)
						ON MP.MountPathId = MPSD.MountPathId
						AND MP.IsEnabled = 1
						AND MP.IsOffline = 0
						AND MP.MountPathTypeId = @i_MountPathTypeId
					INNER JOIN MMDevice DEV WITH (NOLOCK)
						ON MPSD.DeviceId = DEV.DeviceId
						AND DEV.DeviceEnabled = 1
						AND DEV.DeviceBroken = 0
					INNER JOIN MMDeviceController DC WITH (NOLOCK)
						ON DEV.DeviceId = DC.DeviceId
						AND DC.DeviceControllerEnabled = 1
						AND DC.DeviceAccessible = 1
AND (DC.DeviceAccessType & 2) = 2 /* 2 */
					INNER JOIN MMHost H WITH (NOLOCK)
						ON H.ClientId = DC.ClientId
						AND H.MmHostEnabled = 1
						AND H.MmHostSoftState = 1
					INNER JOIN MMDeletedAF DAF WITH (NOLOCK)
						ON MP.MountPathId = DAF.MountPathId
						AND (DAF.archFileId > 0 AND DAF.archChunkId > 0)
					INNER JOIN archCopySIDBStore ACS WITH (NOLOCK)
						ON DAF.SIDBStoreId = ACS.SIDBStoreId
					INNER JOIN archGroupCopy AGC WITH (NOLOCK)
						ON AGC.id = ACS.CopyId
AND (AGC.dedupeFlags & 2097152 /* 2097152 */) = 0
					INNER JOIN IdxSIDBStore SIDB WITH (NOLOCK)
						ON SIDB.SIDBStoreId = DAF.SIDBStoreId
						AND SIDB.CommCellId = 2
AND (SIDB.flags & 256 /* 256 */) = 0
AND SIDB.Status <> 1 /* 1 */
					INNER JOIN MMVolume V WITH (NOLOCK)
						ON DAF.Volumeid = V.Volumeid
	END
	-- Update user name and password for entries that use credentials
	EXEC MMS2GetDeviceControllerCredentials '#tempMMPruneList', 'CredentialAssocId', 'UserName', 'Password'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetPrunableVolsAndAFs')
	delete from GxQscripts where name = 'MMGetPrunableVolsAndAFs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetPrunableVolsAndAFs')
	delete from GXDBVersions where aliasname = 'MMGetPrunableVolsAndAFs'
GO

insert into GXDBVersions values(2, 'MMGetPrunableVolsAndAFs',  '00010004019800030000', 'MMGetPrunableVolsAndAFs', '00010004019800030000')
GO

