

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetPlansForStoragePool.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetPlansForStoragePool.sp,v $ $Id: MMGetPlansForStoragePool.sp,v 1.1.2.8 2020/10/26 06:31:23 pveeravalli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetPlansForStoragePool')
BEGIN
	print '>>> Drop Stored Procedure: MMGetPlansForStoragePool <<<'
	drop procedure MMGetPlansForStoragePool
END
IF EXISTS (select * from GxQscripts where name='MMGetPlansForStoragePool')
	delete from GxQscripts where name = 'MMGetPlansForStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetPlansForStoragePool')
	delete from GXDBVersions where aliasname = 'MMGetPlansForStoragePool'
GO
print '... Creating Procedure: MMGetPlansForStoragePool'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetPlansForStoragePool
  @i_StoragePoolId integer = 0
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_PlanId integer
  DECLARE @o_PlanName NVARCHAR(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tmpDependentCopyList') IS NOT NULL DROP TABLE #tmpDependentCopyList
CREATE TABLE  #tmpDependentCopyList
(
    archGroupId     integer,
    archGroupName   nvarchar(255),
    copyId          integer,
    copyName        nvarchar(255)
)
DECLARE @storagePoolType INTEGER
SELECT @storagePoolType = flags FROM archGroup WITH (NOLOCK) WHERE id = @i_StoragePoolId
INSERT INTO #tmpDependentCopyList (archGroupId, archGroupName, copyId, copyName)
SELECT	AG.id, AG.name, AGC.id, AGC.name
FROM archGroup AG WITH (READUNCOMMITTED)
     INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON AG.id = AGC.archGroupId
     INNER JOIN archCopyToGlobalPolicy GP WITH (READUNCOMMITTED) ON GP.CopyId = AGC.id
     WHERE  GP.GlobalPolicyId = @i_StoragePoolId
SELECT DISTINCT AP.id, AP.name FROM APP_Plan AP WITH (NOLOCK)
inner join
(
	SELECT APP.componentNameId AS PlanId FROM APP_PlanProp APP WITH (NOLOCK)
	inner join #tmpDependentCopyList TMP ON APP.attrName = 'Storage Policy' AND CONVERT(INT,APP.attrVal) = TMP.archGroupId AND APP.modified = 0
	UNION
	SELECT ref.value('@planId', 'INT') AS PlanId FROM App_PlanRule PR WITH (NOLOCK)
		inner join #tmpDependentCopyList TMP ON PR.storagePolicyId = TMP.archGroupId
		CROSS APPLY PR.planIds.nodes('Api_planList/plan') R(ref)
) TMP1
ON AP.id = TMP1.PlanId AND (AP.flag & 0x00020 = 0)
IF OBJECT_ID('tempdb.dbo.#tmpDependentCopyList') IS NOT NULL DROP TABLE #tmpDependentCopyList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetPlansForStoragePool')
	delete from GxQscripts where name = 'MMGetPlansForStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetPlansForStoragePool')
	delete from GXDBVersions where aliasname = 'MMGetPlansForStoragePool'
GO

insert into GXDBVersions values(2, 'MMGetPlansForStoragePool',  '00010001000200080000', 'MMGetPlansForStoragePool', '00010001000200080000')
GO

