

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetOneDeviceInfoForStoragePool.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetOneDeviceInfoForStoragePool.sp,v $ $Id: MMGetOneDeviceInfoForStoragePool.sp,v 1.1.2.9 2018/09/11 11:03:22 pveeravalli Exp $";
--
-- #define EXCLUDE_SILO_DATAPATH_FLAG 1 for i_Flags
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetOneDeviceInfoForStoragePool <<<'

IF EXISTS (select * from sysobjects where name='MMGetOneDeviceInfoForStoragePool')
	drop procedure MMGetOneDeviceInfoForStoragePool
IF EXISTS (select * from GxQscripts where name='MMGetOneDeviceInfoForStoragePool')
	delete from GxQscripts where name = 'MMGetOneDeviceInfoForStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetOneDeviceInfoForStoragePool')
	delete from GXDBVersions where aliasname = 'MMGetOneDeviceInfoForStoragePool'
GO
print '... Creating Procedure: MMGetOneDeviceInfoForStoragePool'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetOneDeviceInfoForStoragePool
  @i_UserId integer,
  @i_StoragePoolId integer,
  @i_Reserve integer
AS
  DECLARE @deviceControllerId integer
  DECLARE @deviceControllerActive integer
  DECLARE @deviceControllerEnabled integer
  DECLARE @deviceAccessible integer
  DECLARE @MAClientId integer
  DECLARE @MAClientName char(255)
  DECLARE @deviceControllerPath VARCHAR(1024)
  DECLARE @deviceControllerUser VARCHAR(1024)
  DECLARE @readWriteAccess integer
  DECLARE @servicePack integer
  DECLARE @dataServerPath VARCHAR(1024)
  DECLARE @deviceId integer
  DECLARE @libraryId integer
  DECLARE @libraryAliasName NVARCHAR(255)
  DECLARE @mountPathId integer
  DECLARE @mountPathName NVARCHAR(2048)
  DECLARE @MADisplayName NVARCHAR(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	--
	-- Temporary table variables
	--
	DECLARE @tmpLibraryId INT = 0
	DECLARE @tmpMountPathName NVARCHAR(2048) = ''
DECLARE @tmpLibraryAliasName NVARCHAR(128) = ''
	DECLARE @showHiddenLibConfig INTEGER = 0
    DECLARE @tmpLibraryListForStoragePool TABLE
	(
		LibraryId					integer primary key,
AliasName  					NVARCHAR(128)
	)
	DECLARE @tblSecLibrary table
	(  LibraryId int,
	   capabilities bigint
	)
    INSERT INTO @tblSecLibrary
    EXEC sec_getLibraryForUser @i_UserId
	-------------------------------------------------
    -- Get 'MMCONFIG_SHOW_HIDDEN_LIBRARIES' value from MMConfigs
    -------------------------------------------------
    SELECT @showHiddenLibConfig = value
    FROM    MMConfigs WITH (NOLOCK)
    WHERE NAME = 'MMCONFIG_SHOW_HIDDEN_LIBRARIES'
	INSERT INTO @tmpLibraryListForStoragePool
    SELECT DISTINCT MP.LibraryId,ML.AliasName
    FROM MMDrivePool DRP WITH (READUNCOMMITTED)
	     INNER JOIN MMDataPath DAP WITH (READUNCOMMITTED) ON DAP.DrivePoolId = DRP.DrivePoolId
		 INNER JOIN ArchGroup  AR WITH (READUNCOMMITTED) ON  (AR.defaultCopy = DAP.CopyId AND AR.id = @i_StoragePoolId)
         INNER JOIN MMMasterPool MP WITH (READUNCOMMITTED) ON DRP.MasterPoolId = MP.MasterPoolId
		 INNER JOIN MMLibrary ML WITH (READUNCOMMITTED) ON  MP.LibraryId = ML.LibraryId
		 INNER JOIN @tblSecLibrary  SL   ON  SL.LibraryId = ML.LibraryId
WHERE ML.LibraryTypeId = 3
AND ( (@showHiddenLibConfig = 1) OR (ML.ExtendedAttributes & 33554432 = 0) )
	--Now you have the list of Disk libraries in the given storage pool
	DECLARE @mpId INTEGER = 0
	select TOP 1 @mpId = MP.MountPathId from MMDeviceController MDC  WITH (READUNCOMMITTED)
	JOIN MMDevice MD  WITH (READUNCOMMITTED) ON MDC.DeviceId = MD.DeviceId
	JOIN MMMountPathToStorageDevice MSD  WITH (READUNCOMMITTED) ON MSD.DeviceId = MD.DeviceId
	JOIN MMMountPath MP  WITH (READUNCOMMITTED) ON MSD.MountPathId = MP.MountPathId
	JOIN @tmpLibraryListForStoragePool tmp ON tmp.LibraryId = MP.LibraryId
	GROUP BY  MP.MountPathId, MDC.DeviceId ORDER BY count(MDC.DeviceId)
	SELECT @tmpLibraryId = MP.LibraryId, @tmpMountPathName = MP.MountPathName,  @tmpLibraryAliasName = ML.AliasName
	from MMMountPath MP  WITH (READUNCOMMITTED)
	JOIN @tmpLibraryListForStoragePool ML ON ML.LibraryId = MP.LibraryId
	where MP.MountPathId=@mpId
	IF OBJECT_ID('tempdb.dbo.#tmpDeviceControllersForStoragePool') IS NOT NULL DROP TABLE #tmpDeviceControllersForStoragePool
	CREATE TABLE  #tmpDeviceControllersForStoragePool
    (
		deviceControllerId			integer,
		deviceControllerActive			integer,
		deviceControllerEnabled			integer,
		deviceAccessible				integer,
		MAClientId					integer,
MAClientName				char(255),
		deviceControllerPath			VARCHAR(1024),
		deviceControllerUser			VARCHAR(1024),
		readWriteAccess				integer,
		servicePack					integer,
		dataServerPath				VARCHAR(1024),
		deviceId					integer,
		credentialId				integer,
credentialName				nvarchar(255),
MADisplayName				nvarchar(255))
	exec MMS2GetDevicePathsForMountPath @mpId
	SELECT deviceControllerId,
			deviceControllerActive,
			deviceControllerEnabled,
			deviceAccessible,
			MAClientId,
			MAClientName,
			deviceControllerPath,
			CASE credentialId
				WHEN 0 THEN deviceControllerUser
				ELSE credentialName
			END AS deviceControllerUser,
			readWriteAccess,
			servicePack,
			dataServerPath,
			deviceId,
			@tmpLibraryId AS 'Library Id' ,
			@tmpLibraryAliasName AS 'Library Name' ,
			@mpId AS 'Mountpath Id',
			@tmpMountPathName AS 'Mountpath Name',
			MADisplayName
	FROM #tmpDeviceControllersForStoragePool
	DROP TABLE #tmpDeviceControllersForStoragePool
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetOneDeviceInfoForStoragePool')
	delete from GxQscripts where name = 'MMGetOneDeviceInfoForStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetOneDeviceInfoForStoragePool')
	delete from GXDBVersions where aliasname = 'MMGetOneDeviceInfoForStoragePool'
GO

insert into GXDBVersions values(2, 'MMGetOneDeviceInfoForStoragePool',  '00010001000200090000', 'MMGetOneDeviceInfoForStoragePool', '00010001000200090000')
GO

