

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMountpathListForStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMountpathListForStore.sp,v $ $Id: MMGetMountpathListForStore.sp,v 1.1.2.3 2020/08/18 21:01:16 gharidas Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMGetMountpathListForStore"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetMountpathListForStore')
BEGIN
	print '>>> Drop Stored Procedure: MMGetMountpathListForStore <<<'
	drop procedure MMGetMountpathListForStore
END
IF EXISTS (select * from GxQscripts where name='MMGetMountpathListForStore')
	delete from GxQscripts where name = 'MMGetMountpathListForStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountpathListForStore')
	delete from GXDBVersions where aliasname = 'MMGetMountpathListForStore'
GO
print '... Creating Procedure: MMGetMountpathListForStore'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMountpathListForStore
  @i_volumeId integer,
  @i_storeId integer
AS
  DECLARE @o_MountPathId INTEGER
  DECLARE @o_originalMountPathId INTEGER
  DECLARE @o_MountPathType INTEGER
  DECLARE @o_MountpathName VARCHAR(2048)
  DECLARE @o_userName VARCHAR(1024)
  DECLARE @o_userPassword VARCHAR(2048)
  DECLARE @o_DeviceAccessType INTEGER
  DECLARE @o_FolderPath VARCHAR(1024)
  DECLARE @o_VolumeName VARCHAR(112)
  DECLARE @o_clientId INTEGER
  DECLARE @o_clientName VARCHAR(1024)
  DECLARE @o_MountpathAttributes INTEGER
if object_id('tempdb.dbo.#MountPathList') is not null DROP table #MountPathList
CREATE TABLE #MountPathList(MountPathId int PRIMARY KEY, originalMountPathId int, MountPathType int, MountpathName varchar(2048), userName varchar(1024), userPassword varchar(2048),
								DeviceAccessType int, FolderPath varchar(1024), VolumeName varchar(256), clientId int, clientName varchar(1024), CredAssocId integer, MountpathAttributes integer)
if object_id('tempdb.dbo.#tempVolumeTable') is not null DROP table #tempVolumeTable
CREATE TABLE #tempVolumeTable
(      mediaSideId INTEGER,
       volumeName VARCHAR(256)
       PRIMARY KEY (mediaSideId)
)
 IF (@i_volumeId > 0)
 BEGIN
	SELECT @i_storeId = SIDBStoreID FROM MMVolume WITH (READUNCOMMITTED) WHERE VolumeId = @i_volumeId
 END
INSERT INTO #tempVolumeTable
SELECT DISTINCT MediaSideId, ''
FROM   MMVolume WITH (READUNCOMMITTED)
WHERE  SIDBStoreId = @i_storeId
UPDATE T
SET T.volumeName = V.VolumeName
FROM #tempVolumeTable T, MMVolume V WITH (READUNCOMMITTED)
WHERE T.MediaSideId = V.MediaSideId
 INSERT INTO #MountPathList
 SELECt DISTINCT MP.MountPathId,MP.OrigCCMountPathId, MP.MountPathTypeId, MP.MountPathName, '', '', 0, '', MV.volumeName, 0, '', 0, MP.attribute
 FROM #tempVolumeTable AS MV
 INNER JOIN MMMountpath MP WITH (READUNCOMMITTED) ON MV.MediaSideId = MP.MediaSideId
 UPDATE MP
 SET MP.FolderPath = MDC.Folder, MP.DeviceAccessType = MDC.DeviceAccessType, MP.userName = MDC.userName, MP.userPassword = MDC.UserPassword,
 MP.clientId = CL.id, MP.clientName = CL.name,  MP.CredAssocId = MDC.CredentialAssocId
 FROM #MountPathList MP
 inner join MMMountPathToStorageDevice MP2SD WITH (READUNCOMMITTED) on MP2SD.MountPathId = MP.MountPathId
 inner join MMDeviceController MDC WITH (READUNCOMMITTED) on MP2SD.DeviceId = MDC.DeviceId AND MDC.DeviceAccessible = 1 AND MDC.DeviceControllerEnabled = 1
 inner join APP_Client CL WITH (READUNCOMMITTED) on MDC.clientId = CL.id
 EXEC MMS2GetDeviceControllerCredentials '#MountPathList', 'CredAssocId', 'userName', 'userPassword'
 select count(*), 0, 0, '', '', '', 0, '', '', 0, '', 0 from #MountPathList
 UNION
 select MountPathId, originalMountPathId, MountPathType, MountpathName, userName, userPassword, DeviceAccessType, FolderPath, VolumeName, clientId, clientName, MountpathAttributes from #MountPathList
 if object_id('tempdb.dbo.#MountPathList') is not null DROP table #MountPathList
 if object_id('tempdb.dbo.#tempVolumeTable') is not null DROP table #tempVolumeTable
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMountpathListForStore')
	delete from GxQscripts where name = 'MMGetMountpathListForStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountpathListForStore')
	delete from GXDBVersions where aliasname = 'MMGetMountpathListForStore'
GO

insert into GXDBVersions values(2, 'MMGetMountpathListForStore',  '00010001000200030000', 'MMGetMountpathListForStore', '00010001000200030000')
GO

