

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMountPathListWC.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMountPathListWC.sp,v $ $Id: MMGetMountPathListWC.sp,v 1.3.2.8 2019/12/18 23:06:50 prasanthm Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetMountPathListWC')
BEGIN
	print '>>> Drop Stored Procedure: MMGetMountPathListWC <<<'
	drop procedure MMGetMountPathListWC
END
IF EXISTS (select * from GxQscripts where name='MMGetMountPathListWC')
	delete from GxQscripts where name = 'MMGetMountPathListWC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountPathListWC')
	delete from GXDBVersions where aliasname = 'MMGetMountPathListWC'
GO
print '... Creating Procedure: MMGetMountPathListWC'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMountPathListWC
  @i_LibraryId integer
AS
  DECLARE @o_mountPathId integer
  DECLARE @o_mountPathName NVARCHAR(1024)
  DECLARE @o_mountPathType integer
  DECLARE @o_deviceName NVARCHAR(1024)
  DECLARE @o_deviceId integer
  DECLARE @o_isOnline integer
  DECLARE @o_jobIdList varchar(max)
  DECLARE @o_maNameList varchar(max)
  DECLARE @o_rpStoreId integer
  DECLARE @o_minspacePerRPStoreGB integer
  DECLARE @o_maxspacePerRPStoreGB integer
  DECLARE @o_MPUsedForLogCaching integer
  DECLARE @o_MountPathOfflineReason integer
  DECLARE @o_isDeviceOrControllersOffline integer 
DECLARE @tblMP TABLE(MountPathId INT, MediaId INT)
INSERT INTO @tblMP
SELECT mp.MountPathId, ms.MediaId
FROM MMMountPath mp WITH (NOLOCK), MMMediaSide as ms WITH (NOLOCK), MMMedia as mm WITH (NOLOCK)
WHERE mm.libraryId = @i_LibraryId
AND mp.mediaSideId = ms.mediaSideId
AND ms.MediaId = mm.MediaId
DECLARE @tblJobMA TABLE(MountPathId INT, JobId INT, ClientId INT)
INSERT INTO @tblJobMA
SELECT DISTINCT A.MountPathId, C.JobId_l, B.ClientId
FROM @tblMP A, MMResource B WITH (NOLOCK), MMResourceToJob C WITH(NOLOCK)
WHERE A.MediaId = B.MediaId AND B.ReservationId = C.ReservationId
DECLARE @tblMA TABLE(MountPathId INT, maName NVARCHAR(256))
DECLARE @tblMAList TABLE(MountPathId INT, maNameList varchar(max))
INSERT INTO @tblMA
SELECT DISTINCT MountPathId, C.Name
FROM @tblJobMA A, MMHost B WITH(NOLOCK), APP_Client C WITH(NOLOCK)
WHERE A.ClientId = B.ClientId
AND B.ClientId = C.Id
INSERT INTO @tblMAList
SELECT A.MountPathId,
	(	SELECT maName + ','
		FROM @tblMA B
		WHERE A.MountPathId = B.MountPathId
		ORDER BY MountPathId
		FOR XML PATH('')
	)	AS maNameList
FROM @tblMA A
UPDATE @tblMAList
SET maNameList = (CASE WHEN LEN(maNameList) > 0 THEN SUBSTRING(maNameList, 1, LEN(maNameList)-1) ELSE maNameList END)
DECLARE @tblJobList TABLE(MountPathId INT, JobIdList varchar(max))
INSERT INTO @tblJobList
SELECT A.MountPathId,
	(	SELECT CONVERT(VARCHAR(20), B.JobId) + ','
		FROM @tblJobMA B
		WHERE A.MountPathId = B.MountPathId
		ORDER BY JobId
		FOR XML PATH('')
	)	AS JobIdList
FROM @tblJobMA A
UPDATE @tblJobList
SET JobIdList = (CASE WHEN LEN(JobIdList) > 0 THEN SUBSTRING(JobIdList, 1, LEN(JobIdList)-1) ELSE JobIdList END)
SELECT DISTINCT MP.MountPathId, MP.MountPathName, MP.MountPathTypeId,
		DeviceName = (CASE WHEN MP.DeviceId = 0 THEN N'' ELSE MD.AliasName END),
		MP.DeviceId,
		IsOnline = (CASE WHEN
						EXISTS(SELECT 1 FROM MMDeviceController AS DC WITH (READUNCOMMITTED) WHERE MD.DeviceId = DC.DeviceId AND DC.DeviceAccessible > 0 AND DC.DeviceControllerEnabled > 0) AND
						MP.IsEnabled > 0 and MP.IsOffline = 0 and MD.DeviceBroken = 0 and MD.DeviceEnabled > 0
						THEN 1 ELSE 0 END),
		JobIdList = ISNULL(JB.JobIdList, ''),
		MaNameList = ISNULL(MA.MaNameList, N''),
		RPStoreID = ISNULL(MRP.RPStoreId, 0),
		MinSpacePerRPStoreGB = ISNULL(MRP.MinSpacePerRPStoreGB, 0),
		MaxSpacePerRPStoreGB = ISNULL(MRP.MaxSpacePerRPStoreGB, 0),
		MPUsedForLogCaching = CASE WHEN EXISTS(SELECT 1 FROM APP_SubclientToMountpathMapping SCM WITH (READUNCOMMITTED) WHERE SCM.mountPathId = MP.MountPathId) THEN 1 ELSE 0 END,
		MP.OfflineReason,
		isDeviceOrControllersOffline = CASE WHEN MD.DeviceBroken <> 0 OR MD.DeviceEnabled = 0 OR NOT EXISTS(SELECT 1 FROM MMDeviceController AS DC WITH (READUNCOMMITTED) WHERE MD.DeviceId = DC.DeviceId AND DC.DeviceAccessible > 0 AND DC.DeviceControllerEnabled > 0) THEN 1 ELSE 0 END
FROM MMS2getMountPathNameGUIView MP WITH (NOLOCK)
        JOIN MMDevice AS MD WITH (READUNCOMMITTED) ON MD.DeviceId = MP.DeviceId
		LEFT OUTER JOIN @tblJobList JB ON MP.MountPathId = JB.MountPathId
		LEFT OUTER JOIN @tblMAList MA ON MP.MountPathId = MA.MountPathId
		LEFT OUTER JOIN MMRPStoreConfig MRP ON MP.MountPathId = MRP.currMountPathId
WHERE MP.LibraryId = @i_libraryId
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMountPathListWC')
	delete from GxQscripts where name = 'MMGetMountPathListWC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountPathListWC')
	delete from GXDBVersions where aliasname = 'MMGetMountPathListWC'
GO

insert into GXDBVersions values(2, 'MMGetMountPathListWC',  '00010003000200080000', 'MMGetMountPathListWC', '00010003000200080000')
GO

