

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMountPathListToMarkOfflineForHost.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMountPathListToMarkOfflineForHost.sp,v $ $Id: MMGetMountPathListToMarkOfflineForHost.sp,v 1.1.2.4 2018/03/20 00:02:03 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetMountPathListToMarkOfflineForHost <<<'

IF EXISTS (select * from sysobjects where name='MMGetMountPathListToMarkOfflineForHost')
	drop procedure MMGetMountPathListToMarkOfflineForHost
IF EXISTS (select * from GxQscripts where name='MMGetMountPathListToMarkOfflineForHost')
	delete from GxQscripts where name = 'MMGetMountPathListToMarkOfflineForHost'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountPathListToMarkOfflineForHost')
	delete from GXDBVersions where aliasname = 'MMGetMountPathListToMarkOfflineForHost'
GO
print '... Creating Procedure: MMGetMountPathListToMarkOfflineForHost'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMountPathListToMarkOfflineForHost
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_hostClientId integer,
  @i_resvInt integer
AS
  DECLARE @o_mountPathId integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
DECLARE	@tblMountPath TABLE	(
	mountPathId				integer
)
DECLARE	@tblClientIds TABLE	(
	t_clientId				integer
)
DECLARE	@l_clientId		integer
SET		@l_clientId	= 0
INSERT INTO @tblClientIds
SELECT AP1.componentNameId FROM APP_ClientProp AP1, APP_ClientProp AP2
WHERE  AP1.attrVal = (CAST (@i_hostClientId  as nvarchar(255))) AND AP1.modified = 0  AND AP1.componentNameId != @i_hostClientId
AND ((AP1.componentNameId = 2 and AP1.attrName = 'CS Active Physical Node') OR (AP1.componentNameId <> 2 and AP1.attrName = 'Active Physical Node'))
AND AP1.componentNameId = AP2.componentNameId AND AP2.attrName = 'Virtual Client' AND (CAST (AP2.attrVal as integer)) = 1
INSERT INTO @tblClientIds
SELECT @i_hostClientId
--Pick only direct attached MountPaths for this MA.
INSERT	INTO @tblMountPath
SELECT	MP.MountPathId
FROM	MMMountPath MP, MMMountPathToStorageDevice PD, MMDeviceController DC, MMLibrary L, @tblClientIds CL
WHERE	(MP.MountPathTypeId IN (4,5,6,7) OR MP.MountPathTypeId = 2 AND DC.VolumeScsiReserved = 1)
		/*2-MOUNT_PATH_DYNAMIC_SHARED, 4-MOUNT_PATH_SHARED_STATIC, 5-MOUNT_PATH_SHARED_REPLICA,6-MOUNT_PATH_DRU*/
		/*7-MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	AND MP.MountPathId = PD.MountPathId AND PD.DeviceId = DC.DeviceId and DC.DeviceControllerEnabled = 1
	AND DC.ClientId = CL.t_clientId AND L.LibraryId = MP.LibraryId
AND DC.DeviceAccessType & (16|32|128) = 0
--Delete any MountPaths which has other non - (DATASERVER_IP_DEVICEACCESS|DATASERVER_SAN_DEVICEACCESS|DATASERVER_ISCSI_DEVICEACCESS) online Media Agents.
DELETE T
FROM @tblMountPath T
	INNER JOIN MMMountPathToStorageDevice PD ON T.MountPathId = PD.MountPathId
	INNER JOIN MMDeviceController DC ON DC.DeviceId = PD.DeviceId
	INNER JOIN MMHost H ON DC.ClientId = H.ClientId
WHERE DC.ClientId NOT IN (SELECT t_clientId FROM @tblClientIds)
AND DC.DeviceAccessible = 1
AND DC.DeviceControllerEnabled = 1
AND H.MmHostEnabled = 1
AND H.MmHostSoftState = 1
AND DC.DeviceAccessType & (16|32|128) = 0
SELECT	mountPathId
FROM	@tblMountPath T
ORDER BY mountPathId
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMountPathListToMarkOfflineForHost')
	delete from GxQscripts where name = 'MMGetMountPathListToMarkOfflineForHost'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountPathListToMarkOfflineForHost')
	delete from GXDBVersions where aliasname = 'MMGetMountPathListToMarkOfflineForHost'
GO

insert into GXDBVersions values(2, 'MMGetMountPathListToMarkOfflineForHost',  '00010001000200040000', 'MMGetMountPathListToMarkOfflineForHost', '00010001000200040000')
GO

