

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMountPathListForPhysicalNode.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMountPathListForPhysicalNode.sp,v $ $Id: MMGetMountPathListForPhysicalNode.sp,v 1.23.2.12.8.1 2021/04/16 21:43:04 vvarghese Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetMountPathListForPhysicalNode')
BEGIN
	print '>>> Drop Stored Procedure: MMGetMountPathListForPhysicalNode <<<'
	drop procedure MMGetMountPathListForPhysicalNode
END
IF EXISTS (select * from GxQscripts where name='MMGetMountPathListForPhysicalNode')
	delete from GxQscripts where name = 'MMGetMountPathListForPhysicalNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountPathListForPhysicalNode')
	delete from GXDBVersions where aliasname = 'MMGetMountPathListForPhysicalNode'
GO
print '... Creating Procedure: MMGetMountPathListForPhysicalNode'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetMountPathListForPhysicalNode
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
-- If isSummary set to true, this will return total capacity of all the mount pathes
-- Otherwise, this will return individual capacity of mount pathes
  @i_hostClientId integer,
  @i_resvInt integer
AS
  DECLARE @o_mountPathId integer
  DECLARE @o_mountPathName NVARCHAR(1024)
  DECLARE @o_userName varchar(1024)
  DECLARE @o_userPassword NVARCHAR(2048)
  DECLARE @o_clientId integer
  DECLARE @o_mountPathTypeId integer
  DECLARE @o_mountPathAttribute integer
  DECLARE @o_origCcCommCellId integer
  DECLARE @o_origCcMountPathId integer
  DECLARE @o_libraryId integer
  DECLARE @o_libAttributes integer
  DECLARE @o_libExtAttributes integer
  DECLARE @o_deviceAccessType integer
  DECLARE @o_noOfCenteraAccessNodes integer
  DECLARE @o_centeraAccessNode varchar(255)
  DECLARE @o_mountPathFlags integer
  DECLARE @o_mountPathExProps varchar(MAX)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
IF OBJECT_ID('tempdb.dbo.#tblMountPath') IS NOT NULL
DROP TABLE #tblMountPath
CREATE TABLE #tblMountPath (
	mountPathId				integer,
mountPathName			nvarchar(1024),
userName				varchar(1024),
userPassword			nvarchar(2048),
	clientId				integer,
	mountPathTypeId			integer,
	mountPathAttribute		integer,
	origCcCommCellId		integer,
	origCcMountPathId		integer,
	libraryId				integer,
	libAttributes			integer,
	libExtAttributes		integer,
	deviceAccessType		integer,
	centeraId				integer,
	noOfCenteraAccessNodes	integer,
	mountPathFlags			integer,
	credentialAssocId		integer,
	mountPathExProps		varchar(max)
)
DECLARE	@tblClientIds TABLE	(
	t_clientId				integer
)
DECLARE	@l_clientId		integer
SET		@l_clientId	= 0
/* Jai - Fri Aug 29 13:49:12 EDT 2008
** No longer needed since we are now getting mountpaths from virtual MA but will be sending
** to active physical node.
** -- See MR 18537 for more details.
*/
INSERT INTO @tblClientIds
SELECT AP1.componentNameId FROM APP_ClientProp AP1, APP_ClientProp AP2
WHERE  AP1.attrVal = (CAST (@i_hostClientId  as nvarchar(255))) AND AP1.modified = 0  AND AP1.componentNameId != @i_hostClientId
AND ((AP1.componentNameId = 2 and AP1.attrName = 'CS Active Physical Node') OR (AP1.componentNameId <> 2 and AP1.attrName = 'Active Physical Node'))
AND AP1.componentNameId = AP2.componentNameId AND AP2.attrName = 'Virtual Client' AND (CAST (AP2.attrVal as integer)) = 1
INSERT INTO @tblClientIds
SELECT @i_hostClientId
INSERT	INTO #tblMountPath
SELECT	MP.MountPathId, MP.MountPathName, MP.UserName, MP.UserPassword, CL.t_clientID,
		MP.MountPathTypeId, MP.Attribute, MP.OrigCcCommCellId, MP.OrigCcMountPathId,
		L.LibraryId, L.LibraryAttribute, L.ExtendedAttributes, 0, ISNULL(PD.CenteraId, 0),
		case when MP.MountPathTypeId = 1
			then (SELECT COUNT(*) FROM MMCenteraAccessNode WHERE centeraId = PD.CenteraId)
		else 0 end,
		0, 0, ''
FROM	MMMountPath MP
	JOIN MMLibraryController LC
		ON MP.MountPathTypeId IN (0, 1) /*0-MOUNT_PATH_MAGNETIC, 1-MOUNT_PATH_CENTERA*/
			AND MP.LibraryId = LC.LibraryId
	JOIN @tblClientIds CL
		ON LC.ClientId = CL.t_clientId
	JOIN MMLibrary L
		ON L.LibraryId = MP.LibraryId
	LEFT OUTER JOIN MMMountPathToStorageDevice PD
		ON MP.MountPathId = PD.MountPathId
INSERT	INTO #tblMountPath
SELECT	MP.MountPathId,
		-- MR 57535 - Gamma: backup is backing up magnetic mountpath contents.
		CASE
			WHEN ( ('/' = RIGHT (DC.Folder, 1))
				OR	('\' = RIGHT (DC.Folder, 1)) )
			THEN (DC.Folder + MP.MountPathName)
			ELSE (DC.Folder + '\' + MP.MountPathName)
		END,
		DC.UserName, DC.UserPassword,
		CL.t_clientID,
		MP.MountPathTypeId, MP.Attribute, MP.OrigCcCommCellId, MP.OrigCcMountPathId,
		L.LibraryId, L.LibraryAttribute, L.ExtendedAttributes, DC.DeviceAccessType, PD.CenteraId,
		(SELECT COUNT(*) FROM MMCenteraAccessNode WHERE centeraId = PD.CenteraId),
		0, DC.CredentialAssocId, ''
FROM	MMMountPath MP, MMMountPathToStorageDevice PD, MMDeviceController DC, MMLibrary L, @tblClientIds CL
WHERE	(MP.MountPathTypeId IN (4,5,6,7,9, 11) OR MP.MountPathTypeId = 2 AND DC.VolumeScsiReserved = 1)
		/*2-MOUNT_PATH_DYNAMIC_SHARED, 4-MOUNT_PATH_SHARED_STATIC, 5-MOUNT_PATH_SHARED_REPLICA,6-MOUNT_PATH_DRU*/
		/*7-MOUNT_PATH_EXTERNAL_REMOTE_HOST, 9-MOUNT_PATH_RPSTORE, 11-MOUNT_PATH_CACHE*/
	AND MP.MountPathId = PD.MountPathId AND PD.DeviceId = DC.DeviceId and DC.DeviceControllerEnabled = 1
	AND DC.ClientId = CL.t_clientId AND L.LibraryId = MP.LibraryId
	-- Filter out MPs that are still pending to join gluster volume
AND (L.LibrarySoftState > 0 OR LibraryStatusReason != 46012)
	-- dont send space-update for disabled mountpaths/library
	AND L.LibraryEnabled > 0
	AND MP.IsEnabled > 0
-- CI Support with HyperScale MountPaths
-- On prodcommserver and forevercell gluster volumes are shared with nodes from other gluster volumes via DS/IP.
-- Also the same node can be used to access more than one gluster volume, so use mountpathId in forming peerlist.
DECLARE @mountPathPeerListMap TABLE (mountPathId int, peerList nvarchar(1024))
INSERT INTO @mountPathPeerListMap
SELECT TMP.MountPathId, R.PeerList
FROM #tblMountPath TMP
		CROSS APPLY
	(	SELECT STUFF (
						(   SELECT DISTINCT '##' + C.net_hostname  FROM
							APP_Client C(NOLOCK), MMDiskHWInfo(NOLOCK) HW, MMMountPathToStorageDevice MPSD(NOLOCK)
							WHERE C.id = HW.hostId AND HW.deviceId = MPSD.DeviceId AND MPSD.MountPathId = TMP.MountPathId
							FOR XML PATH ('')
						)
						, 1, 2, ''
					  )  -- FOR XML PATH concatenates the hostnames and STUFF removes the leading ##.
	) AS R (PeerList)
WHERE TMP.DeviceAccessType & 16 = 16
AND TMP.mountPathAttribute & 64 = 64
-- Data Server - Shared Devices
-- Mount Path Protocol - Access Protocol(iSCSI, FC or IP)|DeviceAccessType|Preferred Data Server Host Id|Preferred Data Server Host Name|Mount Paths Preferred Device Controller|Disk Library Access Path
UPDATE	#tblMountPath
SET		mountPathName = (CASE WHEN TMP.deviceAccessType & 16 /* 16 */ = 16 /* 16 */ THEN N'IP|' WHEN TMP.deviceAccessType & 32 /* 32 */ = 32 /* 32 */ THEN N'FC|' ELSE N'ISCSI|' END)
							+ CAST(TMP.deviceAccessType AS NVARCHAR(10)) + N'|'
							+ CAST(DC.ClientId AS NVARCHAR(10)) + N'|'
							+ (CASE WHEN TMP.mountPathAttribute & 64 = 64 AND TMP.deviceAccessType & 16 = 16 AND TMP2.peerList IS NOT NULL THEN TMP2.peerList + N'|' ELSE CLT.net_hostname + 	N'|' END)
							+ CAST(TMP.MountPathId AS NVARCHAR(10)) + N'|'
							+ (CASE WHEN ( ('/' = RIGHT (DC.Folder, 1)) OR ('\' = RIGHT (DC.Folder, 1)) ) THEN (DC.Folder + MP.MountPathName) ELSE (DC.Folder + '\' + MP.MountPathName) END),
		userName =	DC.UserName, userPassword = DC.UserPassword, credentialAssocId = DC.CredentialAssocId
FROM	#tblMountPath TMP INNER JOIN MMMountPathToStorageDevice MPSD WITH(NOLOCK) ON TMP.MountPathId = MPSD.MountPathId
		INNER JOIN MMMountPath MP WITH(NOLOCK) ON TMP.MountPathId = MP.MountPathId
INNER JOIN MMDeviceController DC WITH(NOLOCK) ON MPSD.DeviceId = DC.DeviceId AND DC.DeviceAccessType & 8 /* 8 */ = 8 /* 8 */
		INNER JOIN APP_Client CLT WITH(NOLOCK) ON DC.ClientId = CLT.id
		LEFT JOIN @mountPathPeerListMap TMP2 ON TMP.MountPathId = TMP2.MountPathId
WHERE	( (TMP.deviceAccessType & 16 /* 16 */ = 16 /* 16 */) OR
(TMP.deviceAccessType & 32 /* 32 */ = 32 /* 32 */) OR
(TMP.deviceAccessType & 128 /* 128 */ = 128 /* 128 */) )
-- Update user name and password for entries that use credentials
EXEC MMS2GetDeviceControllerCredentials '#tblMountPath', 'credentialAssocId', 'userName', 'userPassword'
/* Retrieve and update Silo Status */
UPDATE MP
SET mountPathFlags = 0x01
FROM #tblMountPath MP
INNER JOIN MMVolume V WITH (READUNCOMMITTED) ON V.CurrMountPathId = MP.mountPathId
WHERE V.SiloStatus >= 1
/* Get the extended JSON Properties for the mountpath */
UPDATE MP
SET mountPathExProps = E.stringVal
FROM #tblMountPath MP
	INNER JOIN MMEntityProp E ON MP.mountPathId = E.EntityId
WHERE E.EntityType = 17
AND E.propertyName = 'MountPathExtendedProps'
SELECT	COUNT(DISTINCT mountPathId) AS mountPathId, '' AS mountPathName, '' AS userName, '' AS userPassword, -1 AS clientId,
		-1 AS mountPathTypeId, -1 AS mountPathAttribute, -1 AS origCcCommCellId, -1 AS origCcMountPathId, -1 AS libraryId,
		-1 AS libAttributes, -1 AS libExtAttributes, -1 AS deviceAccessType, -1 AS noOfCenteraAccessNodes, '' AS centeraAccessNode, -1 AS mountPathFlags, '' AS mountPathExProps
FROM	#tblMountPath
UNION
SELECT	mountPathId, mountPathName, userName, userPassword, clientId,
		mountPathTypeId, mountPathAttribute, origCcCommCellId, origCcMountPathId,
		libraryId, libAttributes, libExtAttributes, deviceAccessType,
		noOfCenteraAccessNodes, ISNULL(N.NetHostName, ''), mountPathFlags, mountPathExProps
FROM	#tblMountPath T LEFT OUTER JOIN MMCenteraAccessNode N
	ON	N.CenteraId = T.centeraId
ORDER BY mountPathTypeId, mountPathId
IF OBJECT_ID('tempdb.dbo.#tblMountPath') IS NOT NULL
DROP TABLE #tblMountPath
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMountPathListForPhysicalNode')
	delete from GxQscripts where name = 'MMGetMountPathListForPhysicalNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountPathListForPhysicalNode')
	delete from GXDBVersions where aliasname = 'MMGetMountPathListForPhysicalNode'
GO

insert into GXDBVersions values(2, 'MMGetMountPathListForPhysicalNode',  'v1.23.2.12.8.1', 'MMGetMountPathListForPhysicalNode', 'v1.23.2.12.8.1')
GO

