

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMountPathInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppSharingGetFolderEmails()
--  | Description:  Get shared to emails for a shared folder
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMountPathInfo.sp,v $ $Id: MMGetMountPathInfo.sp,v 1.9.12.2 2018/03/20 00:00:03 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetMountPathInfo <<<'

IF EXISTS (select * from sysobjects where name='MMGetMountPathInfo')
	drop procedure MMGetMountPathInfo
IF EXISTS (select * from GxQscripts where name='MMGetMountPathInfo')
	delete from GxQscripts where name = 'MMGetMountPathInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountPathInfo')
	delete from GXDBVersions where aliasname = 'MMGetMountPathInfo'
GO
print '... Creating Procedure: MMGetMountPathInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetMountPathInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
---
  @i_userId INT,
  @i_libraryId INT,
  @i_mountPathId INT,
  @i_isSummary INT,
  @xmlString XML OUTPUT
-----------------------------------------------------------
AS
BEGIN
DECLARE @_EV_MANAGE_LIBRARY		INT = POWER(2, 8-1)
DECLARE @_EV_ADMIN_LIBRARY		INT = POWER(2, 11-1)
	DECLARE @MountPathRes TABLE ( MountPathId INT, MountPathName NVARCHAR(MAX), LibraryId INT, AliasName NVARCHAR(MAX), TotalSpaceMB BIGINT, FreeBytesMB BIGINT, totalOccupiedSpace BIGINT)
	IF object_id('tempdb.dbo.#entitiesWithViewLibraryCapability') is not null
		DROP TABLE #entitiesWithViewLibraryCapability
--
create table  #entitiesWithViewLibraryCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#entitiesWithViewLibraryCapability'
	INSERT INTO @MountPathRes	EXEC MMGetMountPathCapacity @i_mountPathId, @i_isSummary
	DELETE @MountPathRes
	WHERE MountPathId NOT IN
	(
		SELECT MR.MountPathId
		FROM @MountPathRes MR
		JOIN #entitiesWithViewLibraryCapability sec ON
		--capabilities&(@_EV_MANAGE_LIBRARY|@_EV_ADMIN_LIBRARY)<>0
		--AND
		(
			sec.libraryId = MR.LibraryId
			OR
			sec.mediaAgentId IN ( SELECT id
				FROM	APP_Client CL (NOLOCK)
				INNER JOIN MMLibraryController LC (NOLOCK) ON CL.id =  LC.ClientId
				INNER JOIN MMLibrary L	(NOLOCK) ON  LC.LibraryId = L.LibraryId
				WHERE LC.LibraryId = MR.LibraryId
			)
			OR
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
		)
	)
	SET @xmlString =
		(
			(SELECT
				(SELECT TOP 1
                        CL.id				AS '@clientId',
						CL.name				AS '@clientName',
						CL.net_hostname		AS '@hostName'
				 FROM	APP_Client CL	INNER JOIN MMLibraryController LC	ON CL.id =  LC.ClientId
										INNER JOIN MMLibrary L				ON  LC.LibraryId = L.LibraryId
				 WHERE		LC.LibraryId = @i_libraryId
						AND ((L.LibraryTypeId = 1) AND (LC.LibraryControllerActive = 1) OR (L.LibraryTypeId != 1))
				 FOR XML PATH ('mediaAgent'), TYPE),
				(SELECT TotalSpaceMB '@capacityMB', FreeBytesMB '@freeSpaceMB', totalOccupiedSpace '@usedSpaceMB',
					(SELECT
						MountPathId '@id',
						MountPathName '@name'
						FOR XML PATH ('mountPath'), TYPE
					),
					(SELECT
						LibraryId '@libraryId',
						AliasName '@libraryName'
						FOR XML PATH ('libraryEntity'), TYPE
					)
					FOR XML PATH('MountPathDetails'), TYPE
				)
				FROM @MountPathRes
				WHERE LibraryId = @i_libraryId OR @i_libraryId = 0
				FOR XML PATH(''),
				ROOT('EVGui_MediaAgentMountPathInfo')
			)
		)
	IF @xmlString IS NULL
        SET @xmlString = '<EVGui_MediaAgentMountPathInfo/>'
	IF object_id('tempdb.dbo.#entitiesWithViewLibraryCapability') is not null
		DROP TABLE #entitiesWithViewLibraryCapability
END
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'MMGetMountPathInfo')
	delete from GxQscripts where name = 'MMGetMountPathInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountPathInfo')
	delete from GXDBVersions where aliasname = 'MMGetMountPathInfo'
GO

insert into GXDBVersions values(2, 'MMGetMountPathInfo',  '00010009001200020000', 'MMGetMountPathInfo', '00010009001200020000')
GO

