

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMountPathDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
------------------------------INPUT---------------------------------------
--If mountPath Id is set then it will return details of specific mountPath, irrespective of libraryId
------------------------------Behaviour-----------------------------------
--Only isReady and isReadyToWrite output parameters are reliable
--Rest of the Parameters will skipped as soon as we make sure that mp is not ready
--Means, If we found library is offline, then we will skip rest of the queries
--So, use this stored proc to know MountPath is Ready or Not or basic info
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetMountPathDetails')
BEGIN
	print '>>> Drop Stored Procedure: MMGetMountPathDetails <<<'
	drop procedure MMGetMountPathDetails
END
IF EXISTS (select * from GxQscripts where name='MMGetMountPathDetails')
	delete from GxQscripts where name = 'MMGetMountPathDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountPathDetails')
	delete from GXDBVersions where aliasname = 'MMGetMountPathDetails'
GO
print '... Creating Procedure: MMGetMountPathDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetMountPathDetails
  @i_libraryId integer,			
  @i_mountPathId integer				
AS
--Directly fetched from tables
--MMMountPath
  DECLARE @o_mountPathId integer
  DECLARE @o_libraryId integer
  DECLARE @o_isEnabled integer
  DECLARE @o_isOffline integer
  DECLARE @o_maxConcurrentWriters integer
  DECLARE @o_mountPathTypeId integer
  DECLARE @o_attribute integer
  DECLARE @o_reserveSpaceMB bigint
  DECLARE @o_maxDataToWriteMB bigint
--MMDevice
  DECLARE @o_deviceId integer
  DECLARE @o_deviceTypeId integer
  DECLARE @o_isDeviceEnabled integer
  DECLARE @o_isDeviceBroken integer
--MMMediaSide
  DECLARE @o_totalSpaceMB bigint
  DECLARE @o_freeSpaceMB bigint
--Manipulated from tables
--MMLibrary
  DECLARE @o_isLibraryOnline integer
-- Represent LibraryBroken = 0 AND LibraryEnabled > 0 AND LibrarySoftState > 0
--MMDeviceController
  DECLARE @o_isAnyDeviceControllerEnabled integer
  DECLARE @o_isAnyDeviceControllerHasWriteAccess integer
  DECLARE @o_isAnyDeviceControllerHasWriteAccessAndEnabled integer
  DECLARE @o_isAnyDeviceControllerPowerManaged integer
  DECLARE @o_isAnyDeviceControllerHasWriteAccessAndPowerManaged integer
  DECLARE @o_isReady integer	
--Represent is mp online & enabled & deviceEnabled & deviceControllerEnabled & deviceNotBroken
  DECLARE @o_isReadyToWrite integer		
--Represent is mp online & enabled & deviceEnabled & WriteAccessdeviceControllerEnabled & deviceNotBroken & maxConcurrentWriters >0 & freeSpace>reserveSpace & dataWritten<maxDataToWriteMB
  DECLARE @o_isDeviceControllerExists integer	
  DECLARE @o_credentialId integer	
  DECLARE @o_credentialName NVARCHAR(255) = ''
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tempMountPathInfo') IS NOT NULL DROP TABLE #tempMountPathInfo
CREATE TABLE #tempMountPathInfo (
	mountPathId INT,
	libraryId INT,
	isEnabled INT,
	isOffline INT,
	maxConcurrentWriters INT,
	mountPathTypeId INT,
	attribute INT,
	reserveSpaceMB BIGINT,
	maxDataToWriteMB BIGINT,
	mediaSideId INT,
	deviceId INT DEFAULT 0,
	deviceTypeId INT DEFAULT 0,
	isDeviceEnabled INT DEFAULT 0,
	isDeviceBroken INT DEFAULT 0,
	totalSpaceMB BIGINT DEFAULT 0,
	freeSpaceMB BIGINT DEFAULT 0,
	isAnyDeviceControllerEnabled BIT DEFAULT 0,
	isAnyDeviceControllerHasWriteAccess BIT DEFAULT 0,
	isAnyDeviceControllerHasWriteAccessAndEnabled BIT DEFAULT 0,
	isAnyDeviceControllerPowerManaged BIT DEFAULT 0,
	isAnyDeviceControllerHasWriteAccessAndPowerManaged BIT DEFAULT 0,
	isReady BIT DEFAULT 0,
	isReadyToWrite BIT DEFAULT 0,
	islibraryOnline BIT DEFAULT 0,
	isDeviceControllerExists INT DEFAULT 0,
	credentialId   INT DEFAULT 0,
credentialName NVARCHAR(255) DEFAULT ''
)
declare @libraryId integer = @i_libraryId
declare @mountPathId integer = @i_mountPathId
IF @mountPathId <= 0
	SET @mountPathId = NULL
IF @libraryId <= 0
	SET @libraryId = NULL
INSERT INTO #tempMountPathInfo(mountPathId,libraryId,isEnabled,isOffline,maxConcurrentWriters,mountPathTypeId,attribute,reserveSpaceMB,maxDataToWriteMB,mediaSideId)
	SELECT
		mountPathId,
		libraryId,
		isEnabled,
		isOffline,
		maxConcurrentWriters,
		mountPathTypeId,
		attribute,
		MagneticSpaceRsrvInMB,
		MaxDataToWriteMB,
		mediaSideId
	FROM MMMountPath WITH (NOLOCK)
	WHERE libraryId = ISNULL(@libraryId,libraryId)
		AND mountPathId = ISNULL(@mountPathId,mountPathId)
		-- MOUNT_PATH_EXTERNAL_REMOTE_HOST  = 7 = mountpathtypeid
	UPDATE MP
	SET
		TotalSpaceMB = 	CASE
WHEN mp.mountPathTypeId = 7 AND MS.TotalSpaceMB = 1048576
								THEN -1
							ELSE MS.TotalSpaceMB
						END,
		freeSpaceMB = 	CASE
WHEN mp.mountPathTypeId = 7 AND MS.FreeBytesMB = 1048576
								THEN -1
							ELSE MS.FreeBytesMB
						END
	FROM #tempMountPathInfo AS MP
		INNER JOIN MMMediaSide AS MS WITH (NOLOCK) ON MS.mediaSideId = MP.mediaSideId
	UPDATE MP
	SET	deviceId 									= 	D.DeviceId,
		deviceTypeId								= 	D.DisplayDeviceTypeId,
		isDeviceEnabled 							= 	D.DeviceEnabled,
		isDeviceBroken 								= 	D.DeviceBroken
	FROM #tempMountPathInfo AS MP
		INNER JOIN MMMountPathToStorageDevice AS MPTSD WITH (NOLOCK)	ON MPTSD.mountPathId = MP.mountPathId
		INNER JOIN MMDevice AS D WITH (NOLOCK)	ON D.DeviceId = mptsd.DeviceId
	UPDATE MP
	SET islibraryOnline = 1
	FROM #tempMountPathInfo AS MP
		INNER JOIN MMLibrary AS L WITH (NOLOCK)		ON L.LibraryId = MP.libraryId
	WHERE L.LibraryBroken = 0
		AND LibraryEnabled > 0
		AND LibrarySoftState > 0
	UPDATE MP
	SET	isAnyDeviceControllerEnabled				= 	ISNULL	(
															(
																SELECT TOP 1 1 from MMDeviceController AS DC WITH (NOLOCK)
																INNER JOIN MMHost AS H WITH (NOLOCK) ON DC.ClientId = H.ClientId
																WHERE DC.DeviceControllerEnabled = 1 AND DC.DeviceAccessible = 1
																AND DC.DeviceId = MP.DeviceId
																AND H.MmHostSoftState > 0 AND H.MmHostEnabled > 0
AND H.Attribute & 16 = 0
															),
															0
														),
		isAnyDeviceControllerHasWriteAccess 		= 	ISNULL	(
															(
																SELECT TOP 1 1 from MMDeviceController AS DC WITH (NOLOCK)
WHERE DC.DeviceAccessType & 2 = 2
																AND DC.DeviceId = MP.DeviceId
															),
															0
														),
		isAnyDeviceControllerHasWriteAccessAndEnabled 	= 	ISNULL	(
															(
																SELECT TOP 1 1 from MMDeviceController AS DC WITH (NOLOCK)
																INNER JOIN MMHost AS H WITH (NOLOCK) ON DC.ClientId = H.ClientId
WHERE DC.DeviceAccessType & 2 = 2
																AND DC.DeviceControllerEnabled = 1 AND DC.DeviceAccessible = 1
																AND DC.DeviceId = MP.DeviceId
																AND H.MmHostSoftState > 0 AND H.MmHostEnabled > 0
AND H.Attribute & 16 = 0
															),
															0
														),
		isAnyDeviceControllerPowerManaged			=	ISNULL	(
															(
																SELECT TOP 1 1 from MMDeviceController AS DC WITH (NOLOCK)
																INNER JOIN MMHost AS H WITH (NOLOCK) ON dc.ClientId = H.ClientId
WHERE H.Attribute & 32768 = 32768
																AND DC.DeviceId = MP.DeviceId
															),
															0
														),
		isAnyDeviceControllerHasWriteAccessAndPowerManaged = ISNULL(
															(
																SELECT TOP 1 1 from MMDeviceController AS DC WITH (NOLOCK)
																INNER JOIN MMHost AS H WITH (NOLOCK) ON DC.ClientId = H.ClientId
WHERE H.Attribute & 32768 = 32768
																AND DC.DeviceId = MP.DeviceId
AND DC.DeviceAccessType & 2 = 2
															),
															0
														),
   	      isDeviceControllerExists   =   CASE WHEN EXISTS (SELECT TOP 1 1 FROM MMDeviceController AS DC WITH (READUNCOMMITTED) WHERE DC.DeviceId = MP.DeviceId) THEN 1 ELSE 0 END
	FROM #tempMountPathInfo AS MP
	WHERE isEnabled > 0
		AND isOffline = 0
		AND isDeviceEnabled > 0
		AND isDeviceBroken = 0
		AND islibraryOnline = 1
	UPDATE #tempMountPathInfo
	SET
		isReady = 1,
		isReadyToWrite = CASE
							WHEN	(
								(isAnyDeviceControllerHasWriteAccessAndEnabled = 1 OR isAnyDeviceControllerHasWriteAccessAndPowerManaged=1)
								AND maxConcurrentWriters > 0
								AND (freeSpaceMB > reserveSpaceMB OR freeSpaceMB=-1)
								AND	(maxDataToWriteMB < 0 OR maxDataToWriteMB > (totalSpaceMB-freeSpaceMB))
							) THEN 1
							ELSE 0
						END
	WHERE isEnabled > 0
		AND isOffline = 0
		AND isDeviceEnabled > 0
		AND isDeviceBroken = 0
		AND (isAnyDeviceControllerEnabled = 1	OR isAnyDeviceControllerPowerManaged = 1)
		AND islibraryOnline = 1
	UPDATE MP
	SET	credentialId 								= 	ISNULL(A.credentialId,0),
		credentialName								= 	ISNULL(A.credentialname,'')
	FROM #tempMountPathInfo AS MP
    INNER JOIN MMMountPathToStorageDevice M WITH (READUNCOMMITTED) ON MP.mountPathId  = M.MountPathId
INNER JOIN APP_CredentialAssoc AS AA WITH (READUNCOMMITTED) ON AA.entityId= M.DeviceId AND AA.entityType = 185
    INNER JOIN app_credentials AS A WITH (READUNCOMMITTED) on A.credentialId = AA.credentialId
SELECT 	mountPathId,libraryId,isEnabled,isOffline,maxConcurrentWriters,mountPathTypeId,attribute,reserveSpaceMB,maxDataToWriteMB,
		deviceId,deviceTypeId,isDeviceEnabled,isDeviceBroken,
		totalSpaceMB,freeSpaceMB,
		islibraryOnline,
		isAnyDeviceControllerEnabled,isAnyDeviceControllerHasWriteAccess,isAnyDeviceControllerHasWriteAccessAndEnabled,isAnyDeviceControllerPowerManaged,isAnyDeviceControllerHasWriteAccessAndPowerManaged,
		isReady,isReadyToWrite,isDeviceControllerExists,credentialId,credentialName
FROM #tempMountPathInfo
IF object_id('tempdb.dbo.#tempMountPathInfo') IS NOT NULL DROP TABLE #tempMountPathInfo

IF EXISTS (select * from GxQscripts where name = 'MMGetMountPathDetails')
	delete from GxQscripts where name = 'MMGetMountPathDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountPathDetails')
	delete from GXDBVersions where aliasname = 'MMGetMountPathDetails'
GO

insert into GXDBVersions values(2, 'MMGetMountPathDetails',  '00000000000000000000', 'MMGetMountPathDetails', '00000000000000000000')
GO

