

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMountPathCapacity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMountPathCapacity.sp,v $ $Id: MMGetMountPathCapacity.sp,v 1.4.210.2 2018/03/20 00:07:25 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMGetMountPathCapacity"								|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetMountPathCapacity <<<'

IF EXISTS (select * from sysobjects where name='MMGetMountPathCapacity')
	drop procedure MMGetMountPathCapacity
IF EXISTS (select * from GxQscripts where name='MMGetMountPathCapacity')
	delete from GxQscripts where name = 'MMGetMountPathCapacity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountPathCapacity')
	delete from GXDBVersions where aliasname = 'MMGetMountPathCapacity'
GO
print '... Creating Procedure: MMGetMountPathCapacity'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMountPathCapacity
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
-- If isSummary set to true, this will return total capacity of all the mount pathes
-- Otherwise, this will return individual capacity of mount pathes
  @i_mountPathId integer,
  @i_isSummary integer
AS
  DECLARE @o_mountPathId integer
  DECLARE @o_mountPathName NVARCHAR(255)
  DECLARE @o_libraryId integer
  DECLARE @o_libraryName NVARCHAR(255)
  DECLARE @o_totalCapacity bigint
  DECLARE @o_totalFreeSpace bigint
  DECLARE @o_totalOccupiedSpace bigint
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
	DECLARE	@l_isSummary		integer
	DECLARE	@l_mountPathId	integer
	SET	@l_isSummary = @i_isSummary
	SET	@l_mountPathId = @i_mountPathId
	IF	@l_isSummary > 0
	BEGIN
		-- Return summary
		SELECT	0, '', 0, '',
				ISNULL(SUM(ms.TotalSpaceMB), 0), ISNULL(SUM(ms.FreeBytesMB), 0),
				ISNULL(SUM(ms.TotalSpaceMB - ms.FreeBytesMB), 0)
		FROM		MMMountPath as mp, MMMediaSide as ms
		WHERE		mp.MountPathId > 0 AND mp.MediaSideId = ms.MediaSideId
	END
	ELSE
	BEGIN
		IF @l_mountPathId > 0
		BEGIN
			-- Return info for specified mount path
			SELECT	mp.MountPathId, mp.MountPathName,
							ml.LibraryId, ml.AliasName,
							ms.TotalSpaceMB, ms.FreeBytesMB, ms.TotalSpaceMB - ms.FreeBytesMB
			FROM	MMS2getMountPathNameGUIView as mp, MMMediaSide as ms, MMLibrary as ml
			WHERE	mp.MountPathId = @l_mountPathId
			AND		mp.MediaSideId = ms.MediaSideId AND mp.LibraryId = ml.LibraryId
		END
		ELSE
		BEGIN
			-- Return info for all the mount pathes
			SELECT	mp.MountPathId, mp.MountPathName,
							ml.LibraryId, ml.AliasName,
							ms.TotalSpaceMB, ms.FreeBytesMB, ms.TotalSpaceMB - ms.FreeBytesMB
			FROM	MMS2getMountPathNameGUIView as mp, MMMediaSide as ms, MMLibrary as ml
			WHERE	mp.MountPathId > 0
			AND		mp.MediaSideId = ms.MediaSideId AND mp.LibraryId = ml.LibraryId
		END
	END
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMountPathCapacity')
	delete from GxQscripts where name = 'MMGetMountPathCapacity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMountPathCapacity')
	delete from GXDBVersions where aliasname = 'MMGetMountPathCapacity'
GO

insert into GXDBVersions values(2, 'MMGetMountPathCapacity',  '00010004021000020000', 'MMGetMountPathCapacity', '00010004021000020000')
GO

