

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMetallicStorage.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  MMGetMetallicStorage.sp                    				  */
/*                                                                            */
/*  Description :  Stored procedure to get row from MMMetalliStorage		  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMetallicStorage.sp,v $ $Id: MMGetMetallicStorage.sp,v 1.1.4.3 2020/12/23 21:59:13 pnara Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetMetallicStorage')
BEGIN
	print '>>> Drop Stored Procedure: MMGetMetallicStorage <<<'
	drop procedure MMGetMetallicStorage
END
IF EXISTS (select * from GxQscripts where name='MMGetMetallicStorage')
	delete from GxQscripts where name = 'MMGetMetallicStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMetallicStorage')
	delete from GXDBVersions where aliasname = 'MMGetMetallicStorage'
GO
print '... Creating Procedure: MMGetMetallicStorage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetMetallicStorage
  @i_deviceId INTEGER = 0,
  @i_licenseType INTEGER = 0,
  @i_libraryId INTEGER = 0,
  @i_mountPathId INTEGER = 0,
  @i_forRotateCredentials INTEGER = 0
AS
  DECLARE @o_deviceId INTEGER
  DECLARE @o_licenseType INTEGER
  DECLARE @o_regionName varchar(64)
  DECLARE @o_regionDisplayName varchar(256)
  DECLARE @o_storageClass INTEGER
  DECLARE @o_replication INTEGER
  DECLARE @o_credentialId INTEGER
  DECLARE @o_container varchar(64)
  DECLARE @o_storageAccount varchar(64)
  DECLARE @o_applicationId varchar(64)
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	--
	-- We rotate credential every 1 year, so return mount paths who's credential is older than rotate interval time
	--
	DECLARE @l_rotateIntervalTime INT = 0
	IF @i_forRotateCredentials > 0
	BEGIN
SET @l_rotateIntervalTime = dbo.GetUnixTime(GETUTCDATE()) - ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MM_CONFIG_METALLIC_CREDENTIAL_ROTATE_INTERVAL_DAYS'), 365) * 24 * 60 * 60
	END
	IF @i_deviceId = 0 AND @i_mountPathId = 0 AND @i_libraryId > 0
	BEGIN
		SET @i_deviceId = -1
		SELECT 	TOP 1 @i_deviceId = MD.DeviceId
		FROM	MMMetallicStorage MD WITH(READUNCOMMITTED)
				INNER JOIN MMMountPath MP WITH(READUNCOMMITTED) ON MD.MountPathId = MP.MountPathId
		WHERE	MP.LibraryId = @i_libraryId
	END
	IF @i_deviceId >= 0
	BEGIN
		SELECT	MD.DeviceId, MD.LicenseType, MD.RegionName, MD.RegionDisplayName, MD.StorageClass, MD.ReplicationType, MD.CredentialId,
				CP.value('metallicCredentialInfo[1]/@container', 'varchar(64)') Container,
				CP.value('azureCredInfo[1]/@storageAccountName', 'varchar(64)') StorageAccount,
				CP.value('azureCredInfo[1]/@applicationId', 'varchar(64)') ApplicationId
		FROM	MMMetallicStorage MD WITH(READUNCOMMITTED)
				INNER JOIN App_Credentials C WITH(READUNCOMMITTED) ON MD.CredentialId = C.CredentialId
				CROSS APPLY C.credentialInfo.nodes('/App_AdditionalCredInfo') CN(CP)
		WHERE	(
					(@i_deviceId = 0 AND @i_mountPathId = 0 AND @i_licenseType = 0)
					OR (@i_deviceId > 0 AND MD.DeviceId = @i_deviceId)
					OR (@i_mountPathId > 0 AND MD.MountPathId = @i_mountPathId)
					OR (@i_licenseType > 0 AND MD.LicenseType = @i_licenseType)
				)
				AND (@i_forRotateCredentials = 0 OR (@i_forRotateCredentials > 0 AND C.Created < @l_rotateIntervalTime))
	END
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMetallicStorage')
	delete from GxQscripts where name = 'MMGetMetallicStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMetallicStorage')
	delete from GXDBVersions where aliasname = 'MMGetMetallicStorage'
GO

insert into GXDBVersions values(2, 'MMGetMetallicStorage',  '00010001000400030000', 'MMGetMetallicStorage', '00010001000400030000')
GO

