

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMediaListForExportOperation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMediaListForExportOperation.sp,v $ $Id: MMGetMediaListForExportOperation.sp,v 1.20.12.2 2018/03/20 19:52:10 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: Get list of media for export						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetMediaListForExportOperation <<<'

IF EXISTS (select * from sysobjects where name='MMGetMediaListForExportOperation')
	drop procedure MMGetMediaListForExportOperation
IF EXISTS (select * from GxQscripts where name='MMGetMediaListForExportOperation')
	delete from GxQscripts where name = 'MMGetMediaListForExportOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMediaListForExportOperation')
	delete from GXDBVersions where aliasname = 'MMGetMediaListForExportOperation'
GO
print '... Creating Procedure: MMGetMediaListForExportOperation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMediaListForExportOperation
  @i_libraryControllerId INTEGER,
  @i_mmRequestId INTEGER,
  @i_exportPhase INTEGER
AS
  DECLARE @o_MediaId INTEGER
  DECLARE @o_BarCode char(255)
  DECLARE @o_SourceSlotName char(255)
  DECLARE @o_SourceElementAddress INTEGER
  DECLARE @o_DestinationSlotName char(255)
  DECLARE @o_DestinationElementAddress INTEGER
  DECLARE @o_ExportPhase INTEGER
  DECLARE @o_ExportError INTEGER
  DECLARE @o_ClientId INTEGER
  DECLARE @o_RequestTime INTEGER
  DECLARE @o_ExportLocation NVARCHAR(255)
  DECLARE @o_VTActionId INTEGER
  DECLARE @o_Flags INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @errorCode INTEGER
	set @errorCode = 0
	DECLARE @curor_open INTEGER
	set @curor_open = 0
	IF object_id('tempdb.dbo.#tmpMediaToExport') is not null DROP TABLE #tmpMediaToExport
	IF object_id('tempdb.dbo.#tmpMediaToAbort') is not null DROP TABLE #tmpMediaToAbort
	create table #tmpMediaToExport (mediaId int, VTActionId int, VTPolicyId int)
	create table #tmpMediaToAbort  (mediaId int, VTActionId int, VTPolicyId int)
	insert into #tmpMediaToExport
	select MediaId, VTActionId, 0
	from MMMediaExport WITH (READUNCOMMITTED)
	where LibraryControllerId = @i_libraryControllerId
	AND MmRequestId = @i_mmRequestId and flags = 0
and mediaId not in (select mediaid from MMMedia WITH (READUNCOMMITTED) where Attributes & (16777216 | 536870912) > 0)
	and mediaid not in (select mediaid from MMResource WITH (READUNCOMMITTED))
	and (
			ExportPhase = @i_exportPhase
			or
			VTActionId > 0
			and @i_exportPhase = 0
			and VTActionId in (select actionId from VTAction where ActionQuitTime > DBO.GetUnixTime(GETUTCDATE()))
			and ExportPhase IN(2, 3, 4, 5, 6, 7, 8, 12)
		)
	-- Skip vt stuff if export phase is not MLM_EXPORT_INIT
	IF	@i_exportPhase <> 0
		GOTO SELECTMEDIALIST
	-- Do not process media no longer at source
	delete from #tmpMediaToExport
	where VTActionId > 0
	and mediaId not in
		(select mediaId from VTActionMedia WITH (READUNCOMMITTED)
where state = 1 )
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	update #tmpMediaToExport
	set VTPolicyId = b.policyId
	from #tmpMediaToExport a, VTAction b WITH (READUNCOMMITTED)
	where a.VTActionId = b.actionId and a.VTActionId > 0
	IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Skip vt stuff if there is no media associated with vt policy
	IF NOT EXISTS (select * from #tmpMediaToExport where VTPolicyId > 0)
	   GOTO SELECTMEDIALIST
	insert into #tmpMediaToAbort
	select *
	from #tmpMediaToExport where VTPolicyId > 0
	DECLARE @tempFlags INTEGER
	DECLARE @VTPolicyId INTEGER
	DECLARE @MediaId INTEGER
	DECLARE @VTActionId INTEGER
	SET	@VTPolicyId = ISNULL((select top 1 VTPolicyId from #tmpMediaToAbort), 0)
	declare @tblMediaVTPolicy table (mediaId int, dueBackTime bigint)
	-- If @i_VTFlags is VT_FLAGS_INCLUDE_MEDIA_IN_ACTION, then all media found are returned including media in existing actions.
	-- Otherwise, media in existing actions will be filtered out.
	-- If @i_VTFlags is VT_FLAGS_IGNORE_NUM_MEDIA_LIMIT, then all media found are returned even through action has number of media limitation.
SET @tempFlags = 1024 + 2048
	INSERT INTO @tblMediaVTPolicy
	EXEC RunTMRule @tempFlags, @VTPolicyId, 0
	IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Filter out media qualify for export according to vault tracker
	delete #tmpMediaToAbort from #tmpMediaToAbort a, @tblMediaVTPolicy b
	where a.mediaId = b.mediaId
	IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Filter out media exported already
	delete #tmpMediaToAbort from #tmpMediaToAbort a, mmmedia b
	where a.mediaid = b.mediaid and b.medialocation = 3
	IF	@@ERROR != 0 GOTO CX_ERROR_EXIT
	DECLARE VTMediaExportCur cursor static for select MediaId, VTActionId from #tmpMediaToAbort
	open VTMediaExportCur
	set @curor_open = 1
	fetch next from VTMediaExportCur into @mediaId, @VTActionId
	DECLARE @tblActionCmdReturn table (retVal int, mediaProcessed int, mediaSkipped int, errString VARCHAR(1024))
	while @@FETCH_STATUS = 0
	begin
		insert into @tblActionCmdReturn
EXEC VTRunActionCmd 2, @VTActionId, @mediaId, 0
		fetch next from VTMediaExportCur into @mediaId, @VTActionId
	end
SELECTMEDIALIST:
IF exists (select * from MMConfigs where name = 'MMCONFIG_EXPORT_MEDIA_BY_BARCODE_ORDER' and value = 1)
	select MediaId, BarCode, SourceSlotName, SourceElementAddress, DestinationSlotName,
	DestinationElementAddress, ExportPhase, ExportError, ClientId, RequestTime, ExportLocation,
	VTActionId, Flags
	from MMMediaExport
	where mediaId in (select mediaid from #tmpMediaToExport)
	and mediaId not in (select mediaId from #tmpMediaToAbort)
	order by BarCode
else
	select MediaId, BarCode, SourceSlotName, SourceElementAddress, DestinationSlotName,
	DestinationElementAddress, ExportPhase, ExportError, ClientId, RequestTime, ExportLocation,
	VTActionId, Flags
	from MMMediaExport
	where mediaId in (select mediaid from #tmpMediaToExport)
	and mediaId not in (select mediaId from #tmpMediaToAbort)
	IF object_id('tempdb.dbo.#tmpMediaToExport') is not null DROP TABLE #tmpMediaToExport
	IF object_id('tempdb.dbo.#tmpMediaToAbort') is not null DROP TABLE #tmpMediaToAbort
	IF @curor_open = 1
	BEGIN
		close		VTMediaExportCur
		deallocate	VTMediaExportCur
	END
	return
CX_ERROR_EXIT:
	select * from MMMediaExport where 1 = 0
	IF object_id('tempdb.dbo.#tmpMediaToExport') is not null DROP TABLE #tmpMediaToExport
	IF object_id('tempdb.dbo.#tmpMediaToAbort') is not null DROP TABLE #tmpMediaToAbort
	IF @curor_open = 1
	BEGIN
		close		VTMediaExportCur
		deallocate	VTMediaExportCur
	END
	return
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMediaListForExportOperation')
	delete from GxQscripts where name = 'MMGetMediaListForExportOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMediaListForExportOperation')
	delete from GXDBVersions where aliasname = 'MMGetMediaListForExportOperation'
GO

insert into GXDBVersions values(2, 'MMGetMediaListForExportOperation',  '00010020001200020000', 'MMGetMediaListForExportOperation', '00010020001200020000')
GO

