

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMediaContents.sp] ---------- 

--  +========================================================================+
--  | Stored Procedure:
--	| Author :
--  +========================================================================+
-- $Id: MMGetMediaContents.sp,v 1.1.2.2 2018/08/02 07:01:04 prasanthm Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetMediaContents <<<'

IF EXISTS (select * from sysobjects where name='MMGetMediaContents')
	drop procedure MMGetMediaContents
IF EXISTS (select * from GxQscripts where name='MMGetMediaContents')
	delete from GxQscripts where name = 'MMGetMediaContents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMediaContents')
	delete from GXDBVersions where aliasname = 'MMGetMediaContents'
GO
print '... Creating Procedure: MMGetMediaContents'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMediaContents
  @i_mediaBarcodes nvarchar(256),
  @i_jobIds varchar(MAX),
  @i_isJobIdPassed integer,
  @i_userId integer
AS
  DECLARE @o_jobId bigint
  DECLARE @o_mediaId integer
  DECLARE @o_archFileId integer
  DECLARE @o_archFileType integer
  DECLARE @o_appTypeId integer
  DECLARE @o_jobStatus VARCHAR(255)
  DECLARE @o_clientName VARCHAR(255)
  DECLARE @o_appTypeName varchar(255)
  DECLARE @o_backupSetName varchar(255)
  DECLARE @o_instanceName varchar(255)
  DECLARE @o_subclientName NVARCHAR(255)
  DECLARE @o_backupLevel varchar(255)
  DECLARE @o_cyclesNSeq varchar(255)
  DECLARE @o_archFileTypeName varchar(255)
  DECLARE @o_jobDataStatus varchar(255)
  DECLARE @o_backupTime varchar(255)
  DECLARE @o_retainTill varchar(255)
  DECLARE @o_mediaSideName varchar(255)
  DECLARE @o_archFileName NVARCHAR(2048)
  DECLARE @o_storagePolicyNCopy NVARCHAR(512)
  DECLARE @o_sizeOnMedia varchar(255)
  DECLARE @o_sizeOfBackup varchar(255)
SET NOCOUNT ON
DECLARE @BarCode VARCHAR(256)
DECLARE @MediaId INTEGER
if object_id('tempdb.dbo.#JobsOnMedia') is not null DROP TABLE #JobsOnMedia
if object_id('tempdb.dbo.#MediaIdList') is not null DROP TABLE #MediaIdList
if object_id('tempdb.dbo.#JobIdList') is not null DROP TABLE #JobIdList
CREATE	TABLE #JobsOnMedia
(
jobId            integer,
backupLevel      integer,
fullCycleNum     integer,
cycleSeqNum      integer,
jobStartTime     integer,
jobStatus        integer,
jobDataStatus    integer,
jobDataFlags     integer,
retentionDays    integer,
pinJobEndTime    bigint,
archFileId       integer,
archFileName     NVARCHAR(2048),
archFileType     integer,
archFileCreateTime integer,
isValidData      integer,
sizeOnMedia      bigint,
sizeOfBackup     bigint,
mediaSideId      integer,
clientId         integer,
clientName       varchar(255),
appTypeId        integer,
appTypeName      varchar(255),
instanceId       integer,
instanceName     varchar(255),
backupSetId      integer,
backupSetName    varchar(255),
appId            integer,
subclientName    NVARCHAR(255),
archGroupId      integer,
archGroupName    NVARCHAR(255),
copyId           integer,
copyName         NVARCHAR(255),
mediaSideName    varchar(255),
applicationSize	 bigint
)
DECLARE @ErrorNumber INTEGER = 0
/*Do Validation Stuff*/
--to do
/* End of Validation Stuff*/
CREATE TABLE #MediaIdList ( mediaId integer)
CREATE TABLE #JobIdList (jobId integer)
DECLARE @sqlQuery VARCHAR(MAX) = '
INSERT INTO #MediaIdList
 SELECT MediaId FROM MMMedia
 WHERE BarCode in ('+@i_mediaBarcodes+')'
EXECUTE(@sqlQuery)
INSERT INTO #JobIdList
 select Data FROM dbo.split(@i_jobIds,',')
DECLARE getMediaContentsCursor CURSOR LOCAL FORWARD_ONLY FOR
SELECT	mediaId
FROM	#MediaIdList
OPEN getMediaContentsCursor
FETCH NEXT FROM getMediaContentsCursor INTO @MediaId
WHILE(@@FETCH_STATUS = 0)
BEGIN
--SELECT top 1 @MediaId	=  mediaId FROM #MediaIdList
INSERT INTO #JobsOnMedia
	EXEC getMediaContents @MediaId, @i_userId
	FETCH NEXT FROM getMediaContentsCursor INTO @MediaId
END
CLOSE getMediaContentsCursor
DEALLOCATE getMediaContentsCursor
SELECT distinct J.jobId, M.MediaId, J.archFileId, J.archFileType, J.appTypeId,																							--3 cols
CASE
WHEN J.isValidData < 1 AND J.jobStatus NOT IN (2, 4) THEN 'Invalid'
WHEN J.jobStatus = 0 THEN 'Running'
WHEN J.jobStatus = 1 THEN 'Completed'
WHEN J.jobStatus = 2 THEN 'Failed'
WHEN J.jobStatus = 3 THEN 'Completed with errors'
WHEN J.jobStatus = 4 THEN 'Killed'
WHEN J.jobStatus = 5 THEN 'Suspended'
WHEN J.jobStatus = 6 THEN 'Interrupted'
WHEN J.jobStatus = 7 THEN 'Any Status'
WHEN J.jobStatus = 8 THEN 'Skipped'
WHEN J.jobStatus = 9 THEN 'Failed To Start'
ELSE 'Not Available'
END, J.clientName, J.appTypeName, J.backupSetName, J.instanceName, J.subclientName,												--7 Cols
CASE
	WHEN J.backupLevel = 1 THEN
		CASE WHEN (appTypeId = 45 OR appTypeId = 56 OR appTypeId = 57 OR appTypeId = 58 OR appTypeId = 73)
			THEN 'New Index'
		ELSE
			'Full'
		END
	WHEN J.backupLevel = 2 THEN
		CASE WHEN (appTypeId = 4 OR appTypeId = 16 OR appTypeId = 70 OR appTypeId = 5 OR appTypeId = 81 OR appTypeId = 125)
			THEN 'Transaction Log'
		ELSE
			'Incremental'
		END
	WHEN J.backupLevel = 512 THEN 'Transaction Log'
	WHEN J.backupLevel = 4 THEN
		CASE WHEN (appTypeId = 37 OR appTypeId = 62)
			THEN 'Delta'
		ELSE
			'Differential'
		END
	WHEN J.backupLevel = 64 OR J.backupLevel = 128 THEN 'Synthetic Full'
	WHEN J.backupLevel = 256 THEN 'Trans. Log No Truncation'
	WHEN J.backupLevel = 1024 THEN 'Offline Full'
	WHEN J.backupLevel = 32768 THEN 'Online Full'
	WHEN J.backupLevel = 2048 THEN 'Snapshot'
	WHEN J.backupLevel = 4096 THEN 'Create Replica'
	WHEN J.backupLevel = 8192 THEN 'Update Replica'
ELSE ''
END, CAST(J.fullCycleNum AS VARCHAR) + '/' + CAST(J.cycleSeqNum AS VARCHAR), 																--3 cols
CASE
	WHEN J.archFileType = 1 THEN 'Data'
	WHEN J.archFileType = 2 THEN 'Index'
	WHEN J.archFileType = 3 THEN 'Archive_file'
	WHEN J.archFileType = 4 THEN 'Log'
ELSE ''
END,																																			--1 col
CASE
	WHEN (J.jobDataFlags & 256) > 0 THEN 'AGED'
	WHEN J.jobDataStatus = 100 THEN
		(CASE 	WHEN (J.jobDataFlags & (64 /*CVA_JOB_PINNED_FOR_MANUAL_RETENTION*/ | 2 /*CVA_BAD_JOB_FLAG*/)) = (64 | 2)
					THEN 'BAD & RETAINED'
				WHEN (J.jobDataFlags & 64 /*CVA_JOB_PINNED_FOR_MANUAL_RETENTION*/) > 0
					THEN 'AVAILABLE & RETAINED'
				WHEN (J.jobDataFlags & 2 /*CVA_BAD_JOB_FLAG*/) > 0
					THEN 'BAD'
				ELSE 'AVAILABLE'
		END)
	WHEN J.jobDataStatus in (102, 103) THEN
		(CASE	WHEN (J.jobDataFlags & 1 /*CVA_JOB_DISABLED_FOR_AUXCOPY*/) > 0
					THEN 'PARTIAL & NOT SELECTED'
				ELSE 'PARTIAL'
		END)
	WHEN J.jobDataStatus = 101 THEN
		(CASE 	WHEN (J.jobDataFlags & 1 /*CVA_JOB_DISABLED_FOR_AUXCOPY*/) > 0
					THEN 'NOT SELECTED'
				ELSE 'TO BE COPIED'
		END)
	WHEN J.jobDataStatus = 1 THEN 'RUNNING'
	WHEN J.jobDataStatus = 0 THEN 'NOT SELECTED'
	ELSE 'NOT AVAILABLE'
END, CONVERT(VARCHAR(20), dbo.UTCToClientLocalTime(dbo.GetDateTime(J.archFileCreateTime), 2), 120),												--2 cols
 CASE
	WHEN (J.jobDataFlags & 256) > 0
		THEN 'NA'
	WHEN (J.retentionDays = -1 OR J.pinJobEndTime = -1)
		THEN 'INFINITE'
	WHEN ((J.jobStartTime + J.retentionDays * 24 * 3600) > J.pinJobEndTime)
		THEN CONVERT(VARCHAR(20), dbo.UTCToClientLocalTime(dbo.GetDateTime((J.jobStartTime + J.retentionDays * 24 * 3600)), 2), 120)
	ELSE CONVERT(VARCHAR(20), dbo.UTCToClientLocalTime(dbo.GetDateTime(J.pinJobEndTime), 2), 120)
END, J.mediaSideName, J.archFileName, J.archGroupName + '/' + J.copyName,															--5 cols
 CASE
	WHEN ABS(J.sizeOnMedia) < 1024  THEN CAST(CAST(J.sizeOnMedia AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' Bytes'
	WHEN ABS(J.sizeOnMedia) < 1048576 THEN CAST(CAST((J.sizeOnMedia/1024) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' KB'
	WHEN ABS(J.sizeOnMedia) < 1073741824 THEN CAST(CAST((J.sizeOnMedia/1048576) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' MB'
	WHEN ABS(J.sizeOnMedia) < 1099511627776 THEN CAST(CAST((J.sizeOnMedia/1073741824) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' GB'
	WHEN ABS(J.sizeOnMedia) < 1125899906842624 THEN CAST(CAST((J.sizeOnMedia/1099511627776) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' TB'
	WHEN ABS(J.sizeOnMedia) < 1152921504606846976 THEN CAST(CAST((J.sizeOnMedia/1125899906842624) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' PB'
ELSE
	CAST(CAST(J.sizeOnMedia AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' Bytes'
END,																																			--1 col
CASE
	WHEN ABS(J.sizeOfBackup) < 1024  THEN CAST(CAST(J.sizeOfBackup AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' Bytes'
	WHEN ABS(J.sizeOfBackup) < 1048576 THEN CAST(CAST((J.sizeOfBackup/1024) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' KB'
	WHEN ABS(J.sizeOfBackup) < 1073741824 THEN CAST(CAST((J.sizeOfBackup/1048576) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' MB'
	WHEN ABS(J.sizeOfBackup) < 1099511627776 THEN CAST(CAST((J.sizeOfBackup/1073741824) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' GB'
	WHEN ABS(J.sizeOfBackup) < 1125899906842624 THEN CAST(CAST((J.sizeOfBackup/1099511627776) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' TB'
	WHEN ABS(J.sizeOfBackup) < 1152921504606846976 THEN CAST(CAST((J.sizeOfBackup/1125899906842624) AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' PB'
ELSE
	CAST(CAST(J.sizeOfBackup AS DECIMAL(38, 2)) AS VARCHAR(50)) + ' Bytes'
END																																				--1 col
FROM #JobsOnMedia J
JOIN archChunkMapping ACM WITH(READUNCOMMITTED) ON J.archFileId = ACM.archFileId and J.copyId = ACM.archCopyId
JOIN archChunk AC WITH(READUNCOMMITTED) ON ACM.archChunkid = AC.id and ACM.commCellid = AC.commCellid
JOIN MMVolume V WITH(READUNCOMMITTED) ON Ac.VolumeId = AC.VolumeId AND V.MediaSideId = J.MediaSideId
JOIN MMMedia M WITH(READUNCOMMITTED) ON V.MediaId = M.MediaId
JOIN #MediaIdList ML ON M.MediaId = ML.MediaId
WHERE (J.jobId in (select jobId from #JobIdList) OR 0 = @i_isJobIdPassed)
if object_id('tempdb.dbo.#JobsOnMedia') is not null DROP TABLE #JobsOnMedia
if object_id('tempdb.dbo.#MediaIdList') is not null DROP TABLE #MediaIdList
if object_id('tempdb.dbo.#JobIdList') is not null DROP TABLE #JobIdList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMediaContents')
	delete from GxQscripts where name = 'MMGetMediaContents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMediaContents')
	delete from GXDBVersions where aliasname = 'MMGetMediaContents'
GO

insert into GXDBVersions values(2, 'MMGetMediaContents',  '00010001000200020000', 'MMGetMediaContents', '00010001000200020000')
GO

