

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMediaByJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMediaByJob.sp,v $ $Id: MMGetMediaByJob.sp,v 1.8.208.2 2018/03/19 23:59:38 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "MMGetMediaByJob"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetMediaByJob <<<'

IF EXISTS (select * from sysobjects where name='MMGetMediaByJob')
	drop procedure MMGetMediaByJob
IF EXISTS (select * from GxQscripts where name='MMGetMediaByJob')
	delete from GxQscripts where name = 'MMGetMediaByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMediaByJob')
	delete from GXDBVersions where aliasname = 'MMGetMediaByJob'
GO
print '... Creating Procedure: MMGetMediaByJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMediaByJob
  @i_jobId integer,
  @i_ccId integer
AS
  DECLARE @o_mediaId integer
  DECLARE @o_uniqueId char(64)
  DECLARE @o_barCode char(64)
  DECLARE @o_mediaTypeId integer
  DECLARE @o_mediaTypeName varchar(32)
  DECLARE @o_attributes integer
  DECLARE @o_mediaLocation integer
  DECLARE @o_mediaLocationString varchar(64)
  DECLARE @o_exportLocation NVARCHAR(64)
  DECLARE @o_containerId integer
  DECLARE @o_containerName NVARCHAR(64)
  DECLARE @o_libraryId integer
  DECLARE @o_libraryName NVARCHAR(64)
  DECLARE @o_copyId integer
  DECLARE @o_copyName NVARCHAR(64)
  DECLARE @o_copyPrecedence integer
  DECLARE @o_spId integer
  DECLARE @o_spName NVARCHAR(64)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @tblMedia	TABLE (t_medId int)
INSERT INTO @tblMedia
SELECT mediaId FROM JMJobResourceHistory WITH (NOLOCK) WHERE jobId = @i_jobId AND commCellId = @i_ccId
SELECT	M.MediaId,
	M.UniqueId,
	Barcode = (case M.MediaTypeId
when 10001 then P.MountPathName
			else M.barCode end),
	MediaTypeId,
	MediaTypeName = (SELECT MediaTypeName FROM MMMediaType T WITH (NOLOCK) WHERE M.MediaTypeId = T.MediaTypeId),
	attributes = dbo.MMS2FUNC_GetGUIMediaAttribute(M.MediaId),
	MediaLocation,
	mediaLocationString = dbo.GetMediaLocation(M.MediaId, M.MediaLocation, M.LibraryId, M.ExportLocationId),
	exportLocation = (SELECT ExportLocation FROM MMExportLocation WITH (NOLOCK) WHERE ExportLocationId = M.ExportLocationId),
	ContainerId,
	containerName = (SELECT ISNULL(ContainerName, 'N/A') FROM MMContainer WITH (NOLOCK) WHERE ContainerId = M.ContainerId),
	M.LibraryId,
	libraryName = (SELECT AliasName FROM MMLibrary WITH (NOLOCK) WHERE LibraryId = M.LibraryId),
	copyName = (SELECT name FROM archGroupCopy WITH (NOLOCK) WHERE id = X.archGroupCopyId),
	copyPrecedence = C.copy,
	copyName = C.name,
	spId = X.id,
	spName = X.name
FROM	@tblMedia	JOIN MMMedia M WITH (NOLOCK) ON M.MediaId = t_medId
			JOIN MMMediaSide S WITH (NOLOCK) ON M.MediaId = S.MediaId
			LEFT JOIN MMS2getMountPathNameGUIView P WITH (NOLOCK) ON S.MediaSideId = P.MediaSideId
			LEFT JOIN	(	SELECT	G.name, G.id, O.archGroupCopyId, mediaSideId
						FROM	archgroup G WITH (NOLOCK),
							(SELECT DISTINCT archgroupid, archGroupCopyId, mediaSideId
							 FROM	ArchStream A WITH (NOLOCK), MMVolume V WITH (NOLOCK), @tblMedia
							 WHERE	A.MediaGroupId = V.mediaGroupId AND t_medId = V.mediaId) O
						 WHERE	G.id=O.archgroupid ) X ON X.mediaSideId = S.MediaSideId
			LEFT JOIN archGroupCopy C WITH (NOLOCK) ON C.id = X.archGroupCopyId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMediaByJob')
	delete from GxQscripts where name = 'MMGetMediaByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMediaByJob')
	delete from GXDBVersions where aliasname = 'MMGetMediaByJob'
GO

insert into GXDBVersions values(2, 'MMGetMediaByJob',  '00010008020800020000', 'MMGetMediaByJob', '00010008020800020000')
GO

