

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMediaAgentListForSIDB.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMediaAgentListForSIDB.sp,v $ $Id: MMGetMediaAgentListForSIDB.sp,v 1.17.2.8 2020/11/09 08:43:09 prasanthm Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMGetMediaAgentListForSIDB"				|
--	|									|
--	| Execute the System stored procedure to fetch Access Path candidates	|
--	| .. for the (current) SIDB Store.					|
-- 	+-----------------------------------------------------------------------+
/*
With the recent change from install team simOSId set as generic linux OS, DDB configuration support only in 64 bit OS type.
With this generic OS id unable to differentiate OS type. So sending OS Processor Type to GUI.
Below are linux 64 bit OS types got from install team
18 = Linux glibc-2.3 for x86_64
26 = Linux glibc-2.3 for ppc64
41 = Linux glibc-2.17 for ppc64le
14 = HP-UX 11.23 IA64
40 = MAC OS X 10.4 on Intel
30 = FreeBSD 7 on x86_64
10 = Solaris 10
11 = solaris2.10-x86_64
39 = AIX 6.1
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetMediaAgentListForSIDB')
BEGIN
	print '>>> Drop Stored Procedure: MMGetMediaAgentListForSIDB <<<'
	drop procedure MMGetMediaAgentListForSIDB
END
IF EXISTS (select * from GxQscripts where name='MMGetMediaAgentListForSIDB')
	delete from GxQscripts where name = 'MMGetMediaAgentListForSIDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMediaAgentListForSIDB')
	delete from GXDBVersions where aliasname = 'MMGetMediaAgentListForSIDB'
GO
print '... Creating Procedure: MMGetMediaAgentListForSIDB'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetMediaAgentListForSIDB
  @i_commCellId integer,
  @i_SIDBStoreId integer,
  @i_userId integer
AS
  DECLARE @o_hostClientId integer
  DECLARE @o_hostName char(255)
  DECLARE @o_hostNetworkName char(255)
  DECLARE @o_SystemOsVersion char(255)
  DECLARE @o_SystemHardWare char(255)
  DECLARE @o_SystemOsId integer
  DECLARE @o_isCommServer integer
  DECLARE @o_isVirtualClient integer
  DECLARE @o_indexCachePath char(255)
  DECLARE @o_releaseId integer
  DECLARE @o_byteOrder char(255)
  DECLARE @o_displayName nvarchar(255)
  DECLARE @o_processorType integer
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @showAllOSMA	int = 0
SET @showAllOSMA = ISNULL((SELECT value from MMConfigs WHERE name = 'MMCONFIG_SHOW_ALL_OS_MEDIA_AGENTS'), 0)
IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects') IS NOT NULL
	DROP TABLE #getNonIdaObjects
IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects_InputPermissionsTbl') IS NOT NULL
    DROP TABLE #getNonIdaObjects_InputPermissionsTbl
CREATE TABLE #getNonIdaObjects (entityId INT)
CREATE TABLE #getNonIdaObjects_InputPermissionsTbl(permissionId INT)
INSERT INTO #getNonIdaObjects_InputPermissionsTbl
VALUES (225),(254),(10)
EXEC sec_getNonIdaObjectsForThisUser @i_userId,11,-1,'#getNonIdaObjects'
;with host_cte
AS (
	SELECT	DISTINCT
			H.clientId,
			IIF(IndexCacheUser = 'CV_DEDUP', IndexCachePathName, '') as indexCachePath,
			C.name as clientName,
			C.net_hostname as clientNetHostName,
			OS.name as osName,
			OS.id as osId,
			C.displayName as clientDisplayName,
			C.releaseId
	FROM	MMHost H
			INNER JOIN #getNonIdaObjects TMP ON TMP.entityId = H.ClientId
			INNER JOIN APP_Client C ON C.id = H.ClientId
			INNER JOIN simInstalledPackages I ON I.ClientId = C.id
			INNER JOIN simOperatingSystem os ON OS.id = C.simOperatingSystemId
			INNER JOIN LicUsage as lu ON lu.CId = C.id
	WHERE	H.ClientId > 1
			--Remove the MediaAgents which are previous version v9 (SP14)/v10 (SP7) and lesser servicePack than recommended
AND (C.releaseId >= 16 OR (C.releaseId = 14 AND I.HighestSP >= 14) OR (C.releaseId = 15 AND I.HighestSP >= 7))
AND I.simPackageID IN (51, 1301)
			-- Media Agent list should not include NetWare (for now)
			AND os.Type <> 'NetWare'
			-- Media Agent list should only include Windows and Linux, if showAllOSMA is not set
			AND (@showAllOSMA = 1 OR  os.Type = 'Windows' OR (os.SubType = 'Linux' AND os.PlatformType NOT IN ('PPC', 'PPC64')))
			AND lu.OpType = 'Install'	AND	lu.apptype = 1002 AND lu.LicType <> 33554432 and lu.InstallFlag = 0
			AND NOT EXISTS(
				-- remove the ones already used by current SIDB
				SELECT	1
				FROM	IdxAccessPath P
						INNER JOIN IdxSIDBStore S ON P.IdxCacheId = S.IdxCacheId
				WHERE	S.SIDBStoreId = @i_SIDBStoreId AND P.ClientId = H.ClientId
			)
)
SELECT	H.ClientId,
		H.clientName,
		H.clientNetHostName,
		H.osName,
		dbo.GetClientHardwareName(H.ClientId, NULL),
		H.osId,
		isCommServer = (select sum(platformType) from APP_Platform where clientId = H.clientid),
		CASE WHEN EXISTS(
					SELECT	1
					FROM	APP_ClientProp AS CP
					WHERE	CP.componentNameId= H.clientId and CP.attrName='Virtual Client' and CP.modified =0 AND CP.attrVal = '1'
				) THEN	1
			ELSE 0
		END as isVirtualClient,
		H.indexCachePath,
		H.releaseId,
		byteOrder = (select TOP 1 attrVal from APP_ClientProp where attrName like 'Byte Order' and componentNameId = H.ClientId and modified = 0),
		H.clientDisplayName,
processorType = CASE WHEN H.osId <> 98 THEN 2
WHEN Exists(select TOP 1 attrVal from APP_ClientProp where attrName = 'Binary Set ID' and componentNameId = H.ClientId and modified = 0
and attrVal in (N'18',N'26',N'41',N'14',N'40',N'30',N'10',N'11',N'39') ) THEN 2
ELSE 1
					    END
FROM	host_cte H
ORDER BY H.ClientId
IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects') IS NOT NULL DROP TABLE #getNonIdaObjects
IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects_InputPermissionsTbl') IS NOT NULL
    DROP TABLE #getNonIdaObjects_InputPermissionsTbl
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMediaAgentListForSIDB')
	delete from GxQscripts where name = 'MMGetMediaAgentListForSIDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMediaAgentListForSIDB')
	delete from GXDBVersions where aliasname = 'MMGetMediaAgentListForSIDB'
GO

insert into GXDBVersions values(2, 'MMGetMediaAgentListForSIDB',  '00010017000200080000', 'MMGetMediaAgentListForSIDB', '00010017000200080000')
GO

