

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMediaAgentInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMediaAgentInfo.sp,v $ $Id: MMGetMediaAgentInfo.sp,v 1.4.14.7 2020/04/07 16:45:08 pveeravalli Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetMediaAgentInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMGetMediaAgentInfo <<<'
	drop procedure MMGetMediaAgentInfo
END
IF EXISTS (select * from GxQscripts where name='MMGetMediaAgentInfo')
	delete from GxQscripts where name = 'MMGetMediaAgentInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMediaAgentInfo')
	delete from GXDBVersions where aliasname = 'MMGetMediaAgentInfo'
GO
print '... Creating Procedure: MMGetMediaAgentInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMediaAgentInfo
  @i_mediaAgentID integer,
  @i_mediaAgentName char(255),
  @i_indexCacheType integer
AS
  DECLARE @o_HostClientId integer
  DECLARE @o_HostType integer
  DECLARE @o_HostSoftState integer
  DECLARE @o_HostEnabled integer
  DECLARE @o_OfflineReason integer
  DECLARE @o_Attribute integer
  DECLARE @o_ReleaseId integer
  DECLARE @o_NumLibraries integer
  DECLARE @o_NumAccessPaths integer
  DECLARE @o_IdxAccessPath char(255)
  DECLARE @o_IdxUsername char(255)
  DECLARE @o_IdxPassword char(255)
  DECLARE @o_IdxIsShared integer
  DECLARE @o_IdxRetainDays integer = 0
  DECLARE @o_maxReservations integer
  DECLARE @o_HostName nvarchar	(255)
  DECLARE @o_SoftWareBuildId char(255)
  DECLARE @o_Description NVARCHAR(MAX)
  DECLARE @o_SystemOsVersion char(255)
  DECLARE @o_MediaAgentDisplayName NVARCHAR(255)
  DECLARE @o_IdxConfigurationGUID NVARCHAR(1024)
  DECLARE @o_IdxCacheEnabled integer
  DECLARE @o_IdxMinSpace bigint
  DECLARE @o_IdxAlertSpace bigint
  DECLARE @o_IdxCleanupPercent integer
  DECLARE @o_IdxUsedDiskSize bigint
  DECLARE @o_IdxFreeDiskSize bigint
  DECLARE @o_IdxTotalDiskSize bigint
  DECLARE @o_RansomwareProtected integer
DECLARE  @NumDrives as integer
DECLARE  @enableDLP as integer = 0
DECLARE  @dlpEnableAutomaticDecryption as integer = 0
SET	@NumDrives = 0
SET	@o_NumLibraries = 0
SET	@o_NumAccessPaths = 0
SET	@o_IdxAccessPath = ''
SET	@o_IdxUsername = ''
SET	@o_IdxPassword = ''
SET	@o_IdxIsShared = 0
SET @o_MediaAgentDisplayName = ''
IF @i_mediaAgentName != ''
	SELECT	@o_HostClientId = id, @o_ReleaseId = releaseId, @o_Description = clientDescription
	FROM	APP_Client WITH(NOLOCK)
	WHERE	net_hostname = @i_mediaAgentName OR name = @i_mediaAgentName
ELSE
IF @i_mediaAgentID > 0
	SELECT	@o_HostClientId = id, @o_ReleaseId = releaseId, @o_Description = clientDescription
	FROM	APP_Client WITH(NOLOCK)
	WHERE	id = @i_mediaAgentID
ELSE
	SELECT	@o_HostClientId = -1
IF @o_HostClientId  > 0
BEGIN
	SELECT	@o_NumLibraries = COUNT(*)
	FROM	MMLibraryController WITH(NOLOCK)
	WHERE	ClientId = @o_HostClientId
	SELECT	@NumDrives = COUNT(*)
	FROM	MMDeviceController WITH(NOLOCK)
	WHERE	ClientId = @o_HostClientId
	SET	@o_NumLibraries = @o_NumLibraries + @NumDrives
	SELECT	@NumDrives = COUNT(*)
	FROM	MMDriveController WITH(NOLOCK)
	WHERE	ClientId = @o_HostClientId
	SET	@o_NumLibraries = @o_NumLibraries + @NumDrives
	SELECT	@o_HostName = name ,@o_MediaAgentDisplayName = displayName
	FROM	APP_Client WITH(NOLOCK)
	WHERE	id = @o_HostClientId
	SELECT	@o_SoftWareBuildId = attrVal
	FROM	APP_ClientProp WITH(NOLOCK)
	WHERE	componentNameId = @o_HostClientId
		AND attrName = 'SP Version Info'
	SELECT	@o_SystemOsVersion = CAST(osName AS VARCHAR(255)) FROM ClientOSNameView WHERE clientId = @o_HostClientId
	CREATE TABLE #tempIdx (
IdxAccessPath varchar(255),
IdxUsername varchar(255),
IdxPassword varchar(255),
		IdxPoolId int
	)
	INSERT INTO #tempIdx
	SELECT	A.Path,
			A.Username,
			A.Password,
			C.IdxPoolId
	FROM	IdxAccessPath A WITH(NOLOCK), IdxCache C WITH(NOLOCK)
	WHERE	C.IdxCacheId = A.IdxCacheId
		AND C.IdxCacheType = @i_indexCacheType
		AND A.ClientId = @o_HostClientId
	SELECT	@o_NumAccessPaths = COUNT(*)
	FROM	#tempIdx
	IF @o_NumAccessPaths > 0
		SELECT	TOP 1 @o_IdxAccessPath = A.IdxAccessPath,
				@o_IdxUsername = A.IdxUsername,
				@o_IdxPassword = A.IdxPassword,
				@o_IdxIsShared = P.IsShared
		FROM	#tempIdx A, IdxPool P WITH(NOLOCK)
		WHERE	P.IdxPoolId = A.IdxPoolId
	DROP TABLE #tempIdx
		SELECT @o_IdxConfigurationGUID = [Idx: configuration GUID],
        @o_IdxCacheEnabled = CAST ([Idx: cache enabled] AS INT),
        @o_IdxMinSpace = CAST (ABS([Idx: min space]) AS bigint),
        @o_IdxAlertSpace = CAST(ABS([Idx: alert space]) AS bigint),
        @o_IdxRetainDays = CAST ([Idx: age days] AS INT),
        @o_IdxCleanupPercent = CAST([Idx: cleanup percent] AS int),
        @o_IdxUsedDiskSize = CAST(ABS([Idx: used disk size]) AS bigint),
        @o_IdxFreeDiskSize = CAST(ABS([Idx: free disk size]) AS bigint),
        @o_IdxTotalDiskSize = CAST(ABS([Idx: total disk size]) AS bigint),
        @enableDLP = CAST(ISNULL(([enableDLP]),'0') AS INT),
        @dlpEnableAutomaticDecryption = CAST(ISNULL(([dlpEnableAutomaticDecryption]),'0') AS INT)
    FROM ( SELECT [Idx: configuration GUID], [Idx: cache enabled], [Idx: min space], [Idx: alert space], [Idx: age days], [Idx: cleanup percent],
        [Idx: used disk size], [Idx: free disk size], [Idx: total disk size], [enableDLP], [dlpEnableAutomaticDecryption]
      FROM (SELECT attrName, attrVal FROM APP_ClientProp ACP WITH(NOLOCK) WHERE ACP.componentNameId = @o_HostClientId
        AND  (ACP.attrName = 'Idx: configuration GUID'
        OR ACP.attrName = 'Idx: cache enabled'
        OR ACP.attrName = 'Idx: min space'
        OR ACP.attrName = 'Idx: alert space'
        OR ACP.attrName = 'Idx: age days'
        OR ACP.attrName = 'Idx: cleanup percent'
        OR ACP.attrName = 'Idx: used disk size'
        OR ACP.attrName = 'Idx: free disk size'
        OR ACP.attrName = 'Idx: total disk size'
        OR ACP.attrName = 'enableDLP'
        OR ACP.attrName = 'dlpEnableAutomaticDecryption')
        ) RAWTBL PIVOT (MAX(attrVal) for attrName in ([Idx: configuration GUID], [Idx: cache enabled], [Idx: min space], [Idx: alert space], [Idx: age days], [Idx: cleanup percent],
        [Idx: used disk size], [Idx: free disk size], [Idx: total disk size], [enableDLP], [dlpEnableAutomaticDecryption])) PVT) AS TMP
END
SELECT	ClientId,
		mmHostType,
		mmHostSoftState,
		mmHostEnabled,
		OfflineReason,
		Attribute,
		@o_ReleaseId AS ReleaseId,
		@o_NumLibraries As NumLibraries,
		@o_NumAccessPaths AS NumAccessPaths,
		@o_IdxAccessPath AS IdxAccessPath,
		@o_IdxUsername AS IdxUserName,
		@o_IdxPassword AS IdxPassword,
		@o_IdxIsShared AS IdxIsShared,
		@o_IdxRetainDays AS IdxRetainDays,
		MaxReservations,
		@o_HostName AS HostName,
		@o_SoftWareBuildId AS SoftWareBuildId,
		@o_Description AS Description,
		@o_SystemOsVersion AS SystemOsVersion,
		@o_MediaAgentDisplayName AS MediaAgentDisplayName,
		@o_IdxConfigurationGUID AS IdxConfigurationGUID,
		@o_IdxCacheEnabled AS IdxCacheEnabled,
		@o_IdxMinSpace AS IdxMinSpace,
		@o_IdxAlertSpace AS IdxAlertSpace,
		@o_IdxCleanupPercent AS IdxCleanupPercent,
		@o_IdxUsedDiskSize AS IdxUsedDiskSize,
		@o_IdxFreeDiskSize AS IdxFreeDiskSize,
		@o_IdxTotalDiskSize	AS IdxTotalDiskSize,
		(CASE WHEN @enableDLP>0 AND @dlpEnableAutomaticDecryption>0 THEN 1 ELSE 0 END) AS RansomwareProtected
FROM	MMHost WITH(NOLOCK)
WHERE	ClientId = @o_HostClientId
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMediaAgentInfo')
	delete from GxQscripts where name = 'MMGetMediaAgentInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMediaAgentInfo')
	delete from GXDBVersions where aliasname = 'MMGetMediaAgentInfo'
GO

insert into GXDBVersions values(2, 'MMGetMediaAgentInfo',  '00010004001400070000', 'MMGetMediaAgentInfo', '00010004001400070000')
GO

