

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMagLibVolReconResult.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMagLibVolReconResult.sp,v $ $Id: MMGetMagLibVolReconResult.sp,v 1.13.2.1 2018/03/19 23:59:17 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetMagLibVolReconResult <<<'

IF EXISTS (select * from sysobjects where name='MMGetMagLibVolReconResult')
	drop procedure MMGetMagLibVolReconResult
IF EXISTS (select * from GxQscripts where name='MMGetMagLibVolReconResult')
	delete from GxQscripts where name = 'MMGetMagLibVolReconResult'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMagLibVolReconResult')
	delete from GXDBVersions where aliasname = 'MMGetMagLibVolReconResult'
GO
print '... Creating Procedure: MMGetMagLibVolReconResult'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetMagLibVolReconResult
  @i_copyId integer,
  @i_adminJobId integer,
  @i_mode integer,
  @i_xmlInput XML,
  @i_reserveParam integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-- Constant Definitions
	DECLARE @C_MM_MAG_LIB_RAV_CHUNKLIST_ONLY	integer
	SET @C_MM_MAG_LIB_RAV_CHUNKLIST_ONLY	= 2
	DECLARE @C_MM_MAG_LIB_RAV_SIDB_DUMP_ONLY	integer
	SET @C_MM_MAG_LIB_RAV_SIDB_DUMP_ONLY	= 3
	/* volReconStatus.vrsFinished */
	DECLARE @C_VRS_FINISHED						integer
	SET @C_VRS_FINISHED						= 2
	/* volReconVACStatus.volReconVACStatusInMP */
	DECLARE @C_VAC_STATUS_IN_MP					integer
	SET @C_VAC_STATUS_IN_MP					= 2
	/* volReconVACStatus.volReconVACStatusInCSDB */
	DECLARE @C_VAC_STATUS_IN_CSDB				integer
	SET @C_VAC_STATUS_IN_CSDB				= 3
	/* Timeout Interval */
	DECLARE @C_ADMINJOB_SEARCH_TO_INTERVAL		integer
	SET @C_ADMINJOB_SEARCH_TO_INTERVAL		= 120
	DECLARE @retrytime INTEGER
	DECLARE @curAdminJobId INTEGER
	DECLARE @curAdminJobStartTime INTEGER
	DECLARE @curTime INTEGER
	DECLARE @curStatus INTEGER
	DECLARE @reconDate INTEGER
	DECLARE @magneticPath VARCHAR(1024)
	DECLARE @sepCharPos INTEGER
	SET @curTime = dbo.GetUnixTime(GetUTCDate())
	SET @retrytime = 0
	-- New Admin Job
	IF @i_mode = 1
	BEGIN
		WHILE @retrytime < @C_ADMINJOB_SEARCH_TO_INTERVAL
		BEGIN
			SELECT TOP 1 @curAdminJobId = JobId, @curAdminJobStartTime = StartTime, @curStatus = status
			FROM MMAdminJob WHERE CopyId = @i_copyId ORDER BY JobId DESC
			IF (@curTime - 5) < @curAdminJobStartTime
			BEGIN
				SET @i_adminJobId = @curAdminJobId
				GOTO RUNNINGJOB_FOUND
			END
			SET @curAdminJobId = 0
			SET @curAdminJobStartTime = 0
			SET @curStatus = 0
			SELECT TOP 1 @curAdminJobId = JobId, @curAdminJobStartTime = StartTime, @curStatus = status
			FROM MMAdminJob WHERE CopyId = @i_copyId AND status = 1 ORDER BY JobId DESC
			IF @curAdminJobId > 0
			BEGIN
				SET @i_adminJobId = @curAdminJobId
				GOTO RUNNINGJOB_FOUND
			END
			WaitFor Delay '00:00:01'
			SET @retrytime = @retrytime + 1
			IF @retrytime = @C_ADMINJOB_SEARCH_TO_INTERVAL
				GOTO GETLASTESTJOB
			SET @curTime = dbo.GetUnixTime(GetUTCDate())
		END
	END
	ELSE IF @i_mode = 3
		GOTO PRUNE_MEDIA
	ELSE IF @i_mode = 4
		GOTO PRUNE_JOBS
GETLASTESTJOB:
	SELECT TOP 1 @i_adminJobId = JobId, @reconDate = StartTime
	FROM MMAdminJob WHERE CopyId = @i_copyId AND status = 2 ORDER BY JobId DESC
RUNNINGJOB_FOUND:
	WHILE @curStatus = 1
	BEGIN
		WaitFor Delay '00:00:02'
		SELECT @curStatus = status
		FROM MMAdminJob WHERE JobId = @curAdminJobId
	END
	DECLARE @tblVolReconResultForDangledJobs TABLE
	( AdminJobId int, CopyId int, AFileId int, JobId int, ClientId int, ClientIdName nvarchar(256),
		SubclientId int, SubclientIdName nvarchar(128), ArchGroupId int, ArchGroupIdName nvarchar(144),
		CopyIdName nvarchar(64), MountPathId int, LibraryId int, LibraryIdName nvarchar(128),
		VolumeId int, ChunkId bigint, Path nvarchar(1024), Chunks int, ChunkSize int, VACStatus int,
		ReconDate int, PruneStatus int, PruneStatusName nvarchar(128), PruneDate int
	)
	DECLARE @tblVolReconResultForDangledVols TABLE
	( AdminJobId int, CopyId int, AFileId int, JobId int, ClientId int, ClientIdName nvarchar(256),
		SubclientId int, SubclientIdName nvarchar(128), ArchGroupId int, ArchGroupIdName nvarchar(144),
		CopyIdName nvarchar(64), MountPathId int, LibraryId int, LibraryIdName nvarchar(128),
		VolumeId int, ChunkId bigint, Path nvarchar(1024), Chunks int, ChunkSize int, VACStatus int,
		ReconDate int, PruneStatus int, PruneStatusName nvarchar(128), PruneDate int
	)
	DECLARE @tblVolReconResult TABLE
	( AdminJobId int, CopyId int, AFileId int, JobId int, ClientId int, ClientIdName nvarchar(256),
		SubclientId int, SubclientIdName nvarchar(128), ArchGroupId int, ArchGroupIdName nvarchar(144),
		CopyIdName nvarchar(64), MountPathId int, LibraryId int, LibraryIdName nvarchar(128),
		VolumeId int, ChunkId bigint, Path nvarchar(1024), Chunks int, ChunkSize int, VACStatus int,
		ReconDate int, PruneStatus int, PruneStatusName nvarchar(128), PruneDate int
	)
	-- Get the dangled jobs
	INSERT INTO @tblVolReconResultForDangledJobs
	SELECT @i_adminJobId, @i_copyId, 0, 0, 0, '', 0, '',
	-- ArchGroupId
	(ISNULL((SELECT DISTINCT archGroupId FROM archGroupCopy WHERE id = @i_copyId), 0)) AS ArchGroupId,
	-- ArchGroupIdName
	(ISNULL((SELECT DISTINCT AG.name FROM archGroup AG, archGroupCopy AGC WHERE AGC.id = @i_copyId AND AG.id = AGC.archGroupId), '')) AS ArchGroupIdName,
	-- CopyIdName
	(ISNULL((SELECT DISTINCT name FROM archGroupCopy WHERE id = @i_copyId), '')) AS CopyIdName,
	MountPathId, 0, '', VolumeId, ChunkId, '', 1, ChunkSize, VACStatus, 0, 0, '', 0
	FROM MMVolReconChunkList
	WHERE AdminJobId = @i_adminJobId AND VACStatus = 3
	UPDATE @tblVolReconResultForDangledJobs
	SET
		AFileId = ACM.archfileid,
		JobId = AF.jobId,
		SubclientId = AF.appId,
		SubclientIdName = APP.subclientname,
		ClientId = APP.clientId,
		ClientIdName = CLT.name
	FROM @tblVolReconResultForDangledJobs TVR, archChunkMapping ACM, archFile AF, JMJobDataStats JDS, APP_Application APP, APP_Client CLT
	WHERE
		TVR.ChunkId = ACM.archChunkId AND
		ACM.archfileid = AF.id AND JDS.jobId = AF.jobId AND (JDS.disabled & 256) <> 256 AND
		APP.id = AF.appId AND
		CLT.id = APP.clientId
	-- Update the Library Details
	UPDATE @tblVolReconResultForDangledJobs
	SET LibraryId = LIB.LibraryId, LibraryIdName = LIB.AliasName, Path = MP.MountPathName
	FROM @tblVolReconResultForDangledJobs TVR, MMMountPath MP, MMLibrary LIB
	WHERE MP.MountPathId = TVR.MountPathId AND LIB.LibraryId = MP.LibraryId
	SELECT TOP 1 @magneticPath = Path FROM @tblVolReconResultForDangledJobs
	-- Testing Purpose
	-- SET @magneticPath = '/CommVault/90/Build402/MagLibs/MagLib001'
	SET @sepCharPos = CHARINDEX('\', @magneticPath)
	IF @sepCharPos > 0
		UPDATE @tblVolReconResultForDangledJobs
		SET Path = (Path + '\CV_MAGNETIC\V_' + CAST(VolumeId AS VARCHAR(10)))
	ELSE
		UPDATE @tblVolReconResultForDangledJobs
		SET Path = (Path + '/CV_MAGNETIC/V_' + CAST(VolumeId AS VARCHAR(10)))
	DELETE FROM @tblVolReconResultForDangledJobs
	WHERE JobId = 0
	UPDATE @tblVolReconResultForDangledJobs
	SET LibraryId = MMM.LibraryId, Path = (MMM.MountPathName + '\CV_MAGNETIC\')
	FROM @tblVolReconResultForDangledJobs TVR, MMMountPath MMM
	WHERE MMM.MountPathId = TVR.MountPathId
	UPDATE @tblVolReconResultForDangledJobs
	SET Path = (Path + 'V_' + CAST(VolumeId AS VARCHAR(10)))
	UPDATE @tblVolReconResultForDangledJobs
	SET LibraryIdName = ml.aliasname
	FROM @tblVolReconResultForDangledJobs TVR, MMLibrary ML
	WHERE TVR.LibraryId = ML.LibraryId
	-- Get the dangled volumes
	INSERT INTO @tblVolReconResultForDangledVols
	SELECT
		-- AdminJobId , CopyId , AFileId , JobId , ClientId , ClientIdName
		AdminJobId, @i_copyId, 0, 0, 0, '',
		-- SubclientId , SubclientIdName
		0, '',
		-- ArchGroupId
		(ISNULL((SELECT DISTINCT archGroupId FROM archGroupCopy WHERE id = @i_copyId), 0)) AS ArchGroupId,
		-- ArchGroupIdName
		(ISNULL((SELECT DISTINCT AG.name FROM archGroup AG, archGroupCopy AGC WHERE AGC.id = @i_copyId AND AG.id = AGC.archGroupId), '')) AS ArchGroupIdName,
		-- CopyIdName
		(ISNULL((SELECT DISTINCT name FROM archGroupCopy WHERE id = @i_copyId), '')) AS CopyIdName,
		-- MountPathId
		MountPathId,
		-- LibraryId, LibraryIdName
		0, '',
		-- (ISNULL((SELECT DISTINCT LibraryId FROM MMMountPath WHERE MountPathId = MountPathId), 0)) AS LibraryId,
		-- (ISNULL((SELECT DISTINCT AliasName FROM MMLibrary WHERE LibraryId = LibraryId), '')) AS LibraryIdName,
		-- VolumeId , ChunkId, Path, Chunks, ChunkSize, VACStatus
		VolumeId, ChunkId, '', 1, (ChunkSize / 1024), VACStatus,
		-- ReconDate, PruneStatus
		@reconDate, PruneStatus,
		-- PruneStatusName, PruneDate
		'', 0
	FROM MMVolReconChunkList
	WHERE
		AdminJobId = @i_adminJobId AND
		VACStatus = @C_VAC_STATUS_IN_MP AND
		PruneStatus in (0, 7, 8, 9)
	-- Update the Library Details
	UPDATE @tblVolReconResultForDangledVols
	SET LibraryId = LIB.LibraryId, LibraryIdName = LIB.AliasName, Path = MP.MountPathName
	FROM @tblVolReconResultForDangledVols TVR, MMMountPath MP, MMLibrary LIB
	WHERE MP.MountPathId = TVR.MountPathId AND LIB.LibraryId = MP.LibraryId
	SELECT TOP 1 @magneticPath = Path FROM @tblVolReconResultForDangledVols
	-- Testing Purpose
	-- SET @magneticPath = '/CommVault/90/Build402/MagLibs/MagLib001'
	SET @sepCharPos = CHARINDEX('\', @magneticPath)
	IF @sepCharPos > 0
		UPDATE @tblVolReconResultForDangledVols
		SET Path = (Path + '\CV_MAGNETIC\V_' + CAST(VolumeId AS VARCHAR(10)))
	ELSE
		UPDATE @tblVolReconResultForDangledVols
		SET Path = (Path + '/CV_MAGNETIC/V_' + CAST(VolumeId AS VARCHAR(10)))
	/*
	update @tblVolReconResultForDangledVols
	set Chunks = (select count(ChunkId)	from @tblVolReconResultForDangledVols group by volumeid)
	update @tblVolReconResultForDangledVols
	set Chunks = (select sum(ChunkSize)	from @tblVolReconResultForDangledVols group by volumeid)
	*/
	DECLARE @dup_jobId AS INT
	DECLARE dupJobs_cursor CURSOR
	FOR
	SELECT DISTINCT jobId FROM @tblVolReconResultForDangledJobs
	OPEN dupJobs_cursor;
	FETCH NEXT FROM dupJobs_cursor INTO @dup_jobId;
	WHILE (@@FETCH_STATUS <> -1)
	BEGIN;
		INSERT INTO @tblVolReconResult
		SELECT TOP 1 * FROM @tblVolReconResultForDangledJobs WHERE JobId = @dup_jobId
		FETCH NEXT FROM dupJobs_cursor INTO @dup_jobId;
	END;
	CLOSE dupJobs_cursor;
	DEALLOCATE dupJobs_cursor;
	INSERT INTO @tblVolReconResult
	SELECT * FROM @tblVolReconResultForDangledVols
	UPDATE @tblVolReconResult
	SET ReconDate = (SELECT StatusUpdateTime FROM MMAdminJob WHERE JobId = @i_adminJobId)
GET_RESULT:
	SELECT
	ClientId					'@clientId',
	0							'@apptypeId',
	0							'@instanceId',
	0							'@backupsetId',
	SubclientId					'@subclientId',
	ClientIdName				'@clientName',
	''							'@applicationName',
	''							'@instanceName',
	''							'@backupsetName',
	SubclientIdName				'@subclientName',
	ArchGroupIdName				'@spName',
	CopyId						'@copyId',
	CopyIdName					'@copyName',
	LibraryId					'@libId',
	LibraryIdName				'@libName',
	JobId						'@jobId',
	''							'@jobTypeName',
	''							'@jobStatusName',
	''							'@jobStartTime',
	''							'@jobEndTime',
	''							'@userName',
	''							'@errorCode',
	''							'@description',
	AdminJobId					'@adminJobId',
	(SELECT (CASE Status WHEN 0 THEN 'None' WHEN 1 THEN 'Started' WHEN 2 THEN 'Completed' WHEN 3 THEN 'Failed' END) FROM MMAdminJob WHERE jobid = @i_adminJobId)	'@adminJobStatusName',
	(SELECT StartTime FROM MMAdminJob WHERE jobid = @i_adminJobId)				'@adminJobStartTime',
	ReconDate					'@adminJobEndTime',
	VolumeId					'@volId',
	ChunkId						'@chunkId',
	Path						'@volPath',
	Chunks						'@chunks',
	ChunkSize					'@size',
	VACStatus					'@avcStatus',
	(CASE VACStatus WHEN 2 THEN 'Dangled Volumes' WHEN 3 THEN 'Dangled Jobs' END)	'@avcStatusName',
	ReconDate					'@reconDate',
	PruneStatus					'@pruneStatus',
	(CASE PruneStatus
		WHEN 1 THEN 'Submitted for Pruning'
		WHEN 3 THEN 'Submitted for Pruning'
		WHEN 4 THEN 'Pruned'
		WHEN 6 THEN 'Pruned'
		WHEN 7 THEN 'Prune Submission Failed'
		WHEN 9 THEN 'Prune Submission Failed' END)	'@pruneStatusName',
	0							'@pruneDate'
	FROM @tblVolReconResult
	ORDER BY VolumeId
	FOR XML PATH('listOfVolReconResult'), ROOT('EVGui_GetVolReconResultResp')
	RETURN
PRUNE_MEDIA:
	DECLARE @tblDangledVolumesToPrune TABLE (adminJobId INT, volId INT, chunkId BIGINT, mountPathId INT, avcStatus INT, avcStatusName NVARCHAR(64), pruneStatus INT, pruneStatusName NVARCHAR(64), pruneDate INT)
	INSERT into @tblDangledVolumesToPrune
	SELECT
		ref.value('@adminJobId', 'int'),
		ref.value('@volId', 'int'),
		ref.value('@chunkId', 'bigint'),
		0,
		ref.value('@avcStatus', 'int'),
		'',
		ref.value('@pruneStatus', 'int'),
		'',
		ref.value('@pruneDate', 'int')
	FROM @i_xmlInput.nodes('EVGui_PruneVolReconDangleVolsReq/listOfPruneVolReconDangleVols') R ( ref )
	UPDATE @tblDangledVolumesToPrune SET mountPathId = (SELECT TOP 1 MountPathId FROM MMVolReconChunkList WHERE VolumeId = dv.volId)
	FROM @tblDangledVolumesToPrune dv
	declare @tmpVolume table
	(
		VolumeId						integer,
		VolumeName						varchar(112),
		CreationTime					integer,
		VolumeFlags						integer,
		VolumeInitialized				integer,
		FlushBlockSizeKB				integer,
		NumberOfRestores				integer,
		NumberOfBackups					integer,
		NumberOfMounts					integer,
		NumberOfSoftErrors				integer,
		NumberOfHardErrors				integer,
		LastRestoreTime					integer,
		LastBackupTime					integer,
		LogicalBytesMB					integer,
		PhysicalBytesMB					integer,
		NumberOfActiveFiles				integer,
		LastFile						integer,
		RecordingFormatId				integer,
		ExternalGUID					varchar(33),
		OMLVersion						integer,
		VolumeState						integer,
		VolumeFullReason				integer,
		VolumeFullTime					integer,
		VolumeFullJobId					bigint ,
		origCCcommCellID				integer,
		origCCvolumeID					integer,
		MediaId							integer,
		MediaSideId						integer,
		Attributes						integer,
		MediaGroupId					integer,
		ReformatTime					integer,
		RMSpareStatus					integer,
		RMSpareStatusUpdateTime                         integer,
		SIDBStoreId                                     int    ,
		SiloStatus										int    ,
		CurrMountPathId									int	 ,
		FailureErrorCode					integer,
		MMSpareStatus					integer
	)
	-- Query to get list of volumes to be re-populated
	INSERT INTO @tmpVolume
	SELECT dv.volId, 'V_'+ CAST(dv.volId AS VARCHAR(12)), dbo.getUnixTime(getUTCDate()),
	2, 1, 64, 0, 0, 1, 0, 0, 0, dbo.getUnixTime(getUTCDate()),
	0, 0, 0, 0, 10001, 'VolRecon', 2, 0, 0, 0, 0, 2, 0,
	MS.mediaId, MP.mediaSideId, 0, 0, 0, -1, 0, 0, 0, dv.mountPathId, 0, 0
	FROM @tblDangledVolumesToPrune dv, MMMountPath MP, MMMediaSide MS
	WHERE dv.mountPathId = MP.mountPathId AND MP.mediaSideId = MS.mediaSideId and dv.VolId not in (select distinct volumeid from MMVolume)
	EXECUTE AS USER = 'sqladmin_cv'
	SET IDENTITY_INSERT MMVolume ON
	INSERT INTO MMVolume (VolumeId, VolumeName, CreationTime, VolumeFlags, VolumeInitialized,
		FlushBlockSizeKB, NumberOfRestores, NumberOfBackups, NumberOfMounts, NumberOfSoftErrors,
		NumberOfHardErrors, LastRestoreTime, LastBackupTime, LogicalBytesMB, PhysicalBytesMB,
		NumberOfActiveFiles, LastFile, RecordingFormatId, ExternalGUID, OMLVersion, VolumeState,
		VolumeFullReason, VolumeFullTime, VolumeFullJobId, origCCcommCellID, origCCvolumeID, MediaId,
		MediaSideId, Attributes,MediaGroupId, ReformatTime, RMSpareStatus, RMSpareStatusUpdateTime, SIDBStoreId,
		SiloStatus, CurrMountPathId, FailureErrorCode, MMSpareStatus)
	SELECT DISTINCT *  FROM @tmpVolume
	SET IDENTITY_INSERT MMVolume OFF
	REVERT
	-- Chunk Pruning
	INSERT INTO MMDeletedAF
	SELECT DISTINCT 0, dv.volId, 256, 0, 0, '', 0, dv.chunkId, dv.mountPathId, 0, 0, dbo.getUnixTime(getUTCDATE()), 0, 0, 0, 0, 0, 2
	FROM @tblDangledVolumesToPrune dv LEFT OUTER JOIN archChunk AC WITH (NOLOCK)
	ON 	dv.chunkId = AC.id
	-- WHERE AC.id = 0 AND dv.chunkId > 0
	WHERE dv.chunkId > 0
	update @tblDangledVolumesToPrune
	set pruneStatus = 3, pruneDate = dbo.getUnixTime(getUTCDATE())
	where volId > 0 and chunkId > 0
	-- Volume Pruning
	INSERT INTO MMDeletedAF
	SELECT DISTINCT 0, TV.VolumeId, 256, 0, 0, '', 0, 0, dv.MountPathId, 0, 0, dbo.getUnixTime(getUTCDATE()), 0, 0, 0, 0, 0, 2
	FROM @tblDangledVolumesToPrune AS dv INNER JOIN @tmpVolume AS TV
	ON dv.volId = TV.VolumeId
	update @tblDangledVolumesToPrune
	set pruneStatus = 1, pruneDate = dbo.getUnixTime(getUTCDATE())
	where volId > 0 and chunkId = 0
	update MMVolReconChunkList
	set PruneStatus = dv.pruneStatus, PruneTime = dv.pruneDate
	from @tblDangledVolumesToPrune dv, MMVolReconChunkList vr
	where dv.adminJobId = vr.AdminJobId and dv.volId = vr.VolumeId and vr.ChunkId = 0
	select
	adminJobId					'@adminJobId',
	volId						'@volId',
	chunkId						'@chunkId',
	avcStatus					'@avcStatus',
	(CASE avcStatus when 2 then 'Dangled Volumes' when 3 then 'Dangled Jobs' end)	'@avcStatusName',
	(CASE pruneStatus
		when 1 then 'Submitted for Pruning'
		when 3 then 'Submitted for Pruning'
		when 4 then 'Pruned'
		when 6 then 'Pruned'
		when 7 then 'Prune Submission Failed'
		when 9 then 'Prune Submission Failed' end)	'@pruneStatusName',
	pruneDate					'@pruneDate'
	FROM @tblDangledVolumesToPrune
	order by volId
	for xml path('listOfPruneVolReconDangleVols'), ROOT('EVGui_PruneVolReconDangleVolsResp')
	RETURN
PRUNE_JOBS:
	declare @tblDangledJobsToPrune table (adminJobId int, jobId int, copyId int, avcStatus int, avcStatusName nvarchar(64), pruneStatus int, pruneStatusName nvarchar(64), pruneDate int)
	insert into @tblDangledJobsToPrune
	select
		ref.value('@adminJobId', 'int'),
		ref.value('@jobId', 'int'),
		0,
		ref.value('@avcStatus', 'int'),
		'',
		ref.value('@pruneStatus', 'int'),
		'',
		ref.value('@pruneDate', 'int')
	FROM @i_xmlInput.nodes('EVGui_PruneVolReconDangleJobsReq/listOfPruneVolReconDangleJobs') R ( ref )
	update @tblDangledJobsToPrune set copyId = (SELECT TOP 1 ArchCopyId FROM MMVolReconChunkList WHERE AdminJobId = @i_adminJobId)
	from @tblDangledJobsToPrune dj
	declare @dj_jobId int;
	declare @dj_copyId int;
	-- creating temp table to skip select statment in nested stored procedure, because c++ code expects xml output but nested Stored procedures returns integer, so failed to un serialize output and GUI hangs
	IF OBJECT_ID('tempdb.dbo.#TblDeleteBackupByJobCopyResult') IS NOT NULL
	BEGIN
		DROP TABLE #TblDeleteBackupByJobCopyResult
	END
	CREATE TABLE #TblDeleteBackupByJobCopyResult(retValue Int)
	IF OBJECT_ID('tempdb.dbo.#TblArchSetJobsAgedViaTableResult ') IS NOT NULL
	BEGIN
		DROP TABLE #TblArchSetJobsAgedViaTableResult
	END
	CREATE TABLE #TblArchSetJobsAgedViaTableResult (retValue Int)
	IF OBJECT_ID('tempdb.dbo.#tmpResutSetForArchDisAllowJobForCopy') IS NOT NULL
	BEGIN
		DROP TABLE #tmpResutSetForArchDisAllowJobForCopy
	END
	CREATE TABLE #tmpResutSetForArchDisAllowJobForCopy(retValue Int,retStr1 NVARCHAR(1024), retStr2 NVARCHAR(1024))
	declare dangJob_cursor CURSOR
	for
	select jobId, copyId from @tblDangledJobsToPrune
	open dangJob_cursor;
	FETCH NEXT FROM dangJob_cursor INTO @dj_jobId, @dj_copyId;
	WHILE (@@FETCH_STATUS <> -1)
	BEGIN;
		exec deleteBackupByJobCopy @dj_jobId, 2, @dj_copyId
		FETCH NEXT FROM dangJob_cursor INTO @dj_jobId, @dj_copyId;
	END;
	close dangJob_cursor;
	deallocate dangJob_cursor;
	IF OBJECT_ID('tempdb.dbo.#tmpResutSetForArchDisAllowJobForCopy') IS NOT NULL
	BEGIN
		DROP TABLE #tmpResutSetForArchDisAllowJobForCopy
	END
	IF OBJECT_ID('tempdb.dbo.#TblArchSetJobsAgedViaTableResult ') IS NOT NULL
	BEGIN
		DROP TABLE #TblArchSetJobsAgedViaTableResult
	END
	IF OBJECT_ID('tempdb.dbo.#TblDeleteBackupByJobCopyResult') IS NOT NULL
	BEGIN
		DROP TABLE #TblDeleteBackupByJobCopyResult
	END
	update @tblDangledJobsToPrune
	set pruneStatus = 1, pruneDate = dbo.getUnixTime(getUTCDATE())
	update MMVolReconChunkList
	set PruneStatus = dv.pruneStatus, PruneTime = dv.pruneDate
	from @tblDangledJobsToPrune dv, MMVolReconChunkList vr, archFile af, archChunkMapping acm
	where dv.adminJobId = vr.AdminJobId and dv.jobId = af.jobId and acm.archFileId = af.id and vr.ChunkId = acm.archChunkId
	select
	adminJobId					'@adminJobId',
	jobId						'@jobId',
	avcStatus					'@avcStatus',
	(CASE avcStatus when 2 then 'Dangled Volumes' when 3 then 'Dangled Jobs' end)	'@avcStatusName',
	(CASE pruneStatus
		when 1 then 'Submitted for Pruning'
		when 3 then 'Submitted for Pruning'
		when 4 then 'Pruned'
		when 6 then 'Pruned'
		when 7 then 'Prune Submission Failed'
		when 9 then 'Prune Submission Failed' end)	'@pruneStatusName',
	0							'@pruneDate'
	FROM @tblDangledJobsToPrune
	order by jobId
	for xml path('listOfPruneVolReconDangleJobs'), ROOT('EVGui_PruneVolReconDangleJobsResp')
	RETURN
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMagLibVolReconResult')
	delete from GxQscripts where name = 'MMGetMagLibVolReconResult'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMagLibVolReconResult')
	delete from GXDBVersions where aliasname = 'MMGetMagLibVolReconResult'
GO

insert into GXDBVersions values(2, 'MMGetMagLibVolReconResult',  '00010013000200010000', 'MMGetMagLibVolReconResult', '00010013000200010000')
GO

