

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMagLibMaintenance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMagLibMaintenance.sp,v $ $Id: MMGetMagLibMaintenance.sp,v 1.15.190.3 2018/03/20 00:11:52 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetMagLibMaintenance <<<'

IF EXISTS (select * from sysobjects where name='MMGetMagLibMaintenance')
	drop procedure MMGetMagLibMaintenance
IF EXISTS (select * from GxQscripts where name='MMGetMagLibMaintenance')
	delete from GxQscripts where name = 'MMGetMagLibMaintenance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMagLibMaintenance')
	delete from GXDBVersions where aliasname = 'MMGetMagLibMaintenance'
GO
print '... Creating Procedure: MMGetMagLibMaintenance'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMagLibMaintenance
  @in_LibraryId integer
AS
  DECLARE @o_deviceId integer
  DECLARE @o_deviceName varchar(255)
  DECLARE @o_mountPathID integer
  DECLARE @o_mountPathName NVARCHAR(255)
  DECLARE @o_cummulateiveSizeMB bigint
  DECLARE @o_DateLastFragAnalysis integer
  DECLARE @o_DateLastVolRecon integer
  DECLARE @o_LastAnalyzedFrag integer
IF object_id('TempDB.dbo.#tmpMntPathInfo') IS NOT null drop table #tmpMntPathInfo
create table #tmpMntPathInfo (
	deviceId			integer,
	deviceName			varchar(255),
	mountPathId			integer,
	mountPathName		varchar(255),
	sizeMB			bigint,
	dateLastFADRun		integer,
	dateLastRAVRun		integer,
	lastFADResult		integer)
insert into #tmpMntPathInfo
	select de.deviceId, de.AliasName, mp.mountpathid,mp.MountPathName, ms.TotalSpaceMB-ms.FreeBytesMB as CummulativeSizeMB,0,0,-1
	from MMS2getMountPathNameGUIView mp,MMMediaSide ms, MMDevice de
	where mp.libraryid = @in_LibraryId and mp.mediasideid = ms.mediasideid and mp.DeviceId = de.DeviceId
--Add last FAD task run date and result for mount paths
update #tmpMntPathInfo
	set dateLastFADRun = FAD.fadtaskrundate,
	lastFADResult = ((cast(FAD.numTotalExcessFragments as real)/(FAD.appliedFADThreshold*(FAD.numFileFADScanned + FAD.numFilesFADSkippedAnalysis)))* 100 * 100)
	from #tmpMntPathInfo tmp, mmmaglibfadtaskinfo FAD
	where
	tmp.mountpathid = FAD.mountpathid and
	FAD.fadtaskrundate = (select max(fadtaskrundate) from mmmaglibfadtaskinfo FAD
								where FAD.mountpathid = tmp.mountPathId and
								FAD.taskoption = 1 and FAD.taskStatus = 0 and
								(FAD.numFileFADScanned <> 0 or FAD.numFilesFADSkippedAnalysis <> 0))
--Send lastFADResult*100 to GUI. GUI devides it by 100 to show
--the fractional values. Some issue with GUI to show fractional
--part
update #tmpMntPathInfo set lastFADResult = 100*100
where lastFADResult > 100*100
select deviceId,
	deviceName,
	mountPathId,
	mountPathName,
	sizeMB,
	dateLastFADRun,
	dateLastRAVRun,
	lastFADResult from #tmpMntPathInfo
drop table #tmpMntPathInfo
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMagLibMaintenance')
	delete from GxQscripts where name = 'MMGetMagLibMaintenance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMagLibMaintenance')
	delete from GXDBVersions where aliasname = 'MMGetMagLibMaintenance'
GO

insert into GXDBVersions values(2, 'MMGetMagLibMaintenance',  '00010015019000030000', 'MMGetMagLibMaintenance', '00010015019000030000')
GO

