

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMagLibInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMagLibInfo.sp,v $ $Id: MMGetMagLibInfo.sp,v 1.11.36.7 2019/02/26 20:03:23 aselvanayagam Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetMagLibInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMGetMagLibInfo <<<'
	drop procedure MMGetMagLibInfo
END
IF EXISTS (select * from GxQscripts where name='MMGetMagLibInfo')
	delete from GxQscripts where name = 'MMGetMagLibInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMagLibInfo')
	delete from GXDBVersions where aliasname = 'MMGetMagLibInfo'
GO
print '... Creating Procedure: MMGetMagLibInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMagLibInfo
  @i_libraryId integer
AS
  DECLARE @o_vendor char(255)
  DECLARE @o_model char(255)
  DECLARE @o_softState integer
  DECLARE @o_enabled integer
  DECLARE @o_hostClientId integer
  DECLARE @o_hostName char(255)
  DECLARE @o_attribute integer
  DECLARE @o_ExtendedAttributes integer
  DECLARE @o_lowWaterMark integer
  DECLARE @o_warningWaterMark integer
  DECLARE @o_StatusReason integer
  DECLARE @o_DrivePoolId integer
  DECLARE @o_DrivePoolName NVARCHAR(255)
  DECLARE @o_MasterPoolId integer
  DECLARE @o_MasterPoolName NVARCHAR(255)
  DECLARE @o_libraryAliasName NVARCHAR(255)
  DECLARE @o_maxWritersForLib integer
  DECLARE @o_totalWritersAllowed integer
  DECLARE @o_thresholdPercentage integer
  DECLARE @o_thresholdVariation integer
  DECLARE @o_mountTimeoutSec integer
  DECLARE @o_unmountTimeoutSec integer
  DECLARE @o_cacheMountPeriodInSec integer
  DECLARE @o_libraryDescription NVARCHAR(max)
  DECLARE @o_totalFreeSpaceMB bigint
  DECLARE @o_totalSpaceMB bigint
  DECLARE @o_isAnyDataWritten integer
  DECLARE @o_outOfSpaceAlertInDays integer
  DECLARE @o_hybridCloudDiskLibId integer
  DECLARE @o_mediaAgentDisplayName NVARCHAR(255)
  DECLARE @o_hybridCloudDiskLibAliasName NVARCHAR(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	declare @TotalFreeSpaceMB bigint
	declare @TotalSpaceMB bigint
	declare @DataPruning	int = 0
	declare @hybridCloudDiskLibId int = -1
declare @hybridCloudDiskLibAliasName NVARCHAR(255)
	IF object_id('tempdb.dbo.#tmpPool') is not null DROP TABLE #tmpPool
	create table #tmpPool(
	LibraryId		integer,
	DrivePoolId		integer,
	DrivePoolName	nvarchar(256),
	costCategoryId	integer,
	MasterPoolId	integer,
	MasterPoolName	nvarchar(256),
	ClientId		integer,
	maxWriters		integer
	primary key (LibraryId, costCategoryId, ClientId)
	)
	insert into #tmpPool
	select distinct mmp.LibraryId, mdp.DrivePoolId, mdp.DrivePoolName, mdp.costCategoryId,
	mmp.MasterPoolId, mmp.MasterPoolName, mdp.ClientId, mmp.MaxSwitchForHost
	from MMMasterPool as mmp WITH (READUNCOMMITTED), MMDrivePool as mdp WITH (READUNCOMMITTED)
	where mmp.libraryId = @i_libraryId and mdp.MasterPoolId = mmp.MasterPoolId
	SELECT	@TotalSpaceMB = SUM(CAST(MS.TotalSpaceMB AS BIGINT)), @TotalFreeSpaceMB = SUM(CAST(MS.FreeBytesMB AS BIGINT))
	FROM	MMMedia M WITH (NOLOCK), MMMediaSide MS WITH (NOLOCK)
	WHERE	M.LibraryId = @i_libraryId
			AND M.MediaId = MS.MediaId
SELECT @DataPruning = @DataPruning | (Attribute & 8)
	FROM MMMountPath WITH (READUNCOMMITTED) WHERE LibraryId = @i_libraryId
	SELECT @hybridCloudDiskLibId = HCM.diskLibId, @hybridCloudDiskLibAliasName = LIB.AliasName
	FROM MMHybridCloudMapping HCM INNER JOIN MMLibrary LIB ON LIB.LibraryId = HCM.diskLibId
	WHERE HCM.cloudLibId = @i_libraryId
	select ml.libraryvendor, ml.librarymodel, ml.librarySoftState, ml.libraryenabled,
ct.id as hostClientId, ct.net_hostname, ml.libraryattribute, ml.ExtendedAttributes | (CASE WHEN @DataPruning > 0 THEN 2097152	ELSE 0 END), ml.lowwatermarkmb, ml.WarningWaterMark,
	ml.LibraryStatusReason,	tt.DrivePoolId, tt.DrivePoolname, tt.MasterPoolId,
	tt.MasterPoolName, ml.AliasName, tt.maxWriters,
	totalWritersAllowed = (select sum(MaxConcurrentWriters) from MMMountPath
							where MediaSideId in (select MediaSideId from MMMediaSide
							where MediaId in
							(select MediaId from MMMedia where libraryId = @i_libraryId))),
	ml.ThresholdPercentage, ml.ThresholdVariation, ml.MountTimeOutSec, ml.UnMountTimeOutSec,
	ml.cacheMountPeriodInSec, ml.Descript,
	@TotalFreeSpaceMB, @TotalSpaceMB,
	(CASE WHEN EXISTS(SELECT	*
				FROM	MMVolume MV, MMMedia M
				WHERE	MV.MediaId = M.MediaId
						AND M.LibraryId = ml.LibraryId
						AND MV.PhysicalBytesMB <> 0) THEN 1 ELSE 0 END) AS AnyDataWritten,ml.OutOfSpaceAlertInDays, @hybridCloudDiskLibId AS o_hybridCloudDiskLibId,
   ISNULL(ct.displayName,''), @hybridCloudDiskLibAliasName AS o_hybridCloudDiskLibAliasName
	from MMLibrary as ml WITH (READUNCOMMITTED), APP_Client as ct WITH (READUNCOMMITTED), #tmpPool as tt
	where ml.LibraryId = @i_libraryId AND ct.id = tt.clientid and tt.LibraryId = ml.LibraryId
	order by hostClientId
	IF object_id('tempdb.dbo.#tmpPool') is not null DROP TABLE #tmpPool
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMagLibInfo')
	delete from GxQscripts where name = 'MMGetMagLibInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMagLibInfo')
	delete from GXDBVersions where aliasname = 'MMGetMagLibInfo'
GO

insert into GXDBVersions values(2, 'MMGetMagLibInfo',  '00010011003600070000', 'MMGetMagLibInfo', '00010011003600070000')
GO

