

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMPsOnNonDedupPruningThreshold.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMPsOnNonDedupPruningThreshold.sp,v $ $Id: MMGetMPsOnNonDedupPruningThreshold.sp,v 1.1.2.2 2019/09/20 15:01:10 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetMPsOnNonDedupPruningThreshold')
BEGIN
	print '>>> Drop Stored Procedure: MMGetMPsOnNonDedupPruningThreshold <<<'
	drop procedure MMGetMPsOnNonDedupPruningThreshold
END
IF EXISTS (select * from GxQscripts where name='MMGetMPsOnNonDedupPruningThreshold')
	delete from GxQscripts where name = 'MMGetMPsOnNonDedupPruningThreshold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMPsOnNonDedupPruningThreshold')
	delete from GXDBVersions where aliasname = 'MMGetMPsOnNonDedupPruningThreshold'
GO
print '... Creating Procedure: MMGetMPsOnNonDedupPruningThreshold'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMPsOnNonDedupPruningThreshold
  @i_CommCellId integer,
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MountPathId integer
  DECLARE @o_MountPathName nvarchar(256)
  DECLARE @o_DeviceId integer
  DECLARE @o_DeviceName nvarchar(256)
  DECLARE @o_deletedAFCount integer
declare @MPsOnThreshold table (MountPathId int, deletedAFCount int )
DECLARE @currentTime INT = dbo.getUnixTime(GETUTCDATE())
--retreive config param values
declare @deletedAFCountThreshold int = 0
declare @deletedAFCountThresholdMin int = 0
declare @deletedAFCountThresholdMax int = 0
SELECT @deletedAFCountThreshold = ISNULL(value, 25000),
@deletedAFCountThresholdMin = ISNULL(nMin, 5000),
@deletedAFCountThresholdMax = ISNULL(nMax, 1000000)
FROM MMConfigs WITH (READUNCOMMITTED)
WHERE name = 'DA_CONFIG_MAX_NONDDB_DELETEDAF_COUNT_FOR_MOUNTPATH'
-- maintain sanity
if ((@deletedAFCountThreshold < @deletedAFCountThresholdMin) OR (@deletedAFCountThreshold > @deletedAFCountThresholdMax))
set @deletedAFCountThreshold = 25000
declare @thresholdDaysToConsider int = 0;
set @thresholdDaysToConsider = ISNULL((select value from MMConfigs where name = 'DA_CONFIG_DELETEDAF_EVENT_DAYS_TO_CONSIDER'), 7)
declare @thresholdDaysToConsiderMin int = 0;
set @thresholdDaysToConsiderMin = ISNULL((select nMin from MMConfigs where name = 'DA_CONFIG_DELETEDAF_EVENT_DAYS_TO_CONSIDER'), 1)
declare @thresholdDaysToConsiderMax int = 0;
set @thresholdDaysToConsiderMax = ISNULL((select nMax from MMConfigs where name = 'DA_CONFIG_DELETEDAF_EVENT_DAYS_TO_CONSIDER'), 100)
--maintain sanity
if ((@thresholdDaysToConsider < @thresholdDaysToConsiderMin) OR (@thresholdDaysToConsider > @thresholdDaysToConsiderMax))
set @thresholdDaysToConsider = 7
--if the flag =1 is sent then this is from auto-tuning feature. Do not consider event days. Tune Immediately.
if ((@i_reserveParam & 1) > 0)
	SET @thresholdDaysToConsider = 0
--pickup all the stores which have rows older than the thresholdDaysToConsider config
INSERT INTO @MPsOnThreshold
SELECT MMDAF.MountPathId, COUNT(*)
FROM MMDeletedAF MMDAF WITH (READUNCOMMITTED)
WHERE MMDAF.MountPathId > 0
AND MMDAF.SIDBStoreId = 0 -- consider non-dedup only since dedup is considered by other stored proc.
AND MMDAF.DeletedTime < (@currentTime - (@thresholdDaysToConsider * 24 * 60 * 60))
GROUP BY MMDAF.MountPathId
-- cleanup those rows which do not have hit the threshold
DELETE @MPsOnThreshold
WHERE deletedAFCount < @deletedAFCountThreshold
SELECT DISTINCT MP.MountPathId, M.MountPathName, D.DeviceId, D.AliasName, MP.deletedAFCount
FROM @MPsOnThreshold MP
	INNER JOIN MMMountPath M WITH (READUNCOMMITTED) ON MP.MountPathId = M.MountPathId
	INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MP.MountPathId = MPSD.MountPathId
        INNER JOIN MMDevice D WITH (READUNCOMMITTED) on D.DeviceId = MPSD.DeviceId
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMPsOnNonDedupPruningThreshold')
	delete from GxQscripts where name = 'MMGetMPsOnNonDedupPruningThreshold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMPsOnNonDedupPruningThreshold')
	delete from GXDBVersions where aliasname = 'MMGetMPsOnNonDedupPruningThreshold'
GO

insert into GXDBVersions values(2, 'MMGetMPsOnNonDedupPruningThreshold',  '00010001000200020000', 'MMGetMPsOnNonDedupPruningThreshold', '00010001000200020000')
GO

