

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMPDeviceAndMACombinationMissingFromStoragePool.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMPDeviceAndMACombinationMissingFromStoragePool.sp,v $ $Id: MMGetMPDeviceAndMACombinationMissingFromStoragePool.sp,v 1.1.2.7 2018/03/20 00:15:37 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetMPDeviceAndMACombinationMissingFromStoragePool <<<'

IF EXISTS (select * from sysobjects where name='MMGetMPDeviceAndMACombinationMissingFromStoragePool')
	drop procedure MMGetMPDeviceAndMACombinationMissingFromStoragePool
IF EXISTS (select * from GxQscripts where name='MMGetMPDeviceAndMACombinationMissingFromStoragePool')
	delete from GxQscripts where name = 'MMGetMPDeviceAndMACombinationMissingFromStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMPDeviceAndMACombinationMissingFromStoragePool')
	delete from GXDBVersions where aliasname = 'MMGetMPDeviceAndMACombinationMissingFromStoragePool'
GO
print '... Creating Procedure: MMGetMPDeviceAndMACombinationMissingFromStoragePool'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMPDeviceAndMACombinationMissingFromStoragePool
  @i_MountPathId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MountPathId integer
  DECLARE @o_DeviceId integer	
  DECLARE @o_MAId integer	
  DECLARE @o_MountPathName NVARCHAR(1024)
  DECLARE @o_StoragePoolName NVARCHAR(2048)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--Identify if this mountpath (i_MountPathId) is part of storagepool
--From the mountPathIdToExclude get the library
DECLARE @libraryId int
SELECT @libraryId =  MP.LibraryId FROM MMMountPath MP WITH (READUNCOMMITTED)
	WHERE MP.MountPathId = @i_MountPathId
--From the library get the archGroup
DECLARE @storagePool TABLE (storagePoolId int)
INSERT INTO @storagePool
SELECT DISTINCT AGC.archGroupId
FROM MMDrivePool DRP WITH (READUNCOMMITTED), MMDataPath DAP WITH (READUNCOMMITTED),
	 MMMasterPool MP WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED)
WHERE MP.LibraryId = @libraryId AND DAP.DrivePoolId = DRP.DrivePoolId
AND DRP.MasterPoolId = MP.MasterPoolId AND DRP.DrivePoolType = 10001 AND DAP.CopyId=AGC.id
--Get the list of Storage Pools. Ignore tape because we are dealing with device
DECLARE @tmpGlobalPolicyTable TABLE
(
	id integer,
	name NVARCHAR(255),
	streamCount INT DEFAULT(0),
	retentionDays INT DEFAULT(0),
	retentionCycles INT DEFAULT(0)
)
INSERT INTO @tmpGlobalPolicyTable(id, name)
EXEC archGlobalDedupePolicyList 0, 0, 0
INSERT INTO @tmpGlobalPolicyTable(id, name, streamCount, retentionDays, retentionCycles)
EXEC archGlobalNonDedupePolicyList 0, 0
DELETE tmp FROM @storagePool tmp
	LEFT JOIN @tmpGlobalPolicyTable GP ON GP.id=tmp.storagePoolId
WHERE GP.id is NULL
IF NOT EXISTS (SELECT 1 FROM @storagePool)
BEGIN
SET @libraryId=0
RETURN
END
DECLARE @storagePoolName NVARCHAR(2048)
SET @storagePoolName = ISNULL( (select stuff( 	(select ',' + AG.name FROM @storagePool sp JOIN archGroup AG WITH(READUNCOMMITTED) ON sp.storagePoolId = AG.id
									                 FOR XML PATH('')),1,1,'')), '')
DECLARE @mpDeviceAndMAPartOfStoragePool TABLE (mpId int, deviceId int, maId int, mountPathName nvarchar(1024))
--Get all the mountPath and the devices part of the library
INSERT @mpDeviceAndMAPartOfStoragePool
SELECT DISTINCT MP.MountPathId, MSD.DeviceId, DC.ClientId, '' FROM MMMountPath MP WITH (READUNCOMMITTED)
	JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON MSD.MountPathId = MP.MountPathId
	JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON DC.DeviceId = MSD.DeviceId
	JOIN
	(
		SELECT 	DISTINCT MPool.LibraryId
		FROM	@storagePool SP
				INNER JOIN ArchGroupCopy AGC WITH (READUNCOMMITTED) ON SP.storagePoolId = AGC.archGroupId
				INNER JOIN MMDataPath DPath WITH (READUNCOMMITTED) ON AGC.id = DPath.CopyId
				INNER JOIN MMDrivePool DPool WITH (READUNCOMMITTED) ON DPool.DrivePoolId = DPath.DrivePoolId
				INNER JOIN MMMasterPool MPool WITH (READUNCOMMITTED) ON MPool.MasterPoolId = DPool.MasterPoolId
	) AS LIB ON MP.LibraryId = LIB.LibraryId
DECLARE @allMAPartOfGivenLibrary TABLE (maId int)
INSERT INTO @allMAPartOfGivenLibrary
SELECT DISTINCT maId from @mpDeviceAndMAPartOfStoragePool
DECLARE @deviceAndAllMAPossibleCombination TABLE(mpId int, deviceId int, maId int, mountPathName nvarchar(1024))
INSERT INTO @deviceAndAllMAPossibleCombination
SELECT distinct tmp1.mpId, tmp1.deviceId, tmp2.maId, '' from @mpDeviceAndMAPartOfStoragePool tmp1, @allMAPartOfGivenLibrary tmp2
DECLARE @deviceAndMissingMA TABLE(mpId int, deviceId int, maId int, mountPathName nvarchar(1024))
--Get the difference here
INSERT INTO @deviceAndMissingMA
SELECT * FROM
(SELECT * from @deviceAndAllMAPossibleCombination
EXCEPT
SELECT * from @mpDeviceAndMAPartOfStoragePool)v
UPDATE tmp
SET tmp.mountPathName = MPATH.MountPathName
FROM @deviceAndMissingMA tmp
JOIN MMS2getMountPathNameGUIView MPATH WITH (READUNCOMMITTED) ON MPATH.MountPathId = tmp.mpId
SELECT mpId, deviceId, maId, mountPathName, @storagePoolName FROM @deviceAndMissingMA
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMPDeviceAndMACombinationMissingFromStoragePool')
	delete from GxQscripts where name = 'MMGetMPDeviceAndMACombinationMissingFromStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMPDeviceAndMACombinationMissingFromStoragePool')
	delete from GXDBVersions where aliasname = 'MMGetMPDeviceAndMACombinationMissingFromStoragePool'
GO

insert into GXDBVersions values(2, 'MMGetMPDeviceAndMACombinationMissingFromStoragePool',  '00010001000200070000', 'MMGetMPDeviceAndMACombinationMissingFromStoragePool', '00010001000200070000')
GO

