

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMPAndDeviceWithNoGivenMAFromStoragePool.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMPAndDeviceWithNoGivenMAFromStoragePool.sp,v $ $Id: MMGetMPAndDeviceWithNoGivenMAFromStoragePool.sp,v 1.1.2.1 2016/01/27 21:34:08 kshettigar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetMPAndDeviceWithNoGivenMAFromStoragePool <<<'

IF EXISTS (select * from sysobjects where name='MMGetMPAndDeviceWithNoGivenMAFromStoragePool')
	drop procedure MMGetMPAndDeviceWithNoGivenMAFromStoragePool
IF EXISTS (select * from GxQscripts where name='MMGetMPAndDeviceWithNoGivenMAFromStoragePool')
	delete from GxQscripts where name = 'MMGetMPAndDeviceWithNoGivenMAFromStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMPAndDeviceWithNoGivenMAFromStoragePool')
	delete from GXDBVersions where aliasname = 'MMGetMPAndDeviceWithNoGivenMAFromStoragePool'
GO
print '... Creating Procedure: MMGetMPAndDeviceWithNoGivenMAFromStoragePool'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMPAndDeviceWithNoGivenMAFromStoragePool
  @i_MountPathIdToExclude integer = 0,
  @i_MediaAgentId integer = 0,
  @i_Reserve integer = 0
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MountPathId integer
  DECLARE @o_DeviceId integer	
  DECLARE @o_MAIdlistNotInGivenMPId varchar(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--Identify if this mountpath (i_MountPathIdToExclude) is part of storagepool
--From the mountPathIdToExclude get the library
DECLARE @lib TABLE (libraryId int)
INSERT INTO @lib
SELECT MPOOL.LibraryId FROM MMMasterPool MPOOL WITH (READUNCOMMITTED)
	JOIN MMMountPath MPATH WITH (READUNCOMMITTED) ON MPOOL.MasterPoolId=MPATH.MasterPoolId
	JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON MSD.MountPathId=MPATH.MountPathId
	WHERE MPATH.MountPathId = @i_MountPathIdToExclude
--From the library get the archGroup
DECLARE @storagePool TABLE (storagePoolId int)
INSERT INTO @storagePool
SELECT DISTINCT AGC.archGroupId
FROM MMDrivePool DRP WITH (READUNCOMMITTED), MMDataPath DAP WITH (READUNCOMMITTED),
	 MMMasterPool MP WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED), @lib tmpLib
WHERE MP.LibraryId = tmpLib.libraryId AND DAP.DrivePoolId = DRP.DrivePoolId
AND DRP.MasterPoolId = MP.MasterPoolId AND DRP.DrivePoolType = 10001 AND DAP.CopyId=AGC.id
--Get the list of Storage Pools. Ignore tape because we are dealing with device
DECLARE @tmpGlobalPolicyTable TABLE
(
	id integer,
	name NVARCHAR(255),
	streamCount INT DEFAULT(0)
)
INSERT INTO @tmpGlobalPolicyTable(id, name)
EXEC archGlobalDedupePolicyList 0, 0, 0
INSERT INTO @tmpGlobalPolicyTable(id, name, streamCount)
EXEC archGlobalNonDedupePolicyList 0, 0
DELETE tmp FROM @storagePool tmp
	LEFT JOIN @tmpGlobalPolicyTable GP ON GP.id=tmp.storagePoolId
WHERE GP.id is NULL
DECLARE @maPartOfGivenMPId TABLE (maId int)
INSERT INTO @maPartOfGivenMPId
SELECT DISTINCT DC.ClientId FROM MMMountPathToStorageDevice MSD
JOIN MMMountPath MP ON MP.MountPathId=MSD.MountPathId
JOIN MMDeviceController DC ON DC.DeviceId = MSD.DeviceId
WHERE MP.MountPathId = @i_MountPathIdToExclude
DECLARE @mpAndDeviceWithoutGivenMA TABLE(mpId int, deviceId int, maIdListNotInGivenMPId varchar(255))
--Here if @storagePool is not empty then the given mount path is part of a storagepool
--Get the Devices part of the storage pool where the given controller is not present
--Get all the mountPath and the devices other than the given mountpath and which does not have given MA
INSERT @mpAndDeviceWithoutGivenMA
SELECT DISTINCT MP.MountPathId, MSD.DeviceId, '' FROM MMMountPath MP WITH (READUNCOMMITTED)
	JOIN @lib tmpLib ON MP.LibraryId=tmpLib.libraryId
	JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON MSD.MountPathId = MP.MountPathId
WHERE  MSD.DeviceId NOT IN (SELECT DeviceId from MMDeviceController DC1 WITH (READUNCOMMITTED) where DC1.ClientId = @i_MediaAgentId )
AND MP.MountPathId <> @i_MountPathIdToExclude
DECLARE @maPartOfOtherMPs TABLE (maId int)
INSERT INTO @maPartOfOtherMPs
SELECT DISTINCT DC.ClientId FROM MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED)
JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.MountPathId=MSD.MountPathId
JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON DC.DeviceId = MSD.DeviceId
JOIN @mpAndDeviceWithoutGivenMA tmpDC ON tmpDC.deviceId = DC.DeviceId
--Get the difference here
DECLARE @maToBeIncludedInGivenMPId TABLE (maId int)
INSERT INTO @maToBeIncludedInGivenMPId (maId)
SELECT * FROM
(SELECT DISTINCT maId from @maPartOfOtherMPs
EXCEPT
SELECT DISTINCT maId from @maPartOfGivenMPId)v
UPDATE  @mpAndDeviceWithoutGivenMA
SET maIdListNotInGivenMPId = ISNULL( (select stuff(	(select ',' + cast(maId as varchar(20)) FROM @maToBeIncludedInGivenMPId
									                 FOR XML PATH('')),1,1,'')), '')
SELECT mpId, deviceId, maIdListNotInGivenMPId FROM @mpAndDeviceWithoutGivenMA
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMPAndDeviceWithNoGivenMAFromStoragePool')
	delete from GxQscripts where name = 'MMGetMPAndDeviceWithNoGivenMAFromStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMPAndDeviceWithNoGivenMAFromStoragePool')
	delete from GXDBVersions where aliasname = 'MMGetMPAndDeviceWithNoGivenMAFromStoragePool'
GO

insert into GXDBVersions values(2, 'MMGetMPAndDeviceWithNoGivenMAFromStoragePool',  '00010001000200010000', 'MMGetMPAndDeviceWithNoGivenMAFromStoragePool', '00010001000200010000')
GO

