

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMAListForStoragePool.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetMAListForStoragePool')
BEGIN
	print '>>> Drop Stored Procedure: MMGetMAListForStoragePool <<<'
	drop procedure MMGetMAListForStoragePool
END
IF EXISTS (select * from GxQscripts where name='MMGetMAListForStoragePool')
	delete from GxQscripts where name = 'MMGetMAListForStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMAListForStoragePool')
	delete from GXDBVersions where aliasname = 'MMGetMAListForStoragePool'
GO
print '... Creating Procedure: MMGetMAListForStoragePool'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetMAListForStoragePool
  @i_storagePoolId integer		
AS
  DECLARE @clientId integer
  DECLARE @displayName nvarchar(255)
  DECLARE @hostAttribute integer
  DECLARE @hostSoftState integer
  DECLARE @hostEnabled integer
  DECLARE @bStorageMA Integer
  DECLARE @bDDBMA Integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
;with storageMA_cte
AS    (
    SELECT  DISTINCT DPOOL.ClientId
    FROM    archGroup ag
            INNER JOIN MMDataPath DP ON DP.copyId = ag.defaultcopy
            INNER JOIN MMDrivePool DPOOL ON DPOOL.drivePoolId =  DP.DrivePoolId
    WHERE    ag.id = @i_storagePoolId
),
ddbMA_cte
AS    (
    SELECT  DISTINCT SS.ClientId
    FROM    archGroup ag
            INNER JOIN archCopySidbStore acss ON acss.copyId = ag.defaultCopy
            INNER JOIN IdxSIDBSubStore SS ON SS.sidbStoreId = acss.sidbstoreid
    WHERE    ag.id = @i_storagePoolId
),
associatedMA_cte
AS (
    SELECT ClientId FROM storageMA_cte
    UNION
    SELECT ClientId FROM ddbMA_cte
)
SELECT  C.id,
        C.displayName,
		H.Attribute,
		H.MMHostSoftState,
		H.MMHostEnabled,
        IIF(S.clientId IS NULL, 0, 1) as bStorageMA,
        IIF(D.ClientId IS NULL, 0, 1) as bDDBMA
FROM    associatedMA_cte MA
        INNER JOIN    APP_Client C    	ON C.id = MA.ClientId
        INNER JOIN    MMHost H        	ON H.ClientId = C.id
        LEFT JOIN    storageMA_cte S 	ON S.clientId = MA.ClientId
        LEFT JOIN    ddbMA_cte D        ON D.clientId = MA.ClientId

IF EXISTS (select * from GxQscripts where name = 'MMGetMAListForStoragePool')
	delete from GxQscripts where name = 'MMGetMAListForStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMAListForStoragePool')
	delete from GXDBVersions where aliasname = 'MMGetMAListForStoragePool'
GO

insert into GXDBVersions values(2, 'MMGetMAListForStoragePool',  '00000000000000000000', 'MMGetMAListForStoragePool', '00000000000000000000')
GO

