

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMAListForSharingMountPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMAListForSharingMountPath.sp,v $ $Id: MMGetMAListForSharingMountPath.sp,v 1.2.2.5 2018/12/19 23:35:29 pveeravalli Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMGetMAListForSharingMountPath"				|
--	|									|
--	| Execute the System stored procedure to fetch Access Path candidates	|
--	| .. for the (current) SIDB Store.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetMAListForSharingMountPath')
BEGIN
	print '>>> Drop Stored Procedure: MMGetMAListForSharingMountPath <<<'
	drop procedure MMGetMAListForSharingMountPath
END
IF EXISTS (select * from GxQscripts where name='MMGetMAListForSharingMountPath')
	delete from GxQscripts where name = 'MMGetMAListForSharingMountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMAListForSharingMountPath')
	delete from GXDBVersions where aliasname = 'MMGetMAListForSharingMountPath'
GO
print '... Creating Procedure: MMGetMAListForSharingMountPath'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMAListForSharingMountPath
  @i_userId integer,
  @i_MountPathId integer
AS
  DECLARE @o_mediaAgentId integer
  DECLARE @o_mediaAgentName nvarchar(255)
  DECLARE @o_mediaAgentNetworkName nvarchar(255)
  DECLARE @o_SystemOsVersion nvarchar(255)
  DECLARE @o_SystemHardWare nvarchar(255)
  DECLARE @o_softState integer
  DECLARE @o_enabled integer
  DECLARE @o_mediaAgentDisplayName NVARCHAR(255)
-- lookup all the Media Agent list
DECLARE @tmpMediaAgentList TABLE (
									clientId      integer,
clientName          nvarchar(255),
clientDisplayName   nvarchar(255),
clientNetworkName   nvarchar(255),
									hostType          integer,
									softState         integer,
									enabled           integer,
									MAOfflineReason   integer,
									ReleaseId         integer,
SoftWareRelease   nvarchar(255),
SoftWareBuildId   nvarchar(255),
SystemOsVersion   nvarchar(255),
SystemHardWare    nvarchar(255),
									SystemOsId        integer,
									numLibraries      integer,
									isCommServer      integer,
									isVirtualClient   integer,
									attribute         integer,
									IsUnlicensedMA    integer,
									isPreConfigured   integer,
									patchStatus       integer,
									isMACatalogServer integer,
									isEDCDiscovered   integer,
									MAMaxReservations integer,
									flags             integer,
									description       nvarchar(max),
									Capabilities      bigint,
				                                        installedTime     integer  )
	INSERT	@tmpMediaAgentList
	EXEC MMS2GetMediaAgentList @i_userId
	SELECT tmpMA.clientId, tmpMA.clientName, tmpMA.clientNetworkName, tmpMA.SystemOsVersion, tmpMA.SystemHardWare, tmpMA.softState, tmpMA.enabled,tmpMA.clientDisplayName FROM @tmpMediaAgentList tmpMA
	WHERE tmpMA.clientId NOT IN (Select MDC.ClientId from MMDeviceController MDC with (nolock) JOIN MMMountPathToStorageDevice MSD with (nolock) ON MDC.DeviceId = MSD.DeviceId	WHERE MSD.MountPathId = @i_MountPathId)
	AND tmpMA.IsUnlicensedMA = 0
	ORDER BY tmpMA.clientName
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMAListForSharingMountPath')
	delete from GxQscripts where name = 'MMGetMAListForSharingMountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMAListForSharingMountPath')
	delete from GXDBVersions where aliasname = 'MMGetMAListForSharingMountPath'
GO

insert into GXDBVersions values(2, 'MMGetMAListForSharingMountPath',  '00010002000200050000', 'MMGetMAListForSharingMountPath', '00010002000200050000')
GO

