

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetMAListForLibrary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetMAListForLibrary.sp,v $ $Id: MMGetMAListForLibrary.sp,v 1.2.2.6 2018/12/19 23:35:23 pveeravalli Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMGetMAListForLibrary"				|
--	|									|
--	| Execute the System stored procedure to fetch Access Path candidates	|
--	| .. for the (current) SIDB Store.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetMAListForLibrary')
BEGIN
	print '>>> Drop Stored Procedure: MMGetMAListForLibrary <<<'
	drop procedure MMGetMAListForLibrary
END
IF EXISTS (select * from GxQscripts where name='MMGetMAListForLibrary')
	delete from GxQscripts where name = 'MMGetMAListForLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMAListForLibrary')
	delete from GXDBVersions where aliasname = 'MMGetMAListForLibrary'
GO
print '... Creating Procedure: MMGetMAListForLibrary'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetMAListForLibrary
  @i_userId integer,
  @i_libraryId integer
AS
  DECLARE @o_mediaAgentId integer
  DECLARE @o_mediaAgentName nvarchar(255)
  DECLARE @o_mediaAgentNetworkName nvarchar(255)
  DECLARE @o_SystemOsVersion nvarchar(255)
  DECLARE @o_SystemHardWare nvarchar(255)
  DECLARE @o_softState integer
  DECLARE @o_enabled integer
  DECLARE @o_mediaAgentDisplayName NVARCHAR(255)
-- lookup all the Media Agent list
DECLARE @tmpMediaAgentList TABLE (
									clientId      integer,
clientName          nvarchar(255),
clientDisplayName   nvarchar(255),
clientNetworkName   nvarchar(255),
									hostType          integer,
									softState         integer,
									enabled           integer,
									MAOfflineReason   integer,
									ReleaseId         integer,
SoftWareRelease   nvarchar(255),
SoftWareBuildId   nvarchar(255),
SystemOsVersion   nvarchar(255),
SystemHardWare    nvarchar(255),
									SystemOsId        integer,
									numLibraries      integer,
									isCommServer      integer,
									isVirtualClient   integer,
									attribute         integer,
									IsUnlicensedMA    integer,
									isPreConfigured   integer,
									patchStatus       integer,
									isMACatalogServer integer,
									isEDCDiscovered   integer,
									MAMaxReservations integer,
									flags             integer,
									description       nvarchar(max),
									Capabilities      bigint ,
									installedTime     integer )
	INSERT	@tmpMediaAgentList
	EXEC MMS2GetMediaAgentList @i_userId
	SELECT DISTINCT tmpMA.clientId, tmpMA.clientName, tmpMA.clientNetworkName, tmpMA.SystemOsVersion, tmpMA.SystemHardWare, tmpMA.softState, tmpMA.enabled,tmpMA.clientDisplayName FROM @tmpMediaAgentList tmpMA
	JOIN MMDeviceController MDC with (nolock) on tmpMA.clientId = MDC.clientid
	JOIN MMMountPathToStorageDevice MS with (nolock) on MDC.DeviceId = MS.DeviceId
	JOIN MMMountPath MP with (nolock) on MP.MountPathId = MS.MountPathId
	JOIN MMLibrary ML with ( nolock) on ML.LibraryId = MP.LibraryId
	where ML.LibraryId = @i_libraryId AND tmpMA.IsUnlicensedMA = 0
	ORDER BY tmpMA.clientName
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetMAListForLibrary')
	delete from GxQscripts where name = 'MMGetMAListForLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetMAListForLibrary')
	delete from GXDBVersions where aliasname = 'MMGetMAListForLibrary'
GO

insert into GXDBVersions values(2, 'MMGetMAListForLibrary',  '00010002000200060000', 'MMGetMAListForLibrary', '00010002000200060000')
GO

