

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetListOfVolumesForMPRefresh.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetListOfVolumesForMPRefresh')
BEGIN
	print '>>> Drop Stored Procedure: MMGetListOfVolumesForMPRefresh <<<'
	drop procedure MMGetListOfVolumesForMPRefresh
END
IF EXISTS (select * from GxQscripts where name='MMGetListOfVolumesForMPRefresh')
	delete from GxQscripts where name = 'MMGetListOfVolumesForMPRefresh'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetListOfVolumesForMPRefresh')
	delete from GXDBVersions where aliasname = 'MMGetListOfVolumesForMPRefresh'
GO
print '... Creating Procedure: MMGetListOfVolumesForMPRefresh'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetListOfVolumesForMPRefresh
  @i_deviceControllerId INTEGER,
  @i_sourceMAId INTEGER,
  @i_phase INTEGER,
  @i_moveId INTEGER
AS
  DECLARE @o_volumeId INTEGER
--- i have source device location, source client ID and phase
DECLARE @i_deviceController VARCHAR(1024) = @i_deviceControllerId
DECLARE @i_sourceMA INTEGER = @i_sourceMAId
DECLARE @i_phaseOfMove INTEGER = @i_phase
DECLARE @batchSize 					INTEGER;
DECLARE @minBatchSize 				INTEGER;
DECLARE @mediaSideId 				INTEGER;
DECLARE @mountPathId 				INTEGER;
SELECT 	@batchSize =  value,	@minBatchSize = nMin
FROM 	MMConfigs
WHERE 	(name = 'MMS2_CONFIG_MP_MOVE_BATCH_SIZE')
IF OBJECT_ID('tempdb.dbo.#tmpVolume') IS NOT NULL DROP TABLE #tmpVolume
CREATE TABLE #tmpVolume(volumeId INTEGER)
SELECT TOP 1  @mediaSideId = MP.MediaSideId, @mountPathId = MP.MountPathId
FROM 		MMDeviceController 			DC WITH(NOLOCK)
	INNER JOIN 	MMMountPathToStorageDevice 	MPSD WITH(NOLOCK)	 	ON MPSD.DeviceId = DC.DeviceId
	INNER JOIN 	MMMountPath 				MP WITH(NOLOCK)			ON MP.MountPathId = MPSD.MountPathId
WHERE 	DC.ClientId = @i_sourceMA
	AND  	DC.DeviceControllerId = @i_deviceController
--update totalNoOfBatches and totalDataSizeMB possible in MMMountPathMove table
IF(@i_phaseOfMove = 1)
BEGIN
		;WITH volumes_cte(countN,TotalPhysicalBytesMB, VolumeFlags)
		AS	(
			SELECT 	COUNT(1),sum(V.PhysicalBytesMb),V.VolumeFlags
			FROM MMVolume 	V 							WITH(NOLOCK)
				INNER JOIN 	MMMediaSide MS 					WITH(NOLOCK) 	ON V.MediaSideId = MS.MediaSideId
				INNER JOIN 	MMMedia M 						WITH(NOLOCK) 	ON M.MediaId = MS.MediaId
			WHERE 	V.VolumeInitialized = 1
AND 	(V.Attributes & 512 = 0)
				AND 	M.MediaTypeId = 10001
				AND 	MS.MediaSideId = @mediaSideId
			GROUP BY V.VolumeFlags
		),
		noOfBatches_cte(batchesN)
		AS	(
			SELECT (ISNULL(CEILING(sum(countN)/CAST(@batchSize AS FLOAT)),0)+1)			-- consider count of phase 1 volume only and add 1 for phase 2
			FROM volumes_cte WHERE VolumeFlags IN (2,3,4,6)
		),
		mountPathDataSize_cte(dataSize)
		AS	(
			SELECT ISNULL(sum(TotalPhysicalBytesMB),0)
			FROM volumes_cte
			WHERE VolumeFlags IN (1,2,3,4,6)
		)
	UPDATE MMMountPathMove
	SET
		TotalNoOfBatches = (SELECT TOP 1 batchesN FROM noOfBatches_cte),
		TotalDataSizeMB =	(SELECT TOP 1 dataSize FROM mountPathDataSize_cte)
	WHERE MoveId = @i_moveId
END
ELSE IF(@i_phaseOfMove = 2)
BEGIN
	--current batch is the last batch, as batch no start from 0,so total will be currentBatchId+1
	--no need to update total data size, at this time ma knows
	UPDATE MMMountPathMove
	SET TotalNoOfBatches = CurrBatchId+1
	WHERE MoveId = @i_moveId
END
--total no of batches should always greater or equal to current batch
UPDATE MMMountPathMove
SET TotalNoOfBatches = CurrBatchId+1
WHERE MoveId = @i_moveId AND TotalNoOfBatches <= CurrBatchId
IF(@i_phaseOfMove = 1)
BEGIN
	DECLARE @noOfVolumesInCurrentBatch 	INTEGER =0;
	DECLARE @volumesToBeAlloted 		INTEGER;
	-- Select all the volumes already picked for this batch
	;WITH  volumesAlreadyPickedForThisBatch_cte(volumeId)
	AS (
		SELECT MPTV.VolumeID
		FROM 		MMVolume 				V WITH(NOLOCK)
			INNER JOIN 	MMMPMovePhaseToVolume 	MPTV WITH(NOLOCK) 	ON MPTV.VolumeID = V.VolumeId
			INNER JOIN 	MMMountPathMove 		MPV WITH(NOLOCK) 	ON MPV.CurrBatchId = MPTV.BatchId AND MPV.MoveId = MPTV.MoveId
		WHERE 	MPV.MoveId = @i_moveId
			AND V.MediaSideId = @mediaSideId
	)
	INSERT INTO #tmpVolume
	SELECT volumeId FROM volumesAlreadyPickedForThisBatch_cte
	-- Get no of volumes already alloted to current batch
	SELECT @noOfVolumesInCurrentBatch = @@rowcount
	-- Get no of Volumes to be allotted to this batch
	SELECT @volumesToBeAlloted = IIf(@batchSize - @noOfVolumesInCurrentBatch  > 0,@batchSize -@noOfVolumesInCurrentBatch ,0 )
	IF(@volumesToBeAlloted > 0)
	BEGIN
		;WITH alreadyPickedVolumes_cte(volumeID)
		AS (
			SELECT VolumeId
			FROM MMMPMovePhaseToVolume WITH(NOLOCK)
			WHERE MoveId = @i_moveId
		),
		volumesToBePicked_cte(volumeId)
		AS	(
			SELECT 	TOP (@volumesToBeAlloted +@minBatchSize)
				V.VolumeID
			FROM MMVolume 	V 							WITH(NOLOCK)
				INNER JOIN 	MMMediaSide MS 					WITH(NOLOCK) 	ON V.MediaSideId = MS.MediaSideId
				INNER JOIN 	MMMedia M 						WITH(NOLOCK) 	ON M.MediaId = MS.MediaId
				LEFT JOIN 	alreadyPickedVolumes_cte pvc					ON pvc.volumeID = V.VolumeID
			WHERE 	V.VolumeFlags in (2,3,4,6)
				AND 	V.VolumeInitialized = 1
AND 	(V.Attributes & 512 = 0)
				AND 	M.MediaTypeId = 10001
				AND 	pvc.volumeID IS NULL
				AND 	(MS.MediaSideId = @mediaSideId OR V.VolumeID IN (SELECT volumeId FROM MMCloudVolCacheMountPath WITH(NOLOCK) WHERE cacheMountPathId = @mountPathId))
				AND 	NOT EXISTS (SELECT 1 FROM MMResource r (READUNCOMMITTED) WHERE R.VolumeId = V.VolumeId AND R.ReservationType = 2) --RESERVE_TYPE_WRITE
		),
		noOfVolumesToPick_cte(topN)
		AS	(
			--	In above cte, we have fetched more no. of volumes than capacity of a batch
			--	Because we want to check, we can form next batch or not
			-- 	if we dont have volumes to create next batch, we will send all volumes at once
			--	For eg, 1000 is batch size and minBatchSize =100, then we have picked 1100 volumes
			-- 	if we get one less volume than 1100 we will send all, else only 1000(because we can create new batch with 100 volumes)
			--	For eg, batchsize=1000, and minBatchSize=100, suppose there are only 1050 volumes, then create batch of 1050 rather than 1000,
			SELECT (IIF((SELECT count(1) from volumesToBePicked_cte) < @volumesToBeAlloted +@minBatchSize,@volumesToBeAlloted +@minBatchSize,@volumesToBeAlloted ))
		),
		newVolumesToBeCopied_cte(volumeId)
		AS (
			SELECT TOP (SELECT TOP 1 topN FROM noOfVolumesToPick_cte )
				volumeId
			FROM volumesToBePicked_cte V
		)
		INSERT INTO #tmpVolume
			SELECT  volumeId FROM newVolumesToBeCopied_cte
	END
END
ELSE IF(@i_phase = 2)
BEGIN
--MA does not require any list during phase 2, passing just one volume because, MA had a check for file-list shouldn't be empty
--And to make sure that we have atleast one volume to move
	INSERT INTO #tmpVolume
		SELECT TOP 1 V.VolumeId
		FROM MMVolume 	V 							WITH(NOLOCK)
					INNER JOIN 	MMMediaSide MS 					WITH(NOLOCK) 	ON V.MediaSideId = MS.MediaSideId
					INNER JOIN 	MMMedia M 						WITH(NOLOCK) 	ON M.MediaId = MS.MediaId
		WHERE V.VolumeFlags in (1,2,3,4,6)
			AND  V.volumeInitialized = 1
AND (V.Attributes & 512 = 0)
			AND  M.MediaTypeId = 10001
			AND (MS.MediaSideId = @mediaSideId OR V.VolumeID IN (SELECT volumeId FROM MMCloudVolCacheMountPath WITH(NOLOCK) WHERE cacheMountPathId = @mountPathId))
END
select volumeId from #tmpVolume
IF OBJECT_ID('tempdb.dbo.#tmpVolume') IS NOT NULL DROP TABLE #tmpVolume

IF EXISTS (select * from GxQscripts where name = 'MMGetListOfVolumesForMPRefresh')
	delete from GxQscripts where name = 'MMGetListOfVolumesForMPRefresh'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetListOfVolumesForMPRefresh')
	delete from GXDBVersions where aliasname = 'MMGetListOfVolumesForMPRefresh'
GO

insert into GXDBVersions values(2, 'MMGetListOfVolumesForMPRefresh',  '00000000000000000000', 'MMGetListOfVolumesForMPRefresh', '00000000000000000000')
GO

