

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetListOfMountPathStatusForCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetListOfMountPathStatusForCopy.sp,v $ $Id: MMGetListOfMountPathStatusForCopy.sp,v 1.3.274.10 2020/12/10 00:43:05 kjaiswal Exp $";
--
-- #define EXCLUDE_SILO_DATAPATH_FLAG 1 for i_Flags
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetListOfMountPathStatusForCopy')
BEGIN
	print '>>> Drop Stored Procedure: MMGetListOfMountPathStatusForCopy <<<'
	drop procedure MMGetListOfMountPathStatusForCopy
END
IF EXISTS (select * from GxQscripts where name='MMGetListOfMountPathStatusForCopy')
	delete from GxQscripts where name = 'MMGetListOfMountPathStatusForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetListOfMountPathStatusForCopy')
	delete from GXDBVersions where aliasname = 'MMGetListOfMountPathStatusForCopy'
GO
print '... Creating Procedure: MMGetListOfMountPathStatusForCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetListOfMountPathStatusForCopy
  @i_CopyId integer,
  @i_Flags integer
AS
  DECLARE @o_MountPathId integer
  DECLARE @o_Status integer
  DECLARE @o_reserveParam integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	--
	-- Temporary tables
	--
	IF OBJECT_ID('tempdb..#MagLibsforCopy') IS NOT NULL DROP TABLE #MagLibsforCopy
	CREATE TABLE #MagLibsforCopy (t_LibraryId int)
	IF OBJECT_ID('tempdb..#MPIdsForCopy') IS NOT NULL DROP TABLE #MPIdsForCopy
	CREATE TABLE #MPIdsForCopy (t_MountPathId int, t_Status int, t_flags int)
	INSERT INTO #MagLibsForCopy
	SELECT MP.LibraryId
	FROM MMDrivePool DRP WITH (READUNCOMMITTED) INNER JOIN MMDataPath DAP WITH (READUNCOMMITTED) ON DAP.DrivePoolId = DRP.DrivePoolId AND ((@i_Flags & 1) = 0 OR (DAP.Flag & 8) = 0)
INNER JOIN MMMasterPool MP WITH (READUNCOMMITTED) ON DRP.DrivePoolType = 10001 AND DRP.MasterPoolId = MP.MasterPoolId
	WHERE DAP.CopyId = @i_CopyId
	UNION
	SELECT MP.LibraryId
	FROM MMMountPath MP WITH (READUNCOMMITTED)
	WHERE EXISTS
		(
			SELECT 1 FROM MMVolume V WITH (READUNCOMMITTED)
				INNER JOIN IdxSIDBStore S WITH (READUNCOMMITTED) ON S.SIDBStoreId = V.SIDBStoreId AND S.SealedTime = 0
				INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON S.SIDBStoreId = CS.SIDBStoreId
			 WHERE CS.copyId = @i_CopyId
				AND MP.MediaSideId = V.MediaSideId
		)
	INSERT INTO #MPIdsForCopy
SELECT DISTINCT MP.MountPathId, (CASE WHEN (MP.IsEnabled > 0 AND MP.IsOffline = 0 AND (MP.Attribute & 8192) = 0) THEN 1 ELSE 0 END),
(CASE WHEN MP.OfflineReason = 6 /*MOUNTPATH_MARKED_PERMANENTLY_OFFLINE_BY_USER*/ THEN  1 ELSE 0 END)
	FROM #MagLibsforCopy T, MMMountPath MP WITH (READUNCOMMITTED)
	WHERE MP.LibraryId = T.t_LibraryId
	--For force delete mountpaths
	INSERT INTO #MPIdsForCopy
SELECT DISTINCT MP2DDB.MountpathId, 0, 1
	FROM MMDeletedMPToDDB MP2DDB WITH (READUNCOMMITTED)
	INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON MP2DDB.SIDBStoreId = CS.SIDBStoreId AND CS.CopyId = @i_CopyId
-- fall through
proc_exit:
	select t_MountPathId, t_Status, t_flags
	from #MPIdsForCopy
IF OBJECT_ID('tempdb..#MagLibsforCopy') IS NOT NULL DROP TABLE #MagLibsforCopy
IF OBJECT_ID('tempdb..#MPIdsForCopy') IS NOT NULL DROP TABLE #MPIdsForCopy
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetListOfMountPathStatusForCopy')
	delete from GxQscripts where name = 'MMGetListOfMountPathStatusForCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetListOfMountPathStatusForCopy')
	delete from GXDBVersions where aliasname = 'MMGetListOfMountPathStatusForCopy'
GO

insert into GXDBVersions values(2, 'MMGetListOfMountPathStatusForCopy',  '00010003027400100000', 'MMGetListOfMountPathStatusForCopy', '00010003027400100000')
GO

