

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetLibraryStoragePoolType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetLibraryStoragePoolType.sp,v $ $Id: MMGetLibraryStoragePoolType.sp,v 1.1.4.3 2018/03/27 09:08:33 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetLibraryStoragePoolType <<<'

IF EXISTS (select * from sysobjects where name='MMGetLibraryStoragePoolType')
	drop procedure MMGetLibraryStoragePoolType
IF EXISTS (select * from GxQscripts where name='MMGetLibraryStoragePoolType')
	delete from GxQscripts where name = 'MMGetLibraryStoragePoolType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetLibraryStoragePoolType')
	delete from GXDBVersions where aliasname = 'MMGetLibraryStoragePoolType'
GO
print '... Creating Procedure: MMGetLibraryStoragePoolType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetLibraryStoragePoolType
  @i_userId integer = 0,
  @i_LibraryId integer = 0
AS
  DECLARE @o_StoragePoolType integer
SET @o_StoragePoolType = -1
SELECT  DISTINCT @o_StoragePoolType = (CASE
WHEN AG.flags & 33554432 = 33554432  --CVA_SP_SCALEOUT_STORAGE_POOL - Scale out storagepool
							THEN 4 --EVGui::TypeOfStoragePool_SCALE_OUT
WHEN AG.flags & 256 = 256  --CVA_SP_GLOBAL_DEDUP_FLAG - GDSP
							THEN 1 --EVGui::TypeOfStoragePool_DEDUPLICATION
WHEN AG.flags & 16384 = 16384 --CVA_SP_GLOBAL_AUXCOPY_POLICY_FLAG - GACP
							THEN 2 --EVGui::TypeOfStoragePool_SECONDARY_COPY
WHEN AG.flags & 8388608 = 8388608 --8388608  - Global Non dedup
							THEN 3--EVGui::TypeOfStoragePool_NON_DEDUPLICATION
							ELSE -1
							END )
FROM    ArchGroup AG WITH (READUNCOMMITTED)
		INNER JOIN MMDataPath DPath WITH (READUNCOMMITTED) ON AG.defaultCopy = DPath.CopyId
		INNER JOIN MMDrivePool DPool WITH (READUNCOMMITTED) ON DPool.DrivePoolId = DPath.DrivePoolId
		INNER JOIN MMMasterPool MPool WITH (READUNCOMMITTED) ON MPool.MasterPoolId = DPool.MasterPoolId
		INNER JOIN MMLibrary ML WITH (READUNCOMMITTED) ON MPool.LibraryId = ML.LibraryId
WHERE   ML.LibraryId= @i_LibraryId AND
(AG.flags & (33554432 | 256 | 16384 | 8388608 ) > 0)
SELECT @o_StoragePoolType

IF EXISTS (select * from GxQscripts where name = 'MMGetLibraryStoragePoolType')
	delete from GxQscripts where name = 'MMGetLibraryStoragePoolType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetLibraryStoragePoolType')
	delete from GXDBVersions where aliasname = 'MMGetLibraryStoragePoolType'
GO

insert into GXDBVersions values(2, 'MMGetLibraryStoragePoolType',  '00010001000400030000', 'MMGetLibraryStoragePoolType', '00010001000400030000')
GO

