

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetLibSpaceInfoXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetLibSpaceInfoXML.sp,v $ $Id: MMGetLibSpaceInfoXML.sp,v 1.9 2015/07/10 22:05:10 chandru Exp $";
-- =============================================
-- Author:		Chandrashekar Maranna
-- Create date: 09/26/2007
-- Description:	Get the CommNet Server List
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetLibSpaceInfoXML <<<'

IF EXISTS (select * from sysobjects where name='MMGetLibSpaceInfoXML')
	drop procedure MMGetLibSpaceInfoXML
IF EXISTS (select * from GxQscripts where name='MMGetLibSpaceInfoXML')
	delete from GxQscripts where name = 'MMGetLibSpaceInfoXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetLibSpaceInfoXML')
	delete from GXDBVersions where aliasname = 'MMGetLibSpaceInfoXML'
GO
print '... Creating Procedure: MMGetLibSpaceInfoXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetLibSpaceInfoXML
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @libraryId integer,
  @mountPathId integer=0 
AS
SET NOCOUNT ON
BEGIN
	--DECLARE	@libraryID	integer
	--SET		@libraryID = (SELECT TOP 1 LibraryId FROM MMLibrary WHERE	LibraryId > 0)
	DECLARE   @r_libraryAliasName NVARCHAR(255)
	DECLARE   @r_totalValidData bigint
	DECLARE   @r_totalDataWritten bigint
	DECLARE   @r_totalAppSize bigint
	DECLARE   @r_totalDeduplicationDataWritten bigint
	DECLARE   @r_totalDeduplicationAppSize bigint
	DECLARE   @r_totalFreeSpace bigint
	DECLARE   @r_totalReserveSpaceMB bigint
	DECLARE   @r_totalSpace bigint
	DECLARE   @r_avgDataWrittenPerDayMB bigint
	DECLARE   @r_avgCapacityFreedMB bigint
	DECLARE   @r_avgMediaConsumedPerDay integer
	DECLARE   @r_avgMediaFreedPerDay integer
	DECLARE   @r_lastNumDays integer
	DECLARE   @r_estimatedSpaceRunoutDays integer
	DECLARE   @r_lowWatermark integer
	DECLARE   @r_warningWatermark integer
	DECLARE   @r_NumberOfWriters integer
	DECLARE	  @r_Attribute integer
	DECLARE   @r_AssociatedMA XML
	EXEC	MMGetLibSpaceInfo @libraryID,
		@mountPathId,
		@r_libraryAliasName OUTPUT,
		@r_totalValidData OUTPUT,
		@r_totalDataWritten OUTPUT,
		@r_totalAppSize OUTPUT,
		@r_totalDeduplicationDataWritten OUTPUT,
		@r_totalDeduplicationAppSize OUTPUT,
		@r_totalFreeSpace OUTPUT,
		@r_totalReserveSpaceMB OUTPUT,
		@r_totalSpace OUTPUT,
		@r_avgDataWrittenPerDayMB OUTPUT,
		@r_avgCapacityFreedMB OUTPUT,
		@r_avgMediaConsumedPerDay OUTPUT,
		@r_avgMediaFreedPerDay OUTPUT,
		@r_lastNumDays OUTPUT,
		@r_estimatedSpaceRunoutDays OUTPUT,
		@r_lowWatermark OUTPUT,
		@r_warningWatermark OUTPUT,
		@r_NumberOfWriters OUTPUT,
		@r_Attribute OUTPUT,
		@r_AssociatedMA OUTPUT
	-- EVGui_GetLibrarySpaceInfoResp
	SELECT
	-- EVGui_GetLibrarySpaceInfoResp/librarySpaceInfo
		(SELECT
			@libraryID AS '@libraryId',
			@r_libraryAliasName AS '@libraryName',
			@r_totalValidData AS '@totalValidData',
			@r_totalDataWritten AS '@totalDataWritten',
			@r_totalAppSize AS '@totalAppSize',
			@r_totalDeduplicationDataWritten AS '@totalDeduplicationDataWritten',
			@r_totalDeduplicationAppSize AS '@totalDeduplicationAppSize',
			@r_totalFreeSpace AS '@totalFreeSpace',
			@r_totalReserveSpaceMB AS '@totalReserveSpaceMB',
			@r_totalSpace AS '@totalSpace',
			@r_avgDataWrittenPerDayMB AS '@avgDataWrittenPerDayMB',
			@r_avgCapacityFreedMB AS '@avgCapacityFreedMB',
			@r_avgMediaConsumedPerDay AS '@avgMediaConsumedPerDay',
			@r_avgMediaFreedPerDay AS '@avgMediaFreedPerDay',
			@r_lastNumDays AS '@lastNumDays',
			@r_estimatedSpaceRunoutDays AS '@estimatedSpaceRunoutDays',
			@r_lowWatermark AS '@lowWaterMark',
			@r_warningWatermark AS '@warningWaterMark',
			@r_NumberOfWriters  AS '@numberOfWriters',
			@r_Attribute AS '@attribute',
			@r_AssociatedMA
		FOR XML PATH ('librarySpaceInfo'), TYPE)
	FOR	XML PATH ('EVGui_GetLibrarySpaceInfoResp')
END
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetLibSpaceInfoXML')
	delete from GxQscripts where name = 'MMGetLibSpaceInfoXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetLibSpaceInfoXML')
	delete from GXDBVersions where aliasname = 'MMGetLibSpaceInfoXML'
GO

insert into GXDBVersions values(2, 'MMGetLibSpaceInfoXML',  '00010009000000000000', 'MMGetLibSpaceInfoXML', '00010009000000000000')
GO

