

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetLibSpaceInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetLibSpaceInfo.sp,v $ $Id: MMGetLibSpaceInfo.sp,v 1.17.2.8 2020/08/24 14:12:15 pnara Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetLibSpaceInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMGetLibSpaceInfo <<<'
	drop procedure MMGetLibSpaceInfo
END
IF EXISTS (select * from GxQscripts where name='MMGetLibSpaceInfo')
	delete from GxQscripts where name = 'MMGetLibSpaceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetLibSpaceInfo')
	delete from GXDBVersions where aliasname = 'MMGetLibSpaceInfo'
GO
print '... Creating Procedure: MMGetLibSpaceInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetLibSpaceInfo
  @i_libraryId integer,
  @i_mountPathId integer,
  @r_libraryAliasName NVARCHAR(255) OUT,
  @r_totalValidData bigint OUT,
  @r_totalDataWritten bigint OUT,
  @r_totalAppSize bigint OUT,
  @r_totalDeduplicationDataWritten bigint OUT,
  @r_totalDeduplicationAppSize bigint OUT,
  @r_totalFreeSpace bigint OUT,
  @r_totalReserveSpaceMB bigint OUT,
  @r_totalSpace bigint OUT,
  @r_avgDataWrittenPerDayMB bigint OUT,
  @r_avgCapacityFreedMB bigint OUT,
  @r_avgMediaConsumedPerDay integer OUT,
  @r_avgMediaFreedPerDay integer OUT,
  @r_lastNumDays integer OUT,
  @r_estimatedSpaceRunoutDays integer OUT,
  @r_lowWatermark integer OUT,
  @r_warningWatermark integer OUT,
  @r_NumberOfWriters integer OUT,
  @r_Attribute integer OUT,
  @r_AssociatedMA XML     OUT
AS
  DECLARE @o_libraryAliasName NVARCHAR(255)
  DECLARE @o_totalValidData bigint
  DECLARE @o_totalDataWritten bigint
  DECLARE @o_totalAppSize bigint
  DECLARE @o_totalFreeSpace bigint
  DECLARE @o_totalSpace bigint
  DECLARE @o_avgDataWrittenPerDayMB bigint
  DECLARE @o_avgCapacityFreedMB bigint
  DECLARE @o_avgMediaConsumedPerDay integer
  DECLARE @o_avgMediaFreedPerDay integer
  DECLARE @o_lastNumDays integer
  DECLARE @o_estimatedSpaceRunoutDays integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--	DECLARE		@i_libraryId integer
--	SET			@i_libraryId = (SELECT TOP 1 LibraryID FROM MMLibrary)
	declare @TotalChunkSize bigint
	declare @TotalDataWrittenMB bigint
	declare @TotalApplicationSizeMB bigint
	declare @TotalNoneDedupeDataWrittenMB bigint
	declare @TotalNoneDedupeApplicationSizeMB bigint
	declare @TotalFreeSpaceMB bigint
	declare @TotalSpaceMB bigint
	-- Folowing variables are declared for avg calculation
	DECLARE	@totalDataWrittenMBForAvg	BIGINT
	DECLARE	@capacityFreedMBForAvg		BIGINT
	DECLARE	@totalMediaConsumedForAvg	BIGINT
	DECLARE	@totalMediaFreedForAvg		BIGINT
	DECLARE	@earliestDate				DATETIME
	DECLARE	@avgDataWrittenPerDayMB		bigint
	DECLARE	@avgCapacityFreedMB			bigint
	DECLARE	@avgMediaConsumedPerDay	INTEGER
	DECLARE	@avgMediaFreedPerDay		INTEGER
	DECLARE	@lastNumDays				INTEGER
	DECLARE	@estimatedSpaceRunoutDays	INTEGER
	DECLARE	@retVal						INTEGER = 0
	DECLARE	@oneConstReal REAL = 1.0
    DECLARE @maxEstimatedSpaceRunoutDays INTEGER = 5476 -- 15 years
	IF object_id('tempdb.dbo.#tempChunk') is not null DROP TABLE #tempChunk
	IF object_id('tempdb.dbo.#tempVolume') is not null DROP TABLE #tempVolume
	IF object_id('tempdb.dbo.#tempAFCopy') is not null DROP TABLE #tempAFCopy
	IF object_id('tempdb.dbo.#VOLUME_TEMP') is not null DROP TABLE #VOLUME_TEMP
	IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
	CREATE TABLE #tmpJobSizeInfo (
	JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
 	PRIMARY KEY (JobId, CommCellId))
	CREATE TABLE #tempVolume (VolumeId			int)
IF (@i_mountPathId=0)
BEGIN
INSERT INTO #tempVolume
	SELECT mv.VolumeId
	FROM   MMVolume mv  WITH(NOLOCK), MMMedia as mm  WITH(NOLOCK)
	WHERE  mv.MediaId = mm.MediaId and mm.LibraryId = @i_libraryId
END
ELSE
BEGIN
INSERT INTO #tempVolume
	SELECT mv.VolumeId
	FROM   MMVolume mv  WITH(NOLOCK),
	MMMountPath MP, MMMediaSide as MS, MMMedia as M
     WHERE M.LibraryId = @i_libraryId AND
     MS.MediaId = M.MediaId AND
     MP.MediaSideId = MS.MediaSideId AND
	 MP.MountPathId = @i_mountPathId
	AND  mv.MediaId = m.MediaId
END
	SELECT id, commCellId, volumeId
	INTO   #tempChunk
	FROM   archChunk  WITH(NOLOCK)
	WHERE  volumeId IN (SELECT VolumeId FROM #tempVolume)
	SELECT A.archFileId, A.commCellId, A.archCopyId, A.physicalsize, B.volumeId, A.unCompSize, A.JobId, 0 AS 'IsDedupeData'
	INTO   #tempAFCopy
	FROM   archChunkMapping A  WITH(NOLOCK), #tempChunk B
	WHERE  A.archChunkId = B.id AND A.chunkCommCellId = B.commCellId
	DELETE #tempAFCopy
	FROM   #tempAFCopy A, archFileCopy B  WITH(NOLOCK)
	WHERE  A.archFileId = B.archFileId AND A.commCellId = B.commCellId
	AND A.archCopyId = B.archCopyId AND isValid <> 1
	DELETE #tempAFCopy
	FROM   #tempAFCopy A, archFile B  WITH(NOLOCK)
	WHERE  A.archFileId = B.id AND A.commCellId = B.commCellId
			AND isValid <> 1
	UPDATE	#tempAFCopy
	SET		IsDedupeData = 1
	FROM	#tempAFCopy A, archFileCopyDedup B WITH(NOLOCK)
	WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId
			AND A.archCopyId = B.archCopyId
			AND (B.secondaryObjects > 0)
	INSERT INTO #tmpJobSizeInfo
	SELECT	DISTINCT JobId, CommCellId, 0, 0, 0
	FROM	#tempAFCopy
	WHERE   unCompSize = -1
	EXEC  @retVal = archGetJobSizeInfo 0
	UPDATE	#tempAFCopy
	SET		unCompSize = (CASE WHEN totalBackupSize > physicalSize THEN CAST(((@oneConstReal * (totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END)
	FROM	#tmpJobSizeInfo J
	WHERE	#tempAFCopy.JobId = J.JobId
			AND #tempAFCopy.CommCellId = J.CommCellId
			AND #tempAFCopy.unCompSize = -1
			AND physicalSize > 0
	set    @TotalChunkSize = (SELECT ISNULL(SUM(physicalsize), 0) FROM #tempAFCopy as tc, #tempVolume as tv
		WHERE tc.volumeId = tv.VolumeId)
	DECLARE @tempVolume TABLE (t_volId int, t_physicalBytesMB bigint, t_ApplicationSizeMB bigint, t_noneDedupeApplicationSizeMB bigint, t_noneDedupeMediaSizeMB bigint)
IF (@i_mountPathId=0)
BEGIN
	INSERT INTO @tempVolume
	SELECT mv.VolumeId, mv.PhysicalBytesMB, 0, 0, CASE mv.SIDBStoreId WHEN 0 THEN mv.PhysicalBytesMB ELSE 0 END
	FROM   MMVolume mv WITH (NOLOCK), MMMountPath as mmp WITH (NOLOCK), MMLibrary ML WITH (NOLOCK)
	WHERE  mv.MediaSideId = mmp.MediaSideId and ML.libraryid = MMP.libraryid and mmp.MountPathId <> 0
	AND (ML.libraryid = @i_libraryId) -- OR @libOpt =0)
	AND mv.SiloStatus <> 3
	AND ML.LibraryTypeId = 3
END
ELSE
BEGIN
	INSERT INTO @tempVolume
	SELECT mv.VolumeId, mv.PhysicalBytesMB, 0, 0, CASE mv.SIDBStoreId WHEN 0 THEN mv.PhysicalBytesMB ELSE 0 END
	FROM   MMVolume mv WITH (NOLOCK), MMMountPath as mmp WITH (NOLOCK), MMLibrary ML WITH (NOLOCK)
	WHERE  mv.MediaSideId = mmp.MediaSideId and ML.libraryid = MMP.libraryid and mmp.MountPathId =@i_mountPathId
	AND (ML.libraryid = @i_libraryId) -- OR @libOpt =0)
	AND mv.SiloStatus <> 3
	AND ML.LibraryTypeId = 3
END
	INSERT INTO @tempVolume
	SELECT mv.VolumeId, mv.PhysicalBytesMB, 0, 0, CASE mv.SIDBStoreId WHEN 0 THEN mv.PhysicalBytesMB ELSE 0 END
	FROM   MMVolume MV WITH (NOLOCK), MMMedia as M WITH (NOLOCK), MMLibrary ML WITH (NOLOCK)
	WHERE  MV.MediaId = M.MediaID and ML.libraryid = M.libraryid
	AND (ML.libraryid = @i_libraryId) -- OR @libOpt =0)
	AND mv.SiloStatus <> 3
	AND ML.LibraryTypeId <> 3
	SELECT	VolumeId, SUM(unCompSize) AS ApplicationSize,
			SUM(CASE WHEN (IsDedupeData = 0) THEN unCompSize ELSE 0 END) NoneDedupeApplicationSize,
			SUM(CASE WHEN (IsDedupeData = 0) THEN physicalsize ELSE 0 END) NoneDedupeMediaSize
	INTO	#VOLUME_TEMP
	FROM	#tempAFCopy AFC
	GROUP BY volumeId
	/*
	SELECT volumeId, SUM(CASE WHEN totalBackupSize > 0 THEN ((PhysicalSize * 1.0) /totalBackupSize) * totalUncompBytes ELSE (PhysicalSize * 1.0) END) AS ApplicationSize
	INTO	#VOLUME_TEMP
	FROM
		(SELECT	T.*, B.totalUncompBytes AS totalUncompBytes, B.totalBackupSize
		FROM	JMBkpStats B WITH (NOLOCK),
				(SELECT	AFC.volumeId, AFC.commCellId, AFC.archCopyId, AF.jobId, SUM(AFC.physicalSize) AS PhysicalSize
				FROM	#tempAFCopy AFC, ArchFile AF WITH (NOLOCK)
				WHERE   AFC.archFileId = AF.id
						AND AFC.commCellId = AF.commCellId
				GROUP BY AFC.volumeId, AFC.commCellId, AFC.archCopyId, AF.jobId) AS T
		WHERE	B.jobId = T.jobId AND B.commCellId = T.commCellId
		UNION
		SELECT	T2.*, (CASE WHEN (JA.uncompBytes > 0) THEN JA.uncompBytes ELSE JA.totalBackupSize END) AS totalUncompBytes, JA.totalBackupSize
		FROM	JMAdminJobStatsTable JA WITH (NOLOCK),
				(SELECT	AFC.volumeId, AFC.commCellId, AFC.archCopyId, AF.jobId, SUM(AFC.physicalSize) AS PhysicalSize
				FROM	#tempAFCopy AFC, ArchFile AF WITH (NOLOCK)
				WHERE   AFC.archFileId = AF.id
						AND AFC.commCellId = AF.commCellId
				GROUP BY AFC.volumeId, AFC.commCellId, AFC.archCopyId, AF.jobId) AS T2
		WHERE	JA.jobId = T2.jobId AND JA.commCellId = T2.commCellId
		) AS SizeT
	GROUP BY volumeId
	*/
	--SELECT volumeId, SUM(((PhysicalSize * 1.0) /totalBackupSize) * totalUncompBytes) AS ApplicationSize
	--INTO	#VOLUME_TEMP
	--FROM
	--	(SELECT	T.*, B.totalUncompBytes AS totalUncompBytes, B.totalBackupSize
	--	FROM	JMBkpStats B WITH (NOLOCK),
	--			(SELECT	AC.volumeId, AC.commCellId, ACM.archCopyId, AF.jobId, SUM(AC.physicalSize) AS PhysicalSize
	--			FROM	archChunk AC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), ArchFile AF WITH (NOLOCK), @tempVolume MV
	--			WHERE   AC.id = ACM.archChunkId
	--					AND AC.commCellId = ACM.chunkCommCellId
	--					AND ACM.archFileId = AF.id
	--					AND ACM.commCellId = AF.commCellId
	--					AND MV.t_volId = AC.volumeId
	--			GROUP BY AC.volumeId, AC.commCellId, ACM.archCopyId, AF.jobId) AS T
	--	WHERE	B.jobId = T.jobId AND B.commCellId = T.commCellId
	--	UNION
	--	SELECT	T2.*, (CASE WHEN (JA.uncompBytes > 0) THEN JA.uncompBytes ELSE JA.totalBackupSize END) AS totalUncompBytes, JA.totalBackupSize
	--	FROM	JMAdminJobStatsTable JA WITH (NOLOCK),
	--			(SELECT	AC.volumeId, AC.commCellId, ACM.archCopyId, AF.jobId, SUM(AC.physicalSize) AS PhysicalSize
	--			FROM	archChunk AC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), ArchFile AF WITH (NOLOCK), @tempVolume MV
	--			WHERE   AC.id = ACM.archChunkId
	--					AND AC.commCellId = ACM.chunkCommCellId
	--					AND ACM.archFileId = AF.id
	--					AND ACM.commCellId = AF.commCellId
	--					AND MV.t_volId = AC.volumeId
	--			GROUP BY AC.volumeId, AC.commCellId, ACM.archCopyId, AF.jobId) AS T2
	--	WHERE	JA.jobId = T2.jobId AND JA.commCellId = T2.commCellId
	--	) AS SizeT
	--GROUP BY volumeId
	UPDATE	@tempVolume
	SET		t_ApplicationSizeMB = #VOLUME_TEMP.ApplicationSize  / (1024.0 * 1024.0),
			t_noneDedupeApplicationSizeMB = #VOLUME_TEMP.NoneDedupeApplicationSize  / (1024.0 * 1024.0)
	FROM	#VOLUME_TEMP
	WHERE	#VOLUME_TEMP.VolumeId = t_volId
	UPDATE	@tempVolume
	SET		t_noneDedupeMediaSizeMB = #VOLUME_TEMP.NoneDedupeMediaSize  / (1024.0 * 1024.0)
	FROM	#VOLUME_TEMP
	WHERE	#VOLUME_TEMP.VolumeId = t_volId
			AND t_noneDedupeMediaSizeMB = 0
	SELECT @TotalDataWrittenMB = SUM(MMS.UsedSpaceInBytes)/(1024 * 1024)
	FROM MMMountPath as MMP WITH (READUNCOMMITTED)
	INNER JOIN  MMMetallicStorage MMS WITH (READUNCOMMITTED) ON MMS.MountPathId = MMP.MountPathId
	WHERE (@i_mountPathId = 0 AND MMP.libraryid = @i_libraryId) OR (@i_mountPathId > 0 AND MMP.MountPathId = @i_mountPathId)
	SELECT	@TotalDataWrittenMB = IIF(@TotalDataWrittenMB > 0, @TotalDataWrittenMB, ISNULL(SUM(t_physicalBytesMB), 0)), @TotalApplicationSizeMB = ISNULL(SUM(t_ApplicationSizeMB), 0),
			@TotalNoneDedupeDataWrittenMB = ISNULL(SUM(t_noneDedupeMediaSizeMB), 0), @TotalNoneDedupeApplicationSizeMB = ISNULL(SUM(t_noneDedupeApplicationSizeMB), 0)
	FROM	@tempVolume
	IF @TotalDataWrittenMB = 0
	BEGIN
		SELECT 	@TotalApplicationSizeMB = 0
				, @TotalNoneDedupeDataWrittenMB = 0
				, @TotalNoneDedupeApplicationSizeMB = 0
	END
IF (@i_mountPathId=0)
BEGIN
SELECT	@TotalSpaceMB = SUM(CASE WHEN (MP.MountPathTypeId = 7 AND MS.TotalSpaceMB = 1048576) THEN -1 ELSE CAST(MS.TotalSpaceMB AS BIGINT)  END),
@TotalFreeSpaceMB = SUM(CASE WHEN (MP.MountPathTypeId = 7 AND MS.FreeBytesMB = 1048576) THEN -1 ELSE CAST(MS.FreeBytesMB AS BIGINT) END)
	FROM	MMMedia M WITH (NOLOCK), MMMediaSide MS WITH (NOLOCK),MMMountPath MP WITH (NOLOCK)
	WHERE	M.LibraryId = @i_libraryId
		AND M.MediaId = MS.MediaId
		AND MP.MediaSideId = MS.MediaSideId
END
ELSE
BEGIN
SELECT	@TotalSpaceMB =  SUM(CASE WHEN (MP.MountPathTypeId = 7 AND MS.TotalSpaceMB = 1048576) THEN -1 ELSE CAST(MS.TotalSpaceMB AS BIGINT)  END),
@TotalFreeSpaceMB =  SUM(CASE WHEN (MP.MountPathTypeId = 7 AND MS.FreeBytesMB = 1048576) THEN -1 ELSE CAST(MS.FreeBytesMB AS BIGINT) END)
	FROM	MMMedia M WITH (NOLOCK), MMMediaSide MS WITH (NOLOCK),MMMountPath MP WITH (NOLOCK)
	WHERE	M.LibraryId = @i_libraryId
			AND M.MediaId = MS.MediaId
			AND MP.MediaSideId = MS.MediaSideId AND
			MP.MountPathId = @i_mountPathId
END
	 DECLARE @TotalReserveSpaceMB BIGINT=-1
IF (@i_mountPathId=0)
BEGIN
	SELECT  @TotalReserveSpaceMB =SUM(CAST(mmp.MagneticSpaceRsrvInMB AS BIGINT))
							FROM	MMMountPath as mmp WITH (NOLOCK), MMLibrary ML WITH (NOLOCK)
							WHERE	ML.libraryid = MMP.libraryid and mmp.MountPathId <> 0
							AND (ML.libraryid = @i_libraryId)
							AND ML.LibraryTypeId = 3
END
ELSE
BEGIN
	SELECT  @TotalReserveSpaceMB =SUM(CAST(mmp.MagneticSpaceRsrvInMB AS BIGINT))
							FROM	MMMountPath as mmp WITH (NOLOCK), MMLibrary ML WITH (NOLOCK)
							WHERE	ML.libraryid = MMP.libraryid and mmp.MountPathId = @i_mountPathId
							AND (ML.libraryid = @i_libraryId)
							AND ML.LibraryTypeId = 3
END
	IF((@TotalReserveSpaceMB	IS NULL) OR (@TotalReserveSpaceMB<1))
		SET @TotalReserveSpaceMB	=0
	DECLARE	@currentTime DATETIME
	SET		@currentTime = GETUTCDATE()
	SELECT	@totalDataWrittenMBForAvg = ISNULL(SUM(DataWritten), 0), @capacityFreedMBForAvg = ISNULL(SUM(CapacityFreedMB), 0),
			@totalMediaConsumedForAvg = ISNULL(SUM(NumberOfMediaUsed), 0), @totalMediaFreedForAvg = ISNULL(SUM(NumberOfMediaFreed), 0),
			@earliestDate = ISNULL(MIN(TimeStart), @currentTime)
	FROM	MMLibraryHistory WITH (NOLOCK)
	WHERE	LibraryId = @i_LibraryId
			AND TimeStart > (DATEADD(d, -30, @currentTime))
	SET		@lastNumDays = DATEDIFF(d, @earliestDate, @currentTime) + 1
	if (DATEDIFF(s, @earliestDate, GetUTCDate()) > 0)
	BEGIN
		SET		@avgDataWrittenPerDayMB = @totalDataWrittenMBForAvg / @lastNumDays
		SET		@avgCapacityFreedMB = @capacityFreedMBForAvg / @lastNumDays
		SET		@avgMediaConsumedPerDay = @totalMediaConsumedForAvg / @lastNumDays
		SET		@avgMediaFreedPerDay = @totalMediaFreedForAvg / @lastNumDays
	END
	ELSE
	BEGIN
		SET		@avgDataWrittenPerDayMB = 0
		SET		@avgCapacityFreedMB = 0
		SET		@avgMediaConsumedPerDay = 0
		SET		@avgMediaFreedPerDay = 0
	END
	IF (@avgCapacityFreedMB >= @avgDataWrittenPerDayMB)
		SET	@estimatedSpaceRunoutDays = -1;
	ELSE IF(@TotalFreeSpaceMB<@TotalReserveSpaceMB)
		SET	@estimatedSpaceRunoutDays = -1;
	ELSE IF	(((@TotalFreeSpaceMB-@TotalReserveSpaceMB) / (@avgDataWrittenPerDayMB - @avgCapacityFreedMB)) > @maxEstimatedSpaceRunoutDays )
        SET	@estimatedSpaceRunoutDays = -1;
    ELSE
		SET	@estimatedSpaceRunoutDays = (@TotalFreeSpaceMB-@TotalReserveSpaceMB) / (@avgDataWrittenPerDayMB - @avgCapacityFreedMB);
IF (@i_mountPathId=0)
BEGIN
	SELECT  @r_libraryAliasName = ml.AliasName,
			@r_totalValidData = @TotalChunkSize,
			@r_totalDataWritten = @TotalDataWrittenMB,
			@r_totalAppSize = @TotalApplicationSizeMB,
			@r_totalDeduplicationDataWritten = @TotalDataWrittenMB - @TotalNoneDedupeDataWrittenMB,
			@r_totalDeduplicationAppSize = @TotalApplicationSizeMB - @TotalNoneDedupeApplicationSizeMB,
			@r_totalFreeSpace = @TotalFreeSpaceMB,
			@r_totalReserveSpaceMB = @TotalReserveSpaceMB,
			@r_totalSpace = @TotalSpaceMB,
			@r_avgDataWrittenPerDayMB = @avgDataWrittenPerDayMB,
			@r_avgCapacityFreedMB = @avgCapacityFreedMB,
			@r_avgMediaConsumedPerDay = @avgMediaConsumedPerDay,
			@r_avgMediaFreedPerDay = @avgMediaFreedPerDay,
			@r_lastNumDays = @lastNumDays,
			@r_estimatedSpaceRunoutDays = @estimatedSpaceRunoutDays,
			@r_lowWatermark = LowWaterMarkMB,
			@r_warningWatermark = WarningWaterMark
	from MMLibrary as ml  WITH(NOLOCK)
	WHERE	LibraryId = @i_libraryId
END
ELSE
BEGIN
	DECLARE @AssociatedMA XML
 IF EXISTS (SELECT MountPathTypeId FROM MMMountPath WHERE MountPathId = @i_mountPathId
				AND MountPathTypeId IN (0,1)
			)
BEGIN
	SET @AssociatedMA = (
		Select  C.displayName as [@val]
         FROM        MMMountPath MP WITH (NOLOCK)
		INNER JOIN MMLibraryController LC WITH (NOLOCK)
			ON MP.LibraryId = LC.LibraryId
		AND MP.MountPathTypeId IN (0 , 1)    --MOUNT_PATH_CENTERA
		AND MP.MountPathId = @i_mountPathId
		INNER JOIN
		APP_Client AS c WITH(NOLOCK)
		ON
		c.id=LC.ClientId
		AND  C.status & 0x2<>2
	FOR XML PATH ('associatedMA'))
END
ELSE
BEGIN
	SET @AssociatedMA = (Select c.displayName as [@val]  From MMDeviceController AS mdc WITH(NOLOCK)
		INNER JOIN MMMountPathToStorageDevice AS mps WITH(NOLOCK)
	ON
	mps.DeviceId = mdc.DeviceId
	AND mps.MountPathId = @i_mountPathId
	INNER JOIN
	APP_Client AS c WITH(NOLOCK)
	ON
	c.id=mdc.ClientId
	AND  C.status & 0x2<>2
	FOR XML PATH ('associatedMA'))
END
	SELECT  @r_libraryAliasName = mp.MountPathName,
			@r_totalValidData = @TotalChunkSize,
			@r_totalDataWritten = @TotalDataWrittenMB,
			@r_totalAppSize = @TotalApplicationSizeMB,
			@r_totalDeduplicationDataWritten = @TotalDataWrittenMB - @TotalNoneDedupeDataWrittenMB,
			@r_totalDeduplicationAppSize = @TotalApplicationSizeMB - @TotalNoneDedupeApplicationSizeMB,
			@r_totalFreeSpace = @TotalFreeSpaceMB,
			@r_totalReserveSpaceMB = @TotalReserveSpaceMB,
			@r_totalSpace = @TotalSpaceMB,
			@r_avgDataWrittenPerDayMB = @avgDataWrittenPerDayMB,
			@r_avgCapacityFreedMB = @avgCapacityFreedMB,
			@r_avgMediaConsumedPerDay = @avgMediaConsumedPerDay,
			@r_avgMediaFreedPerDay = @avgMediaFreedPerDay,
			@r_lastNumDays = @lastNumDays,
			@r_estimatedSpaceRunoutDays = @estimatedSpaceRunoutDays,
			@r_lowWatermark = ml.LowWaterMarkMB,
			@r_warningWatermark = ml.WarningWaterMark,
			@r_NumberOfWriters = mp.maxconcurrentwriters,
			@r_Attribute = mmp.Attribute,
			@r_AssociatedMA = @AssociatedMA
	from MMLibrary as ml  WITH(NOLOCK)
	INNER JOIN MMS2getMountPathNameGUIView  as mp  WITH(NOLOCK)
	ON
	mp.LibraryId = ml.LibraryId
	AND	ml.LibraryId = @i_libraryId
	AND mp.MountPathId = @i_mountPathId
	    inner join MMMountPath as mmp WITH(NOLOCK)
		 ON
    mmp.LibraryId = ml.LibraryId
    AND mmp.MountPathId = @i_mountPathId
END
	IF object_id('tempdb.dbo.#tempChunk') is not null DROP TABLE #tempChunk
	IF object_id('tempdb.dbo.#tempVolume') is not null DROP TABLE #tempVolume
	IF object_id('tempdb.dbo.#tempAFCopy') is not null DROP TABLE #tempAFCopy
	IF object_id('tempdb.dbo.#VOLUME_TEMP') is not null DROP TABLE #VOLUME_TEMP
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetLibSpaceInfo')
	delete from GxQscripts where name = 'MMGetLibSpaceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetLibSpaceInfo')
	delete from GXDBVersions where aliasname = 'MMGetLibSpaceInfo'
GO

insert into GXDBVersions values(2, 'MMGetLibSpaceInfo',  '00010017000200080000', 'MMGetLibSpaceInfo', '00010017000200080000')
GO

