

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetLibListForStoragePool.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetLibListForStoragePool.sp,v $ $Id: MMGetLibListForStoragePool.sp,v 1.1.2.12 2019/08/29 22:46:35 vikramsingh Exp $";
--
-- #define EXCLUDE_SILO_DATAPATH_FLAG 1 for i_Flags
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetLibListForStoragePool')
BEGIN
	print '>>> Drop Stored Procedure: MMGetLibListForStoragePool <<<'
	drop procedure MMGetLibListForStoragePool
END
IF EXISTS (select * from GxQscripts where name='MMGetLibListForStoragePool')
	delete from GxQscripts where name = 'MMGetLibListForStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetLibListForStoragePool')
	delete from GXDBVersions where aliasname = 'MMGetLibListForStoragePool'
GO
print '... Creating Procedure: MMGetLibListForStoragePool'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetLibListForStoragePool
  @i_UserId integer,
  @i_StoragePoolId integer,
  @i_Reserve integer
AS
  DECLARE @LibraryId integer
  DECLARE @AliasName NVARCHAR(255)
  DECLARE @LibraryTypeId integer
  DECLARE @libraryVTLType integer
  DECLARE @librarySoftState integer
  DECLARE @libraryEnabled integer
  DECLARE @libraryBroken integer
  DECLARE @barcodeReaderPresent integer
  DECLARE @libraryVendor char(255)
  DECLARE @libraryModel char(255)
  DECLARE @libraryAttribute integer
  DECLARE @libraryExtendedAttributes integer
  DECLARE @isConvertedToSited integer
  DECLARE @driveCount integer
  DECLARE @emptySlotCount integer
  DECLARE @libraryMediaTypeId integer
  DECLARE @description NVARCHAR(max)
  DECLARE @libHasSiloData integer
  DECLARE @Capabilities bigint
  DECLARE @isOnline integer
  DECLARE @associatedMediaAgents NVARCHAR(max)
  DECLARE @freeSpaceOnLib bigint
  DECLARE @capacity bigint
  DECLARE @SIDBStoreId integer
  DECLARE @privateData CHAR(256)
  DECLARE @libraryVendorId integer
  DECLARE @associatedMediaAgentsDisplayName NVARCHAR(max)
  DECLARE @isLibraryUsedForLogCaching integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	--
	-- Temporary table variables
	--
	declare @CopyId					integer
	declare @l_sidbStoreId			integer = 0
	IF OBJECT_ID('tempdb.dbo.#LibsforCopy') IS NOT NULL DROP TABLE #LibsforCopy
	IF OBJECT_ID('tempdb.dbo.#tmpLibraryList') IS NOT NULL DROP TABLE #tmpLibraryList
	CREATE TABLE #LibsforCopy
    (LibraryId int,PRIMARY KEY (LibraryId))
	CREATE TABLE  #tmpLibraryList
	(
		LibraryId					integer,
		AliasName  					NVARCHAR(255),
		LibraryTypeId				integer,
		libraryVTLType				integer,
		librarySoftState			integer,
		libraryEnabled				integer,
		libraryBroken				integer,
		barcodeReaderPresent		integer,
		libraryVendor				VARCHAR(255),
		libraryModel				VARCHAR(255),
		libraryAttribute			integer,
		libraryExtendedAttributes	integer,
		isConvertedToSited			integer,
		driveCount					integer,
		emptySlotCount				integer,
		libraryMediaTypeId			integer,
		description					NVARCHAR(max),
		libHasSiloData				integer,
		Capabilities				bigint,
		isOnline					integer,
		associatedMediaAgents   	NVARCHAR(max),
		freeSpaceOnLib          	bigint,
		capacity                	bigint,
privateData					CHAR(256),
		libraryVendorId				integer,
		poolType 					integer,
		associatedMediaAgentsDisplayName   	NVARCHAR(max),
		isLibraryUsedForLogCaching integer,
		PRIMARY KEY (LibraryId)
	)
	SELECT @CopyId = defaultCopy from archGroup WITH (READUNCOMMITTED) WHERE id = @i_StoragePoolId
SELECT @l_sidbStoreId = SIDBStoreId from archCopySIDBStore WITH (READUNCOMMITTED) WHERE copyId = @CopyId AND (Flags & (2|4) = (2|4))
	INSERT INTO #LibsforCopy
	SELECT DISTINCT MP.LibraryId
	FROM MMDrivePool DRP WITH (READUNCOMMITTED), MMDataPath DAP WITH (READUNCOMMITTED),
		 MMMasterPool MP WITH (READUNCOMMITTED)
	WHERE DAP.CopyId = @CopyId AND DAP.DrivePoolId = DRP.DrivePoolId
	AND DRP.MasterPoolId = MP.MasterPoolId
	--This proc will insert into temp table #tmpLibraryList
	exec MMS2getLibList @i_UserId
	DELETE L FROM #tmpLibraryList L
	LEFT JOIN #LibsforCopy LC ON L.LibraryId = LC.LibraryId
	WHERE LC.LibraryId IS NULL
	IF OBJECT_ID('tempdb.dbo.#tmpLibraryListForStoragePool') IS NOT NULL
	BEGIN
		INSERT INTO #tmpLibraryListForStoragePool
			SELECT LibraryId, AliasName, LibraryTypeId, libraryVTLType, librarySoftState, libraryEnabled,
				   libraryBroken, barcodeReaderPresent, libraryVendor, libraryModel, libraryAttribute,
				   libraryExtendedAttributes, isConvertedToSited, driveCount, emptySlotCount, libraryMediaTypeId,
				   description, libHasSiloData, Capabilities, isOnline,  SUBSTRING(associatedMediaAgents, 0, 4096), freeSpaceOnLib, capacity,
				   @l_sidbStoreId,privateData, libraryVendorId, SUBSTRING(associatedMediaAgentsDisplayName, 0, 4096), isLibraryUsedForLogCaching
			FROM #tmpLibraryList
	END
	ELSE
	BEGIN
		SELECT LibraryId, AliasName, LibraryTypeId, libraryVTLType, librarySoftState, libraryEnabled,
			   libraryBroken, barcodeReaderPresent, libraryVendor, libraryModel, libraryAttribute,
			   libraryExtendedAttributes, isConvertedToSited, driveCount, emptySlotCount, libraryMediaTypeId,
			   description, libHasSiloData, Capabilities, isOnline,  SUBSTRING(associatedMediaAgents, 0, 4096), freeSpaceOnLib, capacity,
			   @l_sidbStoreId, privateData, libraryVendorId, SUBSTRING(associatedMediaAgentsDisplayName, 0, 4096), isLibraryUsedForLogCaching
		FROM #tmpLibraryList
	END
	IF OBJECT_ID('tempdb.dbo.#LibsforCopy') IS NOT NULL DROP TABLE #LibsforCopy
	IF OBJECT_ID('tempdb.dbo.#tmpLibraryList') IS NOT NULL DROP TABLE #tmpLibraryList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetLibListForStoragePool')
	delete from GxQscripts where name = 'MMGetLibListForStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetLibListForStoragePool')
	delete from GXDBVersions where aliasname = 'MMGetLibListForStoragePool'
GO

insert into GXDBVersions values(2, 'MMGetLibListForStoragePool',  '00010001000200120000', 'MMGetLibListForStoragePool', '00010001000200120000')
GO

