

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetLastChunkOnMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetLastChunkOnMedia.sp,v $ $Id: MMGetLastChunkOnMedia.sp,v 1.1.2.5 2019/05/10 16:31:06 dmitriy Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Cursor: "MMGetNextMarkerForIBMiVTLVolume"				|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetLastChunkOnMedia')
BEGIN
	print '>>> Drop Stored Procedure: MMGetLastChunkOnMedia <<<'
	drop procedure MMGetLastChunkOnMedia
END
IF EXISTS (select * from GxQscripts where name='MMGetLastChunkOnMedia')
	delete from GxQscripts where name = 'MMGetLastChunkOnMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetLastChunkOnMedia')
	delete from GXDBVersions where aliasname = 'MMGetLastChunkOnMedia'
GO
print '... Creating Procedure: MMGetLastChunkOnMedia'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetLastChunkOnMedia
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @xmlTextInput XML
AS
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE	@i_commcellId		integer
	DECLARE	@i_MediaID			integer
	DECLARE	@chunkId			bigint
	DECLARE @physicalSize		bigint
	DECLARE @logicalSize		bigint
	DECLARE	@fileMarkerNo		integer
	DECLARE @volumeId			integer
	DECLARE @createTime			integer
	DECLARE @version			integer
	DECLARE @cclip				varchar(255)
	DECLARE @writeTime			integer
	DECLARE @flags				integer
	DECLARE @modifiedTime		integer
	DECLARE @agedBy				bigint
	DECLARE @origCCId			integer
	DECLARE @oXML           XML
	-- Convert input XML to arguments
	SELECT  @i_commcellId = ISNULL( ref.value('@commCellId', 'int'), 2),
			@i_MediaID = ISNULL(ref.value('@mediaId', 'int'), 0)
		FROM @xmlTextInput.nodes('MediaManager_GetLastChunkOnMediaReq') R ( ref )
	-- Initialize value for not-found
	SET @fileMarkerNo = 1
	SET @chunkId = -1
	SET @physicalSize = -1
	SET @logicalSize = -1
	SET @volumeId = -1
	SET @createTime = 0
	SET @version = 0
	SET @cclip = ''
	SET @writeTime = 0
	SET @flags = 0
	SET @modifiedTime = 0
	SET @agedBy = 0
	SET @origCCId = 0
	-- select last chunk on media
	SELECT TOP 1
			@chunkId = C.id,
			@fileMarkerNo = C.fileMarkerNo,
			@physicalSize = C.physicalSize,
			@logicalSize = C.logicalSize,
			@volumeId = C.volumeId,
			@createTime = C.createTime,
			@version = C.version,
			@cclip = C.cclip,
			@writeTime = C.writeTime,
			@flags = C.flags,
			@modifiedTime = C.modifiedTime,
			@agedBy = C.agedBy,
			@origCCId = C.origCCId
		FROM archchunk  C (NOLOCK)
			-- only use active chunks
			INNER JOIN MMVolume V (NOLOCK) ON C.volumeId = V.VolumeId
		WHERE V.MediaId = @i_MediaID AND C.commCellId = @i_commcellId
			AND C.physicalSize > 0 AND C.flags & 256 = 0
		ORDER BY C.fileMarkerNo DESC
	SET @oXML = (SELECT
			@chunkId '@chunkId',
			@fileMarkerNo '@fileMarkerNo',
			@physicalSize '@physicalSize',
			@logicalSize '@logicalSize',
			@volumeId 'volumeId',
			@createTime 'createTime',
			@version 'version',
			@cclip 'cclip',
			@writeTime 'writeTime',
			@flags 'flags',
			@modifiedTime 'modifiedTime',
			@agedBy 'agedBy',
			@origCCId 'origCCId'
		FOR XML PATH('MediaManager_GetLastChunkOnMediaResp'))
	SELECT @oXML
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetLastChunkOnMedia')
	delete from GxQscripts where name = 'MMGetLastChunkOnMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetLastChunkOnMedia')
	delete from GXDBVersions where aliasname = 'MMGetLastChunkOnMedia'
GO

insert into GXDBVersions values(2, 'MMGetLastChunkOnMedia',  '00010001000200050000', 'MMGetLastChunkOnMedia', '00010001000200050000')
GO

