

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetHistoryData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetHistoryData.sp,v $ $Id: MMGetHistoryData.sp,v 1.1.2.1 2018/08/28 03:27:17 cliu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMGetHistoryData"				|
--	|									|
--	| Execute the System stored procedure to fetch history data				|
--	| .. for the given entity.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetHistoryData <<<'

IF EXISTS (select * from sysobjects where name='MMGetHistoryData')
	drop procedure MMGetHistoryData
IF EXISTS (select * from GxQscripts where name='MMGetHistoryData')
	delete from GxQscripts where name = 'MMGetHistoryData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetHistoryData')
	delete from GXDBVersions where aliasname = 'MMGetHistoryData'
GO
print '... Creating Procedure: MMGetHistoryData'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetHistoryData
  @i_historyDataType integer,
  @i_entityId integer
AS
  DECLARE @o_entityId integer = 0
  DECLARE @o_historyCollectTime integer = 0
  DECLARE @o_data bigint = 0
  DECLARE @o_properties nvarchar(255) = ''
/*
enum HistoryDataType {
	mountpath_space_history = 1,
	library_space_history = 2,
	sidb_prune_history_by_hour = 3,
	sidb_prune_history_by_day = 4,
};
*/
IF @i_historyDataType = 1
BEGIN
	IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB..MMMountPathSpaceHistory') IS NOT NULL)
	BEGIN
		SELECT  MountPathId, dbo.GetUnixTime(timestamp) as CollectionTime,
				case when TotalSpaceMB = 0 then 0.00 else cast((FreeBytesMB*100.00/TotalSpaceMB) as DECIMAL(18, 2)) end,
				'' --(SELECT * FROM HistoryDB..MMMountPathSpaceHistory b where a.mountpathid = b.mountpathid and a.timestamp = b.timestamp FOR JSON AUTO) as properties
		FROM	HistoryDB..MMMountPathSpaceHistory a
		WHERE	a.MountPathId = @i_entityId
		ORDER BY a.MountPathId, timestamp
	END
END
ELSE IF @i_historyDataType = 2
BEGIN
	IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB..MMLibrarySpaceHistory') IS NOT NULL)
	BEGIN
		SELECT  LibraryId, dbo.GetUnixTime(timestamp) as CollectionTime,
				case when totalCapMB = 0 then 0.00 else cast((FreespaceMB*100.00/totalCapMB) as decimal(18, 2)) end,
				'' --(SELECT * FROM HistoryDB..MMLibrarySpaceHistory b where a.LibraryId = b.LibraryId and a.timestamp = b.timestamp FOR JSON AUTO) as properties
		FROM	HistoryDB..MMLibrarySpaceHistory a
		WHERE	a.LibraryId = @i_entityId
		ORDER BY timestamp
	END
END
ELSE IF @i_historyDataType = 3
BEGIN
	select substoreid, dbo.GetDateTime(modifiedtime) as time, DataSizeToPrune,
		'' --(SELECT * FROM idxsidbusagehistory b where b.historytype = 0 and a.substoreId = b.substoreId and a.modifiedtime = b.modifiedtime FOR JSON AUTO) as properties
	from idxsidbusagehistory a
	where /*sidbstoreid = 3040 and*/ substoreid = @i_entityId
	and historytype = 0
END
ELSE IF @i_historyDataType = 4
BEGIN
	select substoreid, dbo.GetDateTime(modifiedtime) as time, DataSizeToPrune,
		'' --(SELECT * FROM idxsidbusagehistory b where b.historytype = 2 and a.substoreId = b.substoreId and a.modifiedtime = b.modifiedtime FOR JSON AUTO) as properties
	from idxsidbusagehistory a
	where /*sidbstoreid = 3040 and*/ substoreid = @i_entityId
	and historytype = 2
END
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetHistoryData')
	delete from GxQscripts where name = 'MMGetHistoryData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetHistoryData')
	delete from GXDBVersions where aliasname = 'MMGetHistoryData'
GO

insert into GXDBVersions values(2, 'MMGetHistoryData',  '00010001000200010000', 'MMGetHistoryData', '00010001000200010000')
GO

