

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetGSPStoragePools.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetGSPStoragePools.sp,v $ $Id: MMGetGSPStoragePools.sp,v 1.1.2.12 2020/05/10 01:17:02 pveeravalli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetGSPStoragePools')
BEGIN
	print '>>> Drop Stored Procedure: MMGetGSPStoragePools <<<'
	drop procedure MMGetGSPStoragePools
END
IF EXISTS (select * from GxQscripts where name='MMGetGSPStoragePools')
	delete from GxQscripts where name = 'MMGetGSPStoragePools'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetGSPStoragePools')
	delete from GXDBVersions where aliasname = 'MMGetGSPStoragePools'
GO
print '... Creating Procedure: MMGetGSPStoragePools'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetGSPStoragePools
  @i_userId integer = 0,
  @i_storagepoolId integer = 0
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_StoragePoolId integer
  DECLARE @o_StoragePoolName NVARCHAR(144)
  DECLARE @o_StoragePoolType bigint
  DECLARE @o_RetentionDays integer
  DECLARE @o_RetentionCycles integer
  DECLARE @o_NumberOfDependentCopies integer
  DECLARE @o_libraryTypeId integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @tmpGlobalPolicyStoragePoolTable TABLE
(
	id 				 integer,
	name 			 NVARCHAR(255),
	retentionDays    INT DEFAULT(0),
	retentionCycles  INT DEFAULT(0),
	flags 			 INT DEFAULT(0),
	numberOfDependentCopies	INT DEFAULT(0),
	libraryTypeId	INT DEFAULT(0)
)
DECLARE @globalPolicyFlags INT = 256 | 16384 | 8388608
DECLARE @showHiddenSPConfig INT = 0
SELECT 	@showHiddenSPConfig = value
FROM    MMConfigs WITH (NOLOCK)
WHERE 	name = 'MMCONFIG_SHOW_HIDDEN_STORAGE_POLICIES'
INSERT INTO @tmpGlobalPolicyStoragePoolTable(id, name, flags)
SELECT	AG.id, AG.name, AG.flags
FROM    ArchGroup AG WITH(READUNCOMMITTED)
WHERE   AG.flags & @globalPolicyFlags > 0
AND ( @showHiddenSPConfig > 0 OR ( @showHiddenSPConfig = 0 AND AG.flags & 64 = 0 ))
		AND ( (@i_storagepoolId = 0) OR (AG.id=@i_storagepoolId))
IF @i_userId > 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#globalPolicyStoragePool_UserObjects') IS NOT NULL DROP TABLE #globalPolicyStoragePool_UserObjects
	CREATE TABLE  #globalPolicyStoragePool_UserObjects
		(archGroupId int)
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 160, 0, '#globalPolicyStoragePool_UserObjects'
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 17, 0, '#globalPolicyStoragePool_UserObjects'
    DELETE tmp FROM @tmpGlobalPolicyStoragePoolTable tmp
	    LEFT JOIN #globalPolicyStoragePool_UserObjects Sec ON tmp.id = Sec.archGroupId
   	    WHERE Sec.archGroupId IS NULL
    IF OBJECT_ID('tempdb.dbo.#globalPolicyStoragePool_UserObjects') IS NOT NULL DROP TABLE #globalPolicyStoragePool_UserObjects
END
IF OBJECT_ID('tempdb.dbo.#tmpDependentCopyList') IS NOT NULL DROP TABLE #tmpDependentCopyList
CREATE TABLE  #tmpDependentCopyList
(
	archGroupId 	integer,
	numberOfCopies	  		integer
)
INSERT INTO #tmpDependentCopyList
SELECT globalPolicyId, COUNT(1) FROM archCopyToGlobalPolicy g  WITH (READUNCOMMITTED)
 INNER JOIN @tmpGlobalPolicyStoragePoolTable t ON g.globalPolicyId = T.id
 GROUP BY globalPolicyId
--Update number of dependent copies
UPDATE tmpGP
SET numberOfDependentCopies = numberOfCopies
FROM @tmpGlobalPolicyStoragePoolTable tmpGP
INNER JOIN #tmpDependentCopyList AS tmpDC
ON tmpGP.id = tmpDC.archGroupId
--Update retention
UPDATE tmpGP
	SET retentionDays = tmp.retentionDays, retentionCycles = fullCycles
	FROM @tmpGlobalPolicyStoragePoolTable tmpGP
	INNER JOIN (select  AG.id, AG.defaultCopy, AAR.retentionDays, AAR.fullCycles from archGroupCopy AGC  WITH (READUNCOMMITTED)
				JOIN archGroup AG  WITH (READUNCOMMITTED) ON AGC.archGroupId=AG.id AND AG.defaultCopy=AGC.id
				JOIN archAgingRule AAR  WITH (READUNCOMMITTED) ON AAR.copyId = AGC.id
where extendedFlags&1>0) AS tmp
	ON tmpGP.id = tmp.id
 ;With libraryType_cte
   AS (
      SELECT tmpGp.id as id, MAX(LIB.libraryTypeId) as libraryTypeId
      FROM @tmpGlobalPolicyStoragePoolTable tmpGP
          INNER JOIN ArchGroupCopy AGC WITH(READUNCOMMITTED) ON tmpGP.id = AGC.archGroupId
          INNER JOIN MMDataPath DPath WITH(READUNCOMMITTED) ON AGC.id = DPath.CopyId
          INNER JOIN MMDrivePool DPool WITH(READUNCOMMITTED) ON DPath.DrivePoolId = DPool.DrivePoolId
          INNER JOIN MMMasterPool MPool  WITH(READUNCOMMITTED) ON DPool.MasterPoolId = MPool.MasterPoolId
          INNER JOIN MMLibrary LIB WITH(READUNCOMMITTED) ON MPool.LibraryId = LIB.LibraryId
      GROUP BY tmpGP.id
    )
    UPDATE tmpGP
    SET tmpGP.libraryTypeId = c.libraryTypeId
    FROM  @tmpGlobalPolicyStoragePoolTable tmpGP
    INNER JOIN libraryType_cte C ON C.id = tmpGp.id
SELECT 	id, name, flags AS storagePoolType, retentionDays, retentionCycles, numberOfDependentCopies, libraryTypeId
FROM @tmpGlobalPolicyStoragePoolTable
DROP TABLE #tmpDependentCopyList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetGSPStoragePools')
	delete from GxQscripts where name = 'MMGetGSPStoragePools'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetGSPStoragePools')
	delete from GXDBVersions where aliasname = 'MMGetGSPStoragePools'
GO

insert into GXDBVersions values(2, 'MMGetGSPStoragePools',  '00010001000200120000', 'MMGetGSPStoragePools', '00010001000200120000')
GO

