

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetFallBackSubStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetFallBackSubStore.sp,v $ $Id: MMGetFallBackSubStore.sp,v 1.8.188.5 2020/04/29 19:45:08 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetFallBackSubStore')
BEGIN
	print '>>> Drop Stored Procedure: MMGetFallBackSubStore <<<'
	drop procedure MMGetFallBackSubStore
END
IF EXISTS (select * from GxQscripts where name='MMGetFallBackSubStore')
	delete from GxQscripts where name = 'MMGetFallBackSubStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetFallBackSubStore')
	delete from GXDBVersions where aliasname = 'MMGetFallBackSubStore'
GO
print '... Creating Procedure: MMGetFallBackSubStore'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetFallBackSubStore
  @i_SIDBStoreId INTEGER,
  @i_SubStoreId INTEGER,
  @i_commCellId INTEGER
AS
  DECLARE @o_SIDBStoreId INTEGER
  DECLARE @o_SubStoreId INTEGER
  DECLARE @o_commCellId INTEGER
  DECLARE @o_FallBackSubStoreId INTEGER
  DECLARE @o_OfflineEntity INTEGER
  DECLARE @o_OfflineReason INTEGER	
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- Determine if MA, IdxCache, IdxAccessPath are enabled/online for a given substore. Also check that store is not corrupted
-- If not then look out for next available substore. Currently it has to be group level resiliency.
--Offline Entities
-- MA 			- 1
-- IdxCache 		- 2
-- IdxAccessPath 	- 3
-- Corrupted Substore	- 4
-- SubStoreStatus
-- Online	- 1
-- Offline	- 0
DECLARE	@tmpSubStoresInGroup TABLE
(
	SIDBStoreId			integer,
	SubStoreId			integer,
	commCellId			integer,
	GroupNumber			integer,
	clientId			integer,
	IdxCacheId			integer,
	IdxAccessPathId			integer,
	SubStoreStatus			integer,
	fallBackSubStoreId		integer,
	OfflineEntity			integer,
	OfflineReason			integer
)
DECLARE @tmpAvailableSubStores TABLE
(
	SIDBStoreId			integer,
	SubStoreId			integer,
	commCellId			integer,
	GroupNumber			integer,
	clientId			integer
)
DECLARE @fallbackSubStoreId	INTEGER = 0
DECLARE @groupNumber		INTEGER = 0
DECLARE @SIDBStoreId		INTEGER = 0
DECLARE @SubStoreId		INTEGER = 0
DECLARE @clientId		INTEGER = 0
DECLARE @offlineEntity		INTEGER
DECLARE @subStoreStatus		INTEGER
DECLARE @resiliencyEnable	INTEGER = 0
IF @i_SubStoreId = 0 -- Calculate store level failovers
BEGIN
	-- get all the peer substores for this store.
	INSERT INTO @tmpSubStoresInGroup
	SELECT SIDBStoreId, SubStoreId, commCellId, GroupNumber, clientId, IdxCacheId, IdxAccessPathId, 1, 0, 0, 0
	FROM IdxSIDBSubStore WITH (NOLOCK)
	WHERE SIDBStoreId = @i_SIDBStoreId
	AND commCellId = @i_commCellId
	ORDER BY groupNumber, clientId
SELECT @resiliencyEnable = (AGC.dedupeFlags & 8)
	FROM archGroupCopy AGC WITH (NOLOCK)
		INNER JOIN archCopySIDBStore AGCSI WITH (NOLOCK) ON AGC.id = AGCSI.copyId
	WHERE AGCSI.SIDBStoreId = @i_SIDBStoreId
	IF @resiliencyEnable = 0 -- resiliency is not enabled. Do not perform any calculations done below.
		GOTO CX_EXIT
	-- determine if client MA is up, if not then mark all substores corresponding to it as offline
	UPDATE @tmpSubStoresInGroup
	SET SubStoreStatus = 0,
	OfflineEntity = 1,
	OfflineReason = MMH.OfflineReason
	FROM MMHost MMH, @tmpSubStoresInGroup T
WHERE T.clientId = MMH.ClientId AND ((MMH.MmHostSoftState = 0) OR (MMH.MmHostEnabled = 0) OR ((MMH.Attribute & 16) > 0))
	-- determine if IdxAccessPath and IdxCache are fine
	UPDATE @tmpSubStoresInGroup
	SET SubStoreStatus = 0,
	OfflineEntity = 2,
	OfflineReason = IC.OfflineReason
	FROM IdxCache IC, @tmpSubStoresInGroup T
	WHERE T.IdxCacheId = IC.IdxCacheId
	AND (IC.Enabled = 0 OR IC.SoftState = 0)
	UPDATE @tmpSubStoresInGroup
	SET SubStoreStatus = 0,
	OfflineEntity = 3,
	OfflineReason = IAP.OfflineReason
	FROM IdxAccessPath IAP, @tmpSubStoresInGroup T
	WHERE T.IdxAccessPathId = IAP.IdxAccessPathId
	AND (IAP.Enabled = 0 OR IAP.SoftState = 0)
	-- update all the substores status which are corrupted or being moved
	UPDATE @tmpSubStoresInGroup
	SET SubStoreStatus = 0,
	OfflineEntity = 4,
	OfflineReason = (CASE WHEN ISub.Status = 1 THEN 1 ELSE 1024 END)
	FROM IdxSIDBSubStore ISub, @tmpSubStoresInGroup T
	WHERE T.SIDBStoreId = @i_SIDBStoreId
	AND T.SIDBStoreId = ISub.SIDBStoreId
	AND T.SubStoreId = ISub.SubStoreId
AND (ISub.Status = 1 OR ISub.flags & 1024 = 1024)
	INSERT INTO @tmpAvailableSubStores
	SELECT SIDBStoreId, SubStoreId, commCellId, GroupNumber, clientId
	FROM @tmpSubStoresInGroup
	WHERE SubStoreStatus = 1
	DECLARE curOffSubStore CURSOR FOR
	SELECT SIDBStoreId, SubStoreId, GroupNumber, clientId
	FROM @tmpSubStoresInGroup
	WHERE SubStoreStatus = 0
	OPEN curOffSubStore
	FETCH NEXT FROM curOffSubStore INTO @SIDBStoreId, @SubStoreId, @groupNumber, @clientId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @fallbackSubStoreId = 0
		-- get the next available substore
		SET @fallbackSubStoreId = (SELECT top 1 T.SubStoreId
		FROM (	(SELECT SubStoreId from @tmpAvailableSubStores WHERE GroupNumber = @groupNumber)
			UNION
			(SELECT SubStoreId from @tmpAvailableSubStores WHERE clientId = @clientId and GroupNumber <> @groupNumber)
			UNION
			(SELECT SubStoreId from @tmpAvailableSubStores WHERE clientId <> @clientId)
									) AS T)
		UPDATE @tmpSubStoresInGroup
		SET fallBackSubStoreId = @fallbackSubStoreId
		WHERE SubStoreId = @SubStoreId
		FETCH NEXT FROM curOffSubStore INTO @SIDBStoreId, @SubStoreId, @groupNumber, @clientId
	END
	CLOSE curOffSubStore
	DEALLOCATE curOffSubStore
CX_EXIT:
	UPDATE @tmpSubStoresInGroup
	SET fallBackSubStoreId = SubStoreId
	WHERE fallBackSubStoreId = 0 or fallBackSubStoreId IS NULL
	--create substore state history
	DECLARE @HourStartDate	int
	SET @HourStartDate = dbo.getUnixTime(dbo.GetHourStart(GetUTCDate()))
	IF EXISTS (SELECT * FROM @tmpSubStoresInGroup WHERE (fallBackSubStoreId <> SubStoreId) AND (OfflineEntity > 0))
	BEGIN
		IF 	NOT EXISTS
			(SELECT *
 			 FROM IdxSIDBSubStoreStateHistory   IDX, @tmpSubStoresInGroup T
			 WHERE 	    IDX.SIDBStoreId 	= T.SIDBStoreId
				and IDX.SubStoreId 	= T.SubStoreId
				and IDX.CommCellId  = T.CommCellId
				and Time	 		> @HourStartDate)
		BEGIN
			INSERT INTO IdxSIDBSubStoreStateHistory
			SELECT SIDBStoreId, SubStoreId, 0, commCellId, fallBackSubStoreId, 1, dbo.getUnixTime(GETUTCDATE()),  OfflineEntity, OfflineReason, 0, 0
			FROM @tmpSubStoresInGroup
			WHERE ((fallBackSubStoreId <> SubStoreId AND OfflineEntity > 0) OR fallBackSubStoreId = null)
		END
	END
	SELECT SIDBStoreId, SubStoreId, commCellId, fallBackSubStoreId, OfflineEntity, OfflineReason
	FROM @tmpSubStoresInGroup
END
ELSE
BEGIN
	-- First determine if this substore needs some fallback.
	print 'No Op'
END
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetFallBackSubStore')
	delete from GxQscripts where name = 'MMGetFallBackSubStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetFallBackSubStore')
	delete from GXDBVersions where aliasname = 'MMGetFallBackSubStore'
GO

insert into GXDBVersions values(2, 'MMGetFallBackSubStore',  '00010008018800050000', 'MMGetFallBackSubStore', '00010008018800050000')
GO

