

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDriveListWC.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDriveListWC.sp,v $ $Id: MMGetDriveListWC.sp,v 1.3.2.7 2018/03/20 00:17:46 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMGetDriveListWC"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetDriveListWC <<<'

IF EXISTS (select * from sysobjects where name='MMGetDriveListWC')
	drop procedure MMGetDriveListWC
IF EXISTS (select * from GxQscripts where name='MMGetDriveListWC')
	delete from GxQscripts where name = 'MMGetDriveListWC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDriveListWC')
	delete from GXDBVersions where aliasname = 'MMGetDriveListWC'
GO
print '... Creating Procedure: MMGetDriveListWC'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDriveListWC
  @i_libraryId integer
AS
  DECLARE @o_driveId integer 
  DECLARE @o_aliasName nvarchar(255)
  DECLARE @o_driveTypeId integer 
  DECLARE @o_driveTypeName varchar(255)
  DECLARE @o_dmsDrivePoolId integer 
  DECLARE @o_dmsDrivePoolName nvarchar(255)
  DECLARE @o_dmsDPMAId integer 
  DECLARE @o_dmsDPMAName nvarchar(255)
  DECLARE @o_isAccessible integer
  DECLARE @o_isOnline integer
  DECLARE @o_isReserved integer 
  DECLARE @o_mediaId integer 
  DECLARE @o_barCode varchar(255)
  DECLARE @o_jobIdList varchar(max)
  DECLARE @o_mountStatus integer
  DECLARE @o_isEnabled integer
  DECLARE @o_attribute integer
  DECLARE @o_cleaningRequired integer
  DECLARE @o_canBeCleaned integer
  DECLARE @o_externalGUID nvarchar(255)
	SET NOCOUNT ON
	declare @tmpDrive table (
				driveId				integer,
				MediaId				integer,
				ReservationId		integer,
				DCDPId				integer,
				DCDPMAId			integer,
				isReserved			integer,
				isOnline			integer,
				isAccessible		integer,
				mountStatus			integer,
				isEnabled			integer,
				attribute 			integer
			)
	declare @tmpDriveCtrls	table (
				DriveId					integer,
				DrivePoolId				integer,
				DriveControllerId		integer,
				isAccessible			integer,
				DriveControllerActive	integer,
				DriveControllerSoftState integer,
				DriveControllerEnabled	integer,
				ClientId				integer,
				MediaId					integer
			)
	insert into @tmpDrive
	select a.DriveId, a.MediaId, 0, 0, 0, 0,
	isOnline = (CASE WHEN (DriveBroken = 0 and CleaningRequired = 0 and DriveSoftState > 0 and DriveEnabled > 0) THEN 1 ELSE 0 END),
	0, a.MountStatus, a.DriveEnabled, a.Attributes
	from MMDrive a with (nolock), MMMasterPool b with (nolock)
	where a.MasterPoolId = b.MasterPoolId
	and b.LibraryId = @i_libraryId
	insert into @tmpDriveCtrls
	select  md.driveId, mdc.drivePoolId,
			mdc.driveControllerId,
			isAccessible = (CASE WHEN (mdc.DriveControllerEnabled = 0 or mdc.DriveControllerSoftState = 0) THEN 0 ELSE 1 END),
			mdc.DriveControllerActive, mdc.DriveControllerSoftState,
			mdc.DriveControllerEnabled,
			mdc.ClientId, md.MediaId
	from	@tmpDrive as md, MMDriveController as mdc with (nolock)
	where	md.driveId = mdc.driveId
	declare @tmpisAccessible table (
			driveId integer,
			isAccessible integer,
			numDriveController integer,
			numAccessibleController integer
			)
	-- update the accessibility
	-- isAccessible is default to 2 - Partially accessible.
	-- isAccessible is set to 1 if it is fully accessible.
	insert	into @tmpisAccessible
	select	driveId,
	isAccessible = (CASE WHEN (count(DriveControllerId) = sum(isAccessible)) THEN 1 ELSE 2 END),
	count(DriveControllerId), sum(isAccessible)
	from	@tmpDriveCtrls
	group	by driveId
	-- isAccessible is set to 0 if it is not accessible at all.
	--update	@tmpisAccessible set isAccessible = 1
	--where	numDriveController = numAccessibleController
	update	@tmpisAccessible set isAccessible = 0
	from	@tmpisAccessible tt, MMDrive md with (nolock)
	where	tt.driveId = md.driveId
	and		(tt.numAccessibleController = 0
			or md.DriveEnabled = 0
			or md.DriveSoftState = 0
			or md.DriveBroken = 1)
	update @tmpDrive
	set isAccessible = ac.isAccessible
	from @tmpisAccessible as ac, @tmpDrive as tt
	where tt.DriveId = ac.DriveId
	update @tmpDrive
	set	DCDPId = tdc.DrivePoolId, DCDPMAId = tdc.ClientId
	from	@tmpDriveCtrls as tdc, @tmpDrive as tt
	where	tdc.DriveControllerActive = 1 and tdc.DriveId = tt.DriveId
	update @tmpDrive
	set isReserved = 1, ReservationId = MR.ReservationId, MediaId = MR.MediaId
	from MMResource as mr with (nolock), @tmpDrive as tt
	where tt.DriveId = mr.DriveId
	update @tmpDrive
	set	MediaId = tdc.MediaId
	from	@tmpDriveCtrls as tdc, @tmpDrive as tt
	where	tt.MediaId = 0 and tdc.DriveId = tt.DriveId and tdc.MediaId > 0
	-----------------------------------
	-- Get jobId list in string
	-----------------------------------
	DECLARE @tblJob TABLE(DriveId INT, JobId INT)
	INSERT INTO @tblJob
	SELECT DISTINCT A.DriveId, B.JobId_l
	FROM @tmpDrive A, MMResourceToJob B WITH(NOLOCK)
	WHERE A.ReservationId = B.ReservationId
	DECLARE @tblJobList TABLE(DriveId INT, JobIdList varchar(max))
	INSERT INTO @tblJobList
	SELECT DISTINCT A.DriveId,
		(	SELECT CONVERT(VARCHAR(20), B.JobId) + ','
			FROM @tblJob B
			WHERE A.DriveId = B.DriveId
			ORDER BY JobId
			FOR XML PATH('')
		)	AS JobIdList
	FROM @tblJob A
	UPDATE @tblJobList
	SET JobIdList = (CASE WHEN LEN(JobIdList) > 0 THEN SUBSTRING(JobIdList, 1, LEN(JobIdList)-1) ELSE JobIdList END)
	-- ** Now Return all the info
	SELECT 	DISTINCT	tt.DriveId, md.AliasName,
			md.driveTypeId, dt.driveTypeName,
			tt.DCDPId, DrivePoolName = (CASE WHEN tt.DCDPId = 0 THEN N'' ELSE (SELECT dp.DrivePoolName FROM MMDrivePool dp with (nolock) WHERE dp.DrivePoolId = tt.DCDPId) END),
			tt.DCDPMAId, MAName = (CASE WHEN tt.DCDPMAId = 0 THEN N'' ELSE (SELECT cl.name FROM APP_Client cl with (nolock) WHERE cl.ID = tt.DCDPMAId) END),
			tt.isAccessible, tt.isOnline, tt.isReserved,
	       		tt.MediaId,
			barcode = (CASE WHEN tt.MediaId = 0 THEN N'' ELSE (SELECT mm.barcode FROM MMMedia mm with (nolock) WHERE mm.MediaId = tt.MediaId) END),
			JobIdList = ISNULL(JB.JobIdList, ''), tt.mountStatus, tt.isEnabled, tt.attribute, md.CleaningRequired, dt.CanBeCleaned, md.ExternalGUID
	FROM 	@tmpDrive AS tt
			INNER JOIN MMDrive as md with (nolock) ON tt.DriveId = md.DriveId
			INNER JOIN MMDriveType DT with (nolock) ON DT.driveTypeId = md.driveTypeId
			LEFT OUTER JOIN @tblJobList JB ON tt.DriveId = JB.DriveId
	ORDER BY tt.DriveId
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDriveListWC')
	delete from GxQscripts where name = 'MMGetDriveListWC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDriveListWC')
	delete from GXDBVersions where aliasname = 'MMGetDriveListWC'
GO

insert into GXDBVersions values(2, 'MMGetDriveListWC',  '00010003000200070000', 'MMGetDriveListWC', '00010003000200070000')
GO

