

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDiskLibListForHybridCloud.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDiskLibListForHybridCloud.sp,v $ $Id: MMGetDiskLibListForHybridCloud.sp,v 1.1.2.3 2019/03/18 21:03:07 aselvanayagam Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetDiskLibListForHybridCloud')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDiskLibListForHybridCloud <<<'
	drop procedure MMGetDiskLibListForHybridCloud
END
IF EXISTS (select * from GxQscripts where name='MMGetDiskLibListForHybridCloud')
	delete from GxQscripts where name = 'MMGetDiskLibListForHybridCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDiskLibListForHybridCloud')
	delete from GXDBVersions where aliasname = 'MMGetDiskLibListForHybridCloud'
GO
print '... Creating Procedure: MMGetDiskLibListForHybridCloud'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDiskLibListForHybridCloud
  @i_cloudLibId integer
AS
  DECLARE @o_xml XML
DECLARE @tblMAList TABLE(ClientId INT, MPId INT, rwId INT)
DECLARE @tblDiskMPList TABLE(ClientId INT, MPId INT, rwId INT)
IF EXISTS(SELECT 1 FROM MMMountPath MP WHERE MP.LibraryId = @i_cloudLibId AND MP.MountPathTypeId = 7) -- Is it a cloud mount path
BEGIN
	INSERT INTO @tblMAList
	SELECT DISTINCT DEVC.ClientId, MP.MountPathId, ROW_NUMBER() OVER (partition by DEVC.DeviceId ORDER BY DEVC.ClientId)
	FROM MMMountPath MP WITH (READUNCOMMITTED)
		INNER JOIN MMMountPathToStorageDevice as MSD WITH (READUNCOMMITTED) ON MP.MountPathId = MSD.MountPathId
		INNER JOIN MMDeviceController as DEVC WITH (READUNCOMMITTED) ON MSD.DeviceId = DEVC.DeviceId
	WHERE MP.LibraryId = @i_cloudLibId
AND DEVC.DeviceAccessType & 2 = 2
	INSERT INTO @tblDiskMPList
	SELECT T.ClientId, SD.MountPathId, ROW_NUMBER() OVER (partition by DEVC.DeviceId ORDER BY DEVC.ClientId)
	FROM @tblMAList T
		INNER JOIN MMDeviceController DEVC WITH (READUNCOMMITTED) ON DEVC.ClientId = T.ClientId
		INNER JOIN MMDevice MD WITH (READUNCOMMITTED) ON DEVC.DeviceId = MD.DeviceId
		INNER JOIN MMMountPathToStorageDevice SD WITH (READUNCOMMITTED) ON DEVC.DeviceId = SD.DeviceId AND SD.MountPathId <> T.MPId
WHERE MD.DeviceTypeId = 1
AND DEVC.DeviceAccessType & 2 = 2
	-- clean up rows which have lesser MAs that source cloud lib.
	DELETE T
	FROM @tblDiskMPList T
	WHERE rwId < (SELECT MAX(rwId) from @tblMAList)
	SET @o_XML = (SELECT DISTINCT L.LibraryId as 'library/@libraryId',
					L.AliasName as 'library/@libraryName'
				FROM MMLibrary L WITH (READUNCOMMITTED)
				INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.LibraryId = L.LibraryId
				INNER JOIN @tblDiskMPList T ON MP.MountPathId = T.MPId
WHERE L.LibraryTypeId <> 10
				FOR XML PATH('libraryList'),
				ROOT ('EVGui_GetLibraryListWCResp'))
END
ELSE
BEGIN
    SELECT  1	as TAG,
			0	as Parent,
			1	as [CVGui_GenericResp!1!errorCode],
			'Requesting library is not a cloud library'	as [CVGui_GenericResp!1!errorMessage]
    FOR XML EXPLICIT
END
SELECT @o_xml
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDiskLibListForHybridCloud')
	delete from GxQscripts where name = 'MMGetDiskLibListForHybridCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDiskLibListForHybridCloud')
	delete from GXDBVersions where aliasname = 'MMGetDiskLibListForHybridCloud'
GO

insert into GXDBVersions values(2, 'MMGetDiskLibListForHybridCloud',  '00010001000200030000', 'MMGetDiskLibListForHybridCloud', '00010001000200030000')
GO

