

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDeviceControllerForSharingCloud.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDeviceControllerForSharingCloud.sp,v $ $Id: MMGetDeviceControllerForSharingCloud.sp,v 1.2.2.5 2019/05/04 13:21:10 aselvanayagam Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMGetDeviceControllerForSharingCloud"				|
--	|																		|
--	| Execute the stored procedure to fetch device controller information 	|
--	| .. needed for sharing cloud device controllers						|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetDeviceControllerForSharingCloud')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDeviceControllerForSharingCloud <<<'
	drop procedure MMGetDeviceControllerForSharingCloud
END
IF EXISTS (select * from GxQscripts where name='MMGetDeviceControllerForSharingCloud')
	delete from GxQscripts where name = 'MMGetDeviceControllerForSharingCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDeviceControllerForSharingCloud')
	delete from GXDBVersions where aliasname = 'MMGetDeviceControllerForSharingCloud'
GO
print '... Creating Procedure: MMGetDeviceControllerForSharingCloud'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDeviceControllerForSharingCloud
  @i_mountPathId integer
AS
  DECLARE @o_deviceControllerId integer
  DECLARE @o_userName varchar(1024)
  DECLARE @o_userPassword varchar(2048)
  DECLARE @o_folder varchar(1024)
  DECLARE @o_credentialId integer
-- MOUNT_PATH_EXTERNAL_REMOTE_HOST = 7 -- cloud library
	IF OBJECT_ID('tempdb.dbo.#tmpOutputTable') IS NOT NULL
	DROP TABLE #tmpOutputTable
	CREATE TABLE #tmpOutputTable
	(
		deviceControllerId INT,
		userName VARCHAR(1024),
		userPassword VARCHAR(2048),
		folder VARCHAR(1024),
		credentialId INT
	)
	INSERT INTO #tmpOutputTable ( deviceControllerId, userName, userPassword, folder, credentialId)
	SELECT TOP 1 MDC.DeviceControllerId, MDC.UserName, MDC.UserPassword, MDC.Folder,
	ISNULL(ACA.credentialId, 0) AS credentialId
	FROM MMDeviceController MDC WITH(NOLOCK)
	INNER JOIN MMMountPathToStorageDevice MSD WITH(NOLOCK) ON MSD.DeviceId = MDC.DeviceId
	INNER JOIN MMMountPath MP WITH(NOLOCK) on MSD.MountPathId = MP.MountPathId
	LEFT JOIN APP_CredentialAssoc ACA WITH(NOLOCK) ON ACA.assocId = MDC.CredentialAssocId
	WHERE MSD.DeviceId = MDC.DeviceId AND MSD.MountPathId = MP.MountPathId AND MP.MountPathTypeId = 7 AND MP.MountPathId = @i_mountPathId
	-- Update user name and password for entries that use credentials
	--EXEC MMS2GetDeviceControllerCredentials '#tmpOutputTable', 'credentialAssocId', 'userName', 'userPassword'
	SELECT  OP.deviceControllerId, OP.userName, OP.userPassword, OP.folder, OP.credentialId
	FROM	#tmpOutputTable OP
	IF OBJECT_ID('tempdb.dbo.#tmpOutputTable') IS NOT NULL
	DROP TABLE #tmpOutputTable
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDeviceControllerForSharingCloud')
	delete from GxQscripts where name = 'MMGetDeviceControllerForSharingCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDeviceControllerForSharingCloud')
	delete from GXDBVersions where aliasname = 'MMGetDeviceControllerForSharingCloud'
GO

insert into GXDBVersions values(2, 'MMGetDeviceControllerForSharingCloud',  '00010002000200050000', 'MMGetDeviceControllerForSharingCloud', '00010002000200050000')
GO

