

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDataMoverType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDataMoverType.sp,v $ $Id: MMGetDataMoverType.sp,v 1.9.274.7 2019/02/13 18:12:36 anarulkar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 	SP: "MMGetDataMoverType"
--	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetDataMoverType')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDataMoverType <<<'
	drop procedure MMGetDataMoverType
END
IF EXISTS (select * from GxQscripts where name='MMGetDataMoverType')
	delete from GxQscripts where name = 'MMGetDataMoverType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDataMoverType')
	delete from GXDBVersions where aliasname = 'MMGetDataMoverType'
GO
print '... Creating Procedure: MMGetDataMoverType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDataMoverType
-- ------------------------------------------------------------------------------------------
-- Function is used to get the datamover type for the given mediagroupId
-- ------------------------------------------------------------------------------------------
  @i_CopyId integer,
  @i_VolumeId integer,
  @i_DrivePoolId integer,
  @i_ReserveParam integer
AS
  DECLARE @o_DataMoverType integer
  DECLARE @o_DrivePoolType integer
  DECLARE @o_MMErrorCode integer
SET NOCOUNT ON
	--
	-- declarations
	--
	-- Constants that are enums.
	declare @DM_TYPE_REGULAR			integer
	declare @DM_TYPE_NAS				integer
	declare @DM_TYPE_SERVERLESS			integer
	declare @DM_TYPE_CENTERA			integer
	declare @DM_TYPE_SINGLE_INSTANCE	integer
	declare @DM_TYPE_CV_SINGLE_INSTANCE	integer
	declare @DM_TYPE_EXTERNAL_REMOTE_HOST	integer
	declare @DM_TYPE_EXTERNAL_REMOTE_HOST_SINGLE_INSTANCE	integer
	declare @DM_TYPE_HP_STOREONCE		integer
	declare @MOUNT_PATH_MAGNETIC		integer
	declare @MOUNT_PATH_CENTERA			integer
	declare @MOUNT_PATH_DYNAMIC_SHARED	integer
	declare @MOUNT_PATH_TAPE			integer
	declare @MOUNT_PATH_SHARED_STATIC	integer
	declare @MOUNT_PATH_SHARED_REPLICA	integer
	declare @MOUNT_PATH_DRU				integer
	declare @MOUNT_PATH_EXTERNAL_REMOTE_HOST	integer
	declare	@l_mmError					integer
	declare @l_LibraryId				integer
	declare	@l_LibraryAttribute			integer
	declare	@l_MountPathTypeId			integer
	declare	@l_MediaSideId				integer
	declare	@l_RecordingFormatId		integer
	declare @l_SIDBStoreId				integer
	declare @l_dedupeFlags				integer
	declare @l_mountPathId			integer = 0
	declare @l_deviceTypeId			integer = 0
	declare @l_masterPoolId			integer = 0
	--
	-- Init values
	--
	set @DM_TYPE_REGULAR				=	1
	set @DM_TYPE_NAS					=	2
	set @DM_TYPE_SERVERLESS				=	4
	set @DM_TYPE_CENTERA				=	8
	set @DM_TYPE_SINGLE_INSTANCE		=	16
	set @DM_TYPE_CV_SINGLE_INSTANCE		=	32
	set @DM_TYPE_EXTERNAL_REMOTE_HOST	=	64
	set @DM_TYPE_EXTERNAL_REMOTE_HOST_SINGLE_INSTANCE = 128
	set @DM_TYPE_HP_STOREONCE			  = 256
	set @MOUNT_PATH_MAGNETIC			=	0
	set @MOUNT_PATH_CENTERA				=	1
	set @MOUNT_PATH_DYNAMIC_SHARED		=	2
	set @MOUNT_PATH_TAPE				=	3
	set @MOUNT_PATH_SHARED_STATIC		=	4
	set @MOUNT_PATH_SHARED_REPLICA		=	5
	set @MOUNT_PATH_DRU					=	6
	set @MOUNT_PATH_EXTERNAL_REMOTE_HOST=	7
set @l_mmError						=	0
	set @l_LibraryId					=	0
	set	@l_LibraryAttribute				=	0
	set	@l_MountPathTypeId				=	0
	set	@l_MediaSideId					=	0
	set	@l_RecordingFormatId			=	0
	set @l_SIDBStoreId					=	0
	set @l_dedupeFlags					=	0
	set @o_DrivePoolType				=	0
	set @o_DataMoverType				=	0
	SELECT	@l_dedupeFlags = dedupeFlags
	FROM	ArchGroupCopy
	WHERE	id = @i_CopyId
	IF @l_dedupeFlags > 0
	BEGIN
		-- Get the default store based on copy. If vol info is passed it'll get the correct store.
		SELECT @l_SIDBStoreId = SIDBStoreId
		FROM archCopySIDBStore C WITH (READUNCOMMITTED)
		WHERE CopyId = @i_CopyId
AND (C.flags & 2) > 0
	END
	IF	@i_VolumeId > 0
	BEGIN
		SELECT	@l_MediaSideId		= MediaSideId,
				@l_RecordingFormatId= RecordingFormatId,
				@l_SIDBStoreId		= SIDBStoreId
		FROM	MMVolume
		WHERE	VolumeId = @i_VolumeId
		IF (@l_RecordingFormatId = 10001)
		BEGIN
SELECT @l_mountPathId = MountPathId, @l_MountPathTypeId = MountPathTypeId,  @o_DrivePoolType  = 10001, @l_LibraryId = LibraryId
			FROM MMMountPath
			WHERE MediaSideId = @l_MediaSideId
			GOTO IS_MAGNETIC
		END
	END
	-- If the input drive pool ID is not valid (probably de-configured), reset it to 0
	IF	@i_DrivePoolId > 0 AND NOT EXISTS (SELECT * FROM MMDrivePool WHERE DrivePoolId = @i_DrivePoolId)
		SET @i_DrivePoolId = 0
	-- ArMgr may call this procedure with zero input drivePoolId.
	-- Archive files created prior to 5.9 have zero drivePoolId in archFileCopy table.
	-- First see if we can get DrivePoolId or DrivePoolType from MMDataPath table.
	IF @i_DrivePoolId = 0
	BEGIN
		CREATE	TABLE #DrivePool (
				DrivePoolId int, DrivePoolType int)
		INSERT	INTO #DrivePool
		SELECT	B.DrivePoolId, B.DrivePoolType
		FROM	MMDataPath A, MMDrivePool B
		WHERE	A.CopyId = @i_CopyId
			AND B.DrivePoolId = A.DrivePoolId
AND B.DrivePoolType = 3
		IF	@@ROWCOUNT = 1
			SELECT	@i_DrivePoolId = DrivePoolId, @o_DrivePoolType = DrivePoolType
			FROM	#DrivePool
		ELSE
		BEGIN
			SELECT	DISTINCT @o_DrivePoolType = DrivePoolType
			FROM	#DrivePool
			IF	@@ROWCOUNT <> 1
				SET @o_DrivePoolType = 0
		END
		DROP TABLE #DrivePool
	END
	IF @i_DrivePoolId > 0
	BEGIN
		IF	@o_DrivePoolType = 0
			SELECT	@o_DrivePoolType = DrivePoolType
			FROM	MMDrivePool
			WHERE	DrivePoolId = @i_DrivePoolId
		--
		-- Check NAS first.
		--
IF (@o_DrivePoolType = 3)
		BEGIN
			set @o_DataMoverType	=	(@o_DataMoverType | @DM_TYPE_NAS)
			-- Exit, since once it is set to NAS, it cannot be another type
			-- (unlike SingleInstanced AND Centera).
			GOTO PROC_EXIT
		END
		-- If the drivepool type is not magnetic, this means that we do not need
		-- to set the other datamover types since the rest are only for magnetic.
		-- So, just set it to regular and return.
ELSE IF (@o_DrivePoolType <> 10001)
		BEGIN
			set @o_DataMoverType	=	(@o_DataMoverType | @DM_TYPE_REGULAR)
			GOTO PROC_EXIT
		END
		SELECT	TOP 1 @l_LibraryId = MP.LibraryId
		FROM	MMMasterPool MP, MMDrivePool DP
		WHERE	DP.DrivePoolId = @i_DrivePoolId
			AND DP.MasterPoolId = MP.MasterPoolId
		SELECT	@l_MountPathTypeId = MountPathTypeId, @l_mountPathId = MountPathId
		FROM	MMMountPath
		WHERE	LibraryId = @l_LibraryId
	END
	-- The DrivePoolId is not retrieved from archFileCopy by ArMgrCS outside this procedure.
	-- and not retrieved from MMDataPath table. So, we use VolumeId to get the information.
	-- It is OK if o_DrivePoolType is not set since ArMgrCS does not needs it.
	ELSE
	IF	@i_VolumeId > 0
	BEGIN
		-- Check NAS first.
IF (@o_DrivePoolType = 3)
		BEGIN
			set @o_DataMoverType	=	(@o_DataMoverType | @DM_TYPE_NAS)
			GOTO PROC_EXIT
		END
		-- If the drivepool type is not magnetic, this means that we do not need
		-- to set the other datamover types since the rest are only for magnetic.
		-- So, just set it to regular and return.
IF (@l_RecordingFormatId <> 10001)
		BEGIN
			set @o_DataMoverType	=	(@o_DataMoverType | @DM_TYPE_REGULAR)
			GOTO PROC_EXIT
		END
set @o_DrivePoolType		=	10001
		SELECT	@l_LibraryId = LibraryId, @l_MountPathTypeId = MountPathTypeId, @l_mountPathId = MountPathId
		FROM	MMMountPath
		WHERE	MediaSideId = @l_MediaSideId
	END
IS_MAGNETIC:
	IF @i_VolumeId = 0 AND @i_DrivePoolId = 0
	BEGIN
		SET @l_masterPoolId = (SELECT TOP(1) DP.MasterPoolId
								FROM MMDataPath D WITH (READUNCOMMITTED)
								INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON D.DrivePoolId = DP.DrivePoolId
	  							WHERE D.CopyId = @i_CopyId)
		SELECT @l_mountPathId = MountPathId, @l_MountPathTypeId = MountPathTypeId FROM MMMountPath WITH (READUNCOMMITTED) WHERE MasterPoolId = @l_masterPoolId
	END
	--
	-- Check External Remote Host.
	--
	IF @l_MountPathTypeId = @MOUNT_PATH_EXTERNAL_REMOTE_HOST
	BEGIN
IF	(@l_SIDBStoreId > 0 OR ((@l_dedupeFlags & 262144) > 0))
			set @o_DataMoverType	=	(@o_DataMoverType | @DM_TYPE_EXTERNAL_REMOTE_HOST_SINGLE_INSTANCE)
		ELSE
		BEGIN
			IF EXISTS (SELECT 1 FROM MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED)
					INNER JOIN MMDevice D WITH (READUNCOMMITTED) ON MPSD.DeviceId = D.DeviceId
WHERE D.DeviceTypeId = 59
					AND MPSD.MountPathId = @l_mountPathId)
				SET @o_DataMoverType = @DM_TYPE_HP_STOREONCE
			ELSE
				set @o_DataMoverType	=	(@o_DataMoverType | @DM_TYPE_EXTERNAL_REMOTE_HOST)
		END
set @o_DrivePoolType		=	10001
	  GOTO PROC_EXIT
	END
	ELSE IF @l_mountPathId > 0 AND @l_SIDBStoreId = 0 AND @l_dedupeFlags = 0 AND @l_MountPathTypeId = @MOUNT_PATH_SHARED_STATIC
	BEGIN
		-- Default to regular.
		SET @o_DataMoverType = (@o_DataMoverType | @DM_TYPE_REGULAR)
SET @o_DrivePoolType =	10001
		GOTO PROC_EXIT
	END
	--
	-- Check CV Single Instanced.
	--
IF    (@l_SIDBStoreId > 0 OR ((@l_dedupeFlags & 262144) > 0))
	BEGIN
		  set @o_DataMoverType	=	@DM_TYPE_CV_SINGLE_INSTANCE
		  GOTO PROC_EXIT
	END
	SELECT	@l_LibraryAttribute = LibraryAttribute
	FROM	MMLibrary
	WHERE	LibraryId = @l_LibraryId
	--
	-- Check Single Instanced.
	--
IF (@l_LibraryAttribute & 268435456) = 268435456
		set @o_DataMoverType	=	(@o_DataMoverType | @DM_TYPE_SINGLE_INSTANCE)
	--
	-- Check Centera.
	--
	IF @l_MountPathTypeId = @MOUNT_PATH_CENTERA
		set @o_DataMoverType	=	(@o_DataMoverType | @DM_TYPE_CENTERA)
	IF (@o_DataMoverType = 0)
	BEGIN
		set @o_DataMoverType	=	@DM_TYPE_REGULAR
	END
	-- Fall through.
PROC_EXIT:
	select @o_DataMoverType, @o_DrivePoolType, @l_mmError
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDataMoverType')
	delete from GxQscripts where name = 'MMGetDataMoverType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDataMoverType')
	delete from GXDBVersions where aliasname = 'MMGetDataMoverType'
GO

insert into GXDBVersions values(2, 'MMGetDataMoverType',  '00010009027400070000', 'MMGetDataMoverType', '00010009027400070000')
GO

