

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDRVolumesOnMountPaths.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDRVolumesOnMountPaths.sp,v $ $Id: MMGetDRVolumesOnMountPaths.sp,v 1.1.2.3 2020/08/11 03:01:55 lviswambharan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetDRVolumesOnMountPaths')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDRVolumesOnMountPaths <<<'
	drop procedure MMGetDRVolumesOnMountPaths
END
IF EXISTS (select * from GxQscripts where name='MMGetDRVolumesOnMountPaths')
	delete from GxQscripts where name = 'MMGetDRVolumesOnMountPaths'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDRVolumesOnMountPaths')
	delete from GXDBVersions where aliasname = 'MMGetDRVolumesOnMountPaths'
GO
print '... Creating Procedure: MMGetDRVolumesOnMountPaths'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDRVolumesOnMountPaths
AS
  DECLARE @o_rowType INTEGER
  DECLARE @o_mountPathId INTEGER
  DECLARE @o_value INTEGER
DECLARE @DRAppId INTEGER = 1
SELECT	@DRAppId = id
FROM	APP_Application(READUNCOMMITTED)
WHERE	appTypeId = 1000
DECLARE @lastJobCopiedTime INTEGER = 0
SELECT	@lastJobCopiedTime = MAX(JDS.copiedTime)
FROM	JMJobDataStats JDS(READUNCOMMITTED)
WHERE	JDS.appId = @DRAppId
--We use MMEntityProp table to get bookkeeping info on each mountpath getting updated
--Entity prop entry is inserted for all MPs having DR jobs, and so if these entries say all mountpaths are updated then we dont have to check further
--There are only 2 cases
--1) a new DR backup job ran to any mountpath(may or may not be in entity prop), in this case all entity prop values will be different from current lastJobCopiedTime
--2) We failed to write DR info to some mountpath on last run, in this we still have an entry in entity prop table with time 0 anyway, cause the proc inserts an entry with time 0 when it sees a new mountpath to cover this case
IF 	EXISTS
	(	SELECT 	1
		FROM 	MMEntityProp(READUNCOMMITTED)
WHERE 	propertyName = 'DRInfoEntityPropInsertedForAllMPsAtTime'
				AND longlongVal = @lastJobCopiedTime
AND EntityType = 17 AND EntityId = 0
	)
	AND NOT EXISTS
	(	SELECT 	1
		FROM 	MMEntityProp(READUNCOMMITTED)
WHERE 	propertyName = 'MPLastDRJobTimeDuringDRInfoWrite'
AND longlongVal <> @lastJobCopiedTime AND EntityType = 17
	)
BEGIN
	GOTO _EXIT;
END
IF object_id('tempdb.dbo.#Volumes') IS NOT NULL DROP TABLE #Volumes
SELECT	MV.CurrMountPathId MountPathId, MV.VolumeId, MAX(JDS.copiedTime) LastJobCopiedTime
INTO	#Volumes
FROM	MMVolume MV (READUNCOMMITTED)
		INNER JOIN archChunk AC (READUNCOMMITTED) ON AC.volumeId = MV.VolumeId
		INNER JOIN archChunkMapping ACM (READUNCOMMITTED) ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
		INNER JOIN archFile AF (READUNCOMMITTED) ON AF.id = ACM.archFileId AND AF.commcellId = ACM.commcellId
		INNER JOIN JMJobDataStats JDS (READUNCOMMITTED) ON ACM.jobId = JDS.jobId AND ACM.archCopyId = JDS.archGrpCopyId AND AF.fileType = JDS.dataType AND ACM.commcellId = JDS.commcellId
WHERE	JDS.appId = @DRAppId AND MV.CurrMountPathId <> 0
GROUP BY MV.VolumeId, MV.CurrMountPathId
IF object_id('tempdb.dbo.#MountPaths') IS NOT NULL DROP TABLE #MountPaths
SELECT	MountPathId, MAX(LastJobCopiedTime) CurrLastJobCopiedTime, 0 OldLastJobCopiedTime, 0 LastVolumeId
INTO	#MountPaths
FROM	#Volumes
GROUP BY MountPathId
--If any mountpath which used have DR jobs doesnt have any DR jobs in it anymore, delete the entity prop entry. Do we need to delete the file?
DELETE	MMEntityProp
WHERE	EntityType = 17 AND propertyName = 'MPLastDRJobTimeDuringDRInfoWrite'
		AND EntityId NOT IN (SELECT MountPathId FROM #MountPaths)
--Get current entity prop values for all mountpaths
UPDATE	TMP
SET		TMP.OldLastJobCopiedTime = EP.longlongVal
FROM	#MountPaths TMP
INNER JOIN MMEntityProp EP ON TMP.MountPathId = EP.EntityId AND EP.EntityType = 17 AND propertyName = 'MPLastDRJobTimeDuringDRInfoWrite'
DECLARE @timeNow INTEGER = dbo.getUnixTime(GETUTCDATE())
DECLARE @errorCode INTEGER = 0
DECLARE @errorString NVARCHAR(MAX) = ''
BEGIN TRANSACTION UpdateEntityProp
BEGIN TRY
	--Insert a value with time 0 for new mountpaths, so that even if we dont get to write the file, we'll still have an entry
	INSERT INTO MMEntityProp(EntityId, EntityType, propertyName, propDataType, longlongVal, created, modified, CommCellId)
SELECT	TMP.MountPathId, 17, 'MPLastDRJobTimeDuringDRInfoWrite', 2, 0, @timeNow, @timeNow, 2
	FROM	#MountPaths TMP
	WHERE	TMP.OldLastJobCopiedTime = 0
AND TMP.MountPathId NOT IN (SELECT EntityId FROM MMEntityProp (READUNCOMMITTED) WHERE EntityType = 17 AND propertyName = 'MPLastDRJobTimeDuringDRInfoWrite')
	--If there are no new jobs on some mountpaths, just update it here itself no need to send a req to write file
	UPDATE	EP
	SET		EP.longlongVal = @lastJobCopiedTime, EP.modified = @timeNow
	FROM	MMEntityProp EP
			INNER JOIN #MountPaths TMP ON EP.EntityId = TMP.MountPathId
WHERE	EP.EntityType = 17 AND EP.propertyName = 'MPLastDRJobTimeDuringDRInfoWrite'
AND EP.CommCellId = 2
			AND TMP.CurrLastJobCopiedTime <= TMP.OldLastJobCopiedTime
			AND TMP.OldLastJobCopiedTime <> @lastJobCopiedTime
	--Below entry is used to confirm if all MPs have entity prop entries before checking if all MPs are updated
IF NOT EXISTS(SELECT 1 FROM MMEntityProp(READUNCOMMITTED) WHERE EntityType = 17 AND propertyName = 'DRInfoEntityPropInsertedForAllMPsAtTime' AND EntityId = 0)
	BEGIN
		INSERT INTO MMEntityProp(EntityId, EntityType, propertyName, propDataType, longlongVal, created, modified, CommCellId)
VALUES (0, 17, 'DRInfoEntityPropInsertedForAllMPsAtTime', 2, @lastJobCopiedTime, @timeNow, @timeNow, 2)
	END
	ELSE
	BEGIN
		UPDATE 	MMEntityProp
		SET 	longlongVal = @lastJobCopiedTime, modified = @timeNow
WHERE	EntityType = 17 AND propertyName = 'DRInfoEntityPropInsertedForAllMPsAtTime'
AND EntityId = 0 AND CommCellId = 2
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString  = ERROR_MESSAGE()
END CATCH
IF @errorCode <> 0
BEGIN
	ROLLBACK TRAN UpdateEntityProp
	RAISERROR(@errorString, 0, 1) --severity 0, so that the error is logged, but we still fetch info and write file for other mountpaths
END
ELSE
BEGIN
	COMMIT TRANSACTION UpdateEntityProp
END
--Skip sending MPs which dont have any new jobs
DELETE	TV
FROM	#Volumes TV
		INNER JOIN #MountPaths TMP ON TV.MountPathId = TMP.MountPathId
WHERE	TMP.CurrLastJobCopiedTime <= TMP.OldLastJobCopiedTime
DELETE	#MountPaths
WHERE	CurrLastJobCopiedTime <= OldLastJobCopiedTime
--Fetch one online controller MA for each mountpath
IF object_id('tempdb.dbo.#OnlineMPsToClientMap') IS NOT NULL DROP TABLE #OnlineMPsToClientMap
SELECT	MP.MountPathId, MIN(DC.ClientId) ClientId
INTO	#OnlineMPsToClientMap
FROM	MMMountPath MP (READUNCOMMITTED)
		INNER JOIN MMMountPathToStorageDevice MPSD (READUNCOMMITTED) ON MPSD.MountPathId = MP.MountPathId
		INNER JOIN MMDevice MD (READUNCOMMITTED) ON MD.DeviceId = MPSD.DeviceId
		INNER JOIN MMDeviceController DC (READUNCOMMITTED) ON DC.DeviceId = MD.DeviceId
		INNER JOIN MMHost H (READUNCOMMITTED) ON H.ClientId = DC.ClientId
		INNER JOIN #MountPaths TMP ON MP.MountPathId = TMP.MountPathId
WHERE	DC.DeviceControllerEnabled = 1 AND DC.DeviceAccessible = 1
		AND MD.DeviceEnabled = 1 AND MD.DeviceBroken = 0
		AND MP.IsEnabled = 1 AND MP.IsOffline = 0
		AND H.MmHostEnabled = 1	AND H.MmHostSoftState = 1
AND DC.DeviceAccessType & 6 = 6
GROUP BY MP.MountPathId
--Drop details of offline mountpaths
DELETE	#MountPaths
WHERE	MountPathId NOT IN (SELECT DISTINCT MountPathId FROM #OnlineMPsToClientMap)
DELETE	#Volumes
WHERE	MountPathId NOT IN (SELECT MountPathId FROM #MountPaths)
--Get Last volume on each mountpath
;WITH LastVolOnMP AS
(
	SELECT	CurrMountPathId, MAX(VolumeId) LastVolumeId
	FROM	MMVolume (READUNCOMMITTED)
	GROUP BY CurrMountPathId
)
UPDATE	TMP
SET		TMP.LastVolumeId = LV.LastVolumeId
FROM	#MountPaths TMP
		INNER JOIN LastVolOnMP LV ON LV.CurrMountPathId = TMP.MountPathId
IF object_id('tempdb.dbo.#ActiveVolumes') IS NOT NULL DROP TABLE #ActiveVolumes
SELECT 	MV.CurrMountPathId MountPathId, MV.VolumeId
INTO	#ActiveVolumes
FROM 	MMVolume MV (READUNCOMMITTED)
		INNER JOIN #MountPaths MP ON MP.MountPathId = MV.CurrMountPathId
WHERE 	VolumeFlags IN (1, 7) -- VOL_ACTIVE, VOL_ACTIVE_APPEND
		AND MediaGroupId IN (	SELECT 	MediaGroupId
								FROM 	archStream S (READUNCOMMITTED)
										INNER JOIN archGroup AG (READUNCOMMITTED) ON S.archGroupId = AG.id
WHERE 	AG.type = 2
							)
--No need to add volumes already having jobs in active volumes list
DELETE	AV
FROM	#ActiveVolumes AV
		INNER JOIN #Volumes TV ON AV.VolumeId = TV.VolumeId
SELECT	0  RowType, MountPathId, ClientId--Type 0 MP to MA list
FROM	#OnlineMPsToClientMap
UNION
SELECT	1, MountPathId, LastVolumeId--Type 1 MP to LastVolumeId
FROM	#MountPaths
UNION
SELECT	2, MountPathId, VolumeId	--Type 2 MP to Active Volumes list
FROM	#ActiveVolumes
UNION
SELECT  3, MountPathId, VolumeId	--Type 3 MP to DR volumes list
FROM	#Volumes
UNION
SELECT	4, 0, @DRAppId	--Type 4 DR appId
UNION
SELECT	5, 0, @lastJobCopiedTime --Type 5 last job copied time
DROP TABLE #Volumes
DROP TABLE #MountPaths
DROP TABLE #ActiveVolumes
DROP TABLE #OnlineMPsToClientMap
_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDRVolumesOnMountPaths')
	delete from GxQscripts where name = 'MMGetDRVolumesOnMountPaths'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDRVolumesOnMountPaths')
	delete from GXDBVersions where aliasname = 'MMGetDRVolumesOnMountPaths'
GO

insert into GXDBVersions values(2, 'MMGetDRVolumesOnMountPaths',  '00010001000200030000', 'MMGetDRVolumesOnMountPaths', '00010001000200030000')
GO

