

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBsWithoutDDBBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDDBsWithoutDDBBackup.sp,v $ $Id: MMGetDDBsWithoutDDBBackup.sp,v 1.3.84.3 2018/08/26 16:40:24 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetDDBsWithoutDDBBackup <<<'

IF EXISTS (select * from sysobjects where name='MMGetDDBsWithoutDDBBackup')
	drop procedure MMGetDDBsWithoutDDBBackup
IF EXISTS (select * from GxQscripts where name='MMGetDDBsWithoutDDBBackup')
	delete from GxQscripts where name = 'MMGetDDBsWithoutDDBBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBsWithoutDDBBackup')
	delete from GXDBVersions where aliasname = 'MMGetDDBsWithoutDDBBackup'
GO
print '... Creating Procedure: MMGetDDBsWithoutDDBBackup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDDBsWithoutDDBBackup
  @i_CommCellId integer,
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MAClientId integer
  DECLARE @o_MAClientName nvarchar(256)
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SIDBStoreName nvarchar(256)
  DECLARE @o_SubStoreId integer
  DECLARE @o_archGroupId integer
  DECLARE @o_archGroupName nvarchar(256)
  DECLARE @o_archCopyId integer
  DECLARE @o_archCopyName nvarchar(256)
  DECLARE @o_subStorePath nvarchar(max)
  DECLARE @o_lastSnapTime integer
	declare @l_DDBMAs table (
							ddbMAClientId integer,
							maName nvarchar(max),
							SIBDStoreId integer,
							SIDBStoreName nvarchar(256),
							SubStoreId integer,
							archGroupId integer,
							archGroupName nvarchar(256),
							copyId integer,
							copyName nvarchar(256),
							subStorePath nvarchar(256),
							lastSnapTime  integer
							)
	declare @hrsConfig int = 0
set @hrsConfig = ISNULL((select value from MMConfigs where name = 'MMCONFIG_MAX_INTERVAL_FOR_NO_DDB_BACKUP'), 24)
	declare @thresholdTime int = dbo.getUnixTime(GETUTCDATE()) - (@hrsConfig * 60 * 60)
	declare @storeInitTime int = @thresholdTime - (12 * 60 * 60) -- additional 12 hrs to check store init.
    insert into @l_DDBMAs
    select distinct substore.ClientId, '', substore.SIDBStoreId, store.SIDBStoreName, substore.SubStoreId, AC.archGroupId, '', AC.id, AC.name, '', substore.lastSnapTime
    from IdxSIDBSubStore substore with (readuncommitted)
    inner join IdxSIDBStore store with (readuncommitted) on substore.SIDBStoreId = store.SIDBStoreId
    inner join archCopySIDBStore archtostore with (readuncommitted) on store.SIDBStoreId = archtostore.SIDBStoreId
    inner join archGroupCopy AC with (readuncommitted) on archtostore.CopyId = AC.id
where (store.flags & 256) = 0 and store.SealedTime = 0 and substore.FirstBackupTime > 0
and (AC.dedupeFlags & (33554432 | 67108864)) > 0
		and substore.LastSnapTime < @thresholdTime
and (AC.dedupeFlags & 134217728) = 0 -- do not pick GDSP dependent copy names, instead pick GDSP name.
		and (substore.FirstBackupTime < @storeInitTime and substore.FirstBackupTime > 0)
	-- clean up those which are pre 9.0 version MAs
	delete from @l_DDBMAs where ddbMAClientId IN (
    select T.ddbMAClientId
    from @l_DDBMAs T
		inner join APP_client CL with (readuncommitted) on T.ddbMAClientId = CL.id
	WHERE CL.releaseId <= 13 	-- not to consider pre 9.0 version MAs
	)
	update @l_DDBMAs
	set maName = AC.name
	from @l_DDBMAs T, APP_Client AC with (readuncommitted)
	where T.ddbMAClientId = AC.id
	update @l_DDBMAs
	set archGroupName = AG.name
	from @l_DDBMAs T
	INNER JOIN archGroup AG with (readuncommitted) ON T.archGroupId = AG.id
	update @l_DDBMAs
	set subStorePath = IA.path
	from @l_DDBMAs T
	inner join IdxSIDBSubStore substore with (readuncommitted) on T.SubStoreId = substore.SubStoreId
    	inner join IdxAccessPath IA with (readuncommitted) on IA.IdxAccessPathId = substore.IdxAccessPathId
	select * from @l_DDBMAs
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBsWithoutDDBBackup')
	delete from GxQscripts where name = 'MMGetDDBsWithoutDDBBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBsWithoutDDBBackup')
	delete from GXDBVersions where aliasname = 'MMGetDDBsWithoutDDBBackup'
GO

insert into GXDBVersions values(2, 'MMGetDDBsWithoutDDBBackup',  '00010003008400030000', 'MMGetDDBsWithoutDDBBackup', '00010003008400030000')
GO

