

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBsOnThreshold.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDDBsOnThreshold.sp,v $ $Id: MMGetDDBsOnThreshold.sp,v 1.13.2.7 2020/12/19 05:11:36 pnara Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetDDBsOnThreshold')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDDBsOnThreshold <<<'
	drop procedure MMGetDDBsOnThreshold
END
IF EXISTS (select * from GxQscripts where name='MMGetDDBsOnThreshold')
	delete from GxQscripts where name = 'MMGetDDBsOnThreshold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBsOnThreshold')
	delete from GXDBVersions where aliasname = 'MMGetDDBsOnThreshold'
GO
print '... Creating Procedure: MMGetDDBsOnThreshold'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetDDBsOnThreshold
  @i_CommCellId integer,
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MAClientId integer
  DECLARE @o_MAClientName nvarchar(256)
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SIDBStoreName nvarchar(256)
  DECLARE @o_SubStoreId integer
  DECLARE @o_archGroupId integer
  DECLARE @o_archGroupName nvarchar(256)
  DECLARE @o_archCopyId integer
  DECLARE @o_archCopyName nvarchar(256)
  DECLARE @o_subStorePath nvarchar(1024)
  DECLARE @o_avgQITime integer
  DECLARE @o_primaryRecs bigint
  DECLARE @o_secondaryRecs bigint
  DECLARE @o_numConnections integer
  DECLARE @o_zeroRefCount integer
  DECLARE @o_GraceDays integer
  DECLARE @o_FreeSpacePercent integer
  DECLARE @o_ThresholdLevel integer
/*
 * Prasad Nara : Modified code to get the DDBs which reached the primary record throshold to send event.
 * These changes doesn't effect the old behaviour to get the DDBs which reached avgQI threshold.
 * Added an extra out parameter ThresholdLevel to differentiate the avgQI threshold and primary record threshold.
 * If one DDB reached both thresholds then output contains 2 rows, one for avgQI threshold and one for primary record threshold.
 */
declare @DDBsOnThreshold table (SIDBStoreId int,
			  SubStoreId int,
			  avgQITime bigint,
			  primaryEntries bigint,
			  secondaryEntries bigint,
			  NumOfConnections int,
			  ZeroRefCount bigint,
			  ModifiedTime int,
			  FreeSpacePercent int,
			  ThresholdLevel int
			 )
declare @l_DDBMAs table (
			ddbMAClientId integer,
			maName nvarchar(max),
			SIDBStoreId integer,
			SIDBStoreName nvarchar(256),
			SubStoreId integer,
			archGroupId integer,
			archGroupName nvarchar(256),
			copyId integer,
			copyName nvarchar(256),
			subStorePath nvarchar(256),
			avgQITime  bigint,
			primaryRecs bigint,
			secondaryRecs bigint,
			numConnections int,
			zeroRefCount bigint,
			GraceDays int,
			FreeSpacePercent int,
			ThresholdLevel int
			)
DECLARE @infiniStore BIT = 0
IF EXISTS(SELECT 1 FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_INFINI_STORE' AND value = 1)
	SET @infiniStore = 1
DECLARE @avgQITimeLimitEventPercent int = 0
DECLARE @avgQITimeLimitCriticalEventPercent int = 0
DECLARE @avgQITimeThresholdEventLimit int = 0
DECLARE @avgQITimeThresholdCriticalEventLimit int = 0
DECLARE @avgQITimeThreshold int = 0
DECLARE @thresholdDaysToConsider int = 0
set @avgQITimeThreshold = ISNULL((select value from MMConfigs with (readuncommitted) where name = 'MMCONFIG_MAX_AVGQITIME_FOR_SIDB'), 2000)
IF @infiniStore = 0
BEGIN
	DECLARE @storeLimitEventPercent int = 0
set @storeLimitEventPercent = ISNULL((SELECT  TOP 1 value FROM    MMConfigs with (readuncommitted) WHERE   name = 'MMCONFIG_STORE_LIMIT_EVENT_PERCENT'), 80)
set @avgQITimeLimitEventPercent = ISNULL((SELECT  TOP 1 value FROM    MMConfigs with (readuncommitted) WHERE   name = 'MMCONFIG_AVG_QI_TIME_LIMIT_EVENT_PERCENT'), 70)
set @avgQITimeLimitCriticalEventPercent = ISNULL((SELECT  TOP 1 value FROM    MMConfigs with (readuncommitted) WHERE   name = 'MMCONFIG_AVG_QI_TIME_LIMIT_CRITICAL_EVENT_PERCENT'), 90)
	DECLARE @storeLimitForSubclientLimitEventPercent int = 0
set @storeLimitForSubclientLimitEventPercent = ISNULL((SELECT  TOP 1 value FROM    MMConfigs with (readuncommitted) WHERE   name = 'MMCONFIG_STORE_LIMIT_FOR_SUBCLIENT_EVENT_PERCENT'), 70)
	declare @primaryRecThreshold bigint = 0
set @primaryRecThreshold = ISNULL((select value from MMConfigs with (readuncommitted) where name = 'MMCONFIG_MAX_PRIMARYRECS_IN_SIDB_MIL'), 1000)
	set @primaryRecThreshold = @primaryRecThreshold * 1000000 -- convert from million
	declare @primaryEntriesLimitForSubClient bigint = 0
set @primaryEntriesLimitForSubClient = ISNULL((select value from MMConfigs with (readuncommitted) where name = 'MMCONFIG_SMALL_DDB_LIMIT_FOR_SUBCLIENT_ASSOCIATION_MIL'), 400)
	declare @primaryEntriesLimitPercentForSubClientEvent bigint = 0
set @primaryEntriesLimitPercentForSubClientEvent = ISNULL((select value from MMConfigs with (readuncommitted) where name = 'MMCONFIG_SMALL_DDB_LIMIT_FOR_SUBCLIENT_ASSOCIATION_EVENT_PERCENT'), 50)
	set @avgQITimeThresholdCriticalEventLimit = ((@avgQITimeThreshold * @avgQITimeLimitCriticalEventPercent) / 100) -- calculate @avgQITimeLimitCriticalEventPercent percent
	set @avgQITimeThresholdEventLimit = ((@avgQITimeThreshold * @avgQITimeLimitEventPercent) / 100) -- calculate @avgQITimeLimitEventPercent percent
	declare @primaryRecThresholdEventLimit bigint = ((@primaryRecThreshold * @storeLimitEventPercent) / 100) -- calculate @storeLimitEventPercent percent
	declare @avgQITimeSubclientThresholdEventLimit bigint = ((@avgQITimeThreshold * @storeLimitForSubclientLimitEventPercent) / 100) -- calculate @storeLimitForSubclientLimitEventPercent percent
	declare @primaryRecSubclientThresholdEventLimit bigint = ((@primaryEntriesLimitForSubClient * 1000000 * @primaryEntriesLimitPercentForSubClientEvent) / 100) -- convert from million
set @thresholdDaysToConsider = ISNULL((select value from MMConfigs with (readuncommitted) where name = 'MMCONFIG_STORE_LIMIT_EVENT_DAYS_TO_CONSIDER'), 3);
	declare @SubStoresAvgQITime table (SIDBStoreId int, SubStoreId int, CommCellId int, ModifiedTime int, AvgQITime bigint)
	INSERT INTO @SubStoresAvgQITime
	SELECT SIDBStoreId, SubStoreId, CommCellId, MAX(ModifiedTime), dbo.GetCurrentAvgQITimeMedian(SIDBStoreId, SubStoreId, CommCellId, @thresholdDaysToConsider) AS AvgQITimeMedian
	FROM IdxSIDBUsageHistory WITH (READUNCOMMITTED)
	WHERE HistoryType = 2
	GROUP BY SIDBStoreId, SubStoreId, CommCellId
	INSERT INTO @DDBsOnThreshold
SELECT DISTINCT Usage.SIDBStoreId, Usage.SubStoreId, T.AvgQITime, Usage.PrimaryEntries, Usage.SecondaryEntries, Usage.NumOfConnections, Usage.ZeroRefCount,  Usage.ModifiedTime, 0, 3
	FROM IdxSIDBUsageHistory Usage WITH (READUNCOMMITTED),
		 @SubStoresAvgQITime T
	WHERE Usage.SubStoreId = T.SubStoreId
	AND Usage.ModifiedTime = T.ModifiedTime
	AND Usage.HistoryType = 2 --This is to avoid multiple entries with different values from historyType 1 also
	AND T.AvgQITime >= @avgQITimeThresholdEventLimit
	UPDATE @DDBsOnThreshold
SET ThresholdLevel = 4
	WHERE AvgQITime >= @avgQITimeThresholdCriticalEventLimit
	INSERT INTO @DDBsOnThreshold
SELECT DISTINCT Usage.SIDBStoreId, Usage.SubStoreId, T.AvgQITime, Usage.PrimaryEntries, Usage.SecondaryEntries, Usage.NumOfConnections, Usage.ZeroRefCount,  Usage.ModifiedTime, 0, 1
	FROM IdxSIDBUsageHistory Usage WITH (READUNCOMMITTED),
		 @SubStoresAvgQITime T
	WHERE Usage.SubStoreId = T.SubStoreId
	AND Usage.ModifiedTime = T.ModifiedTime
	AND Usage.HistoryType = 2 --This is to avoid multiple entries with different values from historyType 1 also
	AND T.AvgQITime >= @avgQITimeSubclientThresholdEventLimit
	--Remove entries for subclient warning if primary entries limit doesn't met.
	DELETE DDT
	FROM @DDBsOnThreshold DDT,
		(
			SELECT SU.SIDBStoreId, ISNULL(MIN(SU.PrimaryEntries), 0) PrimaryEntries
			FROM
				(
					SELECT SIDBSToreId, SubStoreId, MAX(ModifiedTime) AS ModifiedTime
					FROM IdxSIDBUsageHistory with(readuncommitted)
					GROUP BY SIDBStoreId, SubStoreId
				) Latest
				INNER JOIN IdxSIDBUsageHistory SU with(readuncommitted)
					ON Latest.SIDBStoreId = SU.SIDBStoreId AND Latest.SubStoreId = SU.SubStoreId AND Latest.ModifiedTime = SU.ModifiedTime
			GROUP BY SU.SIDBStoreId
		) Usage
WHERE DDT.ThresholdLevel = 1
	AND DDT.SIDBStoreId = Usage.SIDBStoreId
	AND Usage.PrimaryEntries < @primaryRecSubclientThresholdEventLimit
END
ELSE
BEGIN
DECLARE @avgQITimeLimit INT = ISNULL((SELECT  TOP 1 value FROM  MMConfigs with (readuncommitted) WHERE   name = 'MMCONFIG_INFINI_STORE_AVG_QI_TIME_LIMIT_PERCENT'), 50)
	set @avgQITimeLimitEventPercent = @avgQITimeLimit * 0.6  --warning at 60% of limit
	set @avgQITimeLimitCriticalEventPercent = @avgQITimeLimit * 0.8  --critical warning at 80% of limit
set @thresholdDaysToConsider = ISNULL((select value from MMConfigs with (readuncommitted) where name = 'MMCONFIG_INFINI_STORE_AVG_QI_TIME_LIMIT_DAYS_TO_CONSIDER'), 30);
	set @avgQITimeThresholdCriticalEventLimit = ((@avgQITimeThreshold * @avgQITimeLimitCriticalEventPercent) / 100)
	set @avgQITimeThresholdEventLimit = ((@avgQITimeThreshold * @avgQITimeLimitEventPercent) / 100)
DECLARE	@storeFreeSpaceLimit int = ISNULL((SELECT  TOP 1 value FROM  MMConfigs with (readuncommitted) WHERE   name = 'MMCONFIG_INFINI_STORE_FREE_SPACE_PERC'), 0)
	DECLARE	@storeFreeSpacePercent int = @storeFreeSpaceLimit * 1.67 --warning at 67% above limit
	DECLARE	@storeFreeSpaceCriticalPercent int = @storeFreeSpaceLimit * 1.34 --warning at 34% above limit
DECLARE @minPrimaryEntries int = ISNULL((SELECT value FROM  MMConfigs with (readuncommitted) WHERE name = 'MMCONFIG_INFINI_STORE_MIN_PRIMARY_ENTRIES'), 200) * 0.8  --QI time alert at 80% min primary entries
	IF 	@avgQITimeThresholdEventLimit > 0
		OR @avgQITimeThresholdCriticalEventLimit > 0
		OR @storeFreeSpacePercent > 0
		OR @storeFreeSpaceCriticalPercent > 0
	BEGIN
		DECLARE @lt_SubStoresQITimeFreeSpace TABLE (SIDBStoreId int, SubStoreId int, AvgQITime bigint, FreeSpacePercent int)
		INSERT INTO @lt_SubStoresQITimeFreeSpace
		SELECT 	SS.SIDBStoreId, SS.SubStoreId,
				dbo.GetCurrentAvgQITimeMedian(SS.SIDBStoreId, SS.SubStoreId, SS.CommCellId, @thresholdDaysToConsider),
				CAST(C.FreeDiskSpaceMB * 1.0 / C.TotalCapacityMB * 100 AS INT)
		FROM	IdxSIDBSubStore SS WITH(READUNCOMMITTED),
				IdxCache C WITH(READUNCOMMITTED)
		WHERE	SS.IdxCacheId = C.IdxCacheId
				AND C.TotalCapacityMB > 0
				AND C.FreeDiskSpaceMB <= C.TotalCapacityMB
				AND SS.Version <> -1 --skip uninitialized DDBs
				AND EXISTS(SELECT 1 FROM archCopySIDBStore I with (readuncommitted)
WHERE SS.SIDBStoreId = I.SIDBStoreId AND I.flags &(4 | 1) = 4)
		--
		-- AvgQITime Threshold Checks
		--
		IF @avgQITimeThresholdEventLimit > 0 OR @avgQITimeThresholdCriticalEventLimit > 0
		BEGIN
			INSERT 	INTO @DDBsOnThreshold (SIDBStoreId, SubStoreId, AvgQITime, FreeSpacePercent, ThresholdLevel)
			SELECT 	S.SIDBStoreId, S.SubStoreId, S.AvgQITime, S.FreeSpacePercent,
					case when S.AvgQITime >= @avgQITimeThresholdCriticalEventLimit
then 7
else 6
					end
			FROM	@lt_SubStoresQITimeFreeSpace S,
					(
						SELECT SU.SIDBStoreId, ISNULL(AVG(SU.PrimaryEntries)/1000000, 0) PrimaryEntriesInMil
						FROM
							(
								SELECT SIDBSToreId, SubStoreId, MAX(ModifiedTime) AS ModifiedTime
								FROM IdxSIDBUsageHistory with(readuncommitted)
								GROUP BY SIDBStoreId, SubStoreId
							) Latest
							INNER JOIN IdxSIDBUsageHistory SU with(readuncommitted)
								ON Latest.SIDBStoreId = SU.SIDBStoreId AND Latest.SubStoreId = SU.SubStoreId AND Latest.ModifiedTime = SU.ModifiedTime
						GROUP BY SU.SIDBStoreId
					) Usage
			WHERE	(
						(
							@avgQITimeThresholdEventLimit > 0
							AND S.AvgQITime >= @avgQITimeThresholdEventLimit
						)
						OR
						(
							@avgQITimeThresholdCriticalEventLimit > 0
							AND S.AvgQITime >= @avgQITimeThresholdCriticalEventLimit
						)
					)
					AND S.SIDBStoreId = Usage.SIDBStoreId
					AND Usage.PrimaryEntriesInMil > @minPrimaryEntries
		END
		--
		-- Free Space Threshold Checks
		--
		IF @storeFreeSpacePercent > 0 OR @storeFreeSpaceCriticalPercent > 0
		BEGIN
			INSERT 	INTO @DDBsOnThreshold (SIDBStoreId, SubStoreId, AvgQITime, FreeSpacePercent, ThresholdLevel)
			SELECT 	SIDBStoreId, SubStoreId, AvgQITime, FreeSpacePercent,
					case when FreeSpacePercent <= @storeFreeSpaceCriticalPercent
then 9
else 8
					end
			FROM	@lt_SubStoresQITimeFreeSpace
			WHERE	(
						(
							@storeFreeSpacePercent > 0
							AND FreeSpacePercent <= @storeFreeSpacePercent
						)
						OR
						(
							@storeFreeSpaceCriticalPercent > 0
							AND FreeSpacePercent <= @storeFreeSpaceCriticalPercent
						)
					)
			--
			-- We create new DDB on the same path when old DDB becomes full
			-- So check if newly created DDB is still on old DDB path if so alert user to move the DDB
			--
			;WITH LastFullDDB AS
			(
				SELECT 	S.SIDBStoreId,
						FS.SIDBStoreId LastFullSIDBStoreId,
						ROW_NUMBER() OVER (PARTITION BY S.SIDBStoreId ORDER BY FS.FullTime DESC) RowNum
				FROM	@DDBsOnThreshold D,
						IdxSIDBStore S WITH(READUNCOMMITTED),
						ArchCopySIDBStore S2C WITH(READUNCOMMITTED),
						IdxSIDBStore FS WITH(READUNCOMMITTED),
						ArchCopySIDBStore FS2C WITH(READUNCOMMITTED),
						ArchGroupCopy AGC WITH(READUNCOMMITTED)
				WHERE	D.SIDBStoreId = S.SIDBStoreId
						AND S.SIDBStoreId = S2C.SIDBStoreId
						AND S2C.copyId = FS2C.copyId
						AND S.AppTypeGroupId > 0
						AND	(S.AppTypeGroupId = FS.AppTypeGroupId OR FS.AppTypeGroupId = 0)
						AND FS.SIDBStoreId = FS2C.SIDBStoreId
						AND FS2C.copyId = AGC.id
AND AGC.dedupeflags & 134217728 = 0
AND FS2C.flags & 1 > 0
AND D.ThresholdLevel IN (9, 8)
			)
			UPDATE 	T
SET		T.ThresholdLevel = 10
			FROM	@DDBsOnThreshold T,
					LastFullDDB F,
					IdxSIDBSubStore SS WITH(READUNCOMMITTED),
					IdxAccessPath AP WITH(READUNCOMMITTED),
					IdxSIDBSubStore FSS WITH(READUNCOMMITTED),
					IdxAccessPath FAP WITH(READUNCOMMITTED)
WHERE	T.ThresholdLevel IN (9, 8)
					AND F.RowNum = 1
					AND T.SIDBStoreId = F.SIDBStoreId
					AND T.SIDBStoreId = SS.SIDBStoreId AND T.SubStoreId = SS.SubStoreId
					AND SS.IdxAccessPathId = AP.IdxAccessPathId
					AND F.LastFullSIDBStoreId = FSS.SIDBStoreId
					AND FSS.IdxAccessPathId = FAP.IdxAccessPathId
					AND SS.ClientId = FSS.ClientId
					AND LEFT(AP.Path, LEN(AP.Path) - LEN(cast(F.SIDBStoreId AS varchar))) = LEFT(FAP.Path, LEN(FAP.Path) - LEN(cast(F.LastFullSIDBStoreId AS varchar)))
			--Skip move DDB alert if freespace is not hit the threshold
			DELETE  @DDBsOnThreshold
WHERE	ThresholdLevel = 10
					AND FreeSpacePercent > @storeFreeSpaceLimit
		END
	END
END
INSERT INTO @l_DDBMAs
SELECT DISTINCT substore.ClientId, '', store.SIDBStoreId, store.SIDBStoreName, Usage.SubStoreId, AC.archGroupId, AG.name, AC.id, AC.name, '', Usage.AvgQITime, Usage.PrimaryEntries, Usage.SecondaryEntries, Usage.NumOfConnections, Usage.ZeroRefCount, AC.DDBLimitExtensionTimeStamp, Usage.FreeSpacePercent,
(CASE 	WHEN Usage.ThresholdLevel = 1
THEN (CASE	WHEN AC.id = AG.defaultCopy AND (AG.flags & 65536 > 0)
THEN 2
					ELSE Usage.ThresholdLevel END)
		ELSE Usage.ThresholdLevel END)
FROM @DDBsOnThreshold Usage
INNER JOIN  IdxSIDBSubStore substore with (readuncommitted) ON Usage.SubStoreId = substore.SubStoreId
	INNER JOIN IdxSIDBStore store with (readuncommitted) on substore.SIDBStoreId = store.SIDBStoreId
	INNER JOIN archCopySIDBStore archtostore with (readuncommitted) on store.SIDBStoreId = archtostore.SIDBStoreId
	INNER JOIN archGroupCopy AC with (readuncommitted) on archtostore.CopyId = AC.id
	INNER JOIN archGroup AG with (readuncommitted) on AC.archGroupId = AG.id
WHERE (store.flags & 256) = 0 AND ((store.SealedTime = 0) OR (store.Status = 0 AND store.SealedTime > 0)) -- do not pick corrupted+sealed or prunable stores.
AND (AC.dedupeFlags & 134217728) = 0 -- do not pick GDSP dependent copy names, instead pick GDSP name.
-- clean up those which are pre 9.0 version MAs
DELETE FROM @l_DDBMAs WHERE ddbMAClientId IN
(
	SELECT T.ddbMAClientId
    FROM @l_DDBMAs T
		inner join APP_client CL with (readuncommitted) on T.ddbMAClientId = CL.id
	WHERE CL.releaseId <= 13 	-- not to consider pre 9.0 version MAs
)
-- clean up those DDBs which are sealed and avgQITime is less than threshold.
-- We are only concerned about QI Time since primaryRecs is no longer relavant to sealed stores.
IF @infiniStore = 0
BEGIN
	DELETE @l_DDBMAs
	FROM @l_DDBMAs T, IdxSIDBStore I with (readuncommitted)
	WHERE T.SIDBStoreId = I.SIDBStoreId
	AND I.SealedTime > 0
AND T.ThresholdLevel not in (4,3)
END
UPDATE @l_DDBMAs
SET maName = AC.name
FROM @l_DDBMAs T, APP_Client AC with (readuncommitted)
WHERE T.ddbMAClientId = AC.id
UPDATE @l_DDBMAs
SET subStorePath = IA.path
FROM @l_DDBMAs T
   INNER JOIN IdxSIDBSubStore substore with (readuncommitted) on T.SubStoreId = substore.SubStoreId
    INNER JOIN IdxAccessPath IA with (readuncommitted) on IA.IdxAccessPathId = substore.IdxAccessPathId
SELECT * FROM @l_DDBMAs ORDER BY ThresholdLevel
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBsOnThreshold')
	delete from GxQscripts where name = 'MMGetDDBsOnThreshold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBsOnThreshold')
	delete from GXDBVersions where aliasname = 'MMGetDDBsOnThreshold'
GO

insert into GXDBVersions values(2, 'MMGetDDBsOnThreshold',  '00010013000200070000', 'MMGetDDBsOnThreshold', '00010013000200070000')
GO

