

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBsOnPruningThreshold.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDDBsOnPruningThreshold.sp,v $ $Id: MMGetDDBsOnPruningThreshold.sp,v 1.4.52.3 2019/09/20 15:01:07 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetDDBsOnPruningThreshold')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDDBsOnPruningThreshold <<<'
	drop procedure MMGetDDBsOnPruningThreshold
END
IF EXISTS (select * from GxQscripts where name='MMGetDDBsOnPruningThreshold')
	delete from GxQscripts where name = 'MMGetDDBsOnPruningThreshold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBsOnPruningThreshold')
	delete from GXDBVersions where aliasname = 'MMGetDDBsOnPruningThreshold'
GO
print '... Creating Procedure: MMGetDDBsOnPruningThreshold'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDDBsOnPruningThreshold
  @i_CommCellId integer,
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SIDBStoreName nvarchar(256)
  DECLARE @o_archGroupId integer
  DECLARE @o_archGroupName nvarchar(256)
  DECLARE @o_archCopyId integer
  DECLARE @o_archCopyName nvarchar(256)
  DECLARE @o_deletedAFCount integer
declare @DDBsOnThreshold table (SIDBStoreId int,
			  deletedAFCount int
			 )
DECLARE @currentTime INT = dbo.getUnixTime(GETUTCDATE())
--retreive config param values
declare @deletedAFCountThreshold int = 0
set @deletedAFCountThreshold = ISNULL((select value from MMConfigs where name = 'DA_CONFIG_MAX_DELETEDAF_COUNT_FOR_SIDB'), 10000)
declare @deletedAFCountThresholdMin int = 0
set @deletedAFCountThresholdMin = ISNULL((select nMin from MMConfigs where name = 'DA_CONFIG_MAX_DELETEDAF_COUNT_FOR_SIDB'), 5000)
declare @deletedAFCountThresholdMax int = 0
set @deletedAFCountThresholdMax = ISNULL((select nMax from MMConfigs where name = 'DA_CONFIG_MAX_DELETEDAF_COUNT_FOR_SIDB'), 1000000)
-- maintain sanity
if ((@deletedAFCountThreshold < @deletedAFCountThresholdMin) OR (@deletedAFCountThreshold > @deletedAFCountThresholdMax))
set @deletedAFCountThreshold = 10000
declare @thresholdDaysToConsider int = 0;
set @thresholdDaysToConsider = ISNULL((select value from MMConfigs where name = 'DA_CONFIG_DELETEDAF_EVENT_DAYS_TO_CONSIDER'), 7)
declare @thresholdDaysToConsiderMin int = 0;
set @thresholdDaysToConsiderMin = ISNULL((select nMin from MMConfigs where name = 'DA_CONFIG_DELETEDAF_EVENT_DAYS_TO_CONSIDER'), 1)
declare @thresholdDaysToConsiderMax int = 0;
set @thresholdDaysToConsiderMax = ISNULL((select nMax from MMConfigs where name = 'DA_CONFIG_DELETEDAF_EVENT_DAYS_TO_CONSIDER'), 100)
--maintain sanity
if ((@thresholdDaysToConsider < @thresholdDaysToConsiderMin) OR (@thresholdDaysToConsider > @thresholdDaysToConsiderMax))
set @thresholdDaysToConsider = 7
--if the flag =1 is sent then this is from auto-tuning feature. Do not consider event days. Tune Immediately.
if ((@i_reserveParam & 1) > 0)
	SET @thresholdDaysToConsider = 0
--pickup all the stores which have rows older than the thresholdDaysToConsider config
INSERT INTO @DDBsOnThreshold
SELECT MMDAF.SIDBStoreId, COUNT(*)
FROM MMDeletedAF MMDAF
WHERE MMDAF.SIDBStoreId > 0
AND MMDAF.DeletedTime < (@currentTime - (@thresholdDaysToConsider * 24 * 60 * 60))
GROUP BY MMDAF.SIDBStoreId
-- cleanup those rows which do not have hit the threshold
DELETE @DDBsOnThreshold
WHERE deletedAFCount < @deletedAFCountThreshold
-- Remove corrupted and sealed stores or silo enabled stores - macro pruning
-- Do not pick prunable stores
DELETE @DDBsOnThreshold
FROM @DDBsOnThreshold T, IdxSIDBStore I with (readuncommitted)
WHERE T.SIDBStoreId = I.SIDBStoreId
AND ((I.SealedTime > 0 AND I.Status = 1)
OR ((I.flags & 2097152) > 0)
OR ((I.flags & 256) > 0)
)
-- Enabling granular pruning on cloud targets will need to consider stores with backlogged pruning on cloud.
-- Remove stores which are pointed to cloud storage - macro pruning
-- Rather than join, the subquery here will just fetch 1 vol. Since even if we have only 1 vol on cloud, it means we are pointing to cloud. We cannot mix and match mountpath types.
DELETE @DDBsOnThreshold
FROM @DDBsOnThreshold T
WHERE EXISTS (SELECT top 1 * FROM MMVolume VOL with (readuncommitted), MMMountPath MP with (readuncommitted)
		WHERE VOL.SIDBStoreId = T.SIDBStoreId AND VOL.mediaSideId = MP.mediaSideId AND MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
AND (MP.Attribute & 32) = 0)
SELECT DISTINCT store.SIDBStoreId, store.SIDBStoreName, AC.archGroupId, AG.name, AC.id, AC.name, DDB.deletedAFCount
FROM @DDBsOnThreshold DDB
        INNER JOIN IdxSIDBStore store with (readuncommitted) on DDB.SIDBStoreId = store.SIDBStoreId
        INNER JOIN archCopySIDBStore archtostore with (readuncommitted) on store.SIDBStoreId = archtostore.SIDBStoreId
        INNER JOIN archGroupCopy AC with (readuncommitted) on archtostore.CopyId = AC.id
	INNER JOIN archGroup AG with (readuncommitted) ON AC.archGroupId = AG.id
WHERE (AC.dedupeFlags & 134217728) = 0 -- do not pick GDSP dependent copy names, instead pick GDSP name.
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBsOnPruningThreshold')
	delete from GxQscripts where name = 'MMGetDDBsOnPruningThreshold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBsOnPruningThreshold')
	delete from GXDBVersions where aliasname = 'MMGetDDBsOnPruningThreshold'
GO

insert into GXDBVersions values(2, 'MMGetDDBsOnPruningThreshold',  '00010004005200030000', 'MMGetDDBsOnPruningThreshold', '00010004005200030000')
GO

