

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBsOnPhysicalPruningThreshold.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDDBsOnPhysicalPruningThreshold.sp,v $ $Id: MMGetDDBsOnPhysicalPruningThreshold.sp,v 1.1.2.2 2019/03/29 10:16:16 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetDDBsOnPhysicalPruningThreshold')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDDBsOnPhysicalPruningThreshold <<<'
	drop procedure MMGetDDBsOnPhysicalPruningThreshold
END
IF EXISTS (select * from GxQscripts where name='MMGetDDBsOnPhysicalPruningThreshold')
	delete from GxQscripts where name = 'MMGetDDBsOnPhysicalPruningThreshold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBsOnPhysicalPruningThreshold')
	delete from GXDBVersions where aliasname = 'MMGetDDBsOnPhysicalPruningThreshold'
GO
print '... Creating Procedure: MMGetDDBsOnPhysicalPruningThreshold'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDDBsOnPhysicalPruningThreshold
  @i_CommCellId integer,
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SubStoreId integer
  DECLARE @o_SIDBStoreName nvarchar(256)
  DECLARE @o_archGroupId integer
  DECLARE @o_archGroupName nvarchar(256)
  DECLARE @o_archCopyId integer
  DECLARE @o_archCopyName nvarchar(256)
  DECLARE @o_zeroRefCount integer
  DECLARE @o_ClientId integer
declare @DDBsOnZeroRefThreshold table (SIDBStoreId int, SubStoreId int, clientId int, zeroRefCount int)
DECLARE @currentTime INT = dbo.getUnixTime(GETUTCDATE())
--retreive config param values
declare @zeroRefThreshold int = 0
set @zeroRefThreshold = ISNULL((select value from MMConfigs where name = 'MMCONFIG_DDB_MAX_ZEROREF_COUNT'), 50000)
-- compute for stores with high pending zeroref count also
INSERT INTO @DDBsOnZeroRefThreshold (SIDBStoreId, SubStoreId, clientId, zeroRefCount)
SELECT distinct I.SIDBStoreId, SUB.SubStoreId, SUB.clientId, U.ZeroRefCount
FROM IdxSIDBStore I WITH (READUNCOMMITTED)
	INNER JOIN IdxSIDBSubStore SUB WITH (READUNCOMMITTED) ON I.SIDBStoreId = SUB.SIDBStoreId
       INNER JOIN archCopySIDBStore C WITH (READUNCOMMITTED) ON SUB.SIDBStoreId = C.SIDBStoreId
       INNER JOIN (SELECT SIDBStoreId, SubStoreId, max(ModifiedTime) as ModifiedTime
        FROM IdxSIDBUsageHistory WITH (READUNCOMMITTED)
        GROUP BY SIDBStoreId, SubStoreId) T ON SUB.SIDBStoreId = T.SIDBStoreId AND SUB.SubStoreId = T.SubStoreId
       INNER JOIN IdxSIDBUsageHistory U WITH (READUNCOMMITTED) ON T.SIDBStoreId = U.SIDBStoreId AND T.ModifiedTime = U.ModifiedTime AND T.SubStoreId = U.SubStoreId
WHERE SUB.commCellId = 2
   AND SUB.SIDBStoreId = T.SIDBStoreId
AND I.flags & 256 = 0
   AND I.Status <> 1
AND I.flags & 2097152 = 0
   AND U.ZeroRefCount > 0
AND I.flags & 536870912 > 0
AND (1 = dbo.IsOperationAllowed(131072,2,SUB.ClientId,0,0,0,0))
-- cleanup those rows which do not have hit the threshold
DELETE @DDBsOnZeroRefThreshold
WHERE zeroRefCount < @zeroRefThreshold
-- Remove corrupted and sealed stores or silo enabled stores - macro pruning
-- Do not pick prunable stores
DELETE T
FROM @DDBsOnZeroRefThreshold T, IdxSIDBStore I with (readuncommitted)
WHERE T.SIDBStoreId = I.SIDBStoreId
AND ((I.SealedTime > 0 AND I.Status = 1)
OR ((I.flags & 2097152) > 0)
OR ((I.flags & 256) > 0)
)
-- Enabling granular pruning on cloud targets will need to consider stores with backlogged pruning on cloud.
-- Remove stores which are pointed to cloud storage - macro pruning
-- Rather than join, the subquery here will just fetch 1 vol. Since even if we have only 1 vol on cloud, it means we are pointing to cloud. We cannot mix and match mountpath types.
DELETE T
FROM @DDBsOnZeroRefThreshold T
WHERE EXISTS (SELECT top 1 * FROM MMVolume VOL with (readuncommitted), MMMountPath MP with (readuncommitted)
		WHERE VOL.SIDBStoreId = T.SIDBStoreId AND VOL.mediaSideId = MP.mediaSideId AND MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
AND (MP.Attribute & 32) = 0)
SELECT DISTINCT DDB.SIDBStoreId, DDB.SubStoreId, store.SIDBStoreName, AC.archGroupId, AG.name, AC.id, AC.name, DDB.zeroRefCount, DDB.clientId
FROM @DDBsOnZeroRefThreshold DDB
        INNER JOIN IdxSIDBStore store with (readuncommitted) on DDB.SIDBStoreId = store.SIDBStoreId
        INNER JOIN archCopySIDBStore archtostore with (readuncommitted) on store.SIDBStoreId = archtostore.SIDBStoreId
        INNER JOIN archGroupCopy AC with (readuncommitted) on archtostore.CopyId = AC.id
	INNER JOIN archGroup AG with (readuncommitted) ON AC.archGroupId = AG.id
WHERE (AC.dedupeFlags & 134217728) = 0 -- do not pick GDSP dependent copy names, instead pick GDSP name.
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBsOnPhysicalPruningThreshold')
	delete from GxQscripts where name = 'MMGetDDBsOnPhysicalPruningThreshold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBsOnPhysicalPruningThreshold')
	delete from GXDBVersions where aliasname = 'MMGetDDBsOnPhysicalPruningThreshold'
GO

insert into GXDBVersions values(2, 'MMGetDDBsOnPhysicalPruningThreshold',  '00010001000200020000', 'MMGetDDBsOnPhysicalPruningThreshold', '00010001000200020000')
GO

