

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBsForDataPruning.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDDBsForDataPruning.sp,v $ $Id: MMGetDDBsForDataPruning.sp,v 1.1.2.9 2019/12/04 23:14:27 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetDDBsForDataPruning')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDDBsForDataPruning <<<'
	drop procedure MMGetDDBsForDataPruning
END
IF EXISTS (select * from GxQscripts where name='MMGetDDBsForDataPruning')
	delete from GxQscripts where name = 'MMGetDDBsForDataPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBsForDataPruning')
	delete from GXDBVersions where aliasname = 'MMGetDDBsForDataPruning'
GO
print '... Creating Procedure: MMGetDDBsForDataPruning'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDDBsForDataPruning
  @i_compute INTEGER,
  @i_reserve INTEGER
AS
  DECLARE @o_SIDBStoreId INTEGER
  DECLARE @o_commCellId INTEGER
  DECLARE @o_isVolRecycle INTEGER
  DECLARE @o_StoreFlags INTEGER
  DECLARE @o_flags INTEGER
  DECLARE @o_isToCloud INTEGER
  DECLARE @o_numRowsDAF INTEGER
  DECLARE @o_numRowsVol INTEGER
  DECLARE @o_reserveInt INTEGER
  DECLARE @o_reserveBigInt BIGINT
DECLARE @errorCode INTEGER = 0
DECLARE @l_MMConfig INTEGER = 0
DECLARE @l_StoreStatus INTEGER = 0
DECLARE @l_dedupeFlags INTEGER = 0
DECLARE @l_SIDBFlags INTEGER = 0
DECLARE @tblDDBs TABLE (SIDBStoreId INT, isVolRecycle INT, isToCloud INT, numRowsDAF INT, numRowsVol INT)
IF @i_compute = 0
	GOTO CV_EXIT
DELETE FROM MMDataToPruneForDDB
INSERT INTO @tblDDBs
SELECT SIDBStoreId, 0, 0, COUNT(*), 0
FROM MMDeletedAF WITH (READUNCOMMITTED)
GROUP BY SIDBStoreId
IF EXISTS (SELECT 1 FROM MMDeletedArchFileTracking WITH (READUNCOMMITTED))
BEGIN
INSERT INTO @tblDDBs
SELECT D.SIDBStoreId, 0, 0, 1, 0
FROM MMDeletedArchFileTracking D WITH (READUNCOMMITTED)
	LEFT OUTER JOIN @tblDDBs T ON T.SIDBStoreId = D.SIDBStoreId
WHERE T.SIDBStoreId IS NULL
GROUP BY D.SIDBStoreId
END
INSERT INTO @tblDDBs
SELECT V.SIDBStoreId, 1, 0, 0, COUNT(*)
FROM MMVolume V WITH (READUNCOMMITTED)
	INNER JOIN IdxSIDBStore S WITH (READUNCOMMITTED) ON V.SIDBStoreId = S.SIDBStoreId
	LEFT OUTER JOIN @tblDDBs T ON T.SIDBStoreId = V.SIDBStoreId
WHERE VolumeFlags = 6
AND (S.flags & 256) > 0 OR T.SIDBStoreId IS NULL
	OR NOT EXISTS (
                        SELECT CopyId FROM archCopySIDBStore WITH (READUNCOMMITTED)
                        WHERE SIDBStoreId = S.SIDBStoreId
			)
GROUP BY V.SIDBStoreId
--Check if there are some stores with zeroref count set. If so send them a prunable vol request to trigger pruning.
INSERT INTO @tblDDBs
SELECT DISTINCT I.SIDBStoreId, 1, 0, 0, 1
FROM 	IdxSIDBStore I WITH (READUNCOMMITTED)
	INNER JOIN archCopySIDBStore C WITH (READUNCOMMITTED) ON I.SIDBStoreId = C.SIDBStoreId
	INNER JOIN IdxSIDBSubStore SUB WITH (READUNCOMMITTED) ON I.SIDBStoreId = SUB.SIDBStoreId
	INNER JOIN (	SELECT 	SIDBStoreId, MAX(ModifiedTime) AS ModifiedTime
			FROM 	IdxSIDBUsageHistory WITH (READUNCOMMITTED)
			GROUP BY SIDBStoreId, SubStoreId
			) T ON I.SIDBStoreId = T.SIDBStoreId
	INNER JOIN IdxSIDBUsageHistory U WITH (READUNCOMMITTED) ON T.SIDBStoreId = U.SIDBStoreId AND T.ModifiedTime = U.ModifiedTime
	LEFT OUTER JOIN @tblDDBs TDDB ON TDDB.SIDBStoreId = I.SIDBStoreId
WHERE 	I.commCellId = 2
AND I.flags & 256 = 0
	AND I.Status <> 1
AND I.flags & 2097152 = 0
	AND U.ZeroRefCount > 0
AND I.flags & 536870912 > 0
	AND TDDB.SIDBStoreId IS NULL
UPDATE T
SET isToCloud = (CASE WHEN M.MountPathTypeId = 7 THEN 1 ELSE 0 END)
FROM @tblDDBs T
  INNER JOIN MMVolume V WITH (READUNCOMMITTED) ON V.VolumeId =
	(SELECT TOP 1 V.VolumeId FROM MMVolume V WITH (READUNCOMMITTED) WHERE V.SIDBStoreId = T.SIDBStoreId) ,
	MMMountPath M WITH (READUNCOMMITTED)
WHERE V.MediaSideId = M.MediaSideId
-- Stores which meet these conditions are not eligible for sending any pruning (AF or vol)
-- 1. Non local CC stores.
-- 2. Stores marked as prunable. Stores marked as prunable will be sent macro pruning. See cpp - isOrphan (MLMDeletedAF.cpp)
-- 3. Stores marked as corrupt.
-- 4. Silo enabled
-- 5. DDB Pruning disabled.
-- 6. Orphan stores.
DELETE 	T
FROM 	@tblDDBs T
	INNER JOIN IdxSIDBStore STORE WITH (READUNCOMMITTED) ON T.SIDBStoreId = STORE.SIDBStoreId
WHERE   ((STORE.CommCellId <> 2) AND ((STORE.flags & 256) = 0))
	OR
	(
				(
					T.isVolRecycle = 0
					AND
					(
( (STORE.flags & 256) > 0)
							OR
						( STORE.Status = 1 /* IDX_SIDBSTORE_STATUS_CORRUPTED */ )
							OR
( (STORE.Flags & 2097152) > 0)
							OR
(STORE.Flags & 536870912) = 0
					)
				)
				OR
				(
					T.isVolRecycle = 1
					AND
(STORE.Flags & 536870912) = 0
					AND
					( EXISTS
						(
							SELECT CopyId FROM archCopySIDBStore WITH (READUNCOMMITTED)
							WHERE SIDBStoreId = T.SIDBStoreId
						)
					)
				)
	)
	OR
	( EXISTS
		(
			SELECT	SubStoreId
			FROM	IdxSIDBSubStore WITH (READUNCOMMITTED)
			WHERE	SIDBStoreId = T.SIDBStoreId
AND flags & 1024 = 1024
		)
	)
INSERT INTO MMDataToPruneForDDB(SIDBStoreId, commCellId, isVolRecycle, StoreFlags, flags, isToCloud, numRowsDAF, numRowsVol, reserveInt, reserveBigInt)
SELECT I.SIDBStoreId, I.commCellId, T.isVolRecycle, I.flags, 0, T.isToCloud, T.numRowsDAF, T.numRowsVol, 0, 0
FROM @tblDDBs T, IdxSIDBStore I WITH (READUNCOMMITTED)
WHERE T.SIDBStoreId = I.SIDBStoreId
AND T.SIDBStoreId > 0
CV_EXIT:
	SELECT SIDBStoreId, commCellId, isVolRecycle, StoreFlags, flags, isToCloud, numRowsDAF, numRowsVol, reserveInt, reserveBigInt
	FROM MMDataToPruneForDDB WITH (READUNCOMMITTED)
	ORDER BY isVolRecycle, SIDBStoreId
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBsForDataPruning')
	delete from GxQscripts where name = 'MMGetDDBsForDataPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBsForDataPruning')
	delete from GXDBVersions where aliasname = 'MMGetDDBsForDataPruning'
GO

insert into GXDBVersions values(2, 'MMGetDDBsForDataPruning',  '00010001000200090000', 'MMGetDDBsForDataPruning', '00010001000200090000')
GO

