

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBSubStoresToBackupOnMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDDBSubStoresToBackupOnMA.sp,v $ $Id: MMGetDDBSubStoresToBackupOnMA.sp,v 1.1.2.5 2019/05/28 20:18:26 kbora Exp $";
--
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetDDBSubStoresToBackupOnMA')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDDBSubStoresToBackupOnMA <<<'
	drop procedure MMGetDDBSubStoresToBackupOnMA
END
IF EXISTS (select * from GxQscripts where name='MMGetDDBSubStoresToBackupOnMA')
	delete from GxQscripts where name = 'MMGetDDBSubStoresToBackupOnMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBSubStoresToBackupOnMA')
	delete from GXDBVersions where aliasname = 'MMGetDDBSubStoresToBackupOnMA'
GO
print '... Creating Procedure: MMGetDDBSubStoresToBackupOnMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDDBSubStoresToBackupOnMA
  @i_clientId integer,
  @i_jobId bigint
AS
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SubStoreId integer
  DECLARE @o_path varchar(1024)
  DECLARE @o_SIDBStoreName NVARCHAR(256)
  DECLARE @o_flags integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @appId INTEGER = 0
DECLARE @ddbBackupSubClientType INTEGER = 0
DECLARE @ddbSubStores TABLE (SIDBStoreId int, SubStoreId int, path varchar(1024), SIDBStoreName nvarchar (256), flag int)
SELECT @appId = applicationId
FROM JMBkpJobInfo WITH (READUNCOMMITTED)
WHERE jobId = @i_jobId
AND commCellId = 2
-- if not able to get the appId from jobInfo then fall back to the default DDB subclient method.
IF (@appId > 0)
BEGIN
    SELECT @ddbBackupSubClientType = CAST(attrVal AS INT)
    FROM APP_SubClientProp WITH (READUNCOMMITTED)
    WHERE componentNameId = @appId
    AND attrName = 'DDB Backup SubClient Type'
    AND modified = 0
END
ELSE
BEGIN
    SELECT @appId = APP.id
    FROM APP_Application APP WITH (READUNCOMMITTED)
    INNER JOIN APP_SubClientProp ASCP WITH (READUNCOMMITTED) ON APP.id = ASCP.componentNameId AND ASCP.attrName = 'DDB Backup' and ASCP.attrVal = '1' AND ASCP.modified = 0
    INNER JOIN APP_SubClientProp ASCP2 WITH (READUNCOMMITTED) ON APP.id = ASCP2.componentNameId AND ASCP2.attrName = 'DDB Backup SubClient Type' AND ASCP2.attrVal = '0' AND ASCP2.modified = 0
    WHERE APP.ClientId = @i_clientId
END
INSERT INTO @ddbSubStores
SELECT DISTINCT S.SIDBStoreId, S.SubStoreId, A.Path, '', 0
FROM IdxSIDBSubStore S WITH (READUNCOMMITTED)
	INNER JOIN archCopySIDBStore ACS WITH (READUNCOMMITTED) ON ACS.SIDBStoreId = S.SIDBStoreId
	INNER JOIN archGroupCopy C WITH (READUNCOMMITTED) ON C.Id = ACS.copyId
	INNER JOIN IdxAccessPath A WITH (READUNCOMMITTED) ON S.IdxAccessPathId = A.IdxAccessPathId
WHERE S.ClientId = @i_clientId
-- either match subclientId if this is user defined subclient job. Or if catch all, pick up all substores which catch all setting.
AND ((S.DDBSubClientId = @appId AND @ddbBackupSubClientType > 0) OR (S.DDBSubClientId = 0 AND @ddbBackupSubClientType = 0))
AND S.SealedTime = 0 AND S.FirstBackupTime > -1 AND S.Version >= 2
AND C.dedupeFlags & 33554432 > 0
AND ((ACS.Flags & 4) > 0)
UPDATE T
SET flag = 1
FROM @ddbSubStores T
	INNER JOIN IdxSIDBSubStore S WITH (READUNCOMMITTED) ON T.SubStoreId = S.SubStoreId
WHERE S.Status = 1
-- Check DDB move operation at substore level
UPDATE T
SET flag = 2
FROM @ddbSubStores T
	INNER JOIN IdxSIDBSubStore S WITH (READUNCOMMITTED) ON T.SubStoreId = S.SubStoreId
WHERE S.flags & 1024 > 0
UPDATE T
SET flag = 2
FROM @ddbSubStores T
	INNER JOIN IdxSIDBStore I WITH (READUNCOMMITTED) ON T.SIDBStoreId = I.SIDBStoreId
WHERE I.flags & (1024|16777216) > 0
UPDATE T
SET SIDBStoreName = I.SIDBStoreName
FROM @ddbSubStores T
	INNER JOIN IdxSIDBStore I WITH (READUNCOMMITTED) ON T.SIDBStoreId = I.SIDBStoreId
SELECT * FROM @ddbSubStores
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBSubStoresToBackupOnMA')
	delete from GxQscripts where name = 'MMGetDDBSubStoresToBackupOnMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBSubStoresToBackupOnMA')
	delete from GXDBVersions where aliasname = 'MMGetDDBSubStoresToBackupOnMA'
GO

insert into GXDBVersions values(2, 'MMGetDDBSubStoresToBackupOnMA',  '00010001000200050000', 'MMGetDDBSubStoresToBackupOnMA', '00010001000200050000')
GO

