

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBResyncInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetDDBResyncInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDDBResyncInfo <<<'
	drop procedure MMGetDDBResyncInfo
END
IF EXISTS (select * from GxQscripts where name='MMGetDDBResyncInfo')
	delete from GxQscripts where name = 'MMGetDDBResyncInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBResyncInfo')
	delete from GXDBVersions where aliasname = 'MMGetDDBResyncInfo'
GO
print '... Creating Procedure: MMGetDDBResyncInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetDDBResyncInfo
  @MaxResyncAttempts INTEGER
AS
  DECLARE @SIDBStoreId INT
  DECLARE @SIDBStoreName VARCHAR (256)
  DECLARE @SIDBStoreStatus INT
  DECLARE @StoreSelected INT
  DECLARE @ReasonString VARCHAR (256)
  DECLARE @Flags INT
  DECLARE @LastAttemptNo INT
  DECLARE @MaintReason INT
  DECLARE @MaintTime INT
  DECLARE @ResyncFlags INT
IF OBJECT_ID('tempdb..#ResyncStoreInfo') IS NOT NULL
	DROP TABLE #ResyncStoreInfo
IF OBJECT_ID('tempdb..#StoreInfo') IS NOT NULL
	DROP TABLE #StoreInfo
IF OBJECT_ID('tempdb..#StoreAvailability') IS NOT NULL
	DROP TABLE #StoreAvailability
IF OBJECT_ID('tempdb..#MinRelMAInfo') IS NOT NULL
	DROP TABLE #MinRelMAInfo
-- Pick all eligible stores.
CREATE TABLE #StoreInfo (SIDBStoreId INT, CommcellId INT, SIDBStoreName NVARCHAR(MAX), Flags INT, Version INT, Status INT, Attempts INT, PRIMARY KEY (SIDBStoreId))
INSERT INTO #StoreInfo
SELECT STORE.SIDBStoreId, STORE.CommcellId, STORE.SIDBStoreName, STORE.Flags, STORE.Version, STORE.Status, ISNULL(MAX(HIST.AttemptNo), 0)
FROM IdxSIDBStore STORE
	INNER JOIN MMEntityProp ENTPROP
ON STORE.SIDBStoreId <> 0 AND STORE.flags & (33554432) <> 0 AND STORE.CommcellId = 2
AND ENTPROP.EntityId = STORE.SIDBStoreId AND ENTPROP.EntityType = 3 AND ENTPROP.PropertyName = 'DDBMaintenanceReason' AND ENTPROP.CommcellId = 2
	LEFT OUTER JOIN IdxSIDBResyncHistory HIST
		ON HIST.SIDBStoreId = STORE.SIDBStoreId AND HIST.MaintenanceTime = ENTPROP.Created AND HIST.CommcellId = 2
GROUP BY STORE.SIDBStoreId, STORE.CommcellId, STORE.SIDBStoreName, STORE.Flags, STORE.Version, STORE.Status
-- Populate DDB host, cache, path availability info
SELECT STORE.SIDBStoreId, MIN(HOST.MmHostEnabled) AS HostEnabled, MIN(HOST.MMHostSoftState) AS HostState, MIN(CACHE.softstate) AS CacheState,
		MIN(PATH.softstate) AS PathState,
MIN(dbo.IsOperationAllowed(131072,2,HOST.ClientId,0,0,0,0)) AS IsPruningAllowedOnMA
INTO #StoreAvailability
FROM #StoreInfo STORE, IdxSIDBSubStore SUBSTORE, MMHost HOST, IdxCache CACHE, IdxAccessPath PATH
WHERE
	STORE.SIDBStoreId = SUBSTORE.SIDBStoreId AND
	SUBSTORE.ClientId = HOST.ClientId AND
	SUBSTORE.IdxCacheId = CACHE.IdxCacheId AND
	SUBSTORE.IdxAccessPathId = PATH.IdxAccessPathId AND
	-- Do not allow unavailability of corrupt partitions affect resync of available partitions.
	-- When resiliency is enabled, resync of available partitions will go thru and the ddb will
	-- be online, as recon supercedes resync for the corrupt partitions.
	SUBSTORE.Status = 0
GROUP BY STORE.SIDBStoreId;
-- Get MA release Info
WITH MAINFODUPL AS (
SELECT
	STORE.SIDBStoreId AS SIDBStoreId,
	CLIENT.ReleaseId AS ReleaseId,
	PKG.HighestSP AS HighestSP,
	PKG.SpMinorVersion AS SpMinorVersion,
	ROW_NUMBER() OVER (PARTITION BY STORE.SIDBStoreId
						ORDER BY STORE.SIDBStoreId, ReleaseId, HighestSP, SpMinorVersion) AS RowNum
FROM
	[#StoreInfo] STORE
	INNER JOIN IdxSIDBSubStore SUBSTORE ON STORE.SIDBStoreId = SUBSTORE.SIDBStoreId AND SUBSTORE.CommcellId = 2
	INNER JOIN APP_Client CLIENT WITH (NOLOCK) ON CLIENT.id = SUBSTORE.ClientId
	-- Cluster clients do not have a SimInstallPackges entry. So, find the physical clients.
	LEFT OUTER JOIN APP_VMToPMMap MAP ON MAP.VMClientId = CLIENT.id
	INNER JOIN SimInstalledPackages PKG ON PKG.ClientId = ISNULL(MAP.PMClientId, CLIENT.id)
WHERE
PKG.simPackageID in (51, 1301))
SELECT SIDBStoreId, ReleaseId, HighestSP, SpMinorVersion
INTO #MinRelMAInfo
FROM MAINFODUPL
WHERE RowNum = 1
-- Is activity disabled?
DECLARE @IsActivityDisabled INT = 0
IF EXISTS (SELECT 1 FROM JMJobAction
		   WHERE
			   ClientId = 1 AND AppType = 0 AND
			   MediaAgentId = 1 AND OpType IN (1, 100) /*All Activity, DDB Activity*/ AND
			   AppId = (SELECT Id FROM App_Application WHERE AppTypeId = 1000) AND
			   ClientGroupId = 0 AND Action = 1)
BEGIN
    SET @IsActivityDisabled = 1
END
-- All the selection logic is put into the populating ReasonString.
-- We also want a boolean column (StoreSelected) to convey the outcome of selection while not repeating the selection code.
-- Populating [StoreSelected] from [ReasonString] on the go errored out saying [ReasonString] column was invalid.
-- Creating [StoreSelected] as a computed column is one way of achieving this.
CREATE TABLE #ResyncStoreInfo(
	[SIDBStoreId] INT,
[SIDBStoreName] VARCHAR(256),
	[StoreStatus] INT,
	[StoreSelected] AS (CASE
						WHEN LEN([ReasonString]) = 0 THEN 1
						ELSE 0
					END),
	[ReasonString] VARCHAR(256),
	[Flags] INT,
	[LastAttemptNo] INT,
	[MaintReason] INT,
	[MaintTime] INT,
	[ResyncFlags] INT)
INSERT INTO #ResyncStoreInfo
SELECT DISTINCT
	[SIDBStoreId] = STORE.SIDBStoreId,
	[SIDBStoreName] = STORE.SIDBStoreName,
	[StoreStatus] = STORE.Status,
	[ReasonString] = (
		CASE
		WHEN STORE.CommcellId <> 2														THEN 'Store from foreign commcell'
WHEN STORE.flags & (33554432) = 0			THEN 'Store not marked for resync'
WHEN STORE.flags & (2097152) <> 0					THEN 'Cannot resync a silo enabled store'
		WHEN STORE.Version < 2 AND STORE.Version <> -1									THEN 'Unsupported store version'
WHEN MINRELMAINFO.releaseId < 15								THEN 'Unsupported MA release'
WHEN (MINRELMAINFO.releaseId = 15 AND
MINRELMAINFO.HighestSP < 6)				THEN 'Unsupported MA service pack'
WHEN (MINRELMAINFO.releaseId = 15 AND
MINRELMAINFO.HighestSP = 6 AND
MINRELMAINFO.SpMinorVersion < 1)	THEN 'Unsupported MA service pack'
		WHEN AVAIL.HostEnabled = 0														THEN 'DDB MA disabled'
		-- Do not shoot yourself in the foot with unreachable softstates.
		-- Try to still contact the DDB for resync.
		-- There should be no risk of hanging because a network timeout is enforced.
		--WHEN AVAIL.HostState = 0														THEN 'DDB MA unreachable'
		--WHEN AVAIL.CacheState = 0														THEN 'Deduplication database unreachable'
		--WHEN AVAIL.PathState = 0														THEN 'Deduplication database path unreachable'
		WHEN STORE.status <> 0															THEN 'Store not in expected state (0)'
		WHEN STORE.Attempts >= @MaxResyncAttempts										THEN 'Maximum resync attempts reached'
		WHEN @IsActivityDisabled = 1													THEN 'All activity or dedupe activity disabled'
		WHEN ENTPROP.intVal IS NULL														THEN 'Invalid maintenance reason'
WHEN ENTPROP.intVal IN (9, 11)  AND
STORE.flags & 536870912 = 0					THEN 'Pruning is disabled on store'
WHEN ENTPROP.intVal IN (9, 11)  AND
			 AVAIL.IsPruningAllowedOnMA = 0												THEN 'MA is in no-pruning op-window'
		ELSE																			''
		END),
	[Flags] = STORE.Flags,
	[LastAttemptNo] = STORE.Attempts,
[MaintReason] = ISNULL (ENTPROP.intVal, 0),
	[MaintTime] = ISNULL (ENTPROP.Created, 0),
	[ResyncFlags] = (CASE
WHEN ISNULL (ENTPROP.intVal, 0) = 9					THEN 1
WHEN ISNULL (ENTPROP.intVal, 0) IN (11, 13)		THEN 1|4
						ELSE 0 END)
FROM #StoreInfo STORE
	LEFT JOIN #MinRelMAInfo MINRELMAINFO
		ON STORE.SIDBStoreId = MINRELMAINFO.SIDBStoreId
	LEFT JOIN #StoreAvailability AVAIL
		ON STORE.SIDBStoreId = AVAIL.SIDBStoreId
	LEFT JOIN MMEntityProp ENTPROP
ON STORE.SIDBStoreId = ENTPROP.EntityId AND ENTPROP.EntityType = 3
			AND ENTPROP.PropertyName = 'DDBMaintenanceReason' AND ENTPROP.CommcellId = 2
WHERE
	-- do not pick the dummy entry
	STORE.SIDBStoreId <> 0
ORDER BY STORE.SIDBStoreId
SELECT * FROM #ResyncStoreInfo
DROP TABLE #ResyncStoreInfo
DROP TABLE #StoreInfo
DROP TABLE #StoreAvailability
DROP TABLE #MinRelMAInfo
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBResyncInfo')
	delete from GxQscripts where name = 'MMGetDDBResyncInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBResyncInfo')
	delete from GXDBVersions where aliasname = 'MMGetDDBResyncInfo'
GO

insert into GXDBVersions values(2, 'MMGetDDBResyncInfo',  '00000000000000000000', 'MMGetDDBResyncInfo', '00000000000000000000')
GO

