

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBReconInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDDBReconInfo.sp,v $ $Id: MMGetDDBReconInfo.sp,v 1.4.54.2 2018/03/20 00:15:19 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetDDBReconInfo <<<'

IF EXISTS (select * from sysobjects where name='MMGetDDBReconInfo')
	drop procedure MMGetDDBReconInfo
IF EXISTS (select * from GxQscripts where name='MMGetDDBReconInfo')
	delete from GxQscripts where name = 'MMGetDDBReconInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBReconInfo')
	delete from GXDBVersions where aliasname = 'MMGetDDBReconInfo'
GO
print '... Creating Procedure: MMGetDDBReconInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetDDBReconInfo
  @i_commcellId integer,
  @i_storeId integer,
  @i_jobId integer,
  @i_reserve integer
AS
  DECLARE @o_CommCellId integer
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_ReconLevel integer
  DECLARE @o_MemDbTimeStamp integer
  DECLARE @o_CorruptionTime integer
SET NOCOUNT ON
IF (@i_jobId = 0)
BEGIN
	SELECT @i_jobId = jobId
             FROM JMJobInfo WITH (READUNCOMMITTED)
             WHERE commCellId = 2 /* Local Commcell ID*/ AND opType = 80  /* DEDUPDBSYNC */
		AND dbo.GetJobOption(jobId, 1777365717/* DEDUPDBSYNCOPTION__SIDBSTORE_ID */) = @i_storeId
END
SELECT	Sub.commcellId, Sub.SIDBStoreId, MIN(Sub.ReconLevel), MIN(Sub.MemDbTimeStamp - C.clientSkewTime),
		(CASE WHEN MIN(CorruptionTime) > 0 THEN MAX(CorruptionTime) ELSE 0 END) as CorruptionTime
FROM IdxSIDBSubStore Sub WITH (NOLOCK), APP_Client C WITH (NOLOCK),
         -- get the list of substores from the TM tables
         (
             SELECT sb.value('@val', 'INT') AS t_substoreId
             FROM
             (
                 select CAST(value AS XML) AS xmlstr
                 from dbo.GetAllJobOptions(@i_JobID)
                 where optionId=34449693 -- DEDUPDBSYNCOPTION__SUB_STORE_ID_LIST
             ) AS O
             CROSS APPLY O.xmlstr.nodes ('SubStoreIdList') R(sb)
         ) T
WHERE Sub.CommCellId = @i_commCellId
AND Sub.SIDBStoreId = @i_storeId
AND Sub.SubStoreId = T.t_substoreId
AND Sub.ClientId = C.id
GROUP BY Sub.commCellId, Sub.SIDBStoreId
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBReconInfo')
	delete from GxQscripts where name = 'MMGetDDBReconInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBReconInfo')
	delete from GXDBVersions where aliasname = 'MMGetDDBReconInfo'
GO

insert into GXDBVersions values(2, 'MMGetDDBReconInfo',  '00010004005400020000', 'MMGetDDBReconInfo', '00010004005400020000')
GO

